/*
 * Decompiled with CFR 0.152.
 */
package org.archive.jmx;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private static final String USAGE = "Usage: java -jar cmdline-jmxclient.jar USER:PASS HOST:PORT [BEAN] [COMMAND]\nOptions:\n USER:PASS Username and password. Required. If none, pass '-'.\n           E.g. 'controlRole:secret'\n HOST:PORT Hostname and port to connect to. Required. E.g. localhost:8081.\n           Lists registered beans if only USER:PASS and this argument.\n BEAN      Optional target bean name. If present we list available operations\n           and attributes.\n COMMAND   Optional operation to run or attribute to fetch. If none supplied,\n           all operations and attributes are listed. Attributes begin with a\n           capital letter: e.g. 'Status' or 'Started'. Operations do not.\n           Operations can take arguments by adding an '=' followed by\n           comma-delimited params. Pass multiple attributes/operations to run\n           more than one per invocation. Use commands 'create' and 'destroy'\n           to instantiate and unregister beans ('create' takes name of class).\n           Pass 'Attributes' to get listing of all attributes and and their\n           values.\nRequirements:\n JDK1.5.0. If connecting to a SUN 1.5.0 JDK JMX Agent, remote side must be\n started with system properties such as the following:\n     -Dcom.sun.management.jmxremote.port=PORT\n     -Dcom.sun.management.jmxremote.authenticate=false\n     -Dcom.sun.management.jmxremote.ssl=false\n The above will start the remote server with no password. See\n http://java.sun.com/j2se/1.5.0/docs/guide/management/agent.html for more on\n 'Monitoring and Management via JMX'.\nClient Use Examples:\n To list MBeans on a non-password protected remote agent:\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\n         org.archive.crawler:name=Heritrix,type=Service\n To list attributes and attributes of the Heritrix MBean:\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\n         org.archive.crawler:name=Heritrix,type=Service \\\n         schedule=http://www.archive.org\n To set set logging level to FINE on a password protected JVM:\n     % java -jar cmdline-jmxclient-X.X.jar controlRole:secret localhost:8081 \\\n         java.util.logging:type=Logging \\\n         setLoggerLevel=org.archive.crawler.Heritrix,FINE";
    protected static final Pattern CMD_LINE_ARGS_PATTERN = Pattern.compile("^([^=]+)(?:(?:\\=)(.+))?$");
    private static final String CREATE_CMD_PREFIX = "create=";

    public static void main(String[] args) throws Exception {
        Client client = new Client();
        Logger l = Logger.getLogger("");
        Handler[] hs = l.getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            Handler h = hs[0];
            if (!(h instanceof ConsoleHandler)) continue;
            h.setFormatter(client.new OneLineSimpleLogger());
        }
        client.execute(args);
    }

    protected static void usage() {
        Client.usage(0, null);
    }

    protected static void usage(int exitCode, String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println(USAGE);
        System.exit(exitCode);
    }

    protected String[] parseUserpass(String userpass) {
        if (userpass == null || userpass.equals("-")) {
            return null;
        }
        int index = userpass.indexOf(58);
        if (index <= 0) {
            throw new RuntimeException("Unable to parse: " + userpass);
        }
        return new String[]{userpass.substring(0, index), userpass.substring(index + 1)};
    }

    protected Map formatCredentials(String login, String password) {
        HashMap<String, String[]> env = null;
        String[] creds = new String[]{login, password};
        env = new HashMap<String, String[]>(1);
        env.put("jmx.remote.credentials", creds);
        return env;
    }

    protected JMXConnector getJMXConnector(String hostport, String login, String password) throws IOException {
        JMXServiceURL rmiurl = new JMXServiceURL("service:jmx:rmi://" + hostport + "/jndi/rmi://" + hostport + "/jmxrmi");
        return JMXConnectorFactory.connect(rmiurl, this.formatCredentials(login, password));
    }

    protected ObjectName getObjectName(String beanname) throws MalformedObjectNameException, NullPointerException {
        return this.notEmpty(beanname) ? new ObjectName(beanname) : null;
    }

    protected void execute(String[] args) throws Exception {
        String[] loginPassword;
        Object[] result;
        if (args.length == 0 || args.length == 1) {
            Client.usage();
        }
        String userpass = args[0];
        String hostport = args[1];
        String beanname = null;
        String[] command = null;
        if (args.length > 2) {
            beanname = args[2];
        }
        if (args.length > 3) {
            command = new String[args.length - 3];
            for (int i = 3; i < args.length; ++i) {
                command[i - 3] = args[i];
            }
        }
        if ((result = this.execute(hostport, (loginPassword = this.parseUserpass(userpass)) == null ? null : loginPassword[0], loginPassword == null ? null : loginPassword[1], beanname, command)) != null) {
            for (int i = 0; i < result.length; ++i) {
                if (result[i] == null || result[i].toString().length() <= 0) continue;
                if (command != null) {
                    logger.info(command[i] + ": " + result[i]);
                    continue;
                }
                logger.info("\n" + result[i].toString());
            }
        }
    }

    protected Object[] execute(String hostport, String login, String password, String beanname, String[] command) throws Exception {
        return this.execute(hostport, login, password, beanname, command, false);
    }

    public Object[] executeOneCmd(String hostport, String login, String password, String beanname, String command) throws Exception {
        return this.execute(hostport, login, password, beanname, new String[]{command}, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] execute(String hostport, String login, String password, String beanname, String[] command, boolean oneBeanOnly) throws Exception {
        JMXConnector jmxc = this.getJMXConnector(hostport, login, password);
        Object[] result = null;
        try {
            result = this.doBeans(jmxc.getMBeanServerConnection(), this.getObjectName(beanname), command, oneBeanOnly);
        }
        finally {
            jmxc.close();
        }
        return result;
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] doBeans(MBeanServerConnection mbsc, ObjectName objName, String[] command, boolean oneBeanOnly) throws Exception {
        Object[] result = null;
        Set<ObjectInstance> beans = mbsc.queryMBeans(objName, null);
        if (beans.size() != 0) {
            if (beans.size() == 1) {
                return this.doBean(mbsc, beans.iterator().next(), command);
            }
            if (oneBeanOnly) {
                throw new RuntimeException("Only supposed to be one bean query result");
            }
            StringBuffer buffer = new StringBuffer();
            for (ObjectInstance obj : beans) {
                if (obj instanceof ObjectName) {
                    buffer.append(((ObjectName)((Object)obj)).getCanonicalName());
                } else {
                    if (!(obj instanceof ObjectInstance)) throw new RuntimeException("Unexpected object type: " + obj);
                    buffer.append(obj.getObjectName().getCanonicalName());
                }
                buffer.append("\n");
            }
            return new String[]{buffer.toString()};
        }
        if (command.length != 1) throw new RuntimeException(objName.getCanonicalName() + " not registered.");
        if (!this.notEmpty(command[0])) throw new RuntimeException(objName.getCanonicalName() + " not registered.");
        if (!command[0].startsWith(CREATE_CMD_PREFIX)) throw new RuntimeException(objName.getCanonicalName() + " not registered.");
        String className = command[0].substring(CREATE_CMD_PREFIX.length());
        mbsc.createMBean(className, objName);
        return result;
    }

    protected Object[] doBean(MBeanServerConnection mbsc, ObjectInstance instance, String[] command) throws Exception {
        if (command == null || command.length <= 0) {
            return new String[]{this.listOptions(mbsc, instance)};
        }
        Object[] result = new Object[command.length];
        for (int i = 0; i < command.length; ++i) {
            result[i] = this.doSubCommand(mbsc, instance, command[i]);
        }
        return result;
    }

    public Object doSubCommand(MBeanServerConnection mbsc, ObjectInstance instance, String subCommand) throws Exception {
        if (subCommand.equals("destroy")) {
            mbsc.unregisterMBean(instance.getObjectName());
            return null;
        }
        if (subCommand.startsWith(CREATE_CMD_PREFIX)) {
            throw new IllegalArgumentException("You cannot call create on an already existing bean.");
        }
        MBeanFeatureInfo[] attributeInfo = mbsc.getMBeanInfo(instance.getObjectName()).getAttributes();
        MBeanFeatureInfo[] operationInfo = mbsc.getMBeanInfo(instance.getObjectName()).getOperations();
        Object result = null;
        result = Character.isUpperCase(subCommand.charAt(0)) ? (!this.isFeatureInfo(attributeInfo, subCommand) && this.isFeatureInfo(operationInfo, subCommand) ? this.doBeanOperation(mbsc, instance, subCommand, (MBeanOperationInfo[])operationInfo) : this.doAttributeOperation(mbsc, instance, subCommand, (MBeanAttributeInfo[])attributeInfo)) : (!this.isFeatureInfo(operationInfo, subCommand) && this.isFeatureInfo(attributeInfo, subCommand) ? this.doAttributeOperation(mbsc, instance, subCommand, (MBeanAttributeInfo[])attributeInfo) : this.doBeanOperation(mbsc, instance, subCommand, (MBeanOperationInfo[])operationInfo));
        if (result instanceof CompositeData) {
            result = this.recurseCompositeData(new StringBuffer("\n"), "", "", (CompositeData)result);
        } else if (result instanceof TabularData) {
            result = this.recurseTabularData(new StringBuffer("\n"), "", "", (TabularData)result);
        } else if (result instanceof String[]) {
            String[] strs = (String[])result;
            StringBuffer buffer = new StringBuffer("\n");
            for (int i = 0; i < strs.length; ++i) {
                buffer.append(strs[i]);
                buffer.append("\n");
            }
            result = buffer;
        } else if (result instanceof AttributeList) {
            AttributeList list = (AttributeList)result;
            if (list.size() <= 0) {
                result = null;
            } else {
                StringBuffer buffer = new StringBuffer("\n");
                for (Attribute a : list) {
                    buffer.append(a.getName());
                    buffer.append(": ");
                    buffer.append(a.getValue());
                    buffer.append("\n");
                }
                result = buffer;
            }
        }
        return result;
    }

    protected boolean isFeatureInfo(MBeanFeatureInfo[] infos, String cmd) {
        return this.getFeatureInfo(infos, cmd) != null;
    }

    protected MBeanFeatureInfo getFeatureInfo(MBeanFeatureInfo[] infos, String cmd) {
        int index = cmd.indexOf(61);
        String name = index > 0 ? cmd.substring(0, index) : cmd;
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].getName().equals(name)) continue;
            return infos[i];
        }
        return null;
    }

    protected StringBuffer recurseTabularData(StringBuffer buffer, String indent, String name, TabularData data) {
        this.addNameToBuffer(buffer, indent, name);
        Collection<?> c = data.values();
        for (Object obj : c) {
            if (obj instanceof CompositeData) {
                this.recurseCompositeData(buffer, indent + " ", "", (CompositeData)obj);
                continue;
            }
            if (obj instanceof TabularData) {
                this.recurseTabularData(buffer, indent, "", (TabularData)obj);
                continue;
            }
            buffer.append(obj);
        }
        return buffer;
    }

    protected StringBuffer recurseCompositeData(StringBuffer buffer, String indent, String name, CompositeData data) {
        indent = this.addNameToBuffer(buffer, indent, name);
        for (String key : data.getCompositeType().keySet()) {
            Object o = data.get(key);
            if (o instanceof CompositeData) {
                this.recurseCompositeData(buffer, indent + " ", key, (CompositeData)o);
                continue;
            }
            if (o instanceof TabularData) {
                this.recurseTabularData(buffer, indent, key, (TabularData)o);
                continue;
            }
            buffer.append(indent);
            buffer.append(key);
            buffer.append(": ");
            buffer.append(o);
            buffer.append("\n");
        }
        return buffer;
    }

    protected String addNameToBuffer(StringBuffer buffer, String indent, String name) {
        if (name == null || name.length() == 0) {
            return indent;
        }
        buffer.append(indent);
        buffer.append(name);
        buffer.append(":\n");
        return indent + " ";
    }

    protected Object doAttributeOperation(MBeanServerConnection mbsc, ObjectInstance instance, String command, MBeanAttributeInfo[] infos) throws Exception {
        CommandParse parse = new CommandParse(command);
        if (parse.getArgs() == null || parse.getArgs().length == 0) {
            if (command.equals("Attributes")) {
                String[] names = new String[infos.length];
                for (int i = 0; i < infos.length; ++i) {
                    names[i] = infos[i].getName();
                }
                return mbsc.getAttributes(instance.getObjectName(), names);
            }
            return mbsc.getAttribute(instance.getObjectName(), parse.getCmd());
        }
        if (parse.getArgs().length != 1) {
            throw new IllegalArgumentException("One only argument setting attribute values: " + parse.getArgs());
        }
        MBeanAttributeInfo info = (MBeanAttributeInfo)this.getFeatureInfo(infos, parse.getCmd());
        Constructor<?> c = Class.forName(info.getType()).getConstructor(String.class);
        Attribute a = new Attribute(parse.getCmd(), c.newInstance(parse.getArgs()[0]));
        mbsc.setAttribute(instance.getObjectName(), a);
        return null;
    }

    protected Object doBeanOperation(MBeanServerConnection mbsc, ObjectInstance instance, String command, MBeanOperationInfo[] infos) throws Exception {
        CommandParse parse = new CommandParse(command);
        MBeanOperationInfo op = (MBeanOperationInfo)this.getFeatureInfo(infos, parse.getCmd());
        Object result = null;
        if (op == null) {
            result = "Operation " + parse.getCmd() + " not found.";
        } else {
            int objsLength;
            MBeanParameterInfo[] paraminfos = op.getSignature();
            int paraminfosLength = paraminfos == null ? 0 : paraminfos.length;
            int n = objsLength = parse.getArgs() == null ? 0 : parse.getArgs().length;
            if (paraminfosLength != objsLength) {
                result = "Passed param count does not match signature count";
            } else {
                String[] signature = new String[paraminfosLength];
                Object[] params = paraminfosLength == 0 ? null : new Object[paraminfosLength];
                for (int i = 0; i < paraminfosLength; ++i) {
                    MBeanParameterInfo paraminfo = paraminfos[i];
                    Constructor<?> c = Class.forName(paraminfo.getType()).getConstructor(String.class);
                    params[i] = c.newInstance(parse.getArgs()[i]);
                    signature[i] = paraminfo.getType();
                }
                result = mbsc.invoke(instance.getObjectName(), parse.getCmd(), params, signature);
            }
        }
        return result;
    }

    protected String listOptions(MBeanServerConnection mbsc, ObjectInstance instance) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanOperationInfo[] operations;
        StringBuffer result = new StringBuffer();
        MBeanInfo info = mbsc.getMBeanInfo(instance.getObjectName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        if (attributes.length > 0) {
            result.append("Attributes:");
            result.append("\n");
            for (int i = 0; i < attributes.length; ++i) {
                result.append(' ' + attributes[i].getName() + ": " + attributes[i].getDescription() + " (type=" + attributes[i].getType() + ")");
                result.append("\n");
            }
        }
        if ((operations = info.getOperations()).length > 0) {
            result.append("Operations:");
            result.append("\n");
            for (int i = 0; i < operations.length; ++i) {
                MBeanParameterInfo[] params = operations[i].getSignature();
                StringBuffer paramsStrBuffer = new StringBuffer();
                if (params != null) {
                    for (int j = 0; j < params.length; ++j) {
                        paramsStrBuffer.append("\n   name=");
                        paramsStrBuffer.append(params[j].getName());
                        paramsStrBuffer.append(" type=");
                        paramsStrBuffer.append(params[j].getType());
                        paramsStrBuffer.append(" ");
                        paramsStrBuffer.append(params[j].getDescription());
                    }
                }
                result.append(' ' + operations[i].getName() + ": " + operations[i].getDescription() + "\n  Parameters " + params.length + ", return type=" + operations[i].getReturnType() + paramsStrBuffer.toString());
                result.append("\n");
            }
        }
        return result.toString();
    }

    private class OneLineSimpleLogger
    extends SimpleFormatter {
        private Date date = new Date();
        private FieldPosition position = new FieldPosition(0);
        private SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss Z");
        private StringBuffer buffer = new StringBuffer();

        public synchronized String format(LogRecord record) {
            this.buffer.setLength(0);
            this.date.setTime(record.getMillis());
            this.position.setBeginIndex(0);
            this.formatter.format(this.date, this.buffer, this.position);
            this.buffer.append(' ');
            if (record.getSourceClassName() != null) {
                this.buffer.append(record.getSourceClassName());
            } else {
                this.buffer.append(record.getLoggerName());
            }
            this.buffer.append(' ');
            this.buffer.append(this.formatMessage(record));
            this.buffer.append(System.getProperty("line.separator"));
            if (record.getThrown() != null) {
                try {
                    StringWriter writer = new StringWriter();
                    PrintWriter printer = new PrintWriter(writer);
                    record.getThrown().printStackTrace(printer);
                    writer.close();
                    this.buffer.append(writer.toString());
                }
                catch (Exception e) {
                    this.buffer.append("Failed to get stack trace: " + e.getMessage());
                }
            }
            return this.buffer.toString();
        }
    }

    protected class CommandParse {
        private String cmd;
        private String[] args;

        protected CommandParse(String command) throws ParseException {
            this.parse(command);
        }

        private void parse(String command) throws ParseException {
            Matcher m = CMD_LINE_ARGS_PATTERN.matcher(command);
            if (m == null || !m.matches()) {
                throw new ParseException("Failed parse of " + command, 0);
            }
            this.cmd = m.group(1);
            this.args = m.group(2) != null && m.group(2).length() > 0 ? m.group(2).split(",") : null;
        }

        protected String getCmd() {
            return this.cmd;
        }

        protected String[] getArgs() {
            return this.args;
        }
    }
}

