/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.BaseAgentsInitializationCommand;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AgentRun
extends BaseAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: AgentRun.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String agentShutdownSignal = "_AGENTRUN_";

    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)tc);
        lockManager.clearGlobalFlag(agentShutdownSignal);
        Logging.root.info((Object)"Running...");
        while (!lockManager.checkGlobalFlag(agentShutdownSignal)) {
            ManifoldCF.startAgents(tc);
            try {
                ManifoldCF.sleep((long)5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        Logging.root.info((Object)"Shutting down...");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: AgentRun");
            System.exit(1);
        }
        try {
            System.err.println("Running...");
            AgentRun agentRun = new AgentRun();
            agentRun.execute();
            System.err.println("Shutting down...");
        }
        catch (ManifoldCFException e) {
            Logging.root.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

