/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.common;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import org.apache.manifoldcf.agents.common.XMLStream;
import org.apache.manifoldcf.agents.common.XMLWriterContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.xml.sax.Attributes;

public class XMLOutputStreamContext
extends XMLWriterContext {
    protected OutputStream outputStream;

    public XMLOutputStreamContext(XMLStream theStream, String namespaceURI, String localname, String qname, Attributes theseAttributes, OutputStream os) throws ManifoldCFException, UnsupportedEncodingException {
        super(theStream, namespaceURI, localname, qname, theseAttributes, new OutputStreamWriter(os, "utf-8"));
        this.outputStream = os;
    }

    public void flush() throws ManifoldCFException {
        try {
            if (this.outputStream != null) {
                super.flush();
                this.outputStream.flush();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws ManifoldCFException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

