/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.common;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import org.apache.manifoldcf.agents.common.XMLContext;
import org.apache.manifoldcf.agents.common.XMLStream;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.xml.sax.Attributes;

public class XMLWriterContext
extends XMLContext {
    protected Writer theWriter;

    public XMLWriterContext(XMLStream theStream, String namespaceURI, String localname, String qname, Attributes theseAttributes, Writer writer) throws ManifoldCFException {
        super(theStream, namespaceURI, localname, qname, theseAttributes);
        this.theWriter = writer;
    }

    public void flush() throws ManifoldCFException {
        try {
            this.theWriter.flush();
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void tagContents(char[] ch, int start, int length) throws ManifoldCFException {
        try {
            this.theWriter.write(ch, start, length);
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
        try {
            this.theWriter.write("<" + localName);
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                this.theWriter.write(" ");
                this.theWriter.write(atts.getLocalName(i));
                this.theWriter.write("=\"");
                this.theWriter.write(XMLWriterContext.escapeAttribute(atts.getValue(i)));
                this.theWriter.write("\"");
            }
            this.theWriter.write(">");
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
        super.beginTag(namespaceURI, localName, qName, atts);
        return new XMLWriterContext(this.theStream, namespaceURI, localName, qName, atts, this.theWriter);
    }

    protected void endTag() throws ManifoldCFException, ServiceInterruption {
        try {
            XMLContext context = this.theStream.getContext();
            String tagName = context.getLocalname();
            this.theWriter.write("</" + tagName + ">");
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
        super.endTag();
    }

    protected static String escapeAttribute(String value) {
        StringBuffer rval = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\'' || x == '\"' || x == '<' || x == '>' || x == '&' || x < ' ' && x >= '\u0000') {
                rval.append("&#").append(Integer.toString(x)).append(";");
                continue;
            }
            rval.append(x);
        }
        return rval.toString();
    }
}

