/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.incrementalingest;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatus;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorFactory;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class IncrementalIngester
extends BaseTable
implements IIncrementalIngester {
    public static final String _rcsid = "@(#)$Id: IncrementalIngester.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String idField = "id";
    protected static final String outputConnNameField = "connectionname";
    protected static final String docKeyField = "dockey";
    protected static final String docURIField = "docuri";
    protected static final String uriHashField = "urihash";
    protected static final String lastVersionField = "lastversion";
    protected static final String lastOutputVersionField = "lastoutputversion";
    protected static final String changeCountField = "changecount";
    protected static final String firstIngestField = "firstingest";
    protected static final String lastIngestField = "lastingest";
    protected static final String authorityNameField = "authorityname";
    protected IThreadContext threadContext;
    protected ILockManager lockManager;
    protected IOutputConnectionManager connectionManager;

    public IncrementalIngester(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "ingeststatus");
        this.threadContext = threadContext;
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.connectionManager = OutputConnectionManagerFactory.make(threadContext);
    }

    public void install() throws ManifoldCFException {
        block5: {
            String outputConnectionTableName = this.connectionManager.getTableName();
            String outputConnectionNameField = this.connectionManager.getConnectionNameColumn();
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(outputConnNameField, new ColumnDescription("VARCHAR(32)", false, false, outputConnectionTableName, outputConnectionNameField, false));
                map.put(docKeyField, new ColumnDescription("VARCHAR(73)", false, false, null, null, false));
                map.put(docURIField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(uriHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(lastVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(lastOutputVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(changeCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(firstIngestField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(lastIngestField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(authorityNameField, new ColumnDescription("VARCHAR(32)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription keyIndex = new IndexDescription(true, new String[]{outputConnNameField, docKeyField});
            IndexDescription uriHashIndex = new IndexDescription(false, new String[]{uriHashField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (keyIndex != null && id.equals((Object)keyIndex)) {
                    keyIndex = null;
                    continue;
                }
                if (uriHashIndex != null && id.equals((Object)uriHashIndex)) {
                    uriHashIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (uriHashIndex != null) {
                this.performAddIndex(null, uriHashIndex);
            }
            if (keyIndex == null) break block5;
            this.performAddIndex(null, keyIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void clearAll() throws ManifoldCFException {
        this.performDelete("", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMimeTypeIndexable(String outputConnectionName, String mimeType) throws ManifoldCFException, ServiceInterruption {
        IOutputConnection connection = this.connectionManager.load(outputConnectionName);
        IOutputConnector connector = OutputConnectorFactory.grab(this.threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
        if (connector == null) {
            throw new ServiceInterruption("Output connector not installed", 300000L);
        }
        try {
            boolean bl = connector.checkMimeTypeIndexable(mimeType);
            return bl;
        }
        finally {
            OutputConnectorFactory.release(connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDocumentIndexable(String outputConnectionName, File localFile) throws ManifoldCFException, ServiceInterruption {
        IOutputConnection connection = this.connectionManager.load(outputConnectionName);
        IOutputConnector connector = OutputConnectorFactory.grab(this.threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
        if (connector == null) {
            throw new ServiceInterruption("Output connector not installed", 300000L);
        }
        try {
            boolean bl = connector.checkDocumentIndexable(localFile);
            return bl;
        }
        finally {
            OutputConnectorFactory.release(connector);
        }
    }

    public void documentRecord(String outputConnectionName, String identifierClass, String identifierHash, String documentVersion, long recordTime, IOutputActivity activities) throws ManifoldCFException, ServiceInterruption {
        IOutputConnection connection = this.connectionManager.load(outputConnectionName);
        String docKey = IncrementalIngester.makeKey(identifierClass, identifierHash);
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("Recording document '" + docKey + "' for output connection '" + outputConnectionName + "'"));
        }
        this.performIngestion(connection, docKey, documentVersion, null, null, null, recordTime, null, activities);
    }

    public boolean documentIngest(String outputConnectionName, String identifierClass, String identifierHash, String documentVersion, String outputVersion, String authorityName, RepositoryDocument data, long ingestTime, String documentURI, IOutputActivity activities) throws ManifoldCFException, ServiceInterruption {
        IOutputConnection connection = this.connectionManager.load(outputConnectionName);
        String docKey = IncrementalIngester.makeKey(identifierClass, identifierHash);
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("Ingesting document '" + docKey + "' into output connection '" + outputConnectionName + "'"));
        }
        return this.performIngestion(connection, docKey, documentVersion, outputVersion, authorityName, data, ingestTime, documentURI, activities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performIngestion(IOutputConnection connection, String docKey, String documentVersion, String outputVersion, String authorityNameString, RepositoryDocument data, long ingestTime, String documentURI, IOutputActivity activities) throws ManifoldCFException, ServiceInterruption {
        String documentURIHash = null;
        if (documentURI != null) {
            documentURIHash = ManifoldCF.hash((String)documentURI);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(docKey);
        list.add(connection.getName());
        IResultSet set = this.performQuery("SELECT docuri,urihash,lastoutputversion FROM " + this.getTableName() + " WHERE " + docKeyField + "=? AND " + outputConnNameField + "=?", list, null, null);
        String oldURI = null;
        String oldURIHash = null;
        String oldOutputVersion = null;
        if (set.getRowCount() > 0) {
            IResultRow row = set.getRow(0);
            oldURI = (String)row.getValue(docURIField);
            oldURIHash = (String)row.getValue(uriHashField);
            oldOutputVersion = (String)row.getValue(lastOutputVersionField);
        }
        int uriCount = 0;
        if (documentURI != null) {
            ++uriCount;
        }
        if (!(oldURI == null || documentURI != null && documentURI.equals(oldURI))) {
            ++uriCount;
        }
        String[] lockArray = new String[uriCount];
        uriCount = 0;
        if (documentURI != null) {
            lockArray[uriCount++] = connection.getName() + ":" + documentURI;
        }
        if (!(oldURI == null || documentURI != null && documentURI.equals(oldURI))) {
            lockArray[uriCount++] = connection.getName() + ":" + oldURI;
        }
        this.lockManager.enterCriticalSections(null, null, lockArray);
        try {
            if (!(oldURI == null || documentURI != null && oldURI.equals(documentURI))) {
                list.clear();
                list.add(oldURIHash);
                list.add(docKey);
                list.add(connection.getName());
                this.performDelete("WHERE urihash=? AND dockey!=? AND connectionname=?", list, null);
                this.removeDocument(connection, oldURI, oldOutputVersion, activities);
            }
            if (documentURI != null) {
                list.clear();
                list.add(documentURIHash);
                list.add(docKey);
                list.add(connection.getName());
                this.performDelete("WHERE urihash=? AND dockey!=? AND connectionname=?", list, null);
            }
            if (documentURI != null) {
                this.noteDocumentIngest(connection.getName(), docKey, null, null, null, ingestTime, documentURI, documentURIHash);
                int result = this.addOrReplaceDocument(connection, documentURI, outputVersion, data, authorityNameString, activities);
                this.noteDocumentIngest(connection.getName(), docKey, documentVersion, outputVersion, authorityNameString, ingestTime, documentURI, documentURIHash);
                boolean bl = result == 0;
                return bl;
            }
            this.noteDocumentIngest(connection.getName(), docKey, documentVersion, outputVersion, authorityNameString, ingestTime, null, null);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lockManager.leaveCriticalSections(null, null, lockArray);
        }
    }

    public void documentCheckMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes, long checkTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            Object idValue;
            int j;
            int maxInClause = this.getMaxInClause();
            HashMap<String, String> docIDValues = new HashMap<String, String>();
            for (j = 0; j < identifierHashes.length; ++j) {
                String docDBString = IncrementalIngester.makeKey(identifierClasses[j], identifierHashes[j]);
                docIDValues.put(docDBString, docDBString);
            }
            HashMap rowIDSet = new HashMap();
            Iterator iter = docIDValues.keySet().iterator();
            j = 0;
            ArrayList<Object> list = new ArrayList<Object>();
            StringBuffer sb = new StringBuffer();
            while (iter.hasNext()) {
                if (j == maxInClause) {
                    this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list, sb.toString());
                    list.clear();
                    sb.setLength(0);
                    j = 0;
                }
                idValue = (String)iter.next();
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                list.add(idValue);
                ++j;
            }
            if (j > 0) {
                this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list, sb.toString());
            }
            j = 0;
            list.clear();
            sb.setLength(0);
            iter = rowIDSet.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxInClause) {
                    this.updateRowIds(list, sb.toString(), checkTime);
                    list.clear();
                    sb.setLength(0);
                    j = 0;
                }
                idValue = (Long)iter.next();
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                list.add(idValue);
                ++j;
            }
            if (j > 0) {
                this.updateRowIds(list, sb.toString(), checkTime);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void documentCheck(String outputConnectionName, String identifierClass, String identifierHash, long checkTime) throws ManifoldCFException {
        this.documentCheckMultiple(outputConnectionName, new String[]{identifierClass}, new String[]{identifierHash}, checkTime);
    }

    protected void updateRowIds(ArrayList list, String queryPart, long checkTime) throws ManifoldCFException {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(lastIngestField, new Long(checkTime));
        this.performUpdate(map, "WHERE id IN (" + queryPart + ")", list, null);
    }

    public void documentDeleteMultiple(String[] outputConnectionNames, String[] identifierClasses, String[] identifierHashes, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        int i;
        HashMap<String, ArrayList<Integer>> keyMap = new HashMap<String, ArrayList<Integer>>();
        for (i = 0; i < outputConnectionNames.length; ++i) {
            String outputConnectionName = outputConnectionNames[i];
            ArrayList<Integer> list = (ArrayList<Integer>)keyMap.get(outputConnectionName);
            if (list == null) {
                list = new ArrayList<Integer>();
                keyMap.put(outputConnectionName, list);
            }
            list.add(new Integer(i));
        }
        for (String outputConnectionName : keyMap.keySet()) {
            ArrayList list = (ArrayList)keyMap.get(outputConnectionName);
            String[] localIdentifierClasses = new String[list.size()];
            String[] localIdentifierHashes = new String[list.size()];
            for (i = 0; i < localIdentifierClasses.length; ++i) {
                int index = (Integer)list.get(i);
                localIdentifierClasses[i] = identifierClasses[index];
                localIdentifierHashes[i] = identifierHashes[index];
            }
            this.documentDeleteMultiple(outputConnectionName, localIdentifierClasses, localIdentifierHashes, activities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentDeleteMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        int i;
        IOutputConnection connection = this.connectionManager.load(outputConnectionName);
        if (Logging.ingest.isDebugEnabled()) {
            for (int i2 = 0; i2 < identifierHashes.length; ++i2) {
                Logging.ingest.debug((Object)("Request to delete document '" + IncrementalIngester.makeKey(identifierClasses[i2], identifierHashes[i2]) + "' from output connection '" + outputConnectionName + "'"));
            }
        }
        DeleteInfo[] uris = this.getDocumentURIMultiple(outputConnectionName, identifierClasses, identifierHashes);
        int validURIcount = 0;
        for (i = 0; i < uris.length; ++i) {
            if (uris[i] == null || uris[i].getURI() == null) continue;
            ++validURIcount;
        }
        String[] lockArray = new String[validURIcount];
        String[] validURIArray = new String[validURIcount];
        validURIcount = 0;
        for (i = 0; i < uris.length; ++i) {
            if (uris[i] == null || uris[i].getURI() == null) continue;
            validURIArray[validURIcount] = uris[i].getURI();
            lockArray[validURIcount] = outputConnectionName + ":" + validURIArray[validURIcount];
            ++validURIcount;
        }
        this.lockManager.enterCriticalSections(null, null, lockArray);
        try {
            int j;
            for (j = 0; j < uris.length; ++j) {
                if (uris[j] == null || uris[j].getURI() == null) continue;
                this.removeDocument(connection, uris[j].getURI(), uris[j].getOutputVersion(), activities);
            }
            this.beginTransaction();
            try {
                int maxInClause = this.getMaxInClause();
                HashMap<String, String> docURIHashValues = new HashMap<String, String>();
                HashMap<String, String> docURIValues = new HashMap<String, String>();
                j = 0;
                while (j < validURIArray.length) {
                    String docDBString = validURIArray[j++];
                    String docDBHashString = ManifoldCF.hash((String)docDBString);
                    docURIValues.put(docDBString, docDBString);
                    docURIHashValues.put(docDBHashString, docDBHashString);
                }
                HashMap rowIDSet = new HashMap();
                Iterator iter = docURIHashValues.keySet().iterator();
                j = 0;
                ArrayList<String> hashList = new ArrayList<String>();
                StringBuffer sb = new StringBuffer();
                while (iter.hasNext()) {
                    if (j == maxInClause) {
                        this.findRowIdsForURIs(outputConnectionName, rowIDSet, docURIValues, hashList, sb.toString());
                        hashList.clear();
                        sb.setLength(0);
                        j = 0;
                    }
                    String hashValue = (String)iter.next();
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append('?');
                    hashList.add(hashValue);
                    ++j;
                }
                if (j > 0) {
                    this.findRowIdsForURIs(outputConnectionName, rowIDSet, docURIValues, hashList, sb.toString());
                }
                j = 0;
                ArrayList<Object> list = new ArrayList<Object>();
                sb.setLength(0);
                iter = rowIDSet.keySet().iterator();
                while (iter.hasNext()) {
                    if (j == maxInClause) {
                        this.deleteRowIds(list, sb.toString());
                        list.clear();
                        sb.setLength(0);
                        j = 0;
                    }
                    Long idValue = (Long)iter.next();
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append('?');
                    list.add(idValue);
                    ++j;
                }
                if (j > 0) {
                    this.deleteRowIds(list, sb.toString());
                }
                HashMap<String, String> docIdValues = new HashMap<String, String>();
                for (j = 0; j < identifierHashes.length; ++j) {
                    String docDBString = IncrementalIngester.makeKey(identifierClasses[j], identifierHashes[j]);
                    docIdValues.put(docDBString, docDBString);
                }
                rowIDSet.clear();
                iter = docIdValues.keySet().iterator();
                j = 0;
                list.clear();
                sb.setLength(0);
                while (iter.hasNext()) {
                    if (j == maxInClause) {
                        this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list, sb.toString());
                        list.clear();
                        sb.setLength(0);
                        j = 0;
                    }
                    String hashValue = (String)iter.next();
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append('?');
                    list.add(hashValue);
                    ++j;
                }
                if (j > 0) {
                    this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list, sb.toString());
                }
                j = 0;
                list.clear();
                sb.setLength(0);
                iter = rowIDSet.keySet().iterator();
                while (iter.hasNext()) {
                    if (j == maxInClause) {
                        this.deleteRowIds(list, sb.toString());
                        list.clear();
                        sb.setLength(0);
                        j = 0;
                    }
                    Long idValue = (Long)iter.next();
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append('?');
                    list.add(idValue);
                    ++j;
                }
                if (j > 0) {
                    this.deleteRowIds(list, sb.toString());
                }
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.lockManager.leaveCriticalSections(null, null, lockArray);
        }
    }

    protected void findRowIdsForURIs(String outputConnectionName, HashMap rowIDSet, HashMap uris, ArrayList hashParamValues, String paramList) throws ManifoldCFException {
        hashParamValues.add(outputConnectionName);
        IResultSet set = this.performQuery("SELECT id,docuri FROM " + this.getTableName() + " WHERE " + uriHashField + " IN (" + paramList + ") AND " + outputConnNameField + "=?", hashParamValues, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row;
            String docURI;
            if ((docURI = (String)(row = set.getRow(i++)).getValue(docURIField)) == null || docURI.length() <= 0 || uris.get(docURI) == null) continue;
            Long rowID = (Long)row.getValue(idField);
            rowIDSet.put(rowID, rowID);
        }
    }

    protected void findRowIdsForDocIds(String outputConnectionName, HashMap rowIDSet, ArrayList paramValues, String paramList) throws ManifoldCFException {
        paramValues.add(outputConnectionName);
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + docKeyField + " IN (" + paramList + ") AND " + outputConnNameField + "=?", paramValues, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long rowID = (Long)row.getValue(idField);
            rowIDSet.put(rowID, rowID);
        }
    }

    protected void deleteRowIds(ArrayList list, String queryPart) throws ManifoldCFException {
        this.performDelete("WHERE id IN (" + queryPart + ")", list, null);
    }

    public void documentDelete(String outputConnectionName, String identifierClass, String identifierHash, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.documentDeleteMultiple(outputConnectionName, new String[]{identifierClass}, new String[]{identifierHash}, activities);
    }

    protected DeleteInfo[] getDocumentURIMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        DeleteInfo[] rval = new DeleteInfo[identifierHashes.length];
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < identifierHashes.length; ++i) {
            map.put(IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]), new Integer(i));
            rval[i] = null;
        }
        this.beginTransaction();
        try {
            StringBuffer sb = new StringBuffer();
            ArrayList list = new ArrayList();
            int maxCount = this.getMaxInClause();
            int j = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxCount) {
                    this.getDocumentURIChunk(rval, map, outputConnectionName, sb.toString(), list);
                    j = 0;
                    sb.setLength(0);
                    list.clear();
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                list.add(iter.next());
                ++j;
            }
            if (j > 0) {
                this.getDocumentURIChunk(rval, map, outputConnectionName, sb.toString(), list);
            }
            DeleteInfo[] deleteInfoArray = rval;
            return deleteInfoArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public DocumentIngestStatus[] getDocumentIngestDataMultiple(String[] outputConnectionNames, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        int i;
        HashMap<String, ArrayList<Integer>> keyMap = new HashMap<String, ArrayList<Integer>>();
        for (i = 0; i < outputConnectionNames.length; ++i) {
            String outputConnectionName = outputConnectionNames[i];
            ArrayList<Integer> list = (ArrayList<Integer>)keyMap.get(outputConnectionName);
            if (list == null) {
                list = new ArrayList<Integer>();
                keyMap.put(outputConnectionName, list);
            }
            list.add(new Integer(i));
        }
        DocumentIngestStatus[] rval = new DocumentIngestStatus[outputConnectionNames.length];
        for (String outputConnectionName : keyMap.keySet()) {
            ArrayList list = (ArrayList)keyMap.get(outputConnectionName);
            String[] localIdentifierClasses = new String[list.size()];
            String[] localIdentifierHashes = new String[list.size()];
            for (i = 0; i < localIdentifierClasses.length; ++i) {
                int index = (Integer)list.get(i);
                localIdentifierClasses[i] = identifierClasses[index];
                localIdentifierHashes[i] = identifierHashes[index];
            }
            DocumentIngestStatus[] localRval = this.getDocumentIngestDataMultiple(outputConnectionName, localIdentifierClasses, localIdentifierHashes);
            for (i = 0; i < localRval.length; ++i) {
                int index = (Integer)list.get(i);
                rval[index] = localRval[i];
            }
        }
        return rval;
    }

    public DocumentIngestStatus[] getDocumentIngestDataMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        DocumentIngestStatus[] rval = new DocumentIngestStatus[identifierHashes.length];
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        for (int i = 0; i < identifierHashes.length; ++i) {
            indexMap.put(IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]), new Integer(i));
            rval[i] = null;
        }
        this.beginTransaction();
        try {
            StringBuffer sb = new StringBuffer();
            ArrayList list = new ArrayList();
            int maxCount = this.getMaxInClause();
            int j = 0;
            Iterator iter = indexMap.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxCount) {
                    this.getDocumentIngestDataChunk(rval, indexMap, outputConnectionName, sb.toString(), list);
                    j = 0;
                    sb.setLength(0);
                    list.clear();
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                list.add(iter.next());
                ++j;
            }
            if (j > 0) {
                this.getDocumentIngestDataChunk(rval, indexMap, outputConnectionName, sb.toString(), list);
            }
            DocumentIngestStatus[] documentIngestStatusArray = rval;
            return documentIngestStatusArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public DocumentIngestStatus getDocumentIngestData(String outputConnectionName, String identifierClass, String identifierHash) throws ManifoldCFException {
        return this.getDocumentIngestDataMultiple(outputConnectionName, new String[]{identifierClass}, new String[]{identifierHash})[0];
    }

    public long getDocumentUpdateInterval(String outputConnectionName, String identifierClass, String identifierHash) throws ManifoldCFException {
        return this.getDocumentUpdateIntervalMultiple(outputConnectionName, new String[]{identifierClass}, new String[]{identifierHash})[0];
    }

    public long[] getDocumentUpdateIntervalMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        int j;
        long[] rval = new long[identifierHashes.length];
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        HashMap<String, String> idCodes = new HashMap<String, String>();
        for (j = 0; j < identifierHashes.length; ++j) {
            String key = IncrementalIngester.makeKey(identifierClasses[j], identifierHashes[j]);
            rval[j] = 0L;
            returnMap.put(key, new Integer(j));
            idCodes.put(key, key);
        }
        int maxInClause = this.getMaxInClause();
        Iterator iter = idCodes.keySet().iterator();
        ArrayList list = new ArrayList();
        StringBuffer sb = new StringBuffer();
        j = 0;
        while (iter.hasNext()) {
            if (j == maxInClause) {
                this.getIntervals(rval, outputConnectionName, list, sb.toString(), returnMap);
                list.clear();
                sb.setLength(0);
                j = 0;
            }
            if (j > 0) {
                sb.append(',');
            }
            sb.append('?');
            list.add(iter.next());
            ++j;
        }
        if (j > 0) {
            this.getIntervals(rval, outputConnectionName, list, sb.toString(), returnMap);
        }
        return rval;
    }

    protected void getIntervals(long[] rval, String outputConnectionName, ArrayList list, String queryPart, HashMap returnMap) throws ManifoldCFException {
        list.add(outputConnectionName);
        IResultSet set = this.performQuery("SELECT dockey,changecount,firstingest,lastingest FROM " + this.getTableName() + " WHERE " + docKeyField + " IN(" + queryPart + ") AND " + outputConnNameField + "=?", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row;
            String docHash;
            Integer index;
            if ((index = (Integer)returnMap.get(docHash = (String)(row = set.getRow(i++)).getValue(docKeyField))) == null) continue;
            long changeCount = (Long)row.getValue(changeCountField);
            long firstIngest = (Long)row.getValue(firstIngestField);
            long lastIngest = (Long)row.getValue(lastIngestField);
            rval[index.intValue()] = (long)((double)(lastIngest - firstIngest) / (double)changeCount);
        }
    }

    public void resetOutputConnection(String outputConnectionName) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(lastVersionField, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add(outputConnectionName);
        this.performUpdate(map, "WHERE connectionname=?", list, null);
    }

    protected void noteDocumentIngest(String outputConnectionName, String docKey, String documentVersion, String outputVersion, String authorityNameString, long ingestTime, String documentURI, String documentURIHash) throws ManifoldCFException {
        while (true) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(lastVersionField, documentVersion);
            map.put(lastOutputVersionField, outputVersion);
            map.put(lastIngestField, new Long(ingestTime));
            if (documentURI != null) {
                map.put(docURIField, documentURI);
                map.put(uriHashField, documentURIHash);
            }
            if (authorityNameString != null) {
                map.put(authorityNameField, authorityNameString);
            } else {
                map.put(authorityNameField, "");
            }
            Long id = new Long(IDFactory.make((IThreadContext)this.threadContext));
            map.put(idField, id);
            map.put(outputConnNameField, outputConnectionName);
            map.put(docKeyField, docKey);
            map.put(changeCountField, new Long(1L));
            map.put(firstIngestField, map.get(lastIngestField));
            this.beginTransaction();
            try {
                this.performInsert(map, null);
                this.noteModifications(1, 0, 0);
                return;
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                if (e.getErrorCode() != 6) {
                    throw e;
                }
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
            map.clear();
            map.put(lastVersionField, documentVersion);
            map.put(lastOutputVersionField, outputVersion);
            map.put(lastIngestField, new Long(ingestTime));
            if (documentURI != null) {
                map.put(docURIField, documentURI);
                map.put(uriHashField, documentURIHash);
            }
            if (authorityNameString != null) {
                map.put(authorityNameField, authorityNameString);
            } else {
                map.put(authorityNameField, "");
            }
            this.beginTransaction();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(docKey);
                list.add(outputConnectionName);
                IResultSet set = this.performQuery("SELECT id,changecount FROM " + this.getTableName() + " WHERE " + docKeyField + "=? AND " + outputConnNameField + "=? FOR UPDATE", list, null, null);
                IResultRow row = null;
                if (set.getRowCount() > 0) {
                    row = set.getRow(0);
                }
                if (row == null) continue;
                list.clear();
                list.add(row.getValue(idField));
                long changeCount = (Long)row.getValue(changeCountField);
                map.put(changeCountField, new Long(++changeCount));
                this.performUpdate(map, "WHERE id=?", list, null);
                return;
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
                continue;
            }
            break;
        }
    }

    protected void getDocumentURIChunk(DeleteInfo[] rval, Map map, String outputConnectionName, String clause, ArrayList list) throws ManifoldCFException {
        list.add(outputConnectionName);
        IResultSet set = this.performQuery("SELECT dockey,docuri,lastoutputversion FROM " + this.getTableName() + " WHERE " + docKeyField + " IN (" + clause + ") AND " + outputConnNameField + "=?", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row;
            String docHash;
            Integer position;
            if ((position = (Integer)map.get(docHash = (row = set.getRow(i++)).getValue(docKeyField).toString())) == null) continue;
            String lastURI = (String)row.getValue(docURIField);
            if (lastURI != null && lastURI.length() == 0) {
                lastURI = null;
            }
            String lastOutputVersion = (String)row.getValue(lastOutputVersionField);
            rval[position.intValue()] = new DeleteInfo(lastURI, lastOutputVersion);
        }
    }

    protected void getDocumentIngestDataChunk(DocumentIngestStatus[] rval, Map map, String outputConnectionName, String clause, ArrayList list) throws ManifoldCFException {
        list.add(outputConnectionName);
        IResultSet set = this.performQuery("SELECT id,dockey,lastversion,lastoutputversion,authorityname FROM " + this.getTableName() + " WHERE " + docKeyField + " IN (" + clause + ") AND " + outputConnNameField + "=?", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row;
            String docHash;
            Integer position;
            if ((position = (Integer)map.get(docHash = (row = set.getRow(i++)).getValue(docKeyField).toString())) == null) continue;
            Long id = (Long)row.getValue(idField);
            String lastVersion = (String)row.getValue(lastVersionField);
            String lastOutputVersion = (String)row.getValue(lastOutputVersionField);
            String authorityName = (String)row.getValue(authorityNameField);
            rval[position.intValue()] = new DocumentIngestStatus(lastVersion, lastOutputVersion, authorityName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addOrReplaceDocument(IOutputConnection connection, String documentURI, String outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption {
        IOutputConnector connector = OutputConnectorFactory.grab(this.threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
        if (connector == null) {
            throw new ServiceInterruption("Output connector not installed", 300000L);
        }
        try {
            int n = connector.addOrReplaceDocument(documentURI, outputDescription, document, authorityNameString, activities);
            return n;
        }
        finally {
            OutputConnectorFactory.release(connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocument(IOutputConnection connection, String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        IOutputConnector connector = OutputConnectorFactory.grab(this.threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
        if (connector == null) {
            throw new ServiceInterruption("Output connector not installed", 300000L);
        }
        try {
            connector.removeDocument(documentURI, outputDescription, activities);
        }
        finally {
            OutputConnectorFactory.release(connector);
        }
    }

    protected static String makeKey(String documentClass, String documentHash) {
        return documentClass + ":" + documentHash;
    }

    protected static class DeleteInfo {
        protected String uriValue;
        protected String outputVersion;

        public DeleteInfo(String uriValue, String outputVersion) {
            this.uriValue = uriValue;
            this.outputVersion = outputVersion;
        }

        public String getURI() {
            return this.uriValue;
        }

        public String getOutputVersion() {
            return this.outputVersion;
        }
    }
}

