/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.manifoldcf.agents.interfaces.IAgent;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AgentFactory {
    public static final String _rcsid = "@(#)$Id: AgentFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String agentIdentifier = "_Agent_";

    private AgentFactory() {
    }

    public static IAgent make(IThreadContext tc, String className) throws ManifoldCFException {
        String agentName = agentIdentifier + className;
        Object o = tc.get((Object)agentName);
        if (o == null || !(o instanceof IAgent)) {
            try {
                Class<?> theClass = Class.forName(className);
                Class[] argumentClasses = new Class[]{IThreadContext.class};
                Constructor<?> c = theClass.getConstructor(argumentClasses);
                Object[] arguments = new Object[]{tc};
                o = c.newInstance(arguments);
                if (!(o instanceof IAgent)) {
                    throw new ManifoldCFException("Class '" + className + "' does not implement IAgent.");
                }
                tc.save((Object)agentName, o);
            }
            catch (InvocationTargetException e) {
                Throwable z = e.getTargetException();
                if (z instanceof Error) {
                    throw (Error)z;
                }
                throw (ManifoldCFException)z;
            }
            catch (ClassNotFoundException e) {
                throw new ManifoldCFException("No class implementing IAgent called '" + className + "'.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ManifoldCFException("No appropriate constructor for IAgent implementation '" + className + "'.  Need xxx(ConfigParams).", (Throwable)e);
            }
            catch (SecurityException e) {
                throw new ManifoldCFException("Protected constructor for IAgent implementation '" + className + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ManifoldCFException("Unavailable constructor for IAgent implementation '" + className + "'", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ManifoldCFException("InstantiationException for IAgent implementation '" + className + "'", (Throwable)e);
            }
            catch (ExceptionInInitializerError e) {
                throw new ManifoldCFException("ExceptionInInitializerError for IAgent implementation '" + className + "'", (Throwable)e);
            }
        }
        return (IAgent)o;
    }
}

