/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import org.apache.manifoldcf.agents.agentmanager.AgentManager;
import org.apache.manifoldcf.agents.interfaces.AgentFactory;
import org.apache.manifoldcf.agents.interfaces.IAgent;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AgentManagerFactory {
    public static final String _rcsid = "@(#)$Id: AgentManagerFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String agentManager = "_AgentManager_";

    private AgentManagerFactory() {
    }

    public static IAgentManager make(IThreadContext threadContext) throws ManifoldCFException {
        Object o = threadContext.get((Object)agentManager);
        if (o == null || !(o instanceof IAgentManager)) {
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            o = new AgentManager(threadContext, database);
            threadContext.save((Object)agentManager, o);
        }
        return (IAgentManager)o;
    }

    public static boolean isOutputConnectionInUse(IThreadContext threadContext, String connName) throws ManifoldCFException {
        IAgent[] theAgents = AgentManagerFactory.instantiateAllAgents(threadContext);
        int i = 0;
        while (i < theAgents.length) {
            if (!theAgents[i++].isOutputConnectionInUse(connName)) continue;
            return true;
        }
        return false;
    }

    public static void noteOutputConnectorDeregistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IAgent[] theAgents = AgentManagerFactory.instantiateAllAgents(threadContext);
        int i = 0;
        while (i < theAgents.length) {
            theAgents[i++].noteOutputConnectorDeregistration(connectionNames);
        }
    }

    public static void noteOutputConnectorRegistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IAgent[] theAgents = AgentManagerFactory.instantiateAllAgents(threadContext);
        int i = 0;
        while (i < theAgents.length) {
            theAgents[i++].noteOutputConnectorRegistration(connectionNames);
        }
    }

    public static void noteOutputConnectionChange(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IAgent[] theAgents = AgentManagerFactory.instantiateAllAgents(threadContext);
        int i = 0;
        while (i < theAgents.length) {
            theAgents[i++].noteOutputConnectionChange(connectionName);
        }
    }

    public static IAgent[] instantiateAllAgents(IThreadContext threadContext) throws ManifoldCFException {
        IAgentManager manager = AgentManagerFactory.make(threadContext);
        String[] allAgents = manager.getAllAgents();
        IAgent[] rval = new IAgent[allAgents.length];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = AgentFactory.make(threadContext, allAgents[i]);
        }
        return rval;
    }
}

