/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorFactory;
import org.apache.manifoldcf.agents.outputconnection.OutputConnectionManager;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class OutputConnectionManagerFactory {
    public static final String _rcsid = "@(#)$Id: OutputConnectionManagerFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    private static final String objectName = "_OutputConnectionMgr_";

    private OutputConnectionManagerFactory() {
    }

    public static IOutputConnectionManager make(IThreadContext tc) throws ManifoldCFException {
        Object o = tc.get((Object)objectName);
        if (o == null || !(o instanceof IOutputConnectionManager)) {
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            o = new OutputConnectionManager(tc, database);
            tc.save((Object)objectName, o);
        }
        return (IOutputConnectionManager)o;
    }

    public static String[] getAllOutputActivities(IThreadContext tc) throws ManifoldCFException {
        IOutputConnectionManager manager = OutputConnectionManagerFactory.make(tc);
        IOutputConnection[] connections = manager.getAllConnections();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < connections.length) {
            IOutputConnection connection = connections[i++];
            String connectionName = connection.getName();
            String[] activities = OutputConnectorFactory.getActivitiesList(tc, connection.getClassName());
            int j = 0;
            while (j < activities.length) {
                String activity = activities[j++] + " (" + connectionName + ")";
                map.put(activity, activity);
            }
        }
        Object[] rval = new String[map.size()];
        i = 0;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        Arrays.sort(rval);
        return rval;
    }
}

