/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class RepositoryDocument {
    public static final String _rcsid = "@(#)$Id: RepositoryDocument.java 988245 2010-08-23 18:39:35Z kwright $";
    protected InputStream binaryFieldData = null;
    protected long binaryLength = 0L;
    protected HashMap fields = new HashMap();
    protected Security fileSecurity = new Security();
    protected Security shareSecurity = new Security();
    protected ArrayList directorySecurity = new ArrayList();

    public void setACL(String[] acl) {
        this.fileSecurity.setACL(acl);
    }

    public String[] getACL() {
        return this.fileSecurity.getACL();
    }

    public void setDenyACL(String[] acl) {
        this.fileSecurity.setDenyACL(acl);
    }

    public String[] getDenyACL() {
        return this.fileSecurity.getDenyACL();
    }

    public void setShareACL(String[] acl) {
        this.shareSecurity.setACL(acl);
    }

    public String[] getShareACL() {
        return this.shareSecurity.getACL();
    }

    public void setShareDenyACL(String[] acl) {
        this.shareSecurity.setDenyACL(acl);
    }

    public String[] getShareDenyACL() {
        return this.shareSecurity.getDenyACL();
    }

    public void clearDirectoryACLs() {
        this.directorySecurity.clear();
    }

    public int countDirectoryACLs() {
        return this.directorySecurity.size();
    }

    public void addDirectoryACLs(String[] allowACL, String[] denyACL) {
        Security s = new Security();
        s.setACL(allowACL);
        s.setDenyACL(denyACL);
        this.directorySecurity.add(s);
    }

    public String[] getDirectoryACL(int index) {
        Security s = (Security)this.directorySecurity.get(index);
        return s.getACL();
    }

    public String[] getDirectoryDenyACL(int index) {
        Security s = (Security)this.directorySecurity.get(index);
        return s.getDenyACL();
    }

    public void setBinary(InputStream binaryFieldData, long binaryLength) {
        this.binaryFieldData = binaryFieldData;
        this.binaryLength = binaryLength;
    }

    public InputStream getBinaryStream() {
        return this.binaryFieldData;
    }

    public long getBinaryLength() {
        return this.binaryLength;
    }

    public void addField(String fieldName, Reader[] fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.fields.remove(fieldName);
        } else {
            this.fields.put(fieldName, fieldData);
        }
    }

    public void addField(String fieldName, Reader fieldData) throws ManifoldCFException {
        this.fields.put(fieldName, new Reader[]{fieldData});
    }

    public void addField(String fieldName, String[] fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.fields.remove(fieldName);
        } else {
            this.fields.put(fieldName, fieldData);
        }
    }

    public void addField(String fieldName, String fieldData) throws ManifoldCFException {
        this.fields.put(fieldName, new String[]{fieldData});
    }

    public Object[] getField(String fieldName) {
        return (Object[])this.fields.get(fieldName);
    }

    public int fieldCount() {
        return this.fields.size();
    }

    public Iterator getFields() {
        return this.fields.keySet().iterator();
    }

    protected static class Security {
        protected String[] tokens = null;
        protected String[] denyTokens = null;

        public void setACL(String[] tokens) {
            this.tokens = tokens;
        }

        public String[] getACL() {
            return this.tokens;
        }

        public void setDenyACL(String[] tokens) {
            this.denyTokens = tokens;
        }

        public String[] getDenyACL() {
            return this.denyTokens;
        }
    }
}

