/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.outputconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.outputconnection.OutputConnection;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;

public class OutputConnectionManager
extends BaseTable
implements IOutputConnectionManager {
    public static final String _rcsid = "@(#)$Id: OutputConnectionManager.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "connectionname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected static Random random = new Random();
    ICacheManager cacheManager;
    IThreadContext threadContext;

    public OutputConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "outputconnections");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    public void install() throws ManifoldCFException {
        block0: {
            Map existing = this.getTableSchema(null, null);
            if (existing != null) break block0;
            HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
            map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
            map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
            map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
            map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
            map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
            this.performCreate(map, null);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        IOutputConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IOutputConnection conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
        }
    }

    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 1) {
            throw new IOException("Unknown repository connection configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IOutputConnection conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            this.save(conn);
        }
    }

    public IOutputConnection[] getAllConnections() throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(OutputConnectionManager.getOutputConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT connectionname,lower(connectionname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IOutputConnection[] iOutputConnectionArray = this.loadMultiple(names);
            return iOutputConnectionArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public IOutputConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    public IOutputConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        OutputConnectionDescription[] objectDescriptions = new OutputConnectionDescription[names.length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < names.length; ++i) {
            ssb.clear();
            ssb.add(OutputConnectionManager.getOutputConnectionKey(names[i]));
            objectDescriptions[i] = new OutputConnectionDescription(names[i], new StringSet(ssb));
        }
        OutputConnectionExecutor exec = new OutputConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        return exec.getResults();
    }

    public IOutputConnection create() throws ManifoldCFException {
        OutputConnection rval = new OutputConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    public boolean save(IOutputConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String name) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(OutputConnectionManager.getOutputConnectionsKey());
        ssb.add(OutputConnectionManager.getOutputConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
        try {
            this.beginTransaction();
            try {
                if (AgentManagerFactory.isOutputConnectionInUse(this.threadContext, name)) {
                    throw new ManifoldCFException("Can't delete output connection '" + name + "': existing entities refer to it");
                }
                ManifoldCF.noteConfigurationChange();
                ArrayList<String> params = new ArrayList<String>();
                params.add(name);
                this.performDelete("WHERE connectionname=?", params, null);
                this.cacheManager.invalidateKeys(ch);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    public String[] findConnectionsForConnector(String className) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(OutputConnectionManager.getOutputConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList<String> params = new ArrayList<String>();
        params.add(className);
        IResultSet set = this.performQuery("SELECT connectionname FROM " + this.getTableName() + " WHERE " + classNameField + "=?", params, localCacheKeys, null);
        Object[] rval = new String[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(nameField);
        }
        Arrays.sort(rval);
        return rval;
    }

    public boolean checkConnectorExists(String name) throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(OutputConnectionManager.getOutputConnectionKey(name));
            StringSet localCacheKeys = new StringSet(ssb);
            ArrayList<String> params = new ArrayList<String>();
            params.add(name);
            IResultSet set = this.performQuery("SELECT classname FROM " + this.getTableName() + " WHERE " + nameField + "=?", params, localCacheKeys, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("No such connection: '" + name + "'");
            }
            IResultRow row = set.getRow(0);
            String className = (String)row.getValue(classNameField);
            IOutputConnectorManager cm = OutputConnectorManagerFactory.make(this.threadContext);
            boolean bl = cm.isInstalled(className);
            return bl;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public String getConnectionNameColumn() {
        return nameField;
    }

    protected static String getOutputConnectionsKey() {
        return CacheKeyFactory.makeOutputConnectionsKey();
    }

    protected static String getOutputConnectionKey(String connectionName) {
        return CacheKeyFactory.makeOutputConnectionKey(connectionName);
    }

    protected OutputConnection[] getOutputConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        OutputConnection[] rval = new OutputConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            StringBuffer sb = new StringBuffer();
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.getMaxInClause();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getOutputConnectionsChunk(rval, returnIndex, sb.toString(), params);
                    sb.setLength(0);
                    params.clear();
                    j = 0;
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getOutputConnectionsChunk(rval, returnIndex, sb.toString(), params);
            }
            OutputConnection[] outputConnectionArray = rval;
            return outputConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected void getOutputConnectionsChunk(OutputConnection[] rval, Map returnIndex, String idList, ArrayList params) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + nameField + " IN (" + idList + ")", params, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            OutputConnection rc = new OutputConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
    }

    protected static class OutputConnectionExecutor
    extends ExecutorBase {
        protected OutputConnectionManager thisManager;
        protected OutputConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public OutputConnectionExecutor(OutputConnectionManager manager, OutputConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new OutputConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public OutputConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                OutputConnectionDescription desc = (OutputConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getOutputConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            OutputConnectionDescription objectDesc = (OutputConnectionDescription)objectDescription;
            OutputConnection ci = (OutputConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class OutputConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public OutputConnectionDescription(String connectionName, StringSet invKeys) {
            super("outputconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof OutputConnectionDescription)) {
                return false;
            }
            OutputConnectionDescription d = (OutputConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

