/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.system;

import java.util.HashMap;
import org.apache.manifoldcf.agents.interfaces.AgentFactory;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IAgent;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IShutdownHook;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class ManifoldCF
extends org.apache.manifoldcf.core.system.ManifoldCF {
    public static final String _rcsid = "@(#)$Id: ManifoldCF.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static boolean agentsInitialized = false;
    protected static HashMap runningHash = new HashMap();
    protected static boolean stopAgentsRun = false;
    protected static final String API_ERRORNODE = "error";
    protected static final String API_SERVICEINTERRUPTIONNODE = "service_interruption";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment() throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (agentsInitialized) {
                return;
            }
            org.apache.manifoldcf.core.system.ManifoldCF.initializeEnvironment();
            org.apache.manifoldcf.core.system.ManifoldCF.addShutdownHook((IShutdownHook)new AgentsShutdownHook());
            Logging.initializeLoggers();
            Logging.setLogLevels();
            agentsInitialized = true;
        }
    }

    public static void installTables(IThreadContext threadcontext) throws ManifoldCFException {
        IAgentManager mgr = AgentManagerFactory.make(threadcontext);
        IIncrementalIngester igstmgr = IncrementalIngesterFactory.make(threadcontext);
        IOutputConnectorManager outputConnMgr = OutputConnectorManagerFactory.make(threadcontext);
        IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make(threadcontext);
        mgr.install();
        outputConnMgr.install();
        outputConnectionManager.install();
        igstmgr.install();
    }

    public static void deinstallTables(IThreadContext threadcontext) throws ManifoldCFException {
        IAgentManager mgr = AgentManagerFactory.make(threadcontext);
        IIncrementalIngester igstmgr = IncrementalIngesterFactory.make(threadcontext);
        IOutputConnectorManager outputConnMgr = OutputConnectorManagerFactory.make(threadcontext);
        IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make(threadcontext);
        igstmgr.deinstall();
        outputConnectionManager.deinstall();
        outputConnMgr.deinstall();
        mgr.deinstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAgents(IThreadContext threadContext) throws ManifoldCFException {
        IAgentManager manager = AgentManagerFactory.make(threadContext);
        String[] classes = manager.getAllAgents();
        ManifoldCFException problem = null;
        HashMap hashMap = runningHash;
        synchronized (hashMap) {
            if (stopAgentsRun) {
                return;
            }
            int i = 0;
            while (i < classes.length) {
                String className;
                if (runningHash.get(className = classes[i++]) != null) continue;
                IAgent agent = AgentFactory.make(threadContext, className);
                try {
                    agent.startAgent();
                    runningHash.put(className, agent);
                }
                catch (ManifoldCFException e) {
                    problem = e;
                }
            }
        }
        if (problem != null) {
            throw problem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAgents(IThreadContext threadContext) throws ManifoldCFException {
        HashMap hashMap = runningHash;
        synchronized (hashMap) {
            HashMap iterHash = (HashMap)runningHash.clone();
            for (String className : iterHash.keySet()) {
                IAgent agent = (IAgent)runningHash.get(className);
                agent.stopAgent();
                runningHash.remove(className);
            }
        }
    }

    public static void signalOutputConnectionRedo(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IIncrementalIngester ingester = IncrementalIngesterFactory.make(threadContext);
        ingester.resetOutputConnection(connectionName);
        AgentManagerFactory.noteOutputConnectionChange(threadContext, connectionName);
    }

    public static ConfigurationNode findConfigurationNode(Configuration input, String argumentName) {
        int i = 0;
        while (i < input.getChildCount()) {
            ConfigurationNode cn;
            if (!(cn = input.findChild(i++)).getType().equals(argumentName)) continue;
            return cn;
        }
        return null;
    }

    public static String getRootArgument(Configuration input, String argumentName) {
        ConfigurationNode node = ManifoldCF.findConfigurationNode(input, argumentName);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public static void createErrorNode(Configuration output, ManifoldCFException e) throws ManifoldCFException {
        if (e.getErrorCode() == 2) {
            throw e;
        }
        Logging.api.error((Object)e.getMessage(), (Throwable)e);
        ConfigurationNode error = new ConfigurationNode(API_ERRORNODE);
        error.setValue(e.getMessage());
        output.addChild(output.getChildCount(), error);
    }

    public static void createServiceInterruptionNode(Configuration output, ServiceInterruption e) {
        Logging.api.warn((Object)e.getMessage(), (Throwable)e);
        ConfigurationNode error = new ConfigurationNode(API_SERVICEINTERRUPTIONNODE);
        error.setValue(e.getMessage());
        output.addChild(output.getChildCount(), error);
    }

    protected static class AgentsShutdownHook
    implements IShutdownHook {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doCleanup() throws ManifoldCFException {
            HashMap hashMap = runningHash;
            synchronized (hashMap) {
                stopAgentsRun = true;
            }
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.stopAgents(tc);
        }
    }
}

