/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IDocumentIdentifierStream;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;

public class FileConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: FileConnector.java 995085 2010-09-08 15:13:38Z kwright $";
    protected static final String ACTIVITY_READ = "read document";
    protected static final String RELATIONSHIP_CHILD = "child";
    protected static final String[] activitiesList = new String[]{"read document"};

    public String getJSPFolder() {
        return "filesystem";
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public String[] getBinNames(String documentIdentifier) {
        if (documentIdentifier.indexOf("/BOTH/") != -1 || documentIdentifier.indexOf("/SLOW/") != -1 && documentIdentifier.indexOf("/FAST/") != -1) {
            return new String[]{"SLOW", "FAST"};
        }
        if (documentIdentifier.indexOf("/SLOW/") != -1) {
            return new String[]{"SLOW"};
        }
        if (documentIdentifier.indexOf("/FAST/") != -1) {
            return new String[]{"FAST"};
        }
        return new String[]{""};
    }

    protected String convertToURI(String documentIdentifier) throws ManifoldCFException {
        try {
            return new File(documentIdentifier).toURI().toURL().toString();
        }
        catch (IOException e) {
            throw new ManifoldCFException("Bad url", (Throwable)e);
        }
    }

    public IDocumentIdentifierStream getDocumentIdentifiers(DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException {
        return new IdentifierStream(spec);
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, DocumentSpecification spec) throws ManifoldCFException, ServiceInterruption {
        String[] rval = new String[documentIdentifiers.length];
        for (int i = 0; i < rval.length; ++i) {
            File file = new File(documentIdentifiers[i]);
            if (file.exists()) {
                long lastModified;
                if (file.isDirectory()) {
                    lastModified = file.lastModified();
                    rval[i] = new Long(lastModified).toString();
                    continue;
                }
                lastModified = file.lastModified();
                long fileLength = file.length();
                StringBuffer sb = new StringBuffer();
                sb.append(new Long(lastModified).toString()).append(":").append(new Long(fileLength).toString());
                rval[i] = sb.toString();
                continue;
            }
            rval[i] = null;
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, DocumentSpecification spec, boolean[] scanOnly) throws ManifoldCFException, ServiceInterruption {
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            String errorDesc;
            String errorCode;
            long startTime;
            File file = new File(documentIdentifiers[i]);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                String documentIdentifier;
                startTime = System.currentTimeMillis();
                errorCode = "OK";
                errorDesc = null;
                String entityReference = documentIdentifier = documentIdentifiers[i];
                try {
                    try {
                        File[] files = file.listFiles();
                        if (files == null) continue;
                        int j = 0;
                        while (j < files.length) {
                            File f;
                            String canonicalPath = f.getCanonicalPath();
                            if (!FileConnector.checkInclude(f = files[j++], canonicalPath, spec)) continue;
                            activities.addDocumentReference(canonicalPath, documentIdentifier, RELATIONSHIP_CHILD);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        errorCode = "IO ERROR";
                        errorDesc = e.getMessage();
                        throw new ManifoldCFException("IO Error: " + e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    activities.recordActivity(new Long(startTime), ACTIVITY_READ, null, entityReference, errorCode, errorDesc, null);
                }
            }
            if (scanOnly[i] || !FileConnector.checkIngest(file, spec)) continue;
            startTime = System.currentTimeMillis();
            errorCode = "OK";
            errorDesc = null;
            Long fileLength = null;
            String documentIdentifier = documentIdentifiers[i];
            String version = versions[i];
            String entityDescription = documentIdentifier;
            try {
                try {
                    FileInputStream is = new FileInputStream(file);
                    try {
                        long fileBytes = file.length();
                        RepositoryDocument data = new RepositoryDocument();
                        data.setBinary((InputStream)is, fileBytes);
                        data.addField("uri", file.toString());
                        activities.ingestDocument(documentIdentifier, version, this.convertToURI(documentIdentifier), data);
                        fileLength = new Long(fileBytes);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    errorCode = "IO ERROR";
                    errorDesc = e.getMessage();
                    throw new ManifoldCFException("IO Error: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileLength, entityDescription, errorCode, errorDesc, null);
                throw throwable;
            }
            activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileLength, entityDescription, errorCode, errorDesc, null);
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException, IOException {
    }

    public void outputSpecificationHeader(IHTTPOutput out, DocumentSpecification ds, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Paths");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkSpecification()\n{\n  // Does nothing right now.\n  return true;\n}\n\nfunction SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, DocumentSpecification ds, String tabName) throws ManifoldCFException, IOException {
        if (tabName.equals("Paths")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"3\"><hr/></td></tr>\n");
            int i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                int j;
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
                String pathDescription = "_" + Integer.toString(k);
                String pathOpName = "specop" + pathDescription;
                if (k == 0) {
                    out.print("  <tr>\n    <td class=\"description\"><nobr>Paths:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>Root path</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Rules</nobr></td>\n        </tr>\n");
                }
                out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <input type=\"hidden\" name=\"" + pathOpName + "\" value=\"\"/>\n" + "            <input type=\"hidden\" name=\"" + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)sn.getAttributeValue("path")) + "\"/>\n" + "            <a name=\"" + "path_" + Integer.toString(k) + "\">\n" + "              <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"" + pathOpName + "\",\"Delete\",\"path_" + Integer.toString(k) + "\")' alt=\"" + "Delete path #" + Integer.toString(k) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              " + Encoder.bodyEscape((String)sn.getAttributeValue("path")) + " \n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"boxcell\">\n" + "            <input type=\"hidden\" name=\"" + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(sn.getChildCount()) + "\"/>\n" + "            <table class=\"formtable\">\n" + "              <tr class=\"formheaderrow\">\n" + "                <td class=\"formcolumnheader\"></td>\n" + "                <td class=\"formcolumnheader\"><nobr>Include/exclude</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>File/directory</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>Match</nobr></td>\n" + "              </tr>\n");
                for (j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String instanceOpName = "specop" + instanceDescription;
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue("type");
                    String nodeMatch = excludeNode.getAttributeValue("match");
                    out.print("              <tr class=\"evenformrow\">\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <input type=\"button\" value=\"Insert Here\" onClick='Javascript:SpecOp(\"specop" + instanceDescription + "\",\"Insert Here\",\"match_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + "Insert new match for path #" + Integer.toString(k) + " before position #" + Integer.toString(j) + "\"/>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + "specflavor" + instanceDescription + "\">\n" + "                      <option value=\"include\">include</option>\n" + "                      <option value=\"exclude\">exclude</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + "spectype" + instanceDescription + "\">\n" + "                      <option value=\"file\">File</option>\n" + "                      <option value=\"directory\">Directory</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <input type=\"text\" size=\"10\" name=\"" + "specmatch" + instanceDescription + "\" value=\"\"/>\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n" + "              <tr class=\"oddformrow\">\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <input type=\"hidden\" name=\"" + "specop" + instanceDescription + "\" value=\"\"/>\n" + "                    <input type=\"hidden\" name=\"" + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n" + "                    <input type=\"hidden\" name=\"" + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n" + "                    <input type=\"hidden\" name=\"" + "specma" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)nodeMatch) + "\"/>\n" + "                    <a name=\"" + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n" + "                      <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"specop" + instanceDescription + "\",\"Delete\",\"match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\")' alt=\"" + "Delete path #" + Integer.toString(k) + ", match spec #" + Integer.toString(j) + "\"/>\n" + "                    </a>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + nodeFlavor + "\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + nodeType + "\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + Encoder.bodyEscape((String)nodeMatch) + "\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n");
                }
                if (j == 0) {
                    out.print("              <tr class=\"formrow\"><td class=\"message\" colspan=\"4\">No rules defined</td></tr>\n");
                }
                out.print("              <tr class=\"formrow\"><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n              <tr class=\"formrow\">\n                <td class=\"formcolumncell\">\n                  <a name=\"match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n" + "                    <input type=\"button\" value=\"Add\" onClick='Javascript:SpecOp(\"" + pathOpName + "\",\"Add\",\"match_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + "Add new match for path #" + Integer.toString(k) + "\"/>\n" + "                  </a>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + "specflavor" + pathDescription + "\">\n" + "                      <option value=\"include\">include</option>\n" + "                      <option value=\"exclude\">exclude</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + "spectype" + pathDescription + "\">\n" + "                      <option value=\"file\">file</option>\n" + "                      <option value=\"directory\">directory</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <input type=\"text\" size=\"10\" name=\"" + "specmatch" + pathDescription + "\" value=\"\"/>\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n" + "            </table>\n" + "          </td>\n" + "        </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"message\" colspan=\"3\">No documents specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"lightseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              <a name=\"path_" + Integer.toString(k) + "\">\n" + "                <input type=\"button\" value=\"Add\" onClick='Javascript:SpecOp(\"specop\",\"Add\",\"path_" + Integer.toString(i + 1) + "\")' alt=\"Add new path\"/>\n" + "                <input type=\"hidden\" name=\"pathcount\" value=\"" + Integer.toString(k) + "\"/>\n" + "                <input type=\"hidden\" name=\"specop\" value=\"\"/>\n" + "              </a>\n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              <input type=\"text\" size=\"80\" name=\"specpath\" value=\"\"/>\n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            int i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
                String pathDescription = "_" + Integer.toString(k);
                out.print("<input type=\"hidden\" name=\"specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)sn.getAttributeValue("path")) + "\"/>\n" + "<input type=\"hidden\" name=\"specchildcount" + pathDescription + "\" value=\"" + Integer.toString(sn.getChildCount()) + "\"/>\n");
                for (int j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue("type");
                    String nodeMatch = excludeNode.getAttributeValue("match");
                    out.print("<input type=\"hidden\" name=\"specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n" + "<input type=\"hidden\" name=\"specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n" + "<input type=\"hidden\" name=\"specma" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)nodeMatch) + "\"/>\n");
                }
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, DocumentSpecification ds) throws ManifoldCFException {
        String x = variableContext.getParameter("pathcount");
        if (x != null) {
            ds.clearChildren();
            int pathCount = Integer.parseInt(x);
            int i = 0;
            int k = 0;
            while (i < pathCount) {
                String pathDescription = "_" + Integer.toString(i);
                String pathOpName = "specop" + pathDescription;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path = variableContext.getParameter("specpath" + pathDescription);
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path);
                String y = variableContext.getParameter("specchildcount" + pathDescription);
                int childCount = Integer.parseInt(y);
                int j = 0;
                int w = 0;
                while (j < childCount) {
                    SpecificationNode sn;
                    String match;
                    String type;
                    String flavor;
                    String instanceDescription = "_" + Integer.toString(i) + "_" + Integer.toString(j);
                    String instanceOp = "specop" + instanceDescription;
                    String z = variableContext.getParameter(instanceOp);
                    if (z != null && z.equals("Delete")) {
                        ++j;
                        continue;
                    }
                    if (z != null && z.equals("Insert Here")) {
                        flavor = variableContext.getParameter("specflavor" + instanceDescription);
                        type = variableContext.getParameter("spectype" + instanceDescription);
                        match = variableContext.getParameter("specmatch" + instanceDescription);
                        sn = new SpecificationNode(flavor);
                        sn.setAttribute("type", type);
                        sn.setAttribute("match", match);
                        node.addChild(w++, (ConfigurationNode)sn);
                    }
                    flavor = variableContext.getParameter("specfl" + instanceDescription);
                    type = variableContext.getParameter("specty" + instanceDescription);
                    match = variableContext.getParameter("specma" + instanceDescription);
                    sn = new SpecificationNode(flavor);
                    sn.setAttribute("type", type);
                    sn.setAttribute("match", match);
                    node.addChild(w++, (ConfigurationNode)sn);
                    ++j;
                }
                if (x != null && x.equals("Add")) {
                    String match = variableContext.getParameter("specmatch" + pathDescription);
                    String type = variableContext.getParameter("spectype" + pathDescription);
                    String flavor = variableContext.getParameter("specflavor" + pathDescription);
                    SpecificationNode sn = new SpecificationNode(flavor);
                    sn.setAttribute("type", type);
                    sn.setAttribute("match", match);
                    node.addChild(w, (ConfigurationNode)sn);
                }
                ds.addChild(k++, (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter("specop");
            if (op != null && op.equals("Add")) {
                String path = variableContext.getParameter("specpath");
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path);
                SpecificationNode sn = new SpecificationNode("include");
                sn.setAttribute("type", "file");
                sn.setAttribute("match", "*");
                node.addChild(node.getChildCount(), (ConfigurationNode)sn);
                sn = new SpecificationNode("include");
                sn.setAttribute("type", "directory");
                sn.setAttribute("match", "*");
                node.addChild(node.getChildCount(), (ConfigurationNode)sn);
                ds.addChild(k, (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, DocumentSpecification ds) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n");
        int i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
            if (!seenAny) {
                seenAny = true;
            }
            out.print("  <tr>\n    <td class=\"description\">" + Encoder.bodyEscape((String)sn.getAttributeValue("path")) + ":" + "</td>\n" + "    <td class=\"value\">\n");
            int j = 0;
            while (j < sn.getChildCount()) {
                SpecificationNode excludeNode = sn.getChild(j++);
                out.print("      " + (excludeNode.getType().equals("include") ? "Include " : "") + "\n" + "      " + (excludeNode.getType().equals("exclude") ? "Exclude " : "") + "\n" + "      " + (excludeNode.getAttributeValue("type").equals("file") ? "file " : "") + "\n" + "      " + (excludeNode.getAttributeValue("type").equals("directory") ? "directory " : "") + "\n" + "      " + Encoder.bodyEscape((String)excludeNode.getAttributeValue("match")) + "<br/>\n");
            }
            out.print("    </td>\n  </tr>\n");
        }
        if (!seenAny) {
            out.print("  <tr><td class=\"message\">No documents specified</td></tr>\n");
        }
        out.print("</table>\n");
    }

    protected static boolean checkInclude(File file, String fileName, DocumentSpecification documentSpecification) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Checking whether to include file '" + fileName + "'"));
        }
        try {
            String filePart;
            String pathPart;
            if (file.isDirectory()) {
                pathPart = fileName;
                filePart = null;
            } else {
                pathPart = file.getParentFile().getCanonicalPath();
                filePart = file.getName();
            }
            int i = 0;
            while (i < documentSpecification.getChildCount()) {
                int matchEnd;
                SpecificationNode sn;
                if (!(sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) continue;
                String path = new File(sn.getAttributeValue("path")).getCanonicalPath();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Checking path '" + path + "' against canonical '" + pathPart + "'"));
                }
                if ((matchEnd = FileConnector.matchSubPath(path, pathPart)) == -1) {
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("Match check '" + path + "' against canonical '" + pathPart + "' failed"));
                    continue;
                }
                int j = 0;
                while (j < sn.getChildCount()) {
                    int sourceIndex;
                    String sourceMatch;
                    SpecificationNode node = sn.getChild(j++);
                    String flavor = node.getType();
                    String match = node.getAttributeValue("match");
                    String type = node.getAttributeValue("type");
                    if (type.equals("file")) {
                        if (filePart == null) continue;
                        sourceMatch = filePart;
                        sourceIndex = 0;
                    } else {
                        if (filePart != null) continue;
                        sourceMatch = pathPart;
                        sourceIndex = matchEnd;
                    }
                    if (flavor.equals("include")) {
                        if (!FileConnector.checkMatch(sourceMatch, sourceIndex, match)) continue;
                        return true;
                    }
                    if (!flavor.equals("exclude") || !FileConnector.checkMatch(sourceMatch, sourceIndex, match)) continue;
                    return false;
                }
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Not including '" + fileName + "' because no matching rules"));
            }
            return false;
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO Error", (Throwable)e);
        }
    }

    protected static boolean checkIngest(File file, DocumentSpecification documentSpecification) throws ManifoldCFException {
        return true;
    }

    protected static int matchSubPath(String subPath, String fullPath) {
        if (subPath.length() > fullPath.length()) {
            return -1;
        }
        if (!fullPath.startsWith(subPath)) {
            return -1;
        }
        int rval = subPath.length();
        if (fullPath.length() == rval) {
            return rval;
        }
        char x = fullPath.charAt(rval);
        if (x == File.separatorChar) {
            ++rval;
        }
        return rval;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = true;
        return FileConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return FileConnector.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || FileConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    protected static class IdentifierStream
    implements IDocumentIdentifierStream {
        protected String[] ids = null;
        protected int currentIndex = 0;

        public IdentifierStream(DocumentSpecification spec) throws ManifoldCFException {
            try {
                SpecificationNode n;
                int i;
                int j = 0;
                for (i = 0; i < spec.getChildCount(); ++i) {
                    n = spec.getChild(i);
                    if (!n.getType().equals("startpoint")) continue;
                    ++j;
                }
                this.ids = new String[j];
                j = 0;
                for (i = 0; i < this.ids.length; ++i) {
                    n = spec.getChild(i);
                    if (!n.getType().equals("startpoint")) continue;
                    this.ids[j] = new File(n.getAttributeValue("path")).getCanonicalPath();
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Seed = '" + this.ids[j] + "'"));
                    }
                    ++j;
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("Could not get a canonical path", (Throwable)e);
            }
        }

        public String getNextIdentifier() throws ManifoldCFException, ServiceInterruption {
            if (this.currentIndex == this.ids.length) {
                return null;
            }
            return this.ids[this.currentIndex++];
        }

        public void close() throws ManifoldCFException {
            this.ids = null;
        }
    }
}

