/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.antadapter.AntAdapterMessages;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JDTCompilerAdapter
extends DefaultCompilerAdapter {
    private static final char[] SEPARATOR_CHARS = new char[]{'/', '\\'};
    private static final char[] ADAPTER_PREFIX = "#ADAPTER#".toCharArray();
    private static final char[] ADAPTER_ENCODING = "ENCODING#".toCharArray();
    private static final char[] ADAPTER_ACCESS = "ACCESS#".toCharArray();
    private static String compilerClass = "org.eclipse.jdt.internal.compiler.batch.Main";
    String logFileName;
    Map customDefaultOptions;
    private Map fileEncodings = null;
    private Map dirEncodings = null;
    private List accessRules = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public boolean execute() throws BuildException {
        this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.usingJDTCompiler"), 3);
        Commandline commandline = this.setupJavacCommand();
        try {
            Class<?> clazz = Class.forName(compilerClass);
            Class[] classArray = new Class[4];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            classArray[2] = Boolean.TYPE;
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz4;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(new PrintWriter(System.out), new PrintWriter(System.err), Boolean.TRUE, this.customDefaultOptions);
            Class[] classArray2 = new Class[1];
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz5;
            Method method = clazz.getMethod("compile", classArray2);
            Object object = method.invoke(obj, new Object[]{commandline.getArguments()});
            boolean bl = (Boolean)object;
            if (!bl && this.logFileName != null) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.error.compilationFailed", this.logFileName));
            }
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(AntAdapterMessages.getString("ant.jdtadapter.error.cannotFindJDTCompiler"));
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    protected Commandline setupJavacCommand() throws BuildException {
        int n;
        int n2;
        Object object;
        String string;
        Commandline commandline = new Commandline();
        this.customDefaultOptions = new CompilerOptions().getMap();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.apache.tools.ant.taskdefs.Javac");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        String[] stringArray = this.processCompilerArguments(clazz2);
        commandline.createArgument().setValue("-noExit");
        if (this.bootclasspath != null) {
            commandline.createArgument().setValue("-bootclasspath");
            if (this.bootclasspath.size() != 0) {
                commandline.createArgument().setPath(this.bootclasspath);
            } else {
                commandline.createArgument().setValue(Util.EMPTY_STRING);
            }
        }
        Path path = new Path(this.project);
        if (this.extdirs != null) {
            commandline.createArgument().setValue("-extdirs");
            commandline.createArgument().setPath(this.extdirs);
        }
        path.append(this.getCompileClasspath());
        Path path2 = null;
        Method method = null;
        try {
            method = clazz2.getMethod("getSourcepath", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Path path3 = null;
        if (method != null) {
            try {
                path3 = (Path)method.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        path2 = path3 != null ? path3 : this.src;
        path.append(path2);
        commandline.createArgument().setValue("-classpath");
        this.createClasspathArgument(commandline, path);
        String string2 = JavaEnvUtils.getJavaVersion();
        String string3 = string = string2.equals("1.1") ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryInitialSize"), 1);
            } else {
                commandline.createArgument().setValue(String.valueOf(string) + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryMaximumSize"), 1);
            } else {
                commandline.createArgument().setValue(String.valueOf(string) + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.debug) {
            object = null;
            try {
                object = clazz2.getMethod("getDebugLevel", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            String string4 = null;
            if (object != null) {
                try {
                    string4 = (String)object.invoke((Object)this.attributes, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (string4 != null) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                if (string4.length() != 0) {
                    if (string4.indexOf("vars") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    }
                    if (string4.indexOf("lines") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    }
                    if (string4.indexOf("source") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    }
                }
            } else {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            }
        } else {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        }
        if (this.attributes.getNowarn()) {
            object = this.customDefaultOptions.entrySet().toArray();
            int n3 = 0;
            n2 = ((Object[])object).length;
            while (n3 < n2) {
                Map.Entry entry = (Map.Entry)object[n3];
                if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                    this.customDefaultOptions.put(entry.getKey(), "ignore");
                }
                ++n3;
            }
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
            if (this.deprecation) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
            }
        } else if (this.deprecation) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        } else {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
        }
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir.getAbsoluteFile());
        }
        if (this.verbose) {
            commandline.createArgument().setValue("-verbose");
        }
        if (!this.attributes.getFailonerror()) {
            commandline.createArgument().setValue("-proceedOnError");
        }
        if (this.target != null) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.target);
        }
        if ((object = this.attributes.getSource()) != null) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.source", object);
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        if (stringArray != null && (n = stringArray.length) != 0) {
            n2 = 0;
            int n4 = n;
            while (n2 < n4) {
                String string5 = stringArray[n2];
                if (this.logFileName == null && "-log".equals(string5) && n2 + 1 < n4) {
                    this.logFileName = stringArray[n2 + 1];
                }
                commandline.createArgument().setValue(string5);
                ++n2;
            }
        }
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    private String[] processCompilerArguments(Class clazz) {
        Method method = null;
        try {
            method = clazz.getMethod("getCurrentCompilerArgs", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        String[] stringArray = null;
        if (method != null) {
            try {
                stringArray = (String[])method.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (stringArray != null) {
            this.checkCompilerArgs(stringArray);
        }
        return stringArray;
    }

    private void checkCompilerArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '@') {
                try {
                    char[] cArray = Util.getFileCharContent(new File(stringArray[n].substring(1)), null);
                    int n2 = 0;
                    int n3 = ADAPTER_PREFIX.length;
                    while ((n2 = CharOperation.indexOf(ADAPTER_PREFIX, cArray, true, n2)) > -1) {
                        String string;
                        int n4;
                        int n5 = n2 + n3;
                        int n6 = CharOperation.indexOf('\n', cArray, n5);
                        if (n6 == -1) {
                            n6 = cArray.length;
                        }
                        while (CharOperation.isWhitespace(cArray[n6])) {
                            --n6;
                        }
                        if (CharOperation.equals(ADAPTER_ENCODING, cArray, n5, n5 + ADAPTER_ENCODING.length)) {
                            CharOperation.replace(cArray, SEPARATOR_CHARS, File.separatorChar, n5, n6 + 1);
                            n4 = CharOperation.lastIndexOf('[', cArray, n5 += ADAPTER_ENCODING.length, n6);
                            if (n5 < n4 && n4 < n6) {
                                boolean bl = CharOperation.equals(SuffixConstants.SUFFIX_java, cArray, n4 - 5, n4, false);
                                string = String.valueOf(cArray, n5, n4 - n5);
                                String string2 = String.valueOf(cArray, n4, n6 - n4 + 1);
                                if (bl) {
                                    if (this.fileEncodings == null) {
                                        this.fileEncodings = new HashMap();
                                    }
                                    this.fileEncodings.put(string, string2);
                                } else {
                                    if (this.dirEncodings == null) {
                                        this.dirEncodings = new HashMap();
                                    }
                                    this.dirEncodings.put(string, string2);
                                }
                            }
                        } else if (CharOperation.equals(ADAPTER_ACCESS, cArray, n5, n5 + ADAPTER_ACCESS.length)) {
                            n4 = CharOperation.indexOf('[', cArray, n5 += ADAPTER_ACCESS.length, n6);
                            CharOperation.replace(cArray, SEPARATOR_CHARS, File.separatorChar, n5, n4);
                            if (n5 < n4 && n4 < n6) {
                                String string3 = String.valueOf(cArray, n5, n4 - n5);
                                string = String.valueOf(cArray, n4, n6 - n4 + 1);
                                if (this.accessRules == null) {
                                    this.accessRules = new ArrayList();
                                }
                                this.accessRules.add(string3);
                                this.accessRules.add(string);
                            }
                        }
                        n2 = n6;
                    }
                }
                catch (IOException iOException) {}
            }
            ++n;
        }
    }

    private void createClasspathArgument(Commandline commandline, Path path) {
        Commandline.Argument argument = commandline.createArgument();
        String[] stringArray = path.list();
        if (stringArray.length == 0) {
            argument.setValue(Util.EMPTY_STRING);
            return;
        }
        if (this.accessRules == null) {
            argument.setPath(path);
            return;
        }
        int n = this.accessRules.size();
        String[] stringArray2 = this.accessRules.toArray(new String[n]);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = stringArray.length;
        while (n3 < n4) {
            if (n3 > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            String string = stringArray[n3];
            stringBuffer.append(string);
            int n5 = n2;
            while (n5 < n) {
                int n6;
                String string2 = stringArray2[n5];
                if (string.endsWith(string2)) {
                    stringBuffer.append(stringArray2[n5 + 1]);
                    n2 = n5 + 2;
                    break;
                }
                if (string2.endsWith(File.separator)) {
                    n6 = string2.length();
                    if (string.regionMatches(false, string.length() - n6 + 1, string2, 0, n6 - 1)) {
                        stringBuffer.append(stringArray2[n5 + 1]);
                        n2 = n5 + 2;
                        break;
                    }
                } else if (string.endsWith(File.separator)) {
                    n6 = string2.length();
                    if (string.regionMatches(false, string.length() - n6 - 1, string2, 0, n6)) {
                        stringBuffer.append(stringArray2[n5 + 1]);
                        n2 = n5 + 2;
                        break;
                    }
                }
                n5 += 2;
            }
            ++n3;
        }
        argument.setValue(stringBuffer.toString());
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        this.attributes.log("Compilation " + commandline.describeArguments(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (this.compileList.length != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        stringBuffer.append(lSep);
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = 0;
        int n2 = 0;
        if (this.fileEncodings != null) {
            n = this.fileEncodings.size();
            stringArray = new String[n];
            this.fileEncodings.keySet().toArray(stringArray);
        }
        if (this.dirEncodings != null) {
            n2 = this.dirEncodings.size();
            stringArray2 = new String[n2];
            this.dirEncodings.keySet().toArray(stringArray2);
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((String)object2).length() - ((String)object).length();
                }
            };
            Arrays.sort(stringArray2, comparator);
        }
        int n3 = 0;
        while (n3 < this.compileList.length) {
            int n4;
            String string = this.compileList[n3].getAbsolutePath();
            boolean bl = false;
            if (stringArray != null) {
                n4 = 0;
                while (n4 < n) {
                    if (string.endsWith(stringArray[n4])) {
                        string = String.valueOf(string) + (String)this.fileEncodings.get(stringArray[n4]);
                        if (n4 < n - 1) {
                            System.arraycopy(stringArray, n4 + 1, stringArray, n4, n - n4 - 1);
                        }
                        stringArray[--n] = null;
                        bl = true;
                        break;
                    }
                    ++n4;
                }
            }
            if (!bl && stringArray2 != null) {
                n4 = 0;
                while (n4 < n2) {
                    if (string.lastIndexOf(stringArray2[n4]) != -1) {
                        string = String.valueOf(string) + (String)this.dirEncodings.get(stringArray2[n4]);
                        break;
                    }
                    ++n4;
                }
            }
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string + lSep);
            ++n3;
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }
}

