/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrame;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFile
implements TypeConstants,
TypeIds {
    private byte[] bytes;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public Set innerClassesBindings;
    public int methodCount;
    public int methodCountOffset;
    boolean isShared = false;
    public int produceAttributes;
    public SourceTypeBinding referenceBinding;
    public boolean isNestedType;
    public long targetJDK;
    public List missingTypes = null;
    public Set visitedTypes;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult compilationResult) {
        ASTNode aSTNode;
        int n;
        int n2;
        CategorizedProblem[] categorizedProblemArray;
        int n3;
        int n4;
        ReferenceBinding[] referenceBindingArray;
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        ClassFile classFile = ClassFile.getNewInstance(sourceTypeBinding);
        classFile.initialize(sourceTypeBinding, null, true);
        if (sourceTypeBinding.hasMemberTypes()) {
            referenceBindingArray = sourceTypeBinding.memberTypes;
            n4 = 0;
            n3 = referenceBindingArray.length;
            while (n4 < n3) {
                classFile.recordInnerClasses(referenceBindingArray[n4]);
                ++n4;
            }
        }
        if (sourceTypeBinding.isNestedType()) {
            classFile.recordInnerClasses(sourceTypeBinding);
        }
        referenceBindingArray = sourceTypeBinding.typeVariables();
        n4 = 0;
        n3 = referenceBindingArray.length;
        while (n4 < n3) {
            categorizedProblemArray = referenceBindingArray[n4];
            if ((categorizedProblemArray.tagBits & 0x800L) != 0L) {
                Util.recordNestedType(classFile, (TypeBinding)categorizedProblemArray);
            }
            ++n4;
        }
        FieldBinding[] fieldBindingArray = sourceTypeBinding.fields();
        if (fieldBindingArray != null && fieldBindingArray != Binding.NO_FIELDS) {
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        categorizedProblemArray = compilationResult.getErrors();
        if (categorizedProblemArray == null) {
            categorizedProblemArray = new CategorizedProblem[]{};
        }
        n3 = categorizedProblemArray.length;
        CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n3];
        System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n3);
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        if (abstractMethodDeclarationArray != null) {
            MethodBinding methodBinding;
            if (sourceTypeBinding.isInterface()) {
                classFile.addProblemClinit(categorizedProblemArray2);
                n2 = 0;
                n = abstractMethodDeclarationArray.length;
                while (n2 < n) {
                    aSTNode = abstractMethodDeclarationArray[n2];
                    methodBinding = aSTNode.binding;
                    if (methodBinding != null && !methodBinding.isConstructor()) {
                        classFile.addAbstractMethod((AbstractMethodDeclaration)aSTNode, methodBinding);
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                n = abstractMethodDeclarationArray.length;
                while (n2 < n) {
                    aSTNode = abstractMethodDeclarationArray[n2];
                    methodBinding = aSTNode.binding;
                    if (methodBinding != null) {
                        if (methodBinding.isConstructor()) {
                            classFile.addProblemConstructor((AbstractMethodDeclaration)aSTNode, methodBinding, categorizedProblemArray2);
                        } else if (methodBinding.isAbstract()) {
                            classFile.addAbstractMethod((AbstractMethodDeclaration)aSTNode, methodBinding);
                        } else {
                            classFile.addProblemMethod((AbstractMethodDeclaration)aSTNode, methodBinding, categorizedProblemArray2);
                        }
                    }
                    ++n2;
                }
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            n2 = 0;
            n = typeDeclaration.memberTypes.length;
            while (n2 < n) {
                aSTNode = typeDeclaration.memberTypes[n2];
                if (((TypeDeclaration)aSTNode).binding != null) {
                    ClassFile.createProblemType((TypeDeclaration)aSTNode, compilationResult);
                }
                ++n2;
            }
        }
        classFile.addAttributes();
        compilationResult.record(sourceTypeBinding.constantPoolName(), classFile);
    }

    public static ClassFile getNewInstance(SourceTypeBinding sourceTypeBinding) {
        LookupEnvironment lookupEnvironment = sourceTypeBinding.scope.environment();
        return lookupEnvironment.classFilePool.acquire(sourceTypeBinding);
    }

    protected ClassFile() {
    }

    public ClassFile(SourceTypeBinding sourceTypeBinding) {
        this.constantPool = new ConstantPool(this);
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        this.referenceBinding = sourceTypeBinding;
        this.isNestedType = sourceTypeBinding.isNestedType();
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else if (this.targetJDK == 2949124L) {
            this.targetJDK = 2949123L;
            this.produceAttributes |= 0x10;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else {
            this.codeStream = new CodeStream(this);
        }
        this.initByteArrays();
    }

    public void addAbstractMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding) {
        methodBinding.modifiers = 1025;
        this.generateMethodInfoHeader(methodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        this.completeMethodInfo(n, n2);
    }

    public void addAttributes() {
        int n;
        Annotation[] annotationArray;
        TypeDeclaration typeDeclaration;
        int n2;
        int n3;
        char[] cArray;
        int n4;
        int n5;
        int n6;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int n7 = 0;
        int n8 = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            String string = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            n6 = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n6 != -1) {
                string = string.substring(n6 + 1, string.length());
            }
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n4 = this.constantPool.literalIndex(string.toCharArray());
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            ++n7;
        }
        if (this.referenceBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int n9 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
            this.contents[this.contentsOffset++] = (byte)n9;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n7;
        }
        if ((cArray = this.referenceBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n5 = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            ++n7;
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            MethodBinding methodBinding;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 4;
            n5 = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            n4 = 0;
            n3 = 0;
            if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
                n2 = this.constantPool.literalIndexForNameAndType(methodBinding.selector, methodBinding.signature(this));
                n4 = (byte)(n2 >> 8);
                n3 = (byte)n2;
            }
            this.contents[this.contentsOffset++] = n4;
            this.contents[this.contentsOffset++] = n3;
            ++n7;
        }
        if (this.targetJDK >= 0x310000L && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null && (annotationArray = typeDeclaration.annotations) != null) {
            n7 += this.generateRuntimeAnnotations(annotationArray);
        }
        if (this.referenceBinding.isHierarchyInconsistent()) {
            ReferenceBinding referenceBinding = this.referenceBinding.superclass;
            if (referenceBinding != null) {
                this.missingTypes = referenceBinding.collectMissingTypes(this.missingTypes);
            }
            ReferenceBinding[] referenceBindingArray = this.referenceBinding.superInterfaces();
            n4 = 0;
            n3 = referenceBindingArray.length;
            while (n4 < n3) {
                this.missingTypes = referenceBindingArray[n4].collectMissingTypes(this.missingTypes);
                ++n4;
            }
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.InconsistentHierarchy);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n7;
        }
        int n10 = n = this.innerClassesBindings == null ? 0 : this.innerClassesBindings.size();
        if (n != 0) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
            this.innerClassesBindings.toArray(referenceBindingArray);
            Arrays.sort(referenceBindingArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    TypeBinding typeBinding = (TypeBinding)object;
                    TypeBinding typeBinding2 = (TypeBinding)object2;
                    return CharOperation.compareTo(typeBinding.constantPoolName(), typeBinding2.constantPoolName());
                }
            });
            n4 = 8 * n + 8;
            if (n4 + this.contentsOffset >= this.contents.length) {
                this.resizeContents(n4);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            int n11 = (n << 3) + 2;
            this.contents[this.contentsOffset++] = (byte)(n11 >> 24);
            this.contents[this.contentsOffset++] = (byte)(n11 >> 16);
            this.contents[this.contentsOffset++] = (byte)(n11 >> 8);
            this.contents[this.contentsOffset++] = (byte)n11;
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            n2 = 0;
            while (n2 < n) {
                int n12;
                ReferenceBinding referenceBinding = referenceBindingArray[n2];
                int n13 = referenceBinding.getAccessFlags();
                int n14 = this.constantPool.literalIndexForType(referenceBinding.constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(n14 >> 8);
                this.contents[this.contentsOffset++] = (byte)n14;
                if (referenceBinding.isMemberType()) {
                    n12 = this.constantPool.literalIndexForType(referenceBinding.enclosingType().constantPoolName());
                    this.contents[this.contentsOffset++] = (byte)(n12 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n12;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (!referenceBinding.isAnonymousType()) {
                    n12 = this.constantPool.literalIndex(referenceBinding.sourceName());
                    this.contents[this.contentsOffset++] = (byte)(n12 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n12;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (referenceBinding.isAnonymousType()) {
                    n13 &= 0xFFFFFFEF;
                } else if (referenceBinding.isMemberType() && referenceBinding.isInterface()) {
                    n13 |= 8;
                }
                this.contents[this.contentsOffset++] = (byte)(n13 >> 8);
                this.contents[this.contentsOffset++] = (byte)n13;
                ++n2;
            }
            ++n7;
        }
        if (this.missingTypes != null) {
            this.generateMissingTypesAttribute();
            ++n7;
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n7 >> 8);
        this.contents[n8] = (byte)n7;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int n15 = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(n15 >> 8);
        this.header[this.constantPoolOffset] = (byte)n15;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            this.generateMethodInfoHeader(methodBindingArray[n]);
            int n3 = this.contentsOffset;
            int n4 = this.generateMethodInfoAttribute(methodBindingArray[n]);
            this.completeMethodInfo(n3, n4);
            ++n;
        }
    }

    private int addFieldAttributes(FieldBinding fieldBinding, int n) {
        Annotation[] annotationArray;
        FieldDeclaration fieldDeclaration;
        char[] cArray;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        Constant constant = fieldBinding.constant();
        if (constant != Constant.NotAConstant) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            ++n5;
            switch (constant.typeID()) {
                case 5: {
                    n3 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    n2 = this.constantPool.literalIndex(constant.intValue());
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    break;
                }
                case 9: {
                    int n6 = this.constantPool.literalIndex(constant.floatValue());
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                    break;
                }
                case 8: {
                    int n7 = this.constantPool.literalIndex(constant.doubleValue());
                    this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n7;
                    break;
                }
                case 7: {
                    int n8 = this.constantPool.literalIndex(constant.longValue());
                    this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n8;
                    break;
                }
                case 11: {
                    int n9 = this.constantPool.literalIndex(((StringConstant)constant).stringValue());
                    if (n9 == -1) {
                        if (!this.creatingProblemType) {
                            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
                            int n10 = 0;
                            int n11 = fieldDeclarationArray.length;
                            while (n10 < n11) {
                                if (fieldDeclarationArray[n10].binding == fieldBinding) {
                                    typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDeclarationArray[n10]);
                                }
                                ++n10;
                            }
                            break;
                        }
                        this.contentsOffset = n;
                        break;
                    }
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                }
            }
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (fieldBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if ((cArray = fieldBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n2 = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && (fieldDeclaration = fieldBinding.sourceField()) != null && (annotationArray = fieldDeclaration.annotations) != null) {
            n5 += this.generateRuntimeAnnotations(annotationArray);
        }
        if ((fieldBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = fieldBinding.type.collectMissingTypes(this.missingTypes);
        }
        return n5;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(fieldBinding.type);
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        int n5 = 0;
        this.contentsOffset += 2;
        n5 += this.addFieldAttributes(fieldBinding, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n4++] = (byte)(n5 >> 8);
        this.contents[n4] = (byte)n5;
    }

    public void addFieldInfos() {
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        FieldBinding[] fieldBindingArray = sourceTypeBinding.syntheticFields();
        int n = sourceTypeBinding.fieldCount() + (fieldBindingArray == null ? 0 : fieldBindingArray.length);
        if (n > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        int n2 = 0;
        int n3 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
        while (n2 < n3) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            if (fieldDeclaration.binding != null) {
                this.addFieldInfo(fieldDeclaration.binding);
            }
            ++n2;
        }
        if (fieldBindingArray != null) {
            n2 = 0;
            n3 = fieldBindingArray.length;
            while (n2 < n3) {
                this.addFieldInfo(fieldBindingArray[n2]);
                ++n2;
            }
        }
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, CategorizedProblem categorizedProblem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
        stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
        String string = stringBuffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, n3, compilationResult.getLineSeparatorPositions(), categorizedProblem.getSourceLineNumber());
        this.completeMethodInfo(n, n2);
    }

    public void addProblemClinit(CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int n = this.contentsOffset;
        this.contentsOffset += 2;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError()) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                    categorizedProblemArray[n7] = null;
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        ++n2;
        this.completeCodeAttributeForClinit(n3, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError()) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(n, n2);
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.isAbstract() && methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError() && categorizedProblem.getSourceStart() >= abstractMethodDeclaration.declarationSourceStart && categorizedProblem.getSourceEnd() <= abstractMethodDeclaration.declarationSourceEnd) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                    categorizedProblemArray[n7] = null;
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(n, n2);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addSpecialMethods() {
        int n;
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n2 = 0;
        int n3 = methodBindingArray.length;
        while (n2 < n3) {
            this.generateMethodInfoHeader(methodBindingArray[n2]);
            n = this.contentsOffset;
            int n4 = this.generateMethodInfoAttribute(methodBindingArray[n2]);
            this.completeMethodInfo(n, n4);
            ++n2;
        }
        SyntheticMethodBinding[] syntheticMethodBindingArray = this.referenceBinding.syntheticMethods();
        if (syntheticMethodBindingArray != null) {
            n3 = 0;
            n = syntheticMethodBindingArray.length;
            while (n3 < n) {
                SyntheticMethodBinding syntheticMethodBinding = syntheticMethodBindingArray[n3];
                switch (syntheticMethodBinding.purpose) {
                    case 1: 
                    case 3: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.addSyntheticMethodAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 6: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 9: {
                        this.addSyntheticEnumValuesMethod(syntheticMethodBinding);
                        break;
                    }
                    case 10: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethodBinding);
                        break;
                    }
                    case 11: {
                        this.addSyntheticSwitchTable(syntheticMethodBinding);
                    }
                }
                ++n3;
            }
        }
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(true, syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void completeCodeAttribute(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte by;
        Object object;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        Object object2;
        this.contents = this.codeStream.bCodeStream;
        int n14 = this.codeStream.classFileOffset;
        int n15 = this.codeStream.position;
        if (n15 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
        }
        if (n14 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n16 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n16 >> 8);
        this.contents[n + 7] = (byte)n16;
        int n17 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n17 >> 8);
        this.contents[n + 9] = (byte)n17;
        this.contents[n + 10] = (byte)(n15 >> 24);
        this.contents[n + 11] = (byte)(n15 >> 16);
        this.contents[n + 12] = (byte)(n15 >> 8);
        this.contents[n + 13] = (byte)n15;
        boolean bl = (this.produceAttributes & 8) != 0;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n18 = 0;
        int n19 = 0;
        int n20 = this.codeStream.exceptionLabelsCounter;
        while (n19 < n20) {
            n18 += this.codeStream.exceptionLabels[n19].count / 2;
            ++n19;
        }
        n19 = n18 * 8 + 2;
        if (n19 + n14 >= this.contents.length) {
            this.resizeContents(n19);
        }
        this.contents[n14++] = (byte)(n18 >> 8);
        this.contents[n14++] = (byte)n18;
        n20 = 0;
        int n21 = this.codeStream.exceptionLabelsCounter;
        while (n20 < n21) {
            object2 = exceptionLabelArray[n20];
            if (object2 != null) {
                n13 = 0;
                n12 = ((ExceptionLabel)object2).count;
                if ((n12 & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (n13 < n12) {
                    n11 = ((ExceptionLabel)object2).ranges[n13++];
                    this.contents[n14++] = (byte)(n11 >> 8);
                    this.contents[n14++] = (byte)n11;
                    n10 = ((ExceptionLabel)object2).ranges[n13++];
                    this.contents[n14++] = (byte)(n10 >> 8);
                    this.contents[n14++] = (byte)n10;
                    n9 = ((ExceptionLabel)object2).position;
                    if (bl) {
                        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                        stackMapFrameCodeStream.addFramePosition(n9);
                    }
                    this.contents[n14++] = (byte)(n9 >> 8);
                    this.contents[n14++] = (byte)n9;
                    if (((ExceptionLabel)object2).exceptionType == null) {
                        this.contents[n14++] = 0;
                        this.contents[n14++] = 0;
                        continue;
                    }
                    int n22 = ((ExceptionLabel)object2).exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(((ExceptionLabel)object2).exceptionType);
                    this.contents[n14++] = (byte)(n22 >> 8);
                    this.contents[n14++] = (byte)n22;
                }
            }
            ++n20;
        }
        n20 = n14;
        n21 = 0;
        if ((n14 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            object2 = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                n13 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (n14 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n14++] = (byte)(n13 >> 8);
                this.contents[n14++] = (byte)n13;
                n12 = n14;
                n14 += 6;
                n11 = 0;
                n10 = this.codeStream.pcToSourceMapSize;
                n9 = 0;
                while (n9 < n10) {
                    if (n14 + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    Object object3 = object2[n9++];
                    this.contents[n14++] = (byte)(object3 >> 8);
                    this.contents[n14++] = (byte)object3;
                    Object object4 = object2[n9++];
                    this.contents[n14++] = (byte)(object4 >> 8);
                    this.contents[n14++] = (byte)object4;
                    ++n11;
                }
                n9 = n11 * 4 + 2;
                this.contents[n12++] = (byte)(n9 >> 24);
                this.contents[n12++] = (byte)(n9 >> 16);
                this.contents[n12++] = (byte)(n9 >> 8);
                this.contents[n12++] = (byte)n9;
                this.contents[n12++] = (byte)(n11 >> 8);
                this.contents[n12++] = (byte)n11;
                ++n21;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int n23;
            int n24 = 0;
            n13 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            n12 = this.codeStream.methodDeclaration.isStatic() ? 1 : 0;
            n11 = 8 + 10 * (n12 != 0 ? 0 : 1);
            n10 = 0;
            while (n10 < this.codeStream.allLocalsCounter) {
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n10];
                n11 += 10 * localVariableBinding.initializationCount;
                ++n10;
            }
            if (n14 + n11 >= this.contents.length) {
                this.resizeContents(n11);
            }
            this.contents[n14++] = (byte)(n13 >> 8);
            this.contents[n14++] = (byte)n13;
            n10 = n14;
            n14 += 6;
            SourceTypeBinding sourceTypeBinding = null;
            if (n12 == 0) {
                ++n24;
                this.contents[n14++] = 0;
                this.contents[n14++] = 0;
                this.contents[n14++] = (byte)(n15 >> 8);
                this.contents[n14++] = (byte)n15;
                int n25 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n14++] = (byte)(n25 >> 8);
                this.contents[n14++] = (byte)n25;
                sourceTypeBinding = (SourceTypeBinding)this.codeStream.methodDeclaration.binding.declaringClass;
                int n26 = this.constantPool.literalIndex(sourceTypeBinding.signature());
                this.contents[n14++] = (byte)(n26 >> 8);
                this.contents[n14++] = (byte)n26;
                this.contents[n14++] = 0;
                this.contents[n14++] = 0;
            }
            int n27 = 0;
            LocalVariableBinding[] localVariableBindingArray = null;
            n8 = 0;
            n7 = 0;
            n6 = this.codeStream.allLocalsCounter;
            while (n7 < n6) {
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n7];
                if (localVariableBinding.declaration != null) {
                    object = localVariableBinding.type;
                    byte by2 = by = !((TypeBinding)object).isParameterizedType() && !((TypeBinding)object).isTypeVariable() ? (byte)0 : 1;
                    if (localVariableBinding.initializationCount != 0 && by != 0) {
                        if (localVariableBindingArray == null) {
                            localVariableBindingArray = new LocalVariableBinding[n6];
                        }
                        localVariableBindingArray[n27++] = localVariableBinding;
                    }
                    n5 = 0;
                    while (n5 < localVariableBinding.initializationCount) {
                        n4 = localVariableBinding.initializationPCs[n5 << 1];
                        n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                        if (n4 != n3) {
                            if (n3 == -1) {
                                localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                            }
                            if (by != 0) {
                                ++n8;
                            }
                            ++n24;
                            this.contents[n14++] = (byte)(n4 >> 8);
                            this.contents[n14++] = (byte)n4;
                            n2 = n3 - n4;
                            this.contents[n14++] = (byte)(n2 >> 8);
                            this.contents[n14++] = (byte)n2;
                            int n28 = this.constantPool.literalIndex(localVariableBinding.name);
                            this.contents[n14++] = (byte)(n28 >> 8);
                            this.contents[n14++] = (byte)n28;
                            int n29 = this.constantPool.literalIndex(((TypeBinding)object).signature());
                            this.contents[n14++] = (byte)(n29 >> 8);
                            this.contents[n14++] = (byte)n29;
                            n23 = localVariableBinding.resolvedPosition;
                            this.contents[n14++] = (byte)(n23 >> 8);
                            this.contents[n14++] = (byte)n23;
                        }
                        ++n5;
                    }
                }
                ++n7;
            }
            n7 = n24 * 10 + 2;
            this.contents[n10++] = (byte)(n7 >> 24);
            this.contents[n10++] = (byte)(n7 >> 16);
            this.contents[n10++] = (byte)(n7 >> 8);
            this.contents[n10++] = (byte)n7;
            this.contents[n10++] = (byte)(n24 >> 8);
            this.contents[n10] = (byte)n24;
            ++n21;
            int n30 = n6 = n12 == 0 && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
            if (n27 != 0 || n6 != 0) {
                n11 = 8 + (n8 += n6 != 0 ? 1 : 0) * 10;
                if (n14 + n11 >= this.contents.length) {
                    this.resizeContents(n11);
                }
                int n31 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n14++] = (byte)(n31 >> 8);
                this.contents[n14++] = (byte)n31;
                n7 = n8 * 10 + 2;
                this.contents[n14++] = (byte)(n7 >> 24);
                this.contents[n14++] = (byte)(n7 >> 16);
                this.contents[n14++] = (byte)(n7 >> 8);
                this.contents[n14++] = (byte)n7;
                this.contents[n14++] = (byte)(n8 >> 8);
                this.contents[n14++] = (byte)n8;
                if (n6 != 0) {
                    this.contents[n14++] = 0;
                    this.contents[n14++] = 0;
                    this.contents[n14++] = (byte)(n15 >> 8);
                    this.contents[n14++] = (byte)n15;
                    int n32 = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[n14++] = (byte)(n32 >> 8);
                    this.contents[n14++] = (byte)n32;
                    int n33 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                    this.contents[n14++] = (byte)(n33 >> 8);
                    this.contents[n14++] = (byte)n33;
                    this.contents[n14++] = 0;
                    this.contents[n14++] = 0;
                }
                int n34 = 0;
                while (n34 < n27) {
                    LocalVariableBinding localVariableBinding = localVariableBindingArray[n34];
                    n5 = 0;
                    while (n5 < localVariableBinding.initializationCount) {
                        n4 = localVariableBinding.initializationPCs[n5 << 1];
                        n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                        if (n4 != n3) {
                            this.contents[n14++] = (byte)(n4 >> 8);
                            this.contents[n14++] = (byte)n4;
                            n2 = n3 - n4;
                            this.contents[n14++] = (byte)(n2 >> 8);
                            this.contents[n14++] = (byte)n2;
                            int n35 = this.constantPool.literalIndex(localVariableBinding.name);
                            this.contents[n14++] = (byte)(n35 >> 8);
                            this.contents[n14++] = (byte)n35;
                            int n36 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                            this.contents[n14++] = (byte)(n36 >> 8);
                            this.contents[n14++] = (byte)n36;
                            n23 = localVariableBinding.resolvedPosition;
                            this.contents[n14++] = (byte)(n23 >> 8);
                            this.contents[n14++] = (byte)n23;
                        }
                        ++n5;
                    }
                    ++n34;
                }
                ++n21;
            }
        }
        if (bl) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n15);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n17, this.contents, n + 14, n15, arrayList, false);
                n12 = arrayList.size();
                if (n12 > 1) {
                    n11 = n14;
                    if (n14 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n10 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
                    this.contents[n14++] = (byte)(n10 >> 8);
                    this.contents[n14++] = (byte)n10;
                    int n37 = n14;
                    if ((n14 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int n38 = n14;
                    if ((n14 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    StackMapFrame stackMapFrame2 = null;
                    int n39 = 1;
                    while (n39 < n12) {
                        stackMapFrame2 = stackMapFrame;
                        stackMapFrame = (StackMapFrame)arrayList.get(n39);
                        n8 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                        block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                            case 2: {
                                if (n14 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n7 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n14++] = (byte)(251 + n7);
                                this.contents[n14++] = (byte)(n8 >> 8);
                                this.contents[n14++] = (byte)n8;
                                n6 = stackMapFrame.getIndexOfDifferentLocals(n7);
                                int n40 = stackMapFrame.getNumberOfLocals();
                                int n41 = n6;
                                while (n41 < stackMapFrame.locals.length && n7 > 0) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n14 + 6 >= this.contents.length) {
                                        this.resizeContents(6);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n41]) == null) {
                                        this.contents[n14++] = 0;
                                    } else {
                                        block8 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n14++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n14++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n14++] = 4;
                                                ++n41;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n14++] = 3;
                                                ++n41;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n14++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n14++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n5 = verificationTypeInfo.offset;
                                                        this.contents[n14++] = (byte)(n5 >> 8);
                                                        this.contents[n14++] = (byte)n5;
                                                        break block8;
                                                    }
                                                    case 7: {
                                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n14++] = (byte)(n4 >> 8);
                                                        this.contents[n14++] = (byte)n4;
                                                    }
                                                }
                                            }
                                        }
                                        --n7;
                                    }
                                    ++n41;
                                }
                                break;
                            }
                            case 0: {
                                if (n14 + 1 >= this.contents.length) {
                                    this.resizeContents(1);
                                }
                                this.contents[n14++] = (byte)n8;
                                break;
                            }
                            case 3: {
                                if (n14 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                this.contents[n14++] = -5;
                                this.contents[n14++] = (byte)(n8 >> 8);
                                this.contents[n14++] = (byte)n8;
                                break;
                            }
                            case 1: {
                                if (n14 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n7 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n14++] = (byte)(251 - n7);
                                this.contents[n14++] = (byte)(n8 >> 8);
                                this.contents[n14++] = (byte)n8;
                                break;
                            }
                            case 5: {
                                if (n14 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n14++] = (byte)(n8 + 64);
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n14++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n14++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n14++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n14++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n14++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n14++] = 5;
                                        break block0;
                                    }
                                }
                                object = stackMapFrame.stackItems[0];
                                by = (byte)((VerificationTypeInfo)object).tag;
                                this.contents[n14++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = ((VerificationTypeInfo)object).offset;
                                        this.contents[n14++] = (byte)(n5 >> 8);
                                        this.contents[n14++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n4 = this.constantPool.literalIndexForType(((VerificationTypeInfo)object).constantPoolName());
                                        this.contents[n14++] = (byte)(n4 >> 8);
                                        this.contents[n14++] = (byte)n4;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                if (n14 + 6 >= this.contents.length) {
                                    this.resizeContents(6);
                                }
                                this.contents[n14++] = -9;
                                this.contents[n14++] = (byte)(n8 >> 8);
                                this.contents[n14++] = (byte)n8;
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n14++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n14++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n14++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n14++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n14++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n14++] = 5;
                                        break block0;
                                    }
                                }
                                object = stackMapFrame.stackItems[0];
                                by = (byte)((VerificationTypeInfo)object).tag;
                                this.contents[n14++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = ((VerificationTypeInfo)object).offset;
                                        this.contents[n14++] = (byte)(n5 >> 8);
                                        this.contents[n14++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n4 = this.constantPool.literalIndexForType(((VerificationTypeInfo)object).constantPoolName());
                                        this.contents[n14++] = (byte)(n4 >> 8);
                                        this.contents[n14++] = (byte)n4;
                                    }
                                }
                                break;
                            }
                            default: {
                                int n42;
                                if (n14 + 5 >= this.contents.length) {
                                    this.resizeContents(5);
                                }
                                this.contents[n14++] = -1;
                                this.contents[n14++] = (byte)(n8 >> 8);
                                this.contents[n14++] = (byte)n8;
                                int n43 = n14;
                                n14 += 2;
                                by = 0;
                                int n44 = stackMapFrame.getNumberOfLocals();
                                n5 = 0;
                                n4 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                                n3 = 0;
                                while (n3 < n4 && by < n44) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n14 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n3]) == null) {
                                        this.contents[n14++] = 0;
                                    } else {
                                        block41 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n14++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n14++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n14++] = 4;
                                                ++n3;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n14++] = 3;
                                                ++n3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n14++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n14++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        int n45 = verificationTypeInfo.offset;
                                                        this.contents[n14++] = (byte)(n45 >> 8);
                                                        this.contents[n14++] = (byte)n45;
                                                        break block41;
                                                    }
                                                    case 7: {
                                                        n42 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n14++] = (byte)(n42 >> 8);
                                                        this.contents[n14++] = (byte)n42;
                                                    }
                                                }
                                            }
                                        }
                                        by = (byte)(by + 1);
                                    }
                                    ++n5;
                                    ++n3;
                                }
                                if (n14 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n43++] = (byte)(n5 >> 8);
                                this.contents[n43] = (byte)n5;
                                n3 = stackMapFrame.numberOfStackItems;
                                this.contents[n14++] = (byte)(n3 >> 8);
                                this.contents[n14++] = (byte)n3;
                                n2 = 0;
                                while (n2 < n3) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n14 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.stackItems[n2]) == null) {
                                        this.contents[n14++] = 0;
                                    } else {
                                        block52 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n14++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n14++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n14++] = 4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n14++] = 3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n14++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n14++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n42 = verificationTypeInfo.offset;
                                                        this.contents[n14++] = (byte)(n42 >> 8);
                                                        this.contents[n14++] = (byte)n42;
                                                        break block52;
                                                    }
                                                    case 7: {
                                                        int n46 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n14++] = (byte)(n46 >> 8);
                                                        this.contents[n14++] = (byte)n46;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                break block0;
                            }
                        }
                        ++n39;
                    }
                    if (--n12 != 0) {
                        this.contents[n38++] = (byte)(n12 >> 8);
                        this.contents[n38] = (byte)n12;
                        n39 = n14 - n37 - 4;
                        this.contents[n37++] = (byte)(n39 >> 24);
                        this.contents[n37++] = (byte)(n39 >> 16);
                        this.contents[n37++] = (byte)(n39 >> 8);
                        this.contents[n37] = (byte)n39;
                        ++n21;
                    } else {
                        n14 = n11;
                    }
                }
            }
        }
        if ((this.produceAttributes & 0x10) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n15);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n17, this.contents, n + 14, n15, arrayList, false);
                n12 = arrayList.size();
                if (n12 > 1) {
                    n11 = n14;
                    if (n14 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n10 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
                    this.contents[n14++] = (byte)(n10 >> 8);
                    this.contents[n14++] = (byte)n10;
                    int n47 = n14;
                    if ((n14 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int n48 = n14;
                    if ((n14 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    int n49 = 1;
                    while (n49 < n12) {
                        stackMapFrame = (StackMapFrame)arrayList.get(n49);
                        int n50 = stackMapFrame.pc;
                        if (n14 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n14++] = (byte)(n50 >> 8);
                        this.contents[n14++] = (byte)n50;
                        n8 = n14;
                        n14 += 2;
                        n7 = 0;
                        n6 = stackMapFrame.getNumberOfLocals();
                        int n51 = 0;
                        int n52 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        by = 0;
                        while (by < n52 && n7 < n6) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n14 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[by]) == null) {
                                this.contents[n14++] = 0;
                            } else {
                                block63 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n14++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n14++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n14++] = 4;
                                        by = (byte)(by + 1);
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n14++] = 3;
                                        by = (byte)(by + 1);
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n14++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n14++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n53 = verificationTypeInfo.offset;
                                                this.contents[n14++] = (byte)(n53 >> 8);
                                                this.contents[n14++] = (byte)n53;
                                                break block63;
                                            }
                                            case 7: {
                                                n3 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n14++] = (byte)(n3 >> 8);
                                                this.contents[n14++] = (byte)n3;
                                            }
                                        }
                                    }
                                }
                                ++n7;
                            }
                            ++n51;
                            by = (byte)(by + 1);
                        }
                        if (n14 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n8++] = (byte)(n51 >> 8);
                        this.contents[n8] = (byte)n51;
                        by = (byte)stackMapFrame.numberOfStackItems;
                        this.contents[n14++] = (byte)(by >> 8);
                        this.contents[n14++] = by;
                        n5 = 0;
                        while (n5 < by) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n14 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n5]) == null) {
                                this.contents[n14++] = 0;
                            } else {
                                block74 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n14++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n14++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n14++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n14++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n14++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n14++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n3 = verificationTypeInfo.offset;
                                                this.contents[n14++] = (byte)(n3 >> 8);
                                                this.contents[n14++] = (byte)n3;
                                                break block74;
                                            }
                                            case 7: {
                                                n2 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n14++] = (byte)(n2 >> 8);
                                                this.contents[n14++] = (byte)n2;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++n49;
                    }
                    if (--n12 != 0) {
                        this.contents[n48++] = (byte)(n12 >> 8);
                        this.contents[n48] = (byte)n12;
                        n49 = n14 - n47 - 4;
                        this.contents[n47++] = (byte)(n49 >> 24);
                        this.contents[n47++] = (byte)(n49 >> 16);
                        this.contents[n47++] = (byte)(n49 >> 8);
                        this.contents[n47] = (byte)n49;
                        ++n21;
                    } else {
                        n14 = n11;
                    }
                }
            }
        }
        this.contents[n20++] = (byte)(n21 >> 8);
        this.contents[n20] = (byte)n21;
        int n54 = n14 - (n + 6);
        this.contents[n + 2] = (byte)(n54 >> 24);
        this.contents[n + 3] = (byte)(n54 >> 16);
        this.contents[n + 4] = (byte)(n54 >> 8);
        this.contents[n + 5] = (byte)n54;
        this.contentsOffset = n14;
    }

    /*
     * WARNING - void declaration
     */
    public void completeCodeAttributeForClinit(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        Object object2;
        this.contents = this.codeStream.bCodeStream;
        int n15 = this.codeStream.classFileOffset;
        int n16 = this.codeStream.position;
        if (n16 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n15 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n17 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n17 >> 8);
        this.contents[n + 7] = (byte)n17;
        int n18 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n18 >> 8);
        this.contents[n + 9] = (byte)n18;
        this.contents[n + 10] = (byte)(n16 >> 24);
        this.contents[n + 11] = (byte)(n16 >> 16);
        this.contents[n + 12] = (byte)(n16 >> 8);
        this.contents[n + 13] = (byte)n16;
        boolean bl = (this.produceAttributes & 8) != 0;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n19 = 0;
        int n20 = 0;
        int n21 = this.codeStream.exceptionLabelsCounter;
        while (n20 < n21) {
            n19 += this.codeStream.exceptionLabels[n20].count / 2;
            ++n20;
        }
        n20 = n19 * 8 + 2;
        if (n20 + n15 >= this.contents.length) {
            this.resizeContents(n20);
        }
        this.contents[n15++] = (byte)(n19 >> 8);
        this.contents[n15++] = (byte)n19;
        n21 = 0;
        int n22 = this.codeStream.exceptionLabelsCounter;
        while (n21 < n22) {
            object2 = exceptionLabelArray[n21];
            if (object2 != null) {
                n14 = 0;
                n13 = ((ExceptionLabel)object2).count;
                if ((n13 & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (n14 < n13) {
                    n12 = ((ExceptionLabel)object2).ranges[n14++];
                    this.contents[n15++] = (byte)(n12 >> 8);
                    this.contents[n15++] = (byte)n12;
                    n11 = ((ExceptionLabel)object2).ranges[n14++];
                    this.contents[n15++] = (byte)(n11 >> 8);
                    this.contents[n15++] = (byte)n11;
                    n10 = ((ExceptionLabel)object2).position;
                    this.contents[n15++] = (byte)(n10 >> 8);
                    this.contents[n15++] = (byte)n10;
                    if (bl) {
                        object = (StackMapFrameCodeStream)this.codeStream;
                        ((StackMapFrameCodeStream)object).addFramePosition(n10);
                    }
                    if (((ExceptionLabel)object2).exceptionType == null) {
                        this.contents[n15++] = 0;
                        this.contents[n15++] = 0;
                        continue;
                    }
                    int n23 = ((ExceptionLabel)object2).exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(((ExceptionLabel)object2).exceptionType);
                    this.contents[n15++] = (byte)(n23 >> 8);
                    this.contents[n15++] = (byte)n23;
                }
            }
            ++n21;
        }
        n21 = n15;
        n22 = 0;
        if ((n15 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            object2 = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                n14 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (n15 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n15++] = (byte)(n14 >> 8);
                this.contents[n15++] = (byte)n14;
                n13 = n15;
                n15 += 6;
                n12 = 0;
                n11 = this.codeStream.pcToSourceMapSize;
                n10 = 0;
                while (n10 < n11) {
                    if (n15 + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    Object object3 = object2[n10++];
                    this.contents[n15++] = (byte)(object3 >> 8);
                    this.contents[n15++] = (byte)object3;
                    Object n9 = object2[n10++];
                    this.contents[n15++] = (byte)(n9 >> 8);
                    this.contents[n15++] = (byte)n9;
                    ++n12;
                }
                n10 = n12 * 4 + 2;
                this.contents[n13++] = (byte)(n10 >> 24);
                this.contents[n13++] = (byte)(n10 >> 16);
                this.contents[n13++] = (byte)(n10 >> 8);
                this.contents[n13++] = (byte)n10;
                this.contents[n13++] = (byte)(n12 >> 8);
                this.contents[n13++] = (byte)n12;
                ++n22;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int n24 = 0;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int n9;
                int n23;
                n14 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
                if (n15 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n15++] = (byte)(n14 >> 8);
                this.contents[n15++] = (byte)n14;
                n13 = n15;
                n15 += 6;
                n10 = 0;
                object = null;
                boolean stackMapFrame = false;
                int n25 = 0;
                n8 = this.codeStream.allLocalsCounter;
                while (n25 < n8) {
                    LocalVariableBinding localVariableBinding = this.codeStream.locals[n25];
                    if (localVariableBinding.declaration != null) {
                        TypeBinding typeBinding = localVariableBinding.type;
                        int n26 = n7 = !typeBinding.isParameterizedType() && !typeBinding.isTypeVariable() ? 0 : 1;
                        if (localVariableBinding.initializationCount != 0 && n7 != 0) {
                            if (object == null) {
                                object = new LocalVariableBinding[n8];
                            }
                            object[n10++] = localVariableBinding;
                        }
                        n6 = 0;
                        while (n6 < localVariableBinding.initializationCount) {
                            n23 = localVariableBinding.initializationPCs[n6 << 1];
                            n9 = localVariableBinding.initializationPCs[(n6 << 1) + 1];
                            if (n23 != n9) {
                                if (n9 == -1) {
                                    localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                                }
                                if (n15 + 10 >= this.contents.length) {
                                    this.resizeContents(10);
                                }
                                ++n24;
                                if (n7 != 0) {
                                    ++stackMapFrame;
                                }
                                this.contents[n15++] = (byte)(n23 >> 8);
                                this.contents[n15++] = (byte)n23;
                                n5 = n9 - n23;
                                this.contents[n15++] = (byte)(n5 >> 8);
                                this.contents[n15++] = (byte)n5;
                                n12 = this.constantPool.literalIndex(localVariableBinding.name);
                                this.contents[n15++] = (byte)(n12 >> 8);
                                this.contents[n15++] = (byte)n12;
                                n11 = this.constantPool.literalIndex(typeBinding.signature());
                                this.contents[n15++] = (byte)(n11 >> 8);
                                this.contents[n15++] = (byte)n11;
                                n4 = localVariableBinding.resolvedPosition;
                                this.contents[n15++] = (byte)(n4 >> 8);
                                this.contents[n15++] = (byte)n4;
                            }
                            ++n6;
                        }
                    }
                    ++n25;
                }
                n25 = n24 * 10 + 2;
                this.contents[n13++] = (byte)(n25 >> 24);
                this.contents[n13++] = (byte)(n25 >> 16);
                this.contents[n13++] = (byte)(n25 >> 8);
                this.contents[n13++] = (byte)n25;
                this.contents[n13++] = (byte)(n24 >> 8);
                this.contents[n13] = (byte)n24;
                ++n22;
                if (n10 != 0) {
                    n8 = 8 + stackMapFrame * 10;
                    if (n15 + n8 >= this.contents.length) {
                        this.resizeContents(n8);
                    }
                    int n27 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                    this.contents[n15++] = (byte)(n27 >> 8);
                    this.contents[n15++] = (byte)n27;
                    n25 = stackMapFrame * 10 + 2;
                    this.contents[n15++] = (byte)(n25 >> 24);
                    this.contents[n15++] = (byte)(n25 >> 16);
                    this.contents[n15++] = (byte)(n25 >> 8);
                    this.contents[n15++] = (byte)n25;
                    this.contents[n15++] = (byte)(stackMapFrame >> 8);
                    this.contents[n15++] = (byte)stackMapFrame;
                    int n28 = 0;
                    while (n28 < n10) {
                        Object object3 = object[n28];
                        n6 = 0;
                        while (n6 < ((LocalVariableBinding)object3).initializationCount) {
                            n23 = ((LocalVariableBinding)object3).initializationPCs[n6 << 1];
                            n9 = ((LocalVariableBinding)object3).initializationPCs[(n6 << 1) + 1];
                            if (n23 != n9) {
                                this.contents[n15++] = (byte)(n23 >> 8);
                                this.contents[n15++] = (byte)n23;
                                n5 = n9 - n23;
                                this.contents[n15++] = (byte)(n5 >> 8);
                                this.contents[n15++] = (byte)n5;
                                n12 = this.constantPool.literalIndex(((LocalVariableBinding)object3).name);
                                this.contents[n15++] = (byte)(n12 >> 8);
                                this.contents[n15++] = (byte)n12;
                                n11 = this.constantPool.literalIndex(((LocalVariableBinding)object3).type.genericTypeSignature());
                                this.contents[n15++] = (byte)(n11 >> 8);
                                this.contents[n15++] = (byte)n11;
                                n4 = ((LocalVariableBinding)object3).resolvedPosition;
                                this.contents[n15++] = (byte)(n4 >> 8);
                                this.contents[n15++] = (byte)n4;
                            }
                            ++n6;
                        }
                        ++n28;
                    }
                    ++n22;
                }
            }
        }
        if ((this.produceAttributes & 8) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n16);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(null, n18, this.contents, n + 14, n16, arrayList, true);
                n13 = arrayList.size();
                if (n13 > 1) {
                    n12 = n15;
                    if (n15 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n11 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
                    this.contents[n15++] = (byte)(n11 >> 8);
                    this.contents[n15++] = (byte)n11;
                    n10 = n15;
                    if ((n15 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int n31 = n15;
                    if ((n15 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    StackMapFrame stackMapFrame2 = null;
                    n8 = 1;
                    while (n8 < n13) {
                        void var19_34;
                        stackMapFrame2 = var19_34;
                        StackMapFrame stackMapFrame3 = (StackMapFrame)arrayList.get(n8);
                        int n29 = stackMapFrame3.getOffsetDelta(stackMapFrame2);
                        block0 : switch (stackMapFrame3.getFrameType(stackMapFrame2)) {
                            case 2: {
                                if (n15 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                int n30 = stackMapFrame3.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n15++] = (byte)(251 + n30);
                                this.contents[n15++] = (byte)(n29 >> 8);
                                this.contents[n15++] = (byte)n29;
                                n7 = stackMapFrame3.getIndexOfDifferentLocals(n30);
                                n6 = stackMapFrame3.getNumberOfLocals();
                                int n32 = n7;
                                while (n32 < stackMapFrame3.locals.length && n30 > 0) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n15 + 6 >= this.contents.length) {
                                        this.resizeContents(6);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame3.locals[n32]) == null) {
                                        this.contents[n15++] = 0;
                                    } else {
                                        block8 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n15++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n15++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n15++] = 4;
                                                ++n32;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n15++] = 3;
                                                ++n32;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n15++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n5 = verificationTypeInfo.offset;
                                                        this.contents[n15++] = (byte)(n5 >> 8);
                                                        this.contents[n15++] = (byte)n5;
                                                        break block8;
                                                    }
                                                    case 7: {
                                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n15++] = (byte)(n4 >> 8);
                                                        this.contents[n15++] = (byte)n4;
                                                    }
                                                }
                                            }
                                        }
                                        --n30;
                                    }
                                    ++n32;
                                }
                                break;
                            }
                            case 0: {
                                if (n15 + 1 >= this.contents.length) {
                                    this.resizeContents(1);
                                }
                                this.contents[n15++] = (byte)n29;
                                break;
                            }
                            case 3: {
                                if (n15 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                this.contents[n15++] = -5;
                                this.contents[n15++] = (byte)(n29 >> 8);
                                this.contents[n15++] = (byte)n29;
                                break;
                            }
                            case 1: {
                                if (n15 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                int n33 = -stackMapFrame3.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n15++] = (byte)(251 - n33);
                                this.contents[n15++] = (byte)(n29 >> 8);
                                this.contents[n15++] = (byte)n29;
                                break;
                            }
                            case 5: {
                                if (n15 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n15++] = (byte)(n29 + 64);
                                if (stackMapFrame3.stackItems[0] == null) {
                                    this.contents[n15++] = 0;
                                    break;
                                }
                                switch (stackMapFrame3.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n15++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n15++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n15++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n15++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n15++] = 5;
                                        break block0;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame3.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n15++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n15++] = (byte)(n5 >> 8);
                                        this.contents[n15++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n15++] = (byte)(n4 >> 8);
                                        this.contents[n15++] = (byte)n4;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                if (n15 + 6 >= this.contents.length) {
                                    this.resizeContents(6);
                                }
                                this.contents[n15++] = -9;
                                this.contents[n15++] = (byte)(n29 >> 8);
                                this.contents[n15++] = (byte)n29;
                                if (stackMapFrame3.stackItems[0] == null) {
                                    this.contents[n15++] = 0;
                                    break;
                                }
                                switch (stackMapFrame3.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n15++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n15++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n15++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n15++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n15++] = 5;
                                        break block0;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame3.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n15++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n15++] = (byte)(n5 >> 8);
                                        this.contents[n15++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n15++] = (byte)(n4 >> 8);
                                        this.contents[n15++] = (byte)n4;
                                    }
                                }
                                break;
                            }
                            default: {
                                int n34;
                                if (n15 + 5 >= this.contents.length) {
                                    this.resizeContents(5);
                                }
                                this.contents[n15++] = -1;
                                this.contents[n15++] = (byte)(n29 >> 8);
                                this.contents[n15++] = (byte)n29;
                                int n35 = n15;
                                n15 += 2;
                                int n36 = 0;
                                n6 = stackMapFrame3.getNumberOfLocals();
                                n5 = 0;
                                n4 = stackMapFrame3.locals == null ? 0 : stackMapFrame3.locals.length;
                                n3 = 0;
                                while (n3 < n4 && n36 < n6) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n15 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame3.locals[n3]) == null) {
                                        this.contents[n15++] = 0;
                                    } else {
                                        block41 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n15++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n15++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n15++] = 4;
                                                ++n3;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n15++] = 3;
                                                ++n3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n15++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        int n37 = verificationTypeInfo.offset;
                                                        this.contents[n15++] = (byte)(n37 >> 8);
                                                        this.contents[n15++] = (byte)n37;
                                                        break block41;
                                                    }
                                                    case 7: {
                                                        n34 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n15++] = (byte)(n34 >> 8);
                                                        this.contents[n15++] = (byte)n34;
                                                    }
                                                }
                                            }
                                        }
                                        ++n36;
                                    }
                                    ++n5;
                                    ++n3;
                                }
                                if (n15 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n35++] = (byte)(n5 >> 8);
                                this.contents[n35] = (byte)n5;
                                n3 = stackMapFrame3.numberOfStackItems;
                                this.contents[n15++] = (byte)(n3 >> 8);
                                this.contents[n15++] = (byte)n3;
                                n2 = 0;
                                while (n2 < n3) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n15 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame3.stackItems[n2]) == null) {
                                        this.contents[n15++] = 0;
                                    } else {
                                        block52 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n15++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n15++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n15++] = 4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n15++] = 3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n15++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n34 = verificationTypeInfo.offset;
                                                        this.contents[n15++] = (byte)(n34 >> 8);
                                                        this.contents[n15++] = (byte)n34;
                                                        break block52;
                                                    }
                                                    case 7: {
                                                        int n38 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n15++] = (byte)(n38 >> 8);
                                                        this.contents[n15++] = (byte)n38;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                break block0;
                            }
                        }
                        ++n8;
                    }
                    if (--n13 != 0) {
                        this.contents[n31++] = (byte)(n13 >> 8);
                        this.contents[n31] = (byte)n13;
                        n8 = n15 - n10 - 4;
                        this.contents[n10++] = (byte)(n8 >> 24);
                        this.contents[n10++] = (byte)(n8 >> 16);
                        this.contents[n10++] = (byte)(n8 >> 8);
                        this.contents[n10] = (byte)n8;
                        ++n22;
                    } else {
                        n15 = n12;
                    }
                }
            }
        }
        if ((this.produceAttributes & 0x10) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n16);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n18, this.contents, n + 14, n16, arrayList, false);
                n13 = arrayList.size();
                if (n13 > 1) {
                    n12 = n15;
                    if (n15 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n11 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
                    this.contents[n15++] = (byte)(n11 >> 8);
                    this.contents[n15++] = (byte)n11;
                    n10 = n15;
                    if ((n15 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int n41 = n15;
                    if ((n15 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    int n39 = 1;
                    while (n39 < n13) {
                        StackMapFrame stackMapFrame4 = (StackMapFrame)arrayList.get(n39);
                        n8 = stackMapFrame4.pc;
                        if (n15 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n15++] = (byte)(n8 >> 8);
                        this.contents[n15++] = (byte)n8;
                        int n40 = n15;
                        n15 += 2;
                        int n42 = 0;
                        n7 = stackMapFrame4.getNumberOfLocals();
                        n6 = 0;
                        int n43 = stackMapFrame4.locals == null ? 0 : stackMapFrame4.locals.length;
                        int n44 = 0;
                        while (n44 < n43 && n42 < n7) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n15 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame4.locals[n44]) == null) {
                                this.contents[n15++] = 0;
                            } else {
                                block63 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n15++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n15++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n15++] = 4;
                                        ++n44;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n15++] = 3;
                                        ++n44;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n15++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n45 = verificationTypeInfo.offset;
                                                this.contents[n15++] = (byte)(n45 >> 8);
                                                this.contents[n15++] = (byte)n45;
                                                break block63;
                                            }
                                            case 7: {
                                                n3 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n15++] = (byte)(n3 >> 8);
                                                this.contents[n15++] = (byte)n3;
                                            }
                                        }
                                    }
                                }
                                ++n42;
                            }
                            ++n6;
                            ++n44;
                        }
                        if (n15 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n40++] = (byte)(n6 >> 8);
                        this.contents[n40] = (byte)n6;
                        n44 = stackMapFrame4.numberOfStackItems;
                        this.contents[n15++] = (byte)(n44 >> 8);
                        this.contents[n15++] = (byte)n44;
                        n5 = 0;
                        while (n5 < n44) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n15 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame4.stackItems[n5]) == null) {
                                this.contents[n15++] = 0;
                            } else {
                                block74 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n15++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n15++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n15++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n15++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n15++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n3 = verificationTypeInfo.offset;
                                                this.contents[n15++] = (byte)(n3 >> 8);
                                                this.contents[n15++] = (byte)n3;
                                                break block74;
                                            }
                                            case 7: {
                                                n2 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n15++] = (byte)(n2 >> 8);
                                                this.contents[n15++] = (byte)n2;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++n39;
                    }
                    if (--n13 != 0) {
                        this.contents[n41++] = (byte)(n13 >> 8);
                        this.contents[n41] = (byte)n13;
                        n39 = n15 - n10 - 4;
                        this.contents[n10++] = (byte)(n39 >> 24);
                        this.contents[n10++] = (byte)(n39 >> 16);
                        this.contents[n10++] = (byte)(n39 >> 8);
                        this.contents[n10] = (byte)n39;
                        ++n22;
                    } else {
                        n15 = n12;
                    }
                }
            }
        }
        if (n21 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n21++] = (byte)(n22 >> 8);
        this.contents[n21] = (byte)n22;
        int n48 = n15 - (n + 6);
        this.contents[n + 2] = (byte)(n48 >> 24);
        this.contents[n + 3] = (byte)(n48 >> 16);
        this.contents[n + 4] = (byte)(n48 >> 8);
        this.contents[n + 5] = (byte)n48;
        this.contentsOffset = n15;
    }

    public void completeCodeAttributeForClinit(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        StackMapFrame stackMapFrame;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        ArrayList arrayList;
        int n16;
        this.contents = this.codeStream.bCodeStream;
        int n17 = this.codeStream.classFileOffset;
        int n18 = this.codeStream.position;
        if (n18 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n17 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n19 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n19 >> 8);
        this.contents[n + 7] = (byte)n19;
        int n20 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n20 >> 8);
        this.contents[n + 9] = (byte)n20;
        this.contents[n + 10] = (byte)(n18 >> 24);
        this.contents[n + 11] = (byte)(n18 >> 16);
        this.contents[n + 12] = (byte)(n18 >> 8);
        this.contents[n + 13] = (byte)n18;
        this.contents[n17++] = 0;
        this.contents[n17++] = 0;
        int n21 = n17;
        int n22 = 0;
        if ((n17 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n17 + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            n16 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n17++] = (byte)(n16 >> 8);
            this.contents[n17++] = (byte)n16;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = 6;
            this.contents[n17++] = 0;
            this.contents[n17++] = 1;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = (byte)(n2 >> 8);
            this.contents[n17++] = (byte)n2;
            ++n22;
        }
        if ((this.produceAttributes & 4) != 0) {
            n16 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n17 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n17++] = (byte)(n16 >> 8);
            this.contents[n17++] = (byte)n16;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = 2;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            ++n22;
        }
        if ((this.produceAttributes & 8) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n18);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                arrayList = new ArrayList();
                this.traverse(null, n20, this.contents, n + 14, n18, arrayList, true);
                n15 = arrayList.size();
                if (n15 > 1) {
                    n14 = n17;
                    if (n17 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n13 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
                    this.contents[n17++] = (byte)(n13 >> 8);
                    this.contents[n17++] = (byte)n13;
                    n12 = n17;
                    if ((n17 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n15 = 0;
                    n11 = n17;
                    if ((n17 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    stackMapFrame = (StackMapFrame)arrayList.get(0);
                    StackMapFrame stackMapFrame2 = null;
                    n10 = 1;
                    while (n10 < n15) {
                        stackMapFrame2 = stackMapFrame;
                        stackMapFrame = (StackMapFrame)arrayList.get(n10);
                        ++n15;
                        n9 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                        block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                            case 2: {
                                int n23;
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n8 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n17++] = (byte)(251 + n8);
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                n7 = stackMapFrame.getIndexOfDifferentLocals(n8);
                                n6 = stackMapFrame.getNumberOfLocals();
                                int n24 = n7;
                                while (n24 < stackMapFrame.locals.length && n8 > 0) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 6 >= this.contents.length) {
                                        this.resizeContents(6);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n24]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block8 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                ++n24;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                ++n24;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n5 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n5 >> 8);
                                                        this.contents[n17++] = (byte)n5;
                                                        break block8;
                                                    }
                                                    case 7: {
                                                        n23 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n23 >> 8);
                                                        this.contents[n17++] = (byte)n23;
                                                    }
                                                }
                                            }
                                        }
                                        --n8;
                                    }
                                    ++n24;
                                }
                                break;
                            }
                            case 0: {
                                if (n17 + 1 >= this.contents.length) {
                                    this.resizeContents(1);
                                }
                                this.contents[n17++] = (byte)n9;
                                break;
                            }
                            case 3: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                this.contents[n17++] = -5;
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                break;
                            }
                            case 1: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n8 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n17++] = (byte)(251 - n8);
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                break;
                            }
                            case 5: {
                                int n23;
                                if (n17 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n17++] = (byte)(n9 + 64);
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n17++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break block0;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n17++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n17++] = (byte)(n5 >> 8);
                                        this.contents[n17++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n23 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n17++] = (byte)(n23 >> 8);
                                        this.contents[n17++] = (byte)n23;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int n23;
                                if (n17 + 6 >= this.contents.length) {
                                    this.resizeContents(6);
                                }
                                this.contents[n17++] = -9;
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n17++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break block0;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n17++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n17++] = (byte)(n5 >> 8);
                                        this.contents[n17++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n23 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n17++] = (byte)(n23 >> 8);
                                        this.contents[n17++] = (byte)n23;
                                    }
                                }
                                break;
                            }
                            default: {
                                int n25;
                                if (n17 + 5 >= this.contents.length) {
                                    this.resizeContents(5);
                                }
                                this.contents[n17++] = -1;
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                int n26 = n17;
                                n17 += 2;
                                int n27 = 0;
                                n6 = stackMapFrame.getNumberOfLocals();
                                n5 = 0;
                                int n23 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                                n4 = 0;
                                while (n4 < n23 && n27 < n6) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n4]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block41 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                ++n4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                ++n4;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        int n28 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n28 >> 8);
                                                        this.contents[n17++] = (byte)n28;
                                                        break block41;
                                                    }
                                                    case 7: {
                                                        n25 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n25 >> 8);
                                                        this.contents[n17++] = (byte)n25;
                                                    }
                                                }
                                            }
                                        }
                                        ++n27;
                                    }
                                    ++n5;
                                    ++n4;
                                }
                                if (n17 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n26++] = (byte)(n5 >> 8);
                                this.contents[n26] = (byte)n5;
                                n4 = stackMapFrame.numberOfStackItems;
                                this.contents[n17++] = (byte)(n4 >> 8);
                                this.contents[n17++] = (byte)n4;
                                n3 = 0;
                                while (n3 < n4) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.stackItems[n3]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block52 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n25 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n25 >> 8);
                                                        this.contents[n17++] = (byte)n25;
                                                        break block52;
                                                    }
                                                    case 7: {
                                                        int n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n29 >> 8);
                                                        this.contents[n17++] = (byte)n29;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++n3;
                                }
                                break block0;
                            }
                        }
                        ++n10;
                    }
                    if (n15 != 0) {
                        this.contents[n11++] = (byte)(n15 >> 8);
                        this.contents[n11] = (byte)n15;
                        n10 = n17 - n12 - 4;
                        this.contents[n12++] = (byte)(n10 >> 24);
                        this.contents[n12++] = (byte)(n10 >> 16);
                        this.contents[n12++] = (byte)(n10 >> 8);
                        this.contents[n12] = (byte)n10;
                        ++n22;
                    } else {
                        n17 = n14;
                    }
                }
            }
        }
        if ((this.produceAttributes & 0x10) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n18);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n20, this.contents, n + 14, n18, arrayList, false);
                n15 = arrayList.size();
                if (n15 > 1) {
                    n14 = n17;
                    if (n17 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n13 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
                    this.contents[n17++] = (byte)(n13 >> 8);
                    this.contents[n17++] = (byte)n13;
                    n12 = n17;
                    if ((n17 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n11 = n17;
                    if ((n17 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    stackMapFrame = (StackMapFrame)arrayList.get(0);
                    int n30 = 1;
                    while (n30 < n15) {
                        stackMapFrame = (StackMapFrame)arrayList.get(n30);
                        n10 = stackMapFrame.pc;
                        if (n17 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n17++] = (byte)(n10 >> 8);
                        this.contents[n17++] = (byte)n10;
                        n9 = n17;
                        n17 += 2;
                        n8 = 0;
                        n7 = stackMapFrame.getNumberOfLocals();
                        n6 = 0;
                        int n31 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n32 = 0;
                        while (n32 < n31 && n8 < n7) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n32]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block63 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        ++n32;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        ++n32;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n33 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n33 >> 8);
                                                this.contents[n17++] = (byte)n33;
                                                break block63;
                                            }
                                            case 7: {
                                                n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n4 >> 8);
                                                this.contents[n17++] = (byte)n4;
                                            }
                                        }
                                    }
                                }
                                ++n8;
                            }
                            ++n6;
                            ++n32;
                        }
                        if (n17 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n9++] = (byte)(n6 >> 8);
                        this.contents[n9] = (byte)n6;
                        n32 = stackMapFrame.numberOfStackItems;
                        this.contents[n17++] = (byte)(n32 >> 8);
                        this.contents[n17++] = (byte)n32;
                        n5 = 0;
                        while (n5 < n32) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n5]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block74 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n4 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n4 >> 8);
                                                this.contents[n17++] = (byte)n4;
                                                break block74;
                                            }
                                            case 7: {
                                                n3 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n3 >> 8);
                                                this.contents[n17++] = (byte)n3;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++n30;
                    }
                    if (--n15 != 0) {
                        this.contents[n11++] = (byte)(n15 >> 8);
                        this.contents[n11] = (byte)n15;
                        n30 = n17 - n12 - 4;
                        this.contents[n12++] = (byte)(n30 >> 24);
                        this.contents[n12++] = (byte)(n30 >> 16);
                        this.contents[n12++] = (byte)(n30 >> 8);
                        this.contents[n12] = (byte)n30;
                        ++n22;
                    } else {
                        n17 = n14;
                    }
                }
            }
        }
        if (n21 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n21++] = (byte)(n22 >> 8);
        this.contents[n21] = (byte)n22;
        int n34 = n17 - (n + 6);
        this.contents[n + 2] = (byte)(n34 >> 24);
        this.contents[n + 3] = (byte)(n34 >> 16);
        this.contents[n + 4] = (byte)(n34 >> 8);
        this.contents[n + 5] = (byte)n34;
        this.contentsOffset = n17;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding methodBinding, int n, int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        StackMapFrame stackMapFrame;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        ArrayList arrayList;
        int n16;
        this.contents = this.codeStream.bCodeStream;
        int n17 = this.codeStream.classFileOffset;
        int n18 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n18 >> 8);
        this.contents[n + 7] = (byte)n18;
        int n19 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n19 >> 8);
        this.contents[n + 9] = (byte)n19;
        int n20 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n20 >> 24);
        this.contents[n + 11] = (byte)(n20 >> 16);
        this.contents[n + 12] = (byte)(n20 >> 8);
        this.contents[n + 13] = (byte)n20;
        if (n17 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n17++] = 0;
        this.contents[n17++] = 0;
        int n21 = n17;
        int n22 = 0;
        if ((n17 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n17 + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            n16 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n17++] = (byte)(n16 >> 8);
            this.contents[n17++] = (byte)n16;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = 6;
            this.contents[n17++] = 0;
            this.contents[n17++] = 1;
            if (n2 == 0) {
                n2 = Util.getLineNumber(methodBinding.sourceStart(), nArray, 0, nArray.length - 1);
            }
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = (byte)(n2 >> 8);
            this.contents[n17++] = (byte)n2;
            ++n22;
        }
        if ((this.produceAttributes & 8) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n20);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                arrayList = new ArrayList();
                this.traverse(methodBinding, n19, this.contents, n + 14, n20, arrayList, false);
                n15 = arrayList.size();
                if (n15 > 1) {
                    n14 = n17;
                    if (n17 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n13 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
                    this.contents[n17++] = (byte)(n13 >> 8);
                    this.contents[n17++] = (byte)n13;
                    n12 = n17;
                    if ((n17 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n15 = 0;
                    n11 = n17;
                    if ((n17 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    stackMapFrame = (StackMapFrame)arrayList.get(0);
                    StackMapFrame stackMapFrame2 = null;
                    n10 = 1;
                    while (n10 < n15) {
                        stackMapFrame2 = stackMapFrame;
                        stackMapFrame = (StackMapFrame)arrayList.get(n10);
                        ++n15;
                        n9 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                        block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                            case 2: {
                                int n23;
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n8 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n17++] = (byte)(251 + n8);
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                n7 = stackMapFrame.getIndexOfDifferentLocals(n8);
                                n6 = stackMapFrame.getNumberOfLocals();
                                int n24 = n7;
                                while (n24 < stackMapFrame.locals.length && n8 > 0) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 6 >= this.contents.length) {
                                        this.resizeContents(6);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n24]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block8 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                ++n24;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                ++n24;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n5 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n5 >> 8);
                                                        this.contents[n17++] = (byte)n5;
                                                        break block8;
                                                    }
                                                    case 7: {
                                                        n23 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n23 >> 8);
                                                        this.contents[n17++] = (byte)n23;
                                                    }
                                                }
                                            }
                                        }
                                        --n8;
                                    }
                                    ++n24;
                                }
                                break;
                            }
                            case 0: {
                                if (n17 + 1 >= this.contents.length) {
                                    this.resizeContents(1);
                                }
                                this.contents[n17++] = (byte)n9;
                                break;
                            }
                            case 3: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                this.contents[n17++] = -5;
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                break;
                            }
                            case 1: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n8 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n17++] = (byte)(251 - n8);
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                break;
                            }
                            case 5: {
                                int n23;
                                if (n17 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n17++] = (byte)(n9 + 64);
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n17++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break block0;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n17++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n17++] = (byte)(n5 >> 8);
                                        this.contents[n17++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n23 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n17++] = (byte)(n23 >> 8);
                                        this.contents[n17++] = (byte)n23;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int n23;
                                if (n17 + 6 >= this.contents.length) {
                                    this.resizeContents(6);
                                }
                                this.contents[n17++] = -9;
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n17++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break block0;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break block0;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break block0;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break block0;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break block0;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n17++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n17++] = (byte)(n5 >> 8);
                                        this.contents[n17++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n23 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n17++] = (byte)(n23 >> 8);
                                        this.contents[n17++] = (byte)n23;
                                    }
                                }
                                break;
                            }
                            default: {
                                int n25;
                                if (n17 + 5 >= this.contents.length) {
                                    this.resizeContents(5);
                                }
                                this.contents[n17++] = -1;
                                this.contents[n17++] = (byte)(n9 >> 8);
                                this.contents[n17++] = (byte)n9;
                                int n26 = n17;
                                n17 += 2;
                                int n27 = 0;
                                n6 = stackMapFrame.getNumberOfLocals();
                                n5 = 0;
                                int n23 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                                n4 = 0;
                                while (n4 < n23 && n27 < n6) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n4]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block41 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                ++n4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                ++n4;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        int n28 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n28 >> 8);
                                                        this.contents[n17++] = (byte)n28;
                                                        break block41;
                                                    }
                                                    case 7: {
                                                        n25 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n25 >> 8);
                                                        this.contents[n17++] = (byte)n25;
                                                    }
                                                }
                                            }
                                        }
                                        ++n27;
                                    }
                                    ++n5;
                                    ++n4;
                                }
                                if (n17 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n26++] = (byte)(n5 >> 8);
                                this.contents[n26] = (byte)n5;
                                n4 = stackMapFrame.numberOfStackItems;
                                this.contents[n17++] = (byte)(n4 >> 8);
                                this.contents[n17++] = (byte)n4;
                                n3 = 0;
                                while (n3 < n4) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.stackItems[n3]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block52 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n25 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n25 >> 8);
                                                        this.contents[n17++] = (byte)n25;
                                                        break block52;
                                                    }
                                                    case 7: {
                                                        int n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n29 >> 8);
                                                        this.contents[n17++] = (byte)n29;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++n3;
                                }
                                break block0;
                            }
                        }
                        ++n10;
                    }
                    if (n15 != 0) {
                        this.contents[n11++] = (byte)(n15 >> 8);
                        this.contents[n11] = (byte)n15;
                        n10 = n17 - n12 - 4;
                        this.contents[n12++] = (byte)(n10 >> 24);
                        this.contents[n12++] = (byte)(n10 >> 16);
                        this.contents[n12++] = (byte)(n10 >> 8);
                        this.contents[n12] = (byte)n10;
                        ++n22;
                    } else {
                        n17 = n14;
                    }
                }
            }
        }
        if ((this.produceAttributes & 0x10) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n20);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n19, this.contents, n + 14, n20, arrayList, false);
                n15 = arrayList.size();
                if (n15 > 1) {
                    n14 = n17;
                    if (n17 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n13 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
                    this.contents[n17++] = (byte)(n13 >> 8);
                    this.contents[n17++] = (byte)n13;
                    n12 = n17;
                    if ((n17 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n11 = n17;
                    if ((n17 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    stackMapFrame = (StackMapFrame)arrayList.get(0);
                    int n30 = 1;
                    while (n30 < n15) {
                        stackMapFrame = (StackMapFrame)arrayList.get(n30);
                        n10 = stackMapFrame.pc;
                        if (n17 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n17++] = (byte)(n10 >> 8);
                        this.contents[n17++] = (byte)n10;
                        n9 = n17;
                        n17 += 2;
                        n8 = 0;
                        n7 = stackMapFrame.getNumberOfLocals();
                        n6 = 0;
                        int n31 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n32 = 0;
                        while (n32 < n31 && n8 < n7) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n32]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block63 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        ++n32;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        ++n32;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n33 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n33 >> 8);
                                                this.contents[n17++] = (byte)n33;
                                                break block63;
                                            }
                                            case 7: {
                                                n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n4 >> 8);
                                                this.contents[n17++] = (byte)n4;
                                            }
                                        }
                                    }
                                }
                                ++n8;
                            }
                            ++n6;
                            ++n32;
                        }
                        if (n17 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n9++] = (byte)(n6 >> 8);
                        this.contents[n9] = (byte)n6;
                        n32 = stackMapFrame.numberOfStackItems;
                        this.contents[n17++] = (byte)(n32 >> 8);
                        this.contents[n17++] = (byte)n32;
                        n5 = 0;
                        while (n5 < n32) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n5]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block74 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n4 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n4 >> 8);
                                                this.contents[n17++] = (byte)n4;
                                                break block74;
                                            }
                                            case 7: {
                                                n3 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n3 >> 8);
                                                this.contents[n17++] = (byte)n3;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++n30;
                    }
                    if (--n15 != 0) {
                        this.contents[n11++] = (byte)(n15 >> 8);
                        this.contents[n11] = (byte)n15;
                        n30 = n17 - n12 - 4;
                        this.contents[n12++] = (byte)(n30 >> 24);
                        this.contents[n12++] = (byte)(n30 >> 16);
                        this.contents[n12++] = (byte)(n30 >> 8);
                        this.contents[n12] = (byte)n30;
                        ++n22;
                    } else {
                        n17 = n14;
                    }
                }
            }
        }
        if (n21 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n21++] = (byte)(n22 >> 8);
        this.contents[n21] = (byte)n22;
        n16 = n17 - (n + 6);
        this.contents[n + 2] = (byte)(n16 >> 24);
        this.contents[n + 3] = (byte)(n16 >> 16);
        this.contents[n + 4] = (byte)(n16 >> 8);
        this.contents[n + 5] = (byte)n16;
        this.contentsOffset = n17;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, int n, int[] nArray, int n2) {
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object2;
        int n9;
        int n10;
        int n11;
        this.contents = this.codeStream.bCodeStream;
        int n12 = this.codeStream.classFileOffset;
        int n13 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n13 >> 8);
        this.contents[n + 7] = (byte)n13;
        int n14 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n14 >> 8);
        this.contents[n + 9] = (byte)n14;
        int n15 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n15 >> 24);
        this.contents[n + 11] = (byte)(n15 >> 16);
        this.contents[n + 12] = (byte)(n15 >> 8);
        this.contents[n + 13] = (byte)n15;
        if (n12 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n12++] = 0;
        this.contents[n12++] = 0;
        int n16 = n12;
        int n17 = 0;
        if ((n12 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n12 + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            n11 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n12++] = (byte)(n11 >> 8);
            this.contents[n12++] = (byte)n11;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = 6;
            this.contents[n12++] = 0;
            this.contents[n12++] = 1;
            if (n2 == 0) {
                n2 = Util.getLineNumber(methodBinding.sourceStart(), nArray, 0, nArray.length - 1);
            }
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = (byte)(n2 >> 8);
            this.contents[n12++] = (byte)n2;
            ++n17;
        }
        if ((this.produceAttributes & 4) != 0) {
            int n18;
            Object object3;
            int n19;
            Object[] objectArray;
            Object object4;
            int n20 = 0;
            n10 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n12 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n12++] = (byte)(n10 >> 8);
            this.contents[n12++] = (byte)n10;
            n9 = n12;
            n12 += 6;
            SourceTypeBinding sourceTypeBinding = null;
            boolean bl = this.codeStream.methodDeclaration.isStatic();
            if (!bl) {
                ++n20;
                if (n12 + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
                this.contents[n12++] = (byte)(n15 >> 8);
                this.contents[n12++] = (byte)n15;
                object2 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n12++] = (byte)(object2 >> 8);
                this.contents[n12++] = (byte)object2;
                sourceTypeBinding = (SourceTypeBinding)this.codeStream.methodDeclaration.binding.declaringClass;
                n8 = this.constantPool.literalIndex(sourceTypeBinding.signature());
                this.contents[n12++] = (byte)(n8 >> 8);
                this.contents[n12++] = (byte)n8;
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
            }
            int n21 = 0;
            LocalVariableBinding[] localVariableBindingArray = null;
            n7 = 0;
            if (methodBinding.isConstructor()) {
                ReferenceBinding referenceBinding = methodBinding.declaringClass;
                if (referenceBinding.isNestedType()) {
                    object4 = (NestedTypeBinding)referenceBinding;
                    n11 = ((NestedTypeBinding)object4).getEnclosingInstancesSlotSize();
                    SyntheticArgumentBinding[] syntheticArgumentBindingArray = ((NestedTypeBinding)object4).syntheticEnclosingInstances();
                    objectArray = syntheticArgumentBindingArray;
                    if (syntheticArgumentBindingArray != null) {
                        int n22 = 0;
                        n19 = objectArray.length;
                        while (n22 < n19) {
                            object3 = objectArray[n22];
                            TypeBinding typeBinding = object3.type;
                            if (typeBinding.isParameterizedType() || typeBinding.isTypeVariable()) {
                                if (localVariableBindingArray == null) {
                                    localVariableBindingArray = new LocalVariableBinding[n19];
                                }
                                localVariableBindingArray[n21++] = object3;
                                ++n7;
                            }
                            if (n12 + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++n20;
                            this.contents[n12++] = 0;
                            this.contents[n12++] = 0;
                            this.contents[n12++] = (byte)(n15 >> 8);
                            this.contents[n12++] = (byte)n15;
                            object2 = this.constantPool.literalIndex(object3.name);
                            this.contents[n12++] = (byte)(object2 >> 8);
                            this.contents[n12++] = (byte)object2;
                            n8 = this.constantPool.literalIndex(typeBinding.signature());
                            this.contents[n12++] = (byte)(n8 >> 8);
                            this.contents[n12++] = (byte)n8;
                            n6 = object3.resolvedPosition;
                            this.contents[n12++] = (byte)(n6 >> 8);
                            this.contents[n12++] = (byte)n6;
                            ++n22;
                        }
                    }
                } else {
                    n11 = 1;
                }
            } else {
                n11 = methodBinding.isStatic() ? 0 : 1;
            }
            n5 = 0;
            object4 = null;
            objectArray = null;
            TypeBinding[] typeBindingArray = null;
            if (abstractMethodDeclaration.binding != null) {
                TypeBinding[] typeBindingArray2 = abstractMethodDeclaration.binding.parameters;
                object3 = abstractMethodDeclaration.arguments;
                if (typeBindingArray2 != null && object3 != null) {
                    int n23 = 0;
                    n6 = typeBindingArray2.length;
                    while (n23 < n6) {
                        object = typeBindingArray2[n23];
                        if (n12 + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++n20;
                        this.contents[n12++] = 0;
                        this.contents[n12++] = 0;
                        this.contents[n12++] = (byte)(n15 >> 8);
                        this.contents[n12++] = (byte)n15;
                        object2 = this.constantPool.literalIndex(object3[n23].name);
                        this.contents[n12++] = (byte)(object2 >> 8);
                        this.contents[n12++] = (byte)object2;
                        n18 = n11;
                        if (((TypeBinding)object).isParameterizedType() || ((TypeBinding)object).isTypeVariable()) {
                            if (n5 == 0) {
                                object4 = new int[n6];
                                objectArray = new int[n6];
                                typeBindingArray = new TypeBinding[n6];
                            }
                            object4[n5] = object2;
                            objectArray[n5] = n18;
                            typeBindingArray[n5++] = object;
                        }
                        n8 = this.constantPool.literalIndex(((TypeBinding)object).signature());
                        this.contents[n12++] = (byte)(n8 >> 8);
                        this.contents[n12++] = (byte)n8;
                        switch (((TypeBinding)object).id) {
                            case 7: 
                            case 8: {
                                n11 += 2;
                                break;
                            }
                            default: {
                                ++n11;
                            }
                        }
                        this.contents[n12++] = (byte)(n18 >> 8);
                        this.contents[n12++] = (byte)n18;
                        ++n23;
                    }
                }
            }
            n19 = n20 * 10 + 2;
            this.contents[n9++] = (byte)(n19 >> 24);
            this.contents[n9++] = (byte)(n19 >> 16);
            this.contents[n9++] = (byte)(n19 >> 8);
            this.contents[n9++] = (byte)n19;
            this.contents[n9++] = (byte)(n20 >> 8);
            this.contents[n9] = (byte)n20;
            ++n17;
            int n24 = n4 = !bl && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
            if (n21 != 0 || n5 != 0 || n4 != 0) {
                n20 = n7 + n5 + (n4 != 0 ? 1 : 0);
                int n25 = 8 + n20 * 10;
                if (n12 + n25 >= this.contents.length) {
                    this.resizeContents(n25);
                }
                n6 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n12++] = (byte)(n6 >> 8);
                this.contents[n12++] = (byte)n6;
                n19 = n20 * 10 + 2;
                this.contents[n12++] = (byte)(n19 >> 24);
                this.contents[n12++] = (byte)(n19 >> 16);
                this.contents[n12++] = (byte)(n19 >> 8);
                this.contents[n12++] = (byte)n19;
                this.contents[n12++] = (byte)(n20 >> 8);
                this.contents[n12++] = (byte)n20;
                if (n4 != 0) {
                    ++n20;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object2 = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[n12++] = (byte)(object2 >> 8);
                    this.contents[n12++] = (byte)object2;
                    n8 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                }
                int n26 = 0;
                while (n26 < n21) {
                    LocalVariableBinding localVariableBinding = localVariableBindingArray[n26];
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object2 = this.constantPool.literalIndex(localVariableBinding.name);
                    this.contents[n12++] = (byte)(object2 >> 8);
                    this.contents[n12++] = (byte)object2;
                    n8 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    n3 = localVariableBinding.resolvedPosition;
                    this.contents[n12++] = (byte)(n3 >> 8);
                    this.contents[n12++] = (byte)n3;
                    ++n26;
                }
                n26 = 0;
                while (n26 < n5) {
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object2 = object4[n26];
                    this.contents[n12++] = (byte)(object2 >> 8);
                    this.contents[n12++] = (byte)object2;
                    n8 = this.constantPool.literalIndex(typeBindingArray[n26].genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    n18 = objectArray[n26];
                    this.contents[n12++] = (byte)(n18 >> 8);
                    this.contents[n12++] = (byte)n18;
                    ++n26;
                }
                ++n17;
            }
        }
        if ((this.produceAttributes & 8) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n15);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(methodBinding, n14, this.contents, n + 14, n15, arrayList, false);
                n10 = arrayList.size();
                if (n10 > 1) {
                    n9 = n12;
                    if (n12 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    object2 = n12;
                    if ((n12 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n10 = 0;
                    int n27 = n12;
                    if ((n12 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    StackMapFrame stackMapFrame2 = null;
                    int n28 = 1;
                    while (n28 < n10) {
                        stackMapFrame2 = stackMapFrame;
                        stackMapFrame = (StackMapFrame)arrayList.get(n28);
                        ++n10;
                        n7 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                        block3 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                            case 2: {
                                if (n12 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n5 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n12++] = (byte)(251 + n5);
                                this.contents[n12++] = (byte)(n7 >> 8);
                                this.contents[n12++] = (byte)n7;
                                int n29 = stackMapFrame.getIndexOfDifferentLocals(n5);
                                int n30 = stackMapFrame.getNumberOfLocals();
                                int n31 = n29;
                                while (n31 < stackMapFrame.locals.length && n5 > 0) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n12 + 6 >= this.contents.length) {
                                        this.resizeContents(6);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n31]) == null) {
                                        this.contents[n12++] = 0;
                                    } else {
                                        block11 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n12++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n12++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n12++] = 4;
                                                ++n31;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n12++] = 3;
                                                ++n31;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n12++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n4 = verificationTypeInfo.offset;
                                                        this.contents[n12++] = (byte)(n4 >> 8);
                                                        this.contents[n12++] = (byte)n4;
                                                        break block11;
                                                    }
                                                    case 7: {
                                                        int n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n12++] = (byte)(n32 >> 8);
                                                        this.contents[n12++] = (byte)n32;
                                                    }
                                                }
                                            }
                                        }
                                        --n5;
                                    }
                                    ++n31;
                                }
                                break;
                            }
                            case 0: {
                                if (n12 + 1 >= this.contents.length) {
                                    this.resizeContents(1);
                                }
                                this.contents[n12++] = (byte)n7;
                                break;
                            }
                            case 3: {
                                if (n12 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                this.contents[n12++] = -5;
                                this.contents[n12++] = (byte)(n7 >> 8);
                                this.contents[n12++] = (byte)n7;
                                break;
                            }
                            case 1: {
                                if (n12 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                n5 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n12++] = (byte)(251 - n5);
                                this.contents[n12++] = (byte)(n7 >> 8);
                                this.contents[n12++] = (byte)n7;
                                break;
                            }
                            case 5: {
                                if (n12 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n12++] = (byte)(n7 + 64);
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n12++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break block3;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break block3;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        break block3;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        break block3;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break block3;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n12++] = by;
                                switch (by) {
                                    case 8: {
                                        n4 = verificationTypeInfo.offset;
                                        this.contents[n12++] = (byte)(n4 >> 8);
                                        this.contents[n12++] = (byte)n4;
                                        break;
                                    }
                                    case 7: {
                                        int n33 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n12++] = (byte)(n33 >> 8);
                                        this.contents[n12++] = (byte)n33;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                if (n12 + 6 >= this.contents.length) {
                                    this.resizeContents(6);
                                }
                                this.contents[n12++] = -9;
                                this.contents[n12++] = (byte)(n7 >> 8);
                                this.contents[n12++] = (byte)n7;
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n12++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break block3;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break block3;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        break block3;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        break block3;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break block3;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n12++] = by;
                                switch (by) {
                                    case 8: {
                                        n4 = verificationTypeInfo.offset;
                                        this.contents[n12++] = (byte)(n4 >> 8);
                                        this.contents[n12++] = (byte)n4;
                                        break;
                                    }
                                    case 7: {
                                        int n34 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n12++] = (byte)(n34 >> 8);
                                        this.contents[n12++] = (byte)n34;
                                    }
                                }
                                break;
                            }
                            default: {
                                if (n12 + 5 >= this.contents.length) {
                                    this.resizeContents(5);
                                }
                                this.contents[n12++] = -1;
                                this.contents[n12++] = (byte)(n7 >> 8);
                                this.contents[n12++] = (byte)n7;
                                int n35 = n12;
                                n12 += 2;
                                int n36 = 0;
                                int n37 = stackMapFrame.getNumberOfLocals();
                                n4 = 0;
                                int n38 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                                n6 = 0;
                                while (n6 < n38 && n36 < n37) {
                                    if (n12 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((object = stackMapFrame.locals[n6]) == null) {
                                        this.contents[n12++] = 0;
                                    } else {
                                        block44 : switch (((VerificationTypeInfo)object).id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n12++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n12++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n12++] = 4;
                                                ++n6;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n12++] = 3;
                                                ++n6;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n12++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n12++] = (byte)((VerificationTypeInfo)object).tag;
                                                switch (((VerificationTypeInfo)object).tag) {
                                                    case 8: {
                                                        int n39 = ((VerificationTypeInfo)object).offset;
                                                        this.contents[n12++] = (byte)(n39 >> 8);
                                                        this.contents[n12++] = (byte)n39;
                                                        break block44;
                                                    }
                                                    case 7: {
                                                        n3 = this.constantPool.literalIndexForType(((VerificationTypeInfo)object).constantPoolName());
                                                        this.contents[n12++] = (byte)(n3 >> 8);
                                                        this.contents[n12++] = (byte)n3;
                                                    }
                                                }
                                            }
                                        }
                                        ++n36;
                                    }
                                    ++n4;
                                    ++n6;
                                }
                                if (n12 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n35++] = (byte)(n4 >> 8);
                                this.contents[n35] = (byte)n4;
                                n6 = stackMapFrame.numberOfStackItems;
                                this.contents[n12++] = (byte)(n6 >> 8);
                                this.contents[n12++] = (byte)n6;
                                int n40 = 0;
                                while (n40 < n6) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n12 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.stackItems[n40]) == null) {
                                        this.contents[n12++] = 0;
                                    } else {
                                        block55 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n12++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n12++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n12++] = 4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n12++] = 3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n12++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n3 = verificationTypeInfo.offset;
                                                        this.contents[n12++] = (byte)(n3 >> 8);
                                                        this.contents[n12++] = (byte)n3;
                                                        break block55;
                                                    }
                                                    case 7: {
                                                        int n41 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n12++] = (byte)(n41 >> 8);
                                                        this.contents[n12++] = (byte)n41;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++n40;
                                }
                                break block3;
                            }
                        }
                        ++n28;
                    }
                    if (n10 != 0) {
                        this.contents[n27++] = (byte)(n10 >> 8);
                        this.contents[n27] = (byte)n10;
                        n28 = n12 - object2 - 4;
                        this.contents[object2++] = (byte)(n28 >> 24);
                        this.contents[object2++] = (byte)(n28 >> 16);
                        this.contents[object2++] = (byte)(n28 >> 8);
                        this.contents[object2] = (byte)n28;
                        ++n17;
                    } else {
                        n12 = n9;
                    }
                }
            }
        }
        if ((this.produceAttributes & 0x10) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n15);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n14, this.contents, n + 14, n15, arrayList, false);
                n10 = arrayList.size();
                if (n10 > 1) {
                    n9 = n12;
                    if (n12 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    object2 = n12;
                    if ((n12 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int n42 = n12;
                    if ((n12 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    int n43 = 1;
                    while (n43 < n10) {
                        stackMapFrame = (StackMapFrame)arrayList.get(n43);
                        int n44 = stackMapFrame.pc;
                        if (n12 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n12++] = (byte)(n44 >> 8);
                        this.contents[n12++] = (byte)n44;
                        n7 = n12;
                        n12 += 2;
                        n5 = 0;
                        int n45 = stackMapFrame.getNumberOfLocals();
                        int n46 = 0;
                        int n47 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n48 = 0;
                        while (n48 < n47 && n5 < n45) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n48]) == null) {
                                this.contents[n12++] = 0;
                            } else {
                                block66 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        ++n48;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        ++n48;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n49 = verificationTypeInfo.offset;
                                                this.contents[n12++] = (byte)(n49 >> 8);
                                                this.contents[n12++] = (byte)n49;
                                                break block66;
                                            }
                                            case 7: {
                                                n6 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n12++] = (byte)(n6 >> 8);
                                                this.contents[n12++] = (byte)n6;
                                            }
                                        }
                                    }
                                }
                                ++n5;
                            }
                            ++n46;
                            ++n48;
                        }
                        if (n12 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n7++] = (byte)(n46 >> 8);
                        this.contents[n7] = (byte)n46;
                        n48 = stackMapFrame.numberOfStackItems;
                        this.contents[n12++] = (byte)(n48 >> 8);
                        this.contents[n12++] = (byte)n48;
                        n4 = 0;
                        while (n4 < n48) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n4]) == null) {
                                this.contents[n12++] = 0;
                            } else {
                                block77 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n6 = verificationTypeInfo.offset;
                                                this.contents[n12++] = (byte)(n6 >> 8);
                                                this.contents[n12++] = (byte)n6;
                                                break block77;
                                            }
                                            case 7: {
                                                int n50 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n12++] = (byte)(n50 >> 8);
                                                this.contents[n12++] = (byte)n50;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n4;
                        }
                        ++n43;
                    }
                    if (--n10 != 0) {
                        this.contents[n42++] = (byte)(n10 >> 8);
                        this.contents[n42] = (byte)n10;
                        n43 = n12 - object2 - 4;
                        this.contents[object2++] = (byte)(n43 >> 24);
                        this.contents[object2++] = (byte)(n43 >> 16);
                        this.contents[object2++] = (byte)(n43 >> 8);
                        this.contents[object2] = (byte)n43;
                        ++n17;
                    } else {
                        n12 = n9;
                    }
                }
            }
        }
        if (n16 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n16++] = (byte)(n17 >> 8);
        this.contents[n16] = (byte)n17;
        int n51 = n12 - (n + 6);
        this.contents[n + 2] = (byte)(n51 >> 24);
        this.contents[n + 3] = (byte)(n51 >> 16);
        this.contents[n + 4] = (byte)(n51 >> 8);
        this.contents[n + 5] = (byte)n51;
        this.contentsOffset = n12;
    }

    public void completeCodeAttributeForSyntheticMethod(boolean bl, SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        boolean bl2;
        this.contents = this.codeStream.bCodeStream;
        int n17 = this.codeStream.classFileOffset;
        int n18 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n18 >> 8);
        this.contents[n + 7] = (byte)n18;
        int n19 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n19 >> 8);
        this.contents[n + 9] = (byte)n19;
        int n20 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n20 >> 24);
        this.contents[n + 11] = (byte)(n20 >> 16);
        this.contents[n + 12] = (byte)(n20 >> 8);
        this.contents[n + 13] = (byte)n20;
        if (n17 + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        boolean bl3 = bl2 = (this.produceAttributes & 8) != 0;
        if (bl) {
            ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
            n16 = 0;
            n15 = 0;
            n14 = this.codeStream.exceptionLabelsCounter;
            while (n15 < n14) {
                n16 += this.codeStream.exceptionLabels[n15].count / 2;
                ++n15;
            }
            n15 = n16 * 8 + 2;
            if (n15 + n17 >= this.contents.length) {
                this.resizeContents(n15);
            }
            this.contents[n17++] = (byte)(n16 >> 8);
            this.contents[n17++] = (byte)n16;
            n14 = 0;
            n13 = this.codeStream.exceptionLabelsCounter;
            while (n14 < n13) {
                ExceptionLabel exceptionLabel = exceptionLabelArray[n14];
                if (exceptionLabel != null) {
                    n12 = 0;
                    n11 = exceptionLabel.count;
                    if ((n11 & 1) != 0) {
                        this.referenceBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(syntheticMethodBinding.selector), this.referenceBinding.scope.problemReporter().referenceContext));
                    }
                    while (n12 < n11) {
                        int n21;
                        n10 = exceptionLabel.ranges[n12++];
                        this.contents[n17++] = (byte)(n10 >> 8);
                        this.contents[n17++] = (byte)n10;
                        n9 = exceptionLabel.ranges[n12++];
                        this.contents[n17++] = (byte)(n9 >> 8);
                        this.contents[n17++] = (byte)n9;
                        n8 = exceptionLabel.position;
                        if (bl2) {
                            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                            stackMapFrameCodeStream.addFramePosition(n8);
                        }
                        this.contents[n17++] = (byte)(n8 >> 8);
                        this.contents[n17++] = (byte)n8;
                        if (exceptionLabel.exceptionType == null) {
                            this.contents[n17++] = 0;
                            this.contents[n17++] = 0;
                            continue;
                        }
                        switch (exceptionLabel.exceptionType.id) {
                            case 12: {
                                n21 = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                                break;
                            }
                            case 7: {
                                n21 = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                                break;
                            }
                            default: {
                                n21 = this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                            }
                        }
                        this.contents[n17++] = (byte)(n21 >> 8);
                        this.contents[n17++] = (byte)n21;
                    }
                }
                ++n14;
            }
        } else {
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
        }
        int n22 = n17;
        n16 = 0;
        if ((n17 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n17 + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            n15 = 0;
            n14 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n17++] = (byte)(n14 >> 8);
            this.contents[n17++] = (byte)n14;
            n13 = n17;
            n17 += 6;
            n15 = Util.getLineNumber(syntheticMethodBinding.sourceStart, nArray, 0, nArray.length - 1);
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = (byte)(n15 >> 8);
            this.contents[n17++] = (byte)n15;
            this.contents[n13++] = 0;
            this.contents[n13++] = 0;
            this.contents[n13++] = 0;
            this.contents[n13++] = 6;
            this.contents[n13++] = 0;
            this.contents[n13++] = 1;
            ++n16;
        }
        if ((this.produceAttributes & 4) != 0) {
            int n23;
            int n24;
            n15 = 0;
            n14 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n17 + 8 > this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n17++] = (byte)(n14 >> 8);
            this.contents[n17++] = (byte)n14;
            n13 = n17;
            n17 += 6;
            n11 = 0;
            LocalVariableBinding[] localVariableBindingArray = null;
            n9 = 0;
            n8 = 0;
            int n25 = this.codeStream.allLocalsCounter;
            while (n8 < n25) {
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n8];
                if (localVariableBinding.declaration != null) {
                    TypeBinding typeBinding = localVariableBinding.type;
                    int n26 = n7 = !typeBinding.isParameterizedType() && !typeBinding.isTypeVariable() ? 0 : 1;
                    if (localVariableBinding.initializationCount != 0 && n7 != 0) {
                        if (localVariableBindingArray == null) {
                            localVariableBindingArray = new LocalVariableBinding[n25];
                        }
                        localVariableBindingArray[n11++] = localVariableBinding;
                    }
                    n6 = 0;
                    while (n6 < localVariableBinding.initializationCount) {
                        n24 = localVariableBinding.initializationPCs[n6 << 1];
                        n23 = localVariableBinding.initializationPCs[(n6 << 1) + 1];
                        if (n24 != n23) {
                            if (n23 == -1) {
                                localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                            }
                            if (n17 + 10 > this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++n15;
                            if (n7 != 0) {
                                ++n9;
                            }
                            this.contents[n17++] = (byte)(n24 >> 8);
                            this.contents[n17++] = (byte)n24;
                            n5 = n23 - n24;
                            this.contents[n17++] = (byte)(n5 >> 8);
                            this.contents[n17++] = (byte)n5;
                            int n27 = this.constantPool.literalIndex(localVariableBinding.name);
                            this.contents[n17++] = (byte)(n27 >> 8);
                            this.contents[n17++] = (byte)n27;
                            n12 = this.constantPool.literalIndex(typeBinding.signature());
                            this.contents[n17++] = (byte)(n12 >> 8);
                            this.contents[n17++] = (byte)n12;
                            n4 = localVariableBinding.resolvedPosition;
                            this.contents[n17++] = (byte)(n4 >> 8);
                            this.contents[n17++] = (byte)n4;
                        }
                        ++n6;
                    }
                }
                ++n8;
            }
            n8 = n15 * 10 + 2;
            this.contents[n13++] = (byte)(n8 >> 24);
            this.contents[n13++] = (byte)(n8 >> 16);
            this.contents[n13++] = (byte)(n8 >> 8);
            this.contents[n13++] = (byte)n8;
            this.contents[n13++] = (byte)(n15 >> 8);
            this.contents[n13] = (byte)n15;
            ++n16;
            if (n11 != 0) {
                n25 = 8 + n9 * 10;
                if (n17 + n25 >= this.contents.length) {
                    this.resizeContents(n25);
                }
                int n28 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n17++] = (byte)(n28 >> 8);
                this.contents[n17++] = (byte)n28;
                n8 = n9 * 10 + 2;
                this.contents[n17++] = (byte)(n8 >> 24);
                this.contents[n17++] = (byte)(n8 >> 16);
                this.contents[n17++] = (byte)(n8 >> 8);
                this.contents[n17++] = (byte)n8;
                this.contents[n17++] = (byte)(n9 >> 8);
                this.contents[n17++] = (byte)n9;
                int n29 = 0;
                while (n29 < n11) {
                    LocalVariableBinding localVariableBinding = localVariableBindingArray[n29];
                    n6 = 0;
                    while (n6 < localVariableBinding.initializationCount) {
                        n24 = localVariableBinding.initializationPCs[n6 << 1];
                        n23 = localVariableBinding.initializationPCs[(n6 << 1) + 1];
                        if (n24 != n23) {
                            this.contents[n17++] = (byte)(n24 >> 8);
                            this.contents[n17++] = (byte)n24;
                            n5 = n23 - n24;
                            this.contents[n17++] = (byte)(n5 >> 8);
                            this.contents[n17++] = (byte)n5;
                            int n30 = this.constantPool.literalIndex(localVariableBinding.name);
                            this.contents[n17++] = (byte)(n30 >> 8);
                            this.contents[n17++] = (byte)n30;
                            n12 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                            this.contents[n17++] = (byte)(n12 >> 8);
                            this.contents[n17++] = (byte)n12;
                            n4 = localVariableBinding.resolvedPosition;
                            this.contents[n17++] = (byte)(n4 >> 8);
                            this.contents[n17++] = (byte)n4;
                        }
                        ++n6;
                    }
                    ++n29;
                }
                ++n16;
            }
        }
        if (bl2) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n20);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(syntheticMethodBinding, n19, this.contents, n + 14, n20, arrayList, false);
                n13 = arrayList.size();
                if (n13 > 1) {
                    int n31 = n17;
                    if (n17 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n12 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
                    this.contents[n17++] = (byte)(n12 >> 8);
                    this.contents[n17++] = (byte)n12;
                    n11 = n17;
                    if ((n17 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n10 = n17;
                    if ((n17 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    StackMapFrame stackMapFrame2 = null;
                    int n32 = 1;
                    while (n32 < n13) {
                        stackMapFrame2 = stackMapFrame;
                        stackMapFrame = (StackMapFrame)arrayList.get(n32);
                        int n33 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                        block4 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                            case 2: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                int n34 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n17++] = (byte)(251 + n34);
                                this.contents[n17++] = (byte)(n33 >> 8);
                                this.contents[n17++] = (byte)n33;
                                n7 = stackMapFrame.getIndexOfDifferentLocals(n34);
                                n6 = stackMapFrame.getNumberOfLocals();
                                int n35 = n7;
                                while (n35 < stackMapFrame.locals.length && n34 > 0) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 6 >= this.contents.length) {
                                        this.resizeContents(6);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n35]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block12 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                ++n35;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                ++n35;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n5 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n5 >> 8);
                                                        this.contents[n17++] = (byte)n5;
                                                        break block12;
                                                    }
                                                    case 7: {
                                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n4 >> 8);
                                                        this.contents[n17++] = (byte)n4;
                                                    }
                                                }
                                            }
                                        }
                                        --n34;
                                    }
                                    ++n35;
                                }
                                break;
                            }
                            case 0: {
                                if (n17 + 1 >= this.contents.length) {
                                    this.resizeContents(1);
                                }
                                this.contents[n17++] = (byte)n33;
                                break;
                            }
                            case 3: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                this.contents[n17++] = -5;
                                this.contents[n17++] = (byte)(n33 >> 8);
                                this.contents[n17++] = (byte)n33;
                                break;
                            }
                            case 1: {
                                if (n17 + 3 >= this.contents.length) {
                                    this.resizeContents(3);
                                }
                                int n36 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                                this.contents[n17++] = (byte)(251 - n36);
                                this.contents[n17++] = (byte)(n33 >> 8);
                                this.contents[n17++] = (byte)n33;
                                break;
                            }
                            case 5: {
                                if (n17 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n17++] = (byte)(n33 + 64);
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n17++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break block4;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break block4;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break block4;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break block4;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break block4;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n17++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n17++] = (byte)(n5 >> 8);
                                        this.contents[n17++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n17++] = (byte)(n4 >> 8);
                                        this.contents[n17++] = (byte)n4;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                if (n17 + 6 >= this.contents.length) {
                                    this.resizeContents(6);
                                }
                                this.contents[n17++] = -9;
                                this.contents[n17++] = (byte)(n33 >> 8);
                                this.contents[n17++] = (byte)n33;
                                if (stackMapFrame.stackItems[0] == null) {
                                    this.contents[n17++] = 0;
                                    break;
                                }
                                switch (stackMapFrame.stackItems[0].id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break block4;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break block4;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break block4;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break block4;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break block4;
                                    }
                                }
                                VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                                byte by = (byte)verificationTypeInfo.tag;
                                this.contents[n17++] = by;
                                switch (by) {
                                    case 8: {
                                        n5 = verificationTypeInfo.offset;
                                        this.contents[n17++] = (byte)(n5 >> 8);
                                        this.contents[n17++] = (byte)n5;
                                        break;
                                    }
                                    case 7: {
                                        n4 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n17++] = (byte)(n4 >> 8);
                                        this.contents[n17++] = (byte)n4;
                                    }
                                }
                                break;
                            }
                            default: {
                                int n37;
                                if (n17 + 5 >= this.contents.length) {
                                    this.resizeContents(5);
                                }
                                this.contents[n17++] = -1;
                                this.contents[n17++] = (byte)(n33 >> 8);
                                this.contents[n17++] = (byte)n33;
                                int n38 = n17;
                                n17 += 2;
                                int n39 = 0;
                                n6 = stackMapFrame.getNumberOfLocals();
                                n5 = 0;
                                n4 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                                n3 = 0;
                                while (n3 < n4 && n39 < n6) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.locals[n3]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block45 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                ++n3;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                ++n3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        int n40 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n40 >> 8);
                                                        this.contents[n17++] = (byte)n40;
                                                        break block45;
                                                    }
                                                    case 7: {
                                                        n37 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n37 >> 8);
                                                        this.contents[n17++] = (byte)n37;
                                                    }
                                                }
                                            }
                                        }
                                        ++n39;
                                    }
                                    ++n5;
                                    ++n3;
                                }
                                if (n17 + 4 >= this.contents.length) {
                                    this.resizeContents(4);
                                }
                                this.contents[n38++] = (byte)(n5 >> 8);
                                this.contents[n38] = (byte)n5;
                                n3 = stackMapFrame.numberOfStackItems;
                                this.contents[n17++] = (byte)(n3 >> 8);
                                this.contents[n17++] = (byte)n3;
                                n2 = 0;
                                while (n2 < n3) {
                                    VerificationTypeInfo verificationTypeInfo;
                                    if (n17 + 3 >= this.contents.length) {
                                        this.resizeContents(3);
                                    }
                                    if ((verificationTypeInfo = stackMapFrame.stackItems[n2]) == null) {
                                        this.contents[n17++] = 0;
                                    } else {
                                        block56 : switch (verificationTypeInfo.id()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 10: {
                                                this.contents[n17++] = 1;
                                                break;
                                            }
                                            case 9: {
                                                this.contents[n17++] = 2;
                                                break;
                                            }
                                            case 7: {
                                                this.contents[n17++] = 4;
                                                break;
                                            }
                                            case 8: {
                                                this.contents[n17++] = 3;
                                                break;
                                            }
                                            case 12: {
                                                this.contents[n17++] = 5;
                                                break;
                                            }
                                            default: {
                                                this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                                switch (verificationTypeInfo.tag) {
                                                    case 8: {
                                                        n37 = verificationTypeInfo.offset;
                                                        this.contents[n17++] = (byte)(n37 >> 8);
                                                        this.contents[n17++] = (byte)n37;
                                                        break block56;
                                                    }
                                                    case 7: {
                                                        int n41 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                        this.contents[n17++] = (byte)(n41 >> 8);
                                                        this.contents[n17++] = (byte)n41;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                break block4;
                            }
                        }
                        ++n32;
                    }
                    if (--n13 != 0) {
                        this.contents[n10++] = (byte)(n13 >> 8);
                        this.contents[n10] = (byte)n13;
                        n32 = n17 - n11 - 4;
                        this.contents[n11++] = (byte)(n32 >> 24);
                        this.contents[n11++] = (byte)(n32 >> 16);
                        this.contents[n11++] = (byte)(n32 >> 8);
                        this.contents[n11] = (byte)n32;
                        ++n16;
                    } else {
                        n17 = n31;
                    }
                }
            }
        }
        if ((this.produceAttributes & 0x10) != 0) {
            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
            stackMapFrameCodeStream.removeFramePosition(n20);
            if (stackMapFrameCodeStream.hasFramePositions()) {
                ArrayList arrayList = new ArrayList();
                this.traverse(this.codeStream.methodDeclaration.binding, n19, this.contents, n + 14, n20, arrayList, false);
                n13 = arrayList.size();
                if (n13 > 1) {
                    int n42 = n17;
                    if (n17 + 8 >= this.contents.length) {
                        this.resizeContents(8);
                    }
                    n12 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
                    this.contents[n17++] = (byte)(n12 >> 8);
                    this.contents[n17++] = (byte)n12;
                    n11 = n17;
                    if ((n17 += 4) + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    n10 = n17;
                    if ((n17 += 2) + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
                    int n43 = 1;
                    while (n43 < n13) {
                        stackMapFrame = (StackMapFrame)arrayList.get(n43);
                        int n44 = stackMapFrame.pc;
                        if (n17 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n17++] = (byte)(n44 >> 8);
                        this.contents[n17++] = (byte)n44;
                        int n45 = n17;
                        n17 += 2;
                        int n46 = 0;
                        n7 = stackMapFrame.getNumberOfLocals();
                        n6 = 0;
                        int n47 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n48 = 0;
                        while (n48 < n47 && n46 < n7) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n48]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block67 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        ++n48;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        ++n48;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n49 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n49 >> 8);
                                                this.contents[n17++] = (byte)n49;
                                                break block67;
                                            }
                                            case 7: {
                                                n3 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n3 >> 8);
                                                this.contents[n17++] = (byte)n3;
                                            }
                                        }
                                    }
                                }
                                ++n46;
                            }
                            ++n6;
                            ++n48;
                        }
                        if (n17 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n45++] = (byte)(n6 >> 8);
                        this.contents[n45] = (byte)n6;
                        n48 = stackMapFrame.numberOfStackItems;
                        this.contents[n17++] = (byte)(n48 >> 8);
                        this.contents[n17++] = (byte)n48;
                        n5 = 0;
                        while (n5 < n48) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n5]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block78 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n3 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n3 >> 8);
                                                this.contents[n17++] = (byte)n3;
                                                break block78;
                                            }
                                            case 7: {
                                                n2 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n2 >> 8);
                                                this.contents[n17++] = (byte)n2;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++n43;
                    }
                    if (--n13 != 0) {
                        this.contents[n10++] = (byte)(n13 >> 8);
                        this.contents[n10] = (byte)n13;
                        n43 = n17 - n11 - 4;
                        this.contents[n11++] = (byte)(n43 >> 24);
                        this.contents[n11++] = (byte)(n43 >> 16);
                        this.contents[n11++] = (byte)(n43 >> 8);
                        this.contents[n11] = (byte)n43;
                        ++n16;
                    } else {
                        n17 = n42;
                    }
                }
            }
        }
        if (n22 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n22++] = (byte)(n16 >> 8);
        this.contents[n22] = (byte)n16;
        int n50 = n17 - (n + 6);
        this.contents[n + 2] = (byte)(n50 >> 24);
        this.contents[n + 3] = (byte)(n50 >> 16);
        this.contents[n + 4] = (byte)(n50 >> 8);
        this.contents[n + 5] = (byte)n50;
        this.contentsOffset = n17;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        this.completeCodeAttributeForSyntheticMethod(false, syntheticMethodBinding, n, nArray);
    }

    public void completeMethodInfo(int n, int n2) {
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(2);
    }

    private void generateAnnotation(Annotation annotation, int n) {
        TypeBinding typeBinding;
        int n2 = n;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((typeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = n2;
            return;
        }
        int n3 = this.constantPool.literalIndex(typeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairArray = normalAnnotation.memberValuePairs;
            if (memberValuePairArray != null) {
                int n4 = memberValuePairArray.length;
                this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                this.contents[this.contentsOffset++] = (byte)n4;
                int n5 = 0;
                while (n5 < n4) {
                    MemberValuePair memberValuePair = memberValuePairArray[n5];
                    if (this.contentsOffset + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    int n6 = this.constantPool.literalIndex(memberValuePair.name);
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        this.contentsOffset = n2;
                    } else {
                        try {
                            this.generateElementValue(memberValuePair.value, methodBinding.returnType, n2);
                        }
                        catch (ClassCastException classCastException) {
                            this.contentsOffset = n2;
                        }
                        catch (ShouldNotImplement shouldNotImplement) {
                            this.contentsOffset = n2;
                        }
                    }
                    ++n5;
                }
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int n7 = this.constantPool.literalIndex(VALUE);
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = n2;
            } else {
                try {
                    this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, n2);
                }
                catch (ClassCastException classCastException) {
                    this.contentsOffset = n2;
                }
                catch (ShouldNotImplement shouldNotImplement) {
                    this.contentsOffset = n2;
                }
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contentsOffset += 12;
    }

    private void generateElementValue(Expression expression, TypeBinding typeBinding, int n) {
        Constant constant = expression.constant;
        TypeBinding typeBinding2 = expression.resolvedType;
        if (typeBinding2 == null) {
            this.contentsOffset = n;
        } else {
            if (typeBinding.isArrayType() && !typeBinding2.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(n, expression, constant, typeBinding.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(expression, n, typeBinding2);
            }
        }
    }

    private void generateElementValue(int n, Expression expression, Constant constant, TypeBinding typeBinding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (typeBinding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int n2 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                this.contents[this.contentsOffset++] = (byte)n2;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int n3 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int n4 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                this.contents[this.contentsOffset++] = (byte)n4;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int n5 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                this.contents[this.contentsOffset++] = (byte)n5;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                this.contents[this.contentsOffset++] = (byte)n6;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                this.contents[this.contentsOffset++] = (byte)n8;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(expression);
                        break;
                    }
                    this.contentsOffset = n;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression expression, int n, TypeBinding typeBinding) {
        if (typeBinding != null) {
            if (typeBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (expression instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)expression;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (expression instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)expression;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    this.contentsOffset = n;
                }
                if (fieldBinding != null) {
                    int n2 = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int n3 = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                }
            } else if (typeBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)expression, n);
            } else if (typeBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    int n4 = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n4;
                    int n5 = 0;
                    while (n5 < n4) {
                        this.generateElementValue(arrayInitializer.expressions[n5], typeBinding.leafComponentType(), n);
                        ++n5;
                    }
                } else {
                    this.contentsOffset = n;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (expression instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)expression;
                    int n6 = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                } else {
                    this.contentsOffset = n;
                }
            }
        } else {
            this.contentsOffset = n;
        }
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding) {
        AbstractMethodDeclaration abstractMethodDeclaration;
        char[] cArray;
        int n;
        int n2;
        int n3;
        this.contentsOffset += 2;
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n3 = referenceBindingArray.length;
            n2 = 8 + n3 * 2;
            if (n2 + this.contentsOffset >= this.contents.length) {
                this.resizeContents(n2);
            }
            n = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            int n5 = n3 * 2 + 2;
            this.contents[this.contentsOffset++] = (byte)(n5 >> 24);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 16);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            int n6 = 0;
            while (n6 < n3) {
                int n7 = this.constantPool.literalIndexForType(referenceBindingArray[n6]);
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                ++n6;
            }
            ++n4;
        }
        if (methodBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n4;
        }
        if (this.targetJDK < 0x310000L) {
            if (methodBinding.isSynthetic()) {
                if (this.contentsOffset + 6 >= this.contents.length) {
                    this.resizeContents(6);
                }
                n3 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                ++n4;
            }
            if (methodBinding.isVarargs()) {
                if (this.contentsOffset + 6 >= this.contents.length) {
                    this.resizeContents(6);
                }
                n3 = this.constantPool.literalIndex(AttributeNamesConstants.VarargsName);
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                ++n4;
            }
        }
        if ((cArray = methodBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n2 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            ++n4;
        }
        if (this.targetJDK >= 0x310000L && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null) {
            Argument[] argumentArray;
            Annotation[] annotationArray = abstractMethodDeclaration.annotations;
            if (annotationArray != null) {
                n4 += this.generateRuntimeAnnotations(annotationArray);
            }
            if ((methodBinding.tagBits & 0x400L) != 0L && (argumentArray = abstractMethodDeclaration.arguments) != null) {
                n4 += this.generateRuntimeAnnotationsForParameters(argumentArray);
            }
        }
        if ((methodBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = methodBinding.collectMissingTypes(this.missingTypes);
        }
        return n4;
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, AnnotationMethodDeclaration annotationMethodDeclaration) {
        int n = this.generateMethodInfoAttribute(methodBinding);
        int n2 = this.contentsOffset;
        if ((annotationMethodDeclaration.modifiers & 0x20000) != 0) {
            int n3 = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            int n4 = this.contentsOffset;
            this.contentsOffset += 4;
            if (this.contentsOffset + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            this.generateElementValue(annotationMethodDeclaration.defaultValue, annotationMethodDeclaration.binding.returnType, n2);
            if (this.contentsOffset != n2) {
                int n5 = this.contentsOffset - n4 - 4;
                this.contents[n4++] = (byte)(n5 >> 24);
                this.contents[n4++] = (byte)(n5 >> 16);
                this.contents[n4++] = (byte)(n5 >> 8);
                this.contents[n4++] = (byte)n5;
                ++n;
            }
        }
        return n;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int n) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEF7F;
        }
        if ((methodBinding.tagBits & 0x400L) != 0L) {
            n &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(methodBinding.signature(this));
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int n = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarationArray, CompilationResult compilationResult) {
        if (methodDeclarationArray != null) {
            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
            int n = typeDeclaration.sourceStart();
            int n2 = typeDeclaration.sourceEnd();
            int n3 = 0;
            int n4 = methodDeclarationArray.length;
            while (n3 < n4) {
                MethodDeclaration methodDeclaration = methodDeclarationArray[n3];
                MethodBinding methodBinding = methodDeclaration.binding;
                String string = new String(methodBinding.readableName());
                CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                int n5 = compilationResult.problemCount;
                int n6 = 0;
                while (n6 < n5) {
                    CategorizedProblem categorizedProblem = categorizedProblemArray[n6];
                    if (categorizedProblem != null && categorizedProblem.getID() == 67109264 && categorizedProblem.getMessage().indexOf(string) != -1 && categorizedProblem.getSourceStart() >= n && categorizedProblem.getSourceEnd() <= n2) {
                        this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, categorizedProblem, compilationResult);
                    }
                    ++n6;
                }
                ++n3;
            }
        }
    }

    private void generateMissingTypesAttribute() {
        int n;
        int n2 = this.missingTypes.size();
        int[] nArray = new int[n2];
        int n3 = 0;
        if (n2 > 1) {
            Collections.sort(this.missingTypes, new Comparator(){

                public int compare(Object object, Object object2) {
                    TypeBinding typeBinding = (TypeBinding)object;
                    TypeBinding typeBinding2 = (TypeBinding)object2;
                    return CharOperation.compareTo(typeBinding.constantPoolName(), typeBinding2.constantPoolName());
                }
            });
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = this.constantPool.literalIndexForType((TypeBinding)this.missingTypes.get(n5));
            if (n4 != n) {
                n4 = n;
                nArray[n3++] = n;
            }
            ++n5;
        }
        n5 = n3 * 2 + 2;
        if (this.contentsOffset + n5 + 6 >= this.contents.length) {
            this.resizeContents(n5 + 6);
        }
        n = this.constantPool.literalIndex(AttributeNamesConstants.MissingTypesName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contents[this.contentsOffset++] = (byte)(n5 >> 24);
        this.contents[this.contentsOffset++] = (byte)(n5 >> 16);
        this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
        this.contents[this.contentsOffset++] = (byte)n5;
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = nArray[n6];
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            ++n6;
        }
    }

    private int generateRuntimeAnnotations(Annotation[] annotationArray) {
        int n;
        Annotation annotation;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = annotationArray.length;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n8) {
            Annotation annotation2 = annotationArray[n11];
            if (this.isRuntimeInvisible(annotation2)) {
                ++n10;
            } else if (this.isRuntimeVisible(annotation2)) {
                ++n9;
            }
            ++n11;
        }
        n11 = this.contentsOffset;
        int n12 = this.constantPool.currentOffset;
        int n13 = this.constantPool.currentIndex;
        if (n10 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            n5 = this.contentsOffset;
            this.contentsOffset += 4;
            n4 = this.contentsOffset;
            this.contentsOffset += 2;
            n3 = 0;
            n2 = 0;
            while (n2 < n8) {
                if (n10 == 0) break;
                annotation = annotationArray[n2];
                if (this.isRuntimeInvisible(annotation)) {
                    n = this.contentsOffset;
                    this.generateAnnotation(annotation, n);
                    --n10;
                    if (this.contentsOffset != n) {
                        ++n3;
                    }
                }
                ++n2;
            }
            if (n3 != 0) {
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                n2 = this.contentsOffset - n5 - 4;
                this.contents[n5++] = (byte)(n2 >> 24);
                this.contents[n5++] = (byte)(n2 >> 16);
                this.contents[n5++] = (byte)(n2 >> 8);
                this.contents[n5++] = (byte)n2;
                ++n7;
            } else {
                this.contentsOffset = n11;
                this.constantPool.resetForAttributeName(AttributeNamesConstants.RuntimeInvisibleAnnotationsName, n13, n12);
            }
        }
        n11 = this.contentsOffset;
        n12 = this.constantPool.currentOffset;
        n13 = this.constantPool.currentIndex;
        if (n9 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            n5 = this.contentsOffset;
            this.contentsOffset += 4;
            n4 = this.contentsOffset;
            this.contentsOffset += 2;
            n3 = 0;
            n2 = 0;
            while (n2 < n8) {
                if (n9 == 0) break;
                annotation = annotationArray[n2];
                if (this.isRuntimeVisible(annotation)) {
                    --n9;
                    n = this.contentsOffset;
                    this.generateAnnotation(annotation, n);
                    if (this.contentsOffset != n) {
                        ++n3;
                    }
                }
                ++n2;
            }
            if (n3 != 0) {
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                n2 = this.contentsOffset - n5 - 4;
                this.contents[n5++] = (byte)(n2 >> 24);
                this.contents[n5++] = (byte)(n2 >> 16);
                this.contents[n5++] = (byte)(n2 >> 8);
                this.contents[n5++] = (byte)n2;
                ++n7;
            } else {
                this.contentsOffset = n11;
                this.constantPool.resetForAttributeName(AttributeNamesConstants.RuntimeVisibleAnnotationsName, n13, n12);
            }
        }
        return n7;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] argumentArray) {
        int n;
        Annotation annotation;
        int n2;
        int n3;
        Annotation[] annotationArray;
        Argument argument;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = argumentArray.length;
        int n10 = 0;
        int n11 = 0;
        int[][] nArray = new int[n9][2];
        int n12 = 0;
        while (n12 < n9) {
            Argument argument2 = argumentArray[n12];
            Annotation[] annotationArray2 = argument2.annotations;
            if (annotationArray2 != null) {
                n8 = 0;
                n7 = annotationArray2.length;
                while (n8 < n7) {
                    Annotation annotation2 = annotationArray2[n8];
                    if (this.isRuntimeInvisible(annotation2)) {
                        int[] nArray2 = nArray[n12];
                        nArray2[1] = nArray2[1] + 1;
                        ++n10;
                    } else if (this.isRuntimeVisible(annotation2)) {
                        int[] nArray3 = nArray[n12];
                        nArray3[0] = nArray3[0] + 1;
                        ++n11;
                    }
                    ++n8;
                }
            }
            ++n12;
        }
        n12 = 0;
        int n13 = this.contentsOffset;
        if (n10 != 0) {
            int n14 = 0;
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n9;
            int n15 = 0;
            while (n15 < n9) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n10 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    n6 = nArray[n15][1];
                    n5 = this.contentsOffset;
                    this.contentsOffset += 2;
                    n4 = 0;
                    if (n6 != 0) {
                        argument = argumentArray[n15];
                        annotationArray = argument.annotations;
                        n3 = 0;
                        n2 = annotationArray.length;
                        while (n3 < n2) {
                            annotation = annotationArray[n3];
                            if (this.isRuntimeInvisible(annotation)) {
                                n = this.contentsOffset;
                                this.generateAnnotation(annotation, n);
                                if (this.contentsOffset != n) {
                                    ++n4;
                                    ++n14;
                                }
                                --n10;
                            }
                            ++n3;
                        }
                    }
                    this.contents[n5++] = (byte)(n4 >> 8);
                    this.contents[n5] = (byte)n4;
                }
                ++n15;
            }
            if (n14 != 0) {
                n15 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n15 >> 24);
                this.contents[n7++] = (byte)(n15 >> 16);
                this.contents[n7++] = (byte)(n15 >> 8);
                this.contents[n7++] = (byte)n15;
                ++n12;
            } else {
                this.contentsOffset = n13;
            }
        }
        if (n11 != 0) {
            int n16 = 0;
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n9;
            int n17 = 0;
            while (n17 < n9) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n11 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    n6 = nArray[n17][0];
                    n5 = this.contentsOffset;
                    this.contentsOffset += 2;
                    n4 = 0;
                    if (n6 != 0) {
                        argument = argumentArray[n17];
                        annotationArray = argument.annotations;
                        n3 = 0;
                        n2 = annotationArray.length;
                        while (n3 < n2) {
                            annotation = annotationArray[n3];
                            if (this.isRuntimeVisible(annotation)) {
                                n = this.contentsOffset;
                                this.generateAnnotation(annotation, n);
                                if (this.contentsOffset != n) {
                                    ++n4;
                                    ++n16;
                                }
                                --n11;
                            }
                            ++n3;
                        }
                    }
                    this.contents[n5++] = (byte)(n4 >> 8);
                    this.contents[n5] = (byte)n4;
                }
                ++n17;
            }
            if (n16 != 0) {
                n17 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n17 >> 24);
                this.contents[n7++] = (byte)(n17 >> 16);
                this.contents[n7++] = (byte)(n17 >> 8);
                this.contents[n7++] = (byte)n17;
                ++n12;
            } else {
                this.contentsOffset = n13;
            }
        }
        return n12;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.headerOffset + this.contentsOffset];
            System.arraycopy(this.header, 0, this.bytes, 0, this.headerOffset);
            System.arraycopy(this.contents, 0, this.bytes, this.headerOffset, this.contentsOffset);
        }
        return this.bytes;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    private int getParametersCount(char[] cArray) {
        char c;
        int n = CharOperation.indexOf('(', cArray);
        if ((c = cArray[++n]) == ')') {
            return 0;
        }
        int n2 = 0;
        block5: while (true) {
            if ((c = cArray[n]) == ')') {
                return n2;
            }
            switch (c) {
                case '[': {
                    int n3 = this.scanType(cArray, n + 1);
                    ++n2;
                    n = n3 + 1;
                    continue block5;
                }
                case 'L': {
                    int n3 = CharOperation.indexOf(';', cArray, n + 1);
                    ++n2;
                    n = n3 + 1;
                    continue block5;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    ++n;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalArgumentException();
    }

    private char[] getReturnType(char[] cArray) {
        int n = CharOperation.lastIndexOf(')', cArray);
        return CharOperation.subarray(cArray, n + 1, cArray.length);
    }

    private final int i4At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return ((byArray[n3++] & 0xFF) << 24) + ((byArray[n3++] & 0xFF) << 16) + ((byArray[n3++] & 0xFF) << 8) + (byArray[n3] & 0xFF);
    }

    protected void initByteArrays() {
        int n = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
        this.header = new byte[1500];
        this.contents = new byte[n < 15 ? 400 : 1500];
    }

    public void initialize(SourceTypeBinding sourceTypeBinding, ClassFile classFile, boolean bl) {
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        long l = this.targetJDK;
        if (l == 0x330000L) {
            l = 0x320000L;
        }
        this.header[this.headerOffset++] = (byte)(l >> 8);
        this.header[this.headerOffset++] = (byte)(l >> 0);
        this.header[this.headerOffset++] = (byte)(l >> 24);
        this.header[this.headerOffset++] = (byte)(l >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool.initialize(this);
        int n = sourceTypeBinding.getAccessFlags();
        if (sourceTypeBinding.isPrivate()) {
            n &= 0xFFFFFFFE;
        }
        if (sourceTypeBinding.isProtected()) {
            n |= 1;
        }
        n &= 0xFFFFF6D1;
        if (!sourceTypeBinding.isInterface()) {
            n |= 0x20;
        }
        if (sourceTypeBinding.isAnonymousType()) {
            n &= 0xFFFFFFEF;
        }
        this.enclosingClassFile = classFile;
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndexForType(sourceTypeBinding);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = sourceTypeBinding.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (sourceTypeBinding.superclass == null ? 0 : this.constantPool.literalIndexForType(sourceTypeBinding.superclass));
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces();
        int n4 = referenceBindingArray.length;
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.constantPool.literalIndexForType(referenceBindingArray[n5]);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            ++n5;
        }
        this.creatingProblemType = bl;
        this.codeStream.maxFieldCount = sourceTypeBinding.scope.outerMostClassScope().referenceType().maxFieldCount;
    }

    private void initializeDefaultLocals(StackMapFrame stackMapFrame, MethodBinding methodBinding, int n, int n2) {
        block24: {
            Object object;
            int n3;
            block25: {
                block26: {
                    SyntheticArgumentBinding[] syntheticArgumentBindingArray;
                    int n4;
                    if (n == 0) break block24;
                    n3 = 0;
                    boolean bl = methodBinding.isConstructor();
                    if (bl) {
                        object = new LocalVariableBinding("this".toCharArray(), (TypeBinding)methodBinding.declaringClass, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = 0;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(6, methodBinding.declaringClass));
                        ++n3;
                    } else if (!methodBinding.isStatic()) {
                        object = new LocalVariableBinding("this".toCharArray(), (TypeBinding)methodBinding.declaringClass, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = 0;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(7, methodBinding.declaringClass));
                        ++n3;
                    }
                    if (!bl) break block25;
                    if (methodBinding.declaringClass.isEnum()) {
                        object = new LocalVariableBinding(" name".toCharArray(), (TypeBinding)this.referenceBinding.scope.getJavaLangString(), 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = n3;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(11, ConstantPool.JavaLangStringConstantPoolName));
                        object = new LocalVariableBinding(" ordinal".toCharArray(), (TypeBinding)TypeBinding.INT, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = ++n3;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(TypeBinding.INT));
                        ++n3;
                    }
                    if (!methodBinding.declaringClass.isNestedType()) break block26;
                    object = methodBinding.declaringClass.syntheticEnclosingInstanceTypes();
                    if (object != null) {
                        int n5 = 0;
                        n4 = ((Object)object).length;
                        while (n5 < n4) {
                            LocalVariableBinding localVariableBinding = new LocalVariableBinding((" enclosingType" + n5).toCharArray(), (TypeBinding)object[n5], 0, false);
                            localVariableBinding.resolvedPosition = n3;
                            this.codeStream.record(localVariableBinding);
                            localVariableBinding.recordInitializationStartPC(0);
                            localVariableBinding.recordInitializationEndPC(n2);
                            stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object[n5]));
                            ++n3;
                            ++n5;
                        }
                    }
                    TypeBinding[] typeBindingArray = methodBinding.parameters;
                    if (methodBinding.parameters != null) {
                        n4 = 0;
                        int n6 = typeBindingArray.length;
                        while (n4 < n6) {
                            TypeBinding typeBinding = typeBindingArray[n4];
                            stackMapFrame.putLocal(n3, new VerificationTypeInfo(typeBinding));
                            switch (typeBinding.id) {
                                case 7: 
                                case 8: {
                                    n3 += 2;
                                    break;
                                }
                                default: {
                                    ++n3;
                                }
                            }
                            ++n4;
                        }
                    }
                    if ((syntheticArgumentBindingArray = methodBinding.declaringClass.syntheticOuterLocalVariables()) == null) break block24;
                    int n7 = 0;
                    int n8 = syntheticArgumentBindingArray.length;
                    while (n7 < n8) {
                        TypeBinding typeBinding = syntheticArgumentBindingArray[n7].type;
                        LocalVariableBinding localVariableBinding = new LocalVariableBinding((" synthetic" + n7).toCharArray(), typeBinding, 0, false);
                        localVariableBinding.resolvedPosition = n3;
                        this.codeStream.record(localVariableBinding);
                        localVariableBinding.recordInitializationStartPC(0);
                        localVariableBinding.recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(typeBinding));
                        switch (typeBinding.id) {
                            case 7: 
                            case 8: {
                                n3 += 2;
                                break;
                            }
                            default: {
                                ++n3;
                            }
                        }
                        ++n7;
                    }
                    break block24;
                }
                object = methodBinding.parameters;
                if (methodBinding.parameters == null) break block24;
                int n9 = 0;
                int n10 = ((Object)object).length;
                while (n9 < n10) {
                    Object object2 = object[n9];
                    stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object2));
                    switch (((TypeBinding)object2).id) {
                        case 7: 
                        case 8: {
                            n3 += 2;
                            break;
                        }
                        default: {
                            ++n3;
                        }
                    }
                    ++n9;
                }
                break block24;
            }
            object = methodBinding.parameters;
            if (methodBinding.parameters != null) {
                int n11 = 0;
                int n12 = ((TypeBinding[])object).length;
                while (n11 < n12) {
                    Object object3 = object[n11];
                    stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object3));
                    switch (((TypeBinding)object3).id) {
                        case 7: 
                        case 8: {
                            n3 += 2;
                            break;
                        }
                        default: {
                            ++n3;
                        }
                    }
                    ++n11;
                }
            }
        }
    }

    private void initializeLocals(boolean bl, int n, StackMapFrame stackMapFrame) {
        VerificationTypeInfo[] verificationTypeInfoArray = stackMapFrame.locals;
        int n2 = verificationTypeInfoArray.length;
        int n3 = 0;
        if (!bl) {
            n3 = 1;
        }
        while (n3 < n2) {
            verificationTypeInfoArray[n3] = null;
            ++n3;
        }
        n3 = 0;
        int n4 = this.codeStream.allLocalsCounter;
        while (n3 < n4) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n3];
            if (localVariableBinding != null) {
                int n5 = localVariableBinding.resolvedPosition;
                TypeBinding typeBinding = localVariableBinding.type;
                int n6 = 0;
                while (n6 < localVariableBinding.initializationCount) {
                    int n7 = localVariableBinding.initializationPCs[n6 << 1];
                    int n8 = localVariableBinding.initializationPCs[(n6 << 1) + 1];
                    if (n >= n7 && n < n8) {
                        if (stackMapFrame.locals[n5] != null) break;
                        stackMapFrame.locals[n5] = new VerificationTypeInfo(typeBinding);
                        break;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
    }

    private boolean isRuntimeInvisible(Annotation annotation) {
        TypeBinding typeBinding = annotation.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x300000000000L) == 0L) {
            return true;
        }
        return (l & 0x300000000000L) == 0x200000000000L;
    }

    private boolean isRuntimeVisible(Annotation annotation) {
        TypeBinding typeBinding = annotation.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x300000000000L) == 0L) {
            return false;
        }
        return (l & 0x300000000000L) == 0x300000000000L;
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile classFile = this;
        while (classFile.enclosingClassFile != null) {
            classFile = classFile.enclosingClassFile;
        }
        return classFile;
    }

    public void recordInnerClasses(TypeBinding typeBinding) {
        if (this.innerClassesBindings == null) {
            this.innerClassesBindings = new HashSet(5);
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        this.innerClassesBindings.add(referenceBinding.erasure());
        ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
        while (referenceBinding2 != null && referenceBinding2.isNestedType()) {
            this.innerClassesBindings.add(referenceBinding2.erasure());
            referenceBinding2 = referenceBinding2.enclosingType();
        }
    }

    public void reset(SourceTypeBinding sourceTypeBinding) {
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.referenceBinding = sourceTypeBinding;
        this.isNestedType = sourceTypeBinding.isNestedType();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
        } else if (this.targetJDK == 2949124L) {
            this.targetJDK = 2949123L;
            this.produceAttributes |= 0x10;
        }
        this.bytes = null;
        this.constantPool.reset();
        this.codeStream.reset(this);
        this.constantPoolOffset = 0;
        this.contentsOffset = 0;
        this.creatingProblemType = false;
        this.enclosingClassFile = null;
        this.headerOffset = 0;
        this.methodCount = 0;
        this.methodCountOffset = 0;
        if (this.innerClassesBindings != null) {
            this.innerClassesBindings.clear();
        }
        this.missingTypes = null;
        this.visitedTypes = null;
    }

    private final void resizeContents(int n) {
        int n2 = this.contents.length;
        int n3 = n2;
        if (n3 < n) {
            n3 = n;
        }
        this.contents = new byte[n2 + n3];
        System.arraycopy(this.contents, 0, this.contents, 0, n2);
    }

    private VerificationTypeInfo retrieveLocal(int n, int n2) {
        int n3 = 0;
        int n4 = this.codeStream.allLocalsCounter;
        while (n3 < n4) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n3];
            if (localVariableBinding != null && n2 == localVariableBinding.resolvedPosition) {
                int n5 = 0;
                while (n5 < localVariableBinding.initializationCount) {
                    int n6 = localVariableBinding.initializationPCs[n5 << 1];
                    int n7 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                    if (n >= n6 && n < n7) {
                        return new VerificationTypeInfo(localVariableBinding.type);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return null;
    }

    private int scanType(char[] cArray, int n) {
        switch (cArray[n]) {
            case '[': {
                return this.scanType(cArray, n + 1);
            }
            case 'L': {
                return CharOperation.indexOf(';', cArray, n + 1);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }

    public void traverse(MethodBinding methodBinding, int n, byte[] byArray, int n2, int n3, ArrayList arrayList, boolean bl) {
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        int[] nArray = stackMapFrameCodeStream.getFramePositions();
        int n4 = n2;
        int[] nArray2 = this.constantPool.offsets;
        byte[] byArray2 = this.constantPool.poolContent;
        int n5 = 0;
        int n6 = nArray.length;
        int n7 = nArray[0];
        int n8 = 0;
        StackMapFrameCodeStream.StackDepthMarker[] stackDepthMarkerArray = stackMapFrameCodeStream.getStackDepthMarkers();
        int n9 = stackDepthMarkerArray == null ? 0 : stackDepthMarkerArray.length;
        boolean bl2 = n9 != 0;
        StackMapFrameCodeStream.StackDepthMarker stackDepthMarker = null;
        if (bl2) {
            stackDepthMarker = stackDepthMarkerArray[0];
        }
        int n10 = 0;
        StackMapFrameCodeStream.StackMarker[] stackMarkerArray = stackMapFrameCodeStream.getStackMarkers();
        int n11 = stackMarkerArray == null ? 0 : stackMarkerArray.length;
        boolean bl3 = n11 != 0;
        StackMapFrameCodeStream.StackMarker stackMarker = null;
        if (bl3) {
            stackMarker = stackMarkerArray[0];
        }
        int n12 = 0;
        StackMapFrameCodeStream.ExceptionMarker[] exceptionMarkerArray = stackMapFrameCodeStream.getExceptionMarkers();
        int n13 = exceptionMarkerArray == null ? 0 : exceptionMarkerArray.length;
        boolean bl4 = n13 != 0;
        StackMapFrameCodeStream.ExceptionMarker exceptionMarker = null;
        if (bl4) {
            exceptionMarker = exceptionMarkerArray[0];
        }
        StackMapFrame stackMapFrame = new StackMapFrame(n);
        if (!bl) {
            this.initializeDefaultLocals(stackMapFrame, methodBinding, n, n3);
        }
        stackMapFrame.pc = -1;
        arrayList.add(stackMapFrame.duplicate());
        do {
            Object object;
            Object object2;
            int n14 = n4 - n2;
            if (bl3 && stackMarker.pc == n14) {
                object2 = stackMapFrame.stackItems;
                object = new VerificationTypeInfo[stackMapFrame.numberOfStackItems];
                System.arraycopy(object2, 0, object, 0, stackMapFrame.numberOfStackItems);
                stackMarker.setInfos((VerificationTypeInfo[])object);
            } else if (bl3 && stackMarker.destinationPC == n14) {
                VerificationTypeInfo[] verificationTypeInfoArray = stackMarker.infos;
                stackMapFrame.stackItems = verificationTypeInfoArray;
                stackMapFrame.numberOfStackItems = verificationTypeInfoArray.length;
                if (++n10 < n11) {
                    stackMarker = stackMarkerArray[n10];
                } else {
                    bl3 = false;
                }
            }
            if (bl2 && stackDepthMarker.pc == n14) {
                object2 = stackDepthMarker.typeBinding;
                if (object2 != null) {
                    if (stackDepthMarker.delta > 0) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo((TypeBinding)object2));
                    } else {
                        stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo((TypeBinding)object2);
                    }
                } else {
                    --stackMapFrame.numberOfStackItems;
                }
                if (++n8 < n9) {
                    stackDepthMarker = stackDepthMarkerArray[n8];
                } else {
                    bl2 = false;
                }
            }
            if (bl4 && exceptionMarker.pc == n14) {
                stackMapFrame.numberOfStackItems = 0;
                stackMapFrame.addStackItem(new VerificationTypeInfo(0, 7, exceptionMarker.constantPoolName));
                if (++n12 < n13) {
                    exceptionMarker = exceptionMarkerArray[n12];
                } else {
                    bl4 = false;
                }
            }
            if (n7 < n14) {
                do {
                    if (++n5 >= n6) {
                        return;
                    }
                    n7 = nArray[n5];
                } while (n7 < n14);
            }
            if (n7 == n14) {
                object2 = stackMapFrame.duplicate();
                object2.pc = n14;
                this.initializeLocals(bl ? true : methodBinding.isStatic(), n14, (StackMapFrame)object2);
                arrayList.add(object2);
                if (++n5 < n6) {
                    n7 = nArray[n5];
                } else {
                    return;
                }
            }
            byte by = (byte)this.u1At(byArray, 0, n4);
            switch (by) {
                case 0: {
                    ++n4;
                    break;
                }
                case 1: {
                    stackMapFrame.addStackItem(TypeBinding.NULL);
                    ++n4;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case 9: 
                case 10: {
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case 14: 
                case 15: {
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case 16: {
                    stackMapFrame.addStackItem(TypeBinding.BYTE);
                    n4 += 2;
                    break;
                }
                case 17: {
                    stackMapFrame.addStackItem(TypeBinding.SHORT);
                    n4 += 3;
                    break;
                }
                case 18: {
                    int n15 = this.u1At(byArray, 1, n4);
                    switch (this.u1At(byArray2, 0, nArray2[n15])) {
                        case 8: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(11, ConstantPool.JavaLangStringConstantPoolName));
                            break;
                        }
                        case 3: {
                            stackMapFrame.addStackItem(TypeBinding.INT);
                            break;
                        }
                        case 4: {
                            stackMapFrame.addStackItem(TypeBinding.FLOAT);
                            break;
                        }
                        case 7: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(16, ConstantPool.JavaLangClassConstantPoolName));
                        }
                    }
                    n4 += 2;
                    break;
                }
                case 19: {
                    int n15 = this.u2At(byArray, 1, n4);
                    switch (this.u1At(byArray2, 0, nArray2[n15])) {
                        case 8: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(11, ConstantPool.JavaLangStringConstantPoolName));
                            break;
                        }
                        case 3: {
                            stackMapFrame.addStackItem(TypeBinding.INT);
                            break;
                        }
                        case 4: {
                            stackMapFrame.addStackItem(TypeBinding.FLOAT);
                            break;
                        }
                        case 7: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(16, ConstantPool.JavaLangClassConstantPoolName));
                        }
                    }
                    n4 += 3;
                    break;
                }
                case 20: {
                    int n15 = this.u2At(byArray, 1, n4);
                    switch (this.u1At(byArray2, 0, nArray2[n15])) {
                        case 6: {
                            stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                            break;
                        }
                        case 5: {
                            stackMapFrame.addStackItem(TypeBinding.LONG);
                        }
                    }
                    n4 += 3;
                    break;
                }
                case 21: {
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    n4 += 2;
                    break;
                }
                case 22: {
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    n4 += 2;
                    break;
                }
                case 23: {
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    n4 += 2;
                    break;
                }
                case 24: {
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    n4 += 2;
                    break;
                }
                case 25: {
                    int n15 = this.u1At(byArray, 1, n4);
                    object = this.retrieveLocal(n14, n15);
                    stackMapFrame.addStackItem((VerificationTypeInfo)object);
                    n4 += 2;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case 42: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.locals[0];
                    if (verificationTypeInfo == null) {
                        verificationTypeInfo = this.retrieveLocal(n14, 0);
                    }
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 43: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n14, 1);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 44: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n14, 2);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 45: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n14, 3);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 46: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case 47: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case 48: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case 49: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case 50: {
                    --stackMapFrame.numberOfStackItems;
                    stackMapFrame.replaceWithElementType();
                    ++n4;
                    break;
                }
                case 51: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.BYTE);
                    ++n4;
                    break;
                }
                case 52: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.CHAR);
                    ++n4;
                    break;
                }
                case 53: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.SHORT);
                    ++n4;
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    --stackMapFrame.numberOfStackItems;
                    n4 += 2;
                    break;
                }
                case 58: {
                    int n15 = this.u1At(byArray, 1, n4);
                    --stackMapFrame.numberOfStackItems;
                    n4 += 2;
                    break;
                }
                case 75: {
                    stackMapFrame.locals[0] = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 77: 
                case 78: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    stackMapFrame.numberOfStackItems -= 3;
                    ++n4;
                    break;
                }
                case 87: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 88: {
                    int n16 = stackMapFrame.numberOfStackItems--;
                    switch (stackMapFrame.stackItems[n16 - 1].id()) {
                        case 7: 
                        case 8: {
                            break;
                        }
                        default: {
                            stackMapFrame.numberOfStackItems -= 2;
                        }
                    }
                    ++n4;
                    break;
                }
                case 89: {
                    stackMapFrame.addStackItem(stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1]);
                    ++n4;
                    break;
                }
                case 90: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    stackMapFrame.addStackItem(verificationTypeInfo2);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 91: {
                    int n16;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo2.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            n16 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo3 = stackMapFrame.stackItems[n16 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo3);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 92: {
                    VerificationTypeInfo verificationTypeInfo2;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 93: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            VerificationTypeInfo verificationTypeInfo4 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo4);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 94: {
                    int n16 = stackMapFrame.numberOfStackItems--;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[n16 - 1];
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    block122 : switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            switch (verificationTypeInfo2.id()) {
                                case 7: 
                                case 8: {
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    break block122;
                                }
                            }
                            n16 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo5 = stackMapFrame.stackItems[n16 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo5);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            n16 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo6 = stackMapFrame.stackItems[n16 - 1];
                            switch (verificationTypeInfo6.id()) {
                                case 7: 
                                case 8: {
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    stackMapFrame.addStackItem(verificationTypeInfo6);
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    break block122;
                                }
                            }
                            n16 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo7 = stackMapFrame.stackItems[n16 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo7);
                            stackMapFrame.addStackItem(verificationTypeInfo6);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 95: {
                    VerificationTypeInfo verificationTypeInfo2;
                    int n16 = stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[n16 - 1];
                    stackMapFrame.stackItems[n16 - 1] = verificationTypeInfo2 = stackMapFrame.stackItems[n16 - 2];
                    stackMapFrame.stackItems[n16 - 2] = verificationTypeInfo;
                    ++n4;
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    ++n4;
                    break;
                }
                case -124: {
                    n4 += 3;
                    break;
                }
                case -123: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case -122: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case -121: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case -120: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -119: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case -118: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case -117: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -116: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case -115: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case -114: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -113: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case -112: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case -111: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.BYTE);
                    ++n4;
                    break;
                }
                case -110: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.CHAR);
                    ++n4;
                    break;
                }
                case -109: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.SHORT);
                    ++n4;
                    break;
                }
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: {
                    --stackMapFrame.numberOfStackItems;
                    n4 += 3;
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: {
                    stackMapFrame.numberOfStackItems -= 2;
                    n4 += 3;
                    break;
                }
                case -89: {
                    n4 += 3;
                    break;
                }
                case -86: {
                    ++n4;
                    while ((n4 - n2 & 3) != 0) {
                        ++n4;
                    }
                    int n17 = this.i4At(byArray, 0, n4 += 4);
                    int n18 = this.i4At(byArray, 0, n4 += 4);
                    n4 += 4;
                    int n19 = n18 - n17 + 1;
                    n4 += n19 * 4;
                    --stackMapFrame.numberOfStackItems;
                    break;
                }
                case -85: {
                    ++n4;
                    while ((n4 - n2 & 3) != 0) {
                        ++n4;
                    }
                    int n20 = (int)this.u4At(byArray, 0, n4 += 4);
                    n4 += 4 + n20 * 8;
                    --stackMapFrame.numberOfStackItems;
                    break;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case -79: {
                    ++n4;
                    break;
                }
                case -78: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n21 = this.u2At(byArray2, 3, nArray2[n15]);
                    int n22 = this.u2At(byArray2, 3, nArray2[n21]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    if (cArray.length == 1) {
                        switch (cArray[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray, 1, cArray.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -77: {
                    --stackMapFrame.numberOfStackItems;
                    n4 += 3;
                    break;
                }
                case -76: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n21 = this.u2At(byArray2, 3, nArray2[n15]);
                    int n22 = this.u2At(byArray2, 3, nArray2[n21]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    --stackMapFrame.numberOfStackItems;
                    if (cArray.length == 1) {
                        switch (cArray[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray, 1, cArray.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -75: {
                    stackMapFrame.numberOfStackItems -= 2;
                    n4 += 3;
                    break;
                }
                case -74: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n21 = this.u2At(byArray2, 3, nArray2[n15]);
                    int n22 = this.u2At(byArray2, 3, nArray2[n21]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    n22 = this.u2At(byArray2, 1, nArray2[n21]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray) + 1;
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -73: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n21 = this.u2At(byArray2, 3, nArray2[n15]);
                    int n22 = this.u2At(byArray2, 3, nArray2[n21]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    n22 = this.u2At(byArray2, 1, nArray2[n21]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    if (CharOperation.equals(ConstantPool.Init, cArray2)) {
                        stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1].tag = 7;
                    }
                    --stackMapFrame.numberOfStackItems;
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -72: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n21 = this.u2At(byArray2, 3, nArray2[n15]);
                    int n22 = this.u2At(byArray2, 3, nArray2[n21]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    n22 = this.u2At(byArray2, 1, nArray2[n21]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -71: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n21 = this.u2At(byArray2, 3, nArray2[n15]);
                    int n22 = this.u2At(byArray2, 3, nArray2[n21]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    n22 = this.u2At(byArray2, 1, nArray2[n21]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray) + 1;
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 5;
                    break;
                }
                case -69: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 1, nArray2[n15]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    VerificationTypeInfo verificationTypeInfo = new VerificationTypeInfo(0, 8, cArray4);
                    verificationTypeInfo.offset = n14;
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    n4 += 3;
                    break;
                }
                case -68: {
                    char[] cArray = null;
                    switch (this.u1At(byArray, 1, n4)) {
                        case 10: {
                            cArray = new char[]{'[', 'I'};
                            break;
                        }
                        case 8: {
                            cArray = new char[]{'[', 'B'};
                            break;
                        }
                        case 4: {
                            cArray = new char[]{'[', 'Z'};
                            break;
                        }
                        case 9: {
                            cArray = new char[]{'[', 'S'};
                            break;
                        }
                        case 5: {
                            cArray = new char[]{'[', 'C'};
                            break;
                        }
                        case 11: {
                            cArray = new char[]{'[', 'J'};
                            break;
                        }
                        case 6: {
                            cArray = new char[]{'[', 'F'};
                            break;
                        }
                        case 7: {
                            cArray = new char[]{'[', 'D'};
                        }
                    }
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(1, cArray);
                    n4 += 2;
                    break;
                }
                case -67: {
                    char[] cArray;
                    int n15 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 1, nArray2[n15]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    int n23 = cArray4.length;
                    if (cArray4[0] != '[') {
                        cArray = new char[n23 + 3];
                        System.arraycopy(cArray4, 0, cArray, 2, n23);
                        cArray[0] = 91;
                        cArray[1] = 76;
                        cArray[n23 + 2] = 59;
                    } else {
                        cArray = new char[n23 + 1];
                        System.arraycopy(cArray4, 0, cArray, 1, n23);
                        cArray[0] = 91;
                    }
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(0, cArray);
                    n4 += 3;
                    break;
                }
                case -66: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -65: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case -64: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 1, nArray2[n15]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(0, cArray4);
                    n4 += 3;
                    break;
                }
                case -63: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    n4 += 3;
                    break;
                }
                case -62: 
                case -61: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case -60: {
                    by = (byte)this.u1At(byArray, 1, n4);
                    if (by == -124) {
                        n4 += 6;
                        break;
                    }
                    int n15 = this.u2At(byArray, 2, n4);
                    switch (by) {
                        case 21: {
                            stackMapFrame.addStackItem(TypeBinding.INT);
                            break;
                        }
                        case 23: {
                            stackMapFrame.addStackItem(TypeBinding.FLOAT);
                            break;
                        }
                        case 25: {
                            object = stackMapFrame.locals[n15];
                            if (object == null) {
                                object = this.retrieveLocal(n14, n15);
                            }
                            stackMapFrame.addStackItem((VerificationTypeInfo)object);
                            break;
                        }
                        case 22: {
                            stackMapFrame.addStackItem(TypeBinding.LONG);
                            break;
                        }
                        case 24: {
                            stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                            break;
                        }
                        case 54: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 56: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 58: {
                            stackMapFrame.locals[n15] = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 55: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 57: {
                            --stackMapFrame.numberOfStackItems;
                        }
                    }
                    n4 += 4;
                    break;
                }
                case -59: {
                    int n15 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 1, nArray2[n15]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n22] + 3, this.u2At(byArray2, 1, nArray2[n22]));
                    int n24 = this.u1At(byArray, 3, n4);
                    stackMapFrame.numberOfStackItems -= n24;
                    int n23 = cArray4.length;
                    char[] cArray = new char[n23 + n24];
                    int n25 = 0;
                    while (n25 < n24) {
                        cArray[n25] = 91;
                        ++n25;
                    }
                    System.arraycopy(cArray4, 0, cArray, n24, n23);
                    stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray));
                    n4 += 4;
                    break;
                }
                case -58: 
                case -57: {
                    --stackMapFrame.numberOfStackItems;
                    n4 += 3;
                    break;
                }
                case -56: {
                    n4 += 5;
                    break;
                }
                default: {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidOpcode, new Object[]{new Byte(by), new Integer(n4), new String(methodBinding.shortReadableName())}), this.codeStream.methodDeclaration);
                }
            }
        } while (n4 < n3 + n2);
    }

    private final int u1At(byte[] byArray, int n, int n2) {
        return byArray[n + n2] & 0xFF;
    }

    private final int u2At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return ((byArray[n3++] & 0xFF) << 8) + (byArray[n3] & 0xFF);
    }

    private final long u4At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return (((long)byArray[n3++] & 0xFFL) << 24) + (long)((byArray[n3++] & 0xFF) << 16) + (long)((byArray[n3++] & 0xFF) << 8) + (long)(byArray[n3] & 0xFF);
    }

    public char[] utf8At(byte[] byArray, int n, int n2) {
        int n3 = n2;
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = n;
        while (n3 != 0) {
            int n6 = byArray[n5++] & 0xFF;
            --n3;
            if ((0x80 & n6) != 0) {
                if ((n6 & 0x20) != 0) {
                    n3 -= 2;
                    n6 = (n6 & 0xF) << 12 | (byArray[n5++] & 0x3F) << 6 | byArray[n5++] & 0x3F;
                } else {
                    --n3;
                    n6 = (n6 & 0x1F) << 6 | byArray[n5++] & 0x3F;
                }
            }
            cArray[n4++] = (char)n6;
        }
        if (n4 != n2) {
            char[] cArray2 = cArray;
            cArray = new char[n4];
            System.arraycopy(cArray2, 0, cArray, 0, n4);
        }
        return cArray;
    }
}

