/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.jdt.internal.compiler.util.Util;

public class CompilationResult {
    public CategorizedProblem[] problems;
    public CategorizedProblem[] tasks;
    public int problemCount;
    public int taskCount;
    public ICompilationUnit compilationUnit;
    public Map problemsMap;
    public Set firstErrors;
    private int maxProblemPerUnit;
    public char[][][] qualifiedReferences;
    public char[][] simpleNameReferences;
    public char[][] rootReferences;
    public boolean hasAnnotations = false;
    public int[] lineSeparatorPositions;
    public RecoveryScannerData recoveryScannerData;
    public Map compiledTypes = new Hashtable(11);
    public int unitIndex;
    public int totalUnitsKnown;
    public boolean hasBeenAccepted = false;
    public char[] fileName;
    public boolean hasInconsistentToplevelHierarchies = false;
    public boolean hasSyntaxError = false;
    public char[][] packageName;
    public boolean checkSecondaryTypes = false;
    private static final int[] EMPTY_LINE_ENDS = Util.EMPTY_INT_ARRAY;
    private static final Comparator PROBLEM_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((CategorizedProblem)object).getSourceStart() - ((CategorizedProblem)object2).getSourceStart();
        }
    };

    public CompilationResult(char[] cArray, int n, int n2, int n3) {
        this.fileName = cArray;
        this.unitIndex = n;
        this.totalUnitsKnown = n2;
        this.maxProblemPerUnit = n3;
    }

    public CompilationResult(ICompilationUnit iCompilationUnit, int n, int n2, int n3) {
        this.fileName = iCompilationUnit.getFileName();
        this.compilationUnit = iCompilationUnit;
        this.unitIndex = n;
        this.totalUnitsKnown = n2;
        this.maxProblemPerUnit = n3;
    }

    private int computePriority(CategorizedProblem categorizedProblem) {
        ReferenceContext referenceContext;
        int n = 10000 - categorizedProblem.getSourceLineNumber();
        if (n < 0) {
            n = 0;
        }
        if (categorizedProblem.isError()) {
            n += 100000;
        }
        ReferenceContext referenceContext2 = referenceContext = this.problemsMap == null ? null : (ReferenceContext)this.problemsMap.get(categorizedProblem);
        if (referenceContext != null) {
            if (referenceContext instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
                if (abstractMethodDeclaration.isStatic()) {
                    n += 10000;
                }
            } else {
                n += 40000;
            }
            if (this.firstErrors.contains(categorizedProblem)) {
                n += 20000;
            }
        } else {
            n += 40000;
        }
        return n;
    }

    public CategorizedProblem[] getAllProblems() {
        int n;
        CategorizedProblem[] categorizedProblemArray = this.getProblems();
        int n2 = categorizedProblemArray != null ? categorizedProblemArray.length : 0;
        CategorizedProblem[] categorizedProblemArray2 = this.getTasks();
        int n3 = n = categorizedProblemArray2 != null ? categorizedProblemArray2.length : 0;
        if (n == 0) {
            return categorizedProblemArray;
        }
        if (n2 == 0) {
            return categorizedProblemArray2;
        }
        int n4 = n2 + n;
        CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n6 + n7 < n4) {
            CategorizedProblem categorizedProblem = null;
            CategorizedProblem categorizedProblem2 = null;
            if (n6 < n) {
                categorizedProblem = categorizedProblemArray2[n6];
            }
            if (n7 < n2) {
                categorizedProblem2 = categorizedProblemArray[n7];
            }
            CategorizedProblem categorizedProblem3 = null;
            if (categorizedProblem2 != null) {
                if (categorizedProblem != null) {
                    if (categorizedProblem2.getSourceStart() < categorizedProblem.getSourceStart()) {
                        categorizedProblem3 = categorizedProblem2;
                        ++n7;
                    } else {
                        categorizedProblem3 = categorizedProblem;
                        ++n6;
                    }
                } else {
                    categorizedProblem3 = categorizedProblem2;
                    ++n7;
                }
            } else if (categorizedProblem != null) {
                categorizedProblem3 = categorizedProblem;
                ++n6;
            }
            categorizedProblemArray3[n5++] = categorizedProblem3;
        }
        return categorizedProblemArray3;
    }

    public ClassFile[] getClassFiles() {
        ClassFile[] classFileArray = new ClassFile[this.compiledTypes.size()];
        this.compiledTypes.values().toArray(classFileArray);
        return classFileArray;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public CategorizedProblem[] getErrors() {
        CategorizedProblem[] categorizedProblemArray = this.getProblems();
        int n = 0;
        int n2 = 0;
        while (n2 < this.problemCount) {
            if (categorizedProblemArray[n2].isError()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.problemCount) {
            return categorizedProblemArray;
        }
        CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.problemCount) {
            if (categorizedProblemArray[n4].isError()) {
                categorizedProblemArray2[n3++] = categorizedProblemArray[n4];
            }
            ++n4;
        }
        return categorizedProblemArray2;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public int[] getLineSeparatorPositions() {
        return this.lineSeparatorPositions == null ? EMPTY_LINE_ENDS : this.lineSeparatorPositions;
    }

    public CategorizedProblem[] getProblems() {
        if (this.problems != null) {
            if (this.problemCount != this.problems.length) {
                this.problems = new CategorizedProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            if (this.maxProblemPerUnit > 0 && this.problemCount > this.maxProblemPerUnit) {
                this.quickPrioritize(this.problems, 0, this.problemCount - 1);
                this.problemCount = this.maxProblemPerUnit;
                this.problems = new CategorizedProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            Arrays.sort(this.problems, 0, this.problems.length, PROBLEM_COMPARATOR);
        }
        return this.problems;
    }

    public CategorizedProblem[] getTasks() {
        if (this.tasks != null) {
            if (this.taskCount != this.tasks.length) {
                this.tasks = new CategorizedProblem[this.taskCount];
                System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
            }
            Arrays.sort(this.tasks, 0, this.tasks.length, PROBLEM_COMPARATOR);
        }
        return this.tasks;
    }

    public boolean hasErrors() {
        if (this.problems != null) {
            int n = 0;
            while (n < this.problemCount) {
                if (this.problems[n].isError()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean hasProblems() {
        return this.problemCount != 0;
    }

    public boolean hasTasks() {
        return this.taskCount != 0;
    }

    public boolean hasWarnings() {
        if (this.problems != null) {
            int n = 0;
            while (n < this.problemCount) {
                if (this.problems[n].isWarning()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void quickPrioritize(CategorizedProblem[] categorizedProblemArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = this.computePriority(categorizedProblemArray[n + (n2 - n) / 2]);
        while (true) {
            if (this.computePriority(categorizedProblemArray[n2]) < n5) {
                --n2;
                continue;
            }
            while (n5 < this.computePriority(categorizedProblemArray[n])) {
                ++n;
            }
            if (n <= n2) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n];
                categorizedProblemArray[n] = categorizedProblemArray[n2];
                categorizedProblemArray[n2] = categorizedProblem;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            this.quickPrioritize(categorizedProblemArray, n3, n2);
        }
        if (n < n4) {
            this.quickPrioritize(categorizedProblemArray, n, n4);
        }
    }

    public void recordPackageName(char[][] cArray) {
        this.packageName = cArray;
    }

    public void record(CategorizedProblem categorizedProblem, ReferenceContext referenceContext) {
        if (categorizedProblem.getID() == 536871362) {
            this.recordTask(categorizedProblem);
            return;
        }
        if (this.problemCount == 0) {
            this.problems = new CategorizedProblem[5];
        } else if (this.problemCount == this.problems.length) {
            this.problems = new CategorizedProblem[this.problemCount * 2];
            System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
        }
        this.problems[this.problemCount++] = categorizedProblem;
        if (referenceContext != null) {
            if (this.problemsMap == null) {
                this.problemsMap = new HashMap(5);
            }
            if (this.firstErrors == null) {
                this.firstErrors = new HashSet(5);
            }
            if (categorizedProblem.isError() && !referenceContext.hasErrors()) {
                this.firstErrors.add(categorizedProblem);
            }
            this.problemsMap.put(categorizedProblem, referenceContext);
        }
        if ((categorizedProblem.getID() & 0x40000000) != 0 && categorizedProblem.isError()) {
            this.hasSyntaxError = true;
        }
    }

    public void record(char[] cArray, ClassFile classFile) {
        SourceTypeBinding sourceTypeBinding = classFile.referenceBinding;
        if (!sourceTypeBinding.isLocalType() && sourceTypeBinding.isHierarchyInconsistent()) {
            this.hasInconsistentToplevelHierarchies = true;
        }
        this.compiledTypes.put(cArray, classFile);
    }

    private void recordTask(CategorizedProblem categorizedProblem) {
        if (this.taskCount == 0) {
            this.tasks = new CategorizedProblem[5];
        } else if (this.taskCount == this.tasks.length) {
            this.tasks = new CategorizedProblem[this.taskCount * 2];
            System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
        }
        this.tasks[this.taskCount++] = categorizedProblem;
    }

    public CompilationResult tagAsAccepted() {
        this.hasBeenAccepted = true;
        this.problemsMap = null;
        this.firstErrors = null;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileName != null) {
            stringBuffer.append("Filename : ").append(this.fileName).append('\n');
        }
        if (this.compiledTypes != null) {
            stringBuffer.append("COMPILED type(s)\t\n");
            Iterator iterator = this.compiledTypes.keySet().iterator();
            while (iterator.hasNext()) {
                char[] cArray = (char[])iterator.next();
                stringBuffer.append("\t - ").append(cArray).append('\n');
            }
        } else {
            stringBuffer.append("No COMPILED type\n");
        }
        if (this.problems != null) {
            stringBuffer.append(this.problemCount).append(" PROBLEM(s) detected \n");
            int n = 0;
            while (n < this.problemCount) {
                stringBuffer.append("\t - ").append(this.problems[n]).append('\n');
                ++n;
            }
        } else {
            stringBuffer.append("No PROBLEM\n");
        }
        return stringBuffer.toString();
    }
}

