/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IDebugRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ProcessTaskManager;
import org.eclipse.jdt.internal.compiler.ReadManager;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerStats;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public Parser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    protected PrintWriter out;
    public CompilerStats stats;
    public CompilationProgress progress;
    public int remainingIterations = 1;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;
    public AbstractAnnotationProcessorManager annotationProcessorManager;
    public int annotationProcessorStartIndex = 0;
    public ReferenceBinding[] referenceBindings;
    public boolean useSingleThread = true;
    public static IDebugRequestor DebugRequestor = null;

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this(iNameEnvironment, iErrorHandlingPolicy, new CompilerOptions(map), iCompilerRequestor, iProblemFactory, null, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, boolean bl) {
        this(iNameEnvironment, iErrorHandlingPolicy, new CompilerOptions(map, bl), iCompilerRequestor, iProblemFactory, null, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this(iNameEnvironment, iErrorHandlingPolicy, compilerOptions, iCompilerRequestor, iProblemFactory, null, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, PrintWriter printWriter) {
        this(iNameEnvironment, iErrorHandlingPolicy, compilerOptions, iCompilerRequestor, iProblemFactory, printWriter, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, final ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, PrintWriter printWriter, CompilationProgress compilationProgress) {
        this.options = compilerOptions;
        this.progress = compilationProgress;
        this.requestor = DebugRequestor == null ? iCompilerRequestor : new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(compilationResult);
                }
                iCompilerRequestor.acceptResult(compilationResult);
            }
        };
        this.problemReporter = new ProblemReporter(iErrorHandlingPolicy, this.options, iProblemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, iNameEnvironment);
        this.out = printWriter == null ? new PrintWriter(System.out, true) : printWriter;
        this.stats = new CompilerStats();
        this.initializeParser();
    }

    public void accept(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        if (this.options.verbose) {
            this.out.println(Messages.bind(Messages.compilation_loadBinary, new String(iBinaryType.getName())));
        }
        this.lookupEnvironment.createBinaryTypeFrom(iBinaryType, packageBinding, accessRestriction);
    }

    public void accept(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        compilationResult.checkSecondaryTypes = true;
        try {
            Object object;
            if (this.options.verbose) {
                object = String.valueOf(this.totalUnits + 1);
                this.out.println(Messages.bind(Messages.compilation_request, new String[]{object, object, new String(iCompilationUnit.getFileName())}));
            }
            object = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnit, compilationResult) : this.parser.dietParse(iCompilationUnit, compilationResult);
            ((CompilationUnitDeclaration)object).bits |= 1;
            this.lookupEnvironment.buildTypeBindings((CompilationUnitDeclaration)object, accessRestriction);
            this.addCompilationUnit(iCompilationUnit, (CompilationUnitDeclaration)object);
            this.lookupEnvironment.completeTypeBindings((CompilationUnitDeclaration)object);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            if (compilationResult.compilationUnit == iCompilationUnit) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
            throw abortCompilationUnit;
        }
    }

    public void accept(ISourceType[] iSourceTypeArray, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.problemReporter.abortDueToInternalError(Messages.bind(Messages.abort_againstSourceModel, new String[]{String.valueOf(iSourceTypeArray[0].getName()), String.valueOf(iSourceTypeArray[0].getFileName())}));
    }

    protected synchronized void addCompilationUnit(ICompilationUnit iCompilationUnit, CompilationUnitDeclaration compilationUnitDeclaration) {
        int n = this.unitsToProcess.length;
        if (this.totalUnits == n) {
            this.unitsToProcess = new CompilationUnitDeclaration[n * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = compilationUnitDeclaration;
    }

    protected void beginToCompile(ICompilationUnit[] iCompilationUnitArray) {
        int n = iCompilationUnitArray.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[n];
        this.internalBeginToCompile(iCompilationUnitArray, n);
    }

    protected void reportProgress(String string) {
        if (this.progress != null) {
            if (this.progress.isCanceled()) {
                throw new AbortCompilation(true, null);
            }
            this.progress.setTaskName(string);
        }
    }

    protected void reportWorked(int n, int n2) {
        if (this.progress != null) {
            if (this.progress.isCanceled()) {
                throw new AbortCompilation(true, null);
            }
            this.progress.worked(n, this.totalUnits * this.remainingIterations - n2 - 1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(ICompilationUnit[] iCompilationUnitArray) {
        ProcessTaskManager processTaskManager;
        block30: {
            this.stats.startTime = System.currentTimeMillis();
            CompilationUnitDeclaration compilationUnitDeclaration = null;
            processTaskManager = null;
            try {
                block28: {
                    block29: {
                        try {
                            block27: {
                                this.reportProgress(Messages.compilation_beginningToCompile);
                                if (this.annotationProcessorManager == null) {
                                    this.beginToCompile(iCompilationUnitArray);
                                } else {
                                    ICompilationUnit[] iCompilationUnitArray2 = (ICompilationUnit[])iCompilationUnitArray.clone();
                                    try {
                                        this.beginToCompile(iCompilationUnitArray);
                                        this.processAnnotations();
                                        if (!this.options.generateClassFiles) {
                                        }
                                        break block27;
                                    }
                                    catch (SourceTypeCollisionException sourceTypeCollisionException) {
                                        this.reset();
                                        int n = iCompilationUnitArray2.length;
                                        int n2 = sourceTypeCollisionException.newAnnotationProcessorUnits.length;
                                        ICompilationUnit[] iCompilationUnitArray3 = new ICompilationUnit[n + n2];
                                        System.arraycopy(iCompilationUnitArray2, 0, iCompilationUnitArray3, 0, n);
                                        System.arraycopy(sourceTypeCollisionException.newAnnotationProcessorUnits, 0, iCompilationUnitArray3, n, n2);
                                        this.annotationProcessorStartIndex = n;
                                        this.compile(iCompilationUnitArray3);
                                    }
                                    Object var9_10 = null;
                                    if (processTaskManager == null) break block28;
                                    break block29;
                                }
                            }
                            if (this.useSingleThread) {
                                int n = 0;
                                while (n < this.totalUnits) {
                                    compilationUnitDeclaration = this.unitsToProcess[n];
                                    this.reportProgress(Messages.bind(Messages.compilation_processing, new String(compilationUnitDeclaration.getFileName())));
                                    try {
                                        if (this.options.verbose) {
                                            this.out.println(Messages.bind(Messages.compilation_process, new String[]{String.valueOf(n + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[n].getFileName())}));
                                        }
                                        this.process(compilationUnitDeclaration, n);
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_15 = null;
                                        compilationUnitDeclaration.cleanUp();
                                        throw throwable;
                                    }
                                    {
                                        Object var5_16 = null;
                                        compilationUnitDeclaration.cleanUp();
                                        this.unitsToProcess[n] = null;
                                        this.reportWorked(1, n);
                                    }
                                    this.stats.lineCount += (long)compilationUnitDeclaration.compilationResult.lineSeparatorPositions.length;
                                    long l = System.currentTimeMillis();
                                    this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
                                    this.stats.generateTime += System.currentTimeMillis() - l;
                                    if (this.options.verbose) {
                                        this.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(n + 1), String.valueOf(this.totalUnits), new String(compilationUnitDeclaration.getFileName())}));
                                    }
                                    ++n;
                                }
                                break block30;
                            }
                            processTaskManager = new ProcessTaskManager(this);
                            int n = 0;
                            while (true) {
                                try {
                                    compilationUnitDeclaration = processTaskManager.removeNextUnit();
                                }
                                catch (Error error) {
                                    compilationUnitDeclaration = processTaskManager.unitToProcess;
                                    throw error;
                                }
                                catch (RuntimeException runtimeException) {
                                    compilationUnitDeclaration = processTaskManager.unitToProcess;
                                    throw runtimeException;
                                }
                                if (compilationUnitDeclaration != null) {
                                    this.reportWorked(1, n++);
                                    this.stats.lineCount += (long)compilationUnitDeclaration.compilationResult.lineSeparatorPositions.length;
                                    this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
                                    if (!this.options.verbose) continue;
                                    this.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(n), String.valueOf(this.totalUnits), new String(compilationUnitDeclaration.getFileName())}));
                                    continue;
                                }
                                break block30;
                                break;
                            }
                        }
                        catch (AbortCompilation abortCompilation) {
                            this.handleInternalException(abortCompilation, compilationUnitDeclaration);
                            break block30;
                        }
                        catch (Error error) {
                            this.handleInternalException(error, compilationUnitDeclaration, null);
                            throw error;
                        }
                        catch (RuntimeException runtimeException) {
                            this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
                            throw runtimeException;
                        }
                    }
                    processTaskManager.shutdown();
                    processTaskManager = null;
                }
                this.reset();
                this.annotationProcessorStartIndex = 0;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (processTaskManager != null) {
                    processTaskManager.shutdown();
                    processTaskManager = null;
                }
                this.reset();
                this.annotationProcessorStartIndex = 0;
                this.stats.endTime = System.currentTimeMillis();
                throw throwable;
            }
            this.stats.endTime = System.currentTimeMillis();
            return;
        }
        Object var9_12 = null;
        if (processTaskManager != null) {
            processTaskManager.shutdown();
            processTaskManager = null;
        }
        this.reset();
        this.annotationProcessorStartIndex = 0;
        this.stats.endTime = System.currentTimeMillis();
        if (!this.options.verbose) return;
        if (this.totalUnits > 1) {
            this.out.println(Messages.bind(Messages.compilation_units, String.valueOf(this.totalUnits)));
            return;
        }
        this.out.println(Messages.bind(Messages.compilation_unit, String.valueOf(this.totalUnits)));
    }

    public synchronized CompilationUnitDeclaration getUnitToProcess(int n) {
        if (n < this.totalUnits) {
            CompilationUnitDeclaration compilationUnitDeclaration = this.unitsToProcess[n];
            this.unitsToProcess[n] = null;
            return compilationUnitDeclaration;
        }
        return null;
    }

    public void setBinaryTypes(ReferenceBinding[] referenceBindingArray) {
        this.referenceBindings = referenceBindingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalException(Throwable throwable, CompilationUnitDeclaration compilationUnitDeclaration, CompilationResult compilationResult) {
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null) {
            Compiler compiler = this;
            synchronized (compiler) {
                if (this.unitsToProcess != null && this.totalUnits > 0) {
                    compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
                }
            }
        }
        boolean bl = true;
        if (compilationResult != null) {
            String[] stringArray = new String[]{Messages.bind(Messages.compilation_internalError, Util.getExceptionSummary(throwable))};
            compilationResult.record(this.problemReporter.createProblem(compilationResult.getFileName(), 0, stringArray, stringArray, 1, 0, 0, 0, 0), compilationUnitDeclaration);
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
                bl = false;
            }
        }
        if (bl) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalException(AbortCompilation abortCompilation, CompilationUnitDeclaration compilationUnitDeclaration) {
        Object object;
        if (abortCompilation.isSilent) {
            if (abortCompilation.silentException == null) {
                return;
            }
            throw abortCompilation.silentException;
        }
        CompilationResult compilationResult = abortCompilation.compilationResult;
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null) {
            object = this;
            synchronized (object) {
                if (this.unitsToProcess != null && this.totalUnits > 0) {
                    compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
                }
            }
        }
        if (compilationResult != null && !compilationResult.hasBeenAccepted) {
            block18: {
                if (abortCompilation.problem != null) {
                    object = abortCompilation.problem;
                    CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                    int n = 0;
                    while (n < compilationResult.problemCount) {
                        if (categorizedProblemArray[n] != object) {
                            ++n;
                            continue;
                        }
                        break block18;
                    }
                    if (object instanceof DefaultProblem) {
                        ((DefaultProblem)object).setOriginatingFileName(compilationResult.getFileName());
                    }
                    compilationResult.record((CategorizedProblem)object, compilationUnitDeclaration);
                } else if (abortCompilation.exception != null) {
                    this.handleInternalException(abortCompilation.exception, null, compilationResult);
                    return;
                }
            }
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
        } else {
            abortCompilation.printStackTrace();
        }
    }

    public void initializeParser() {
        this.parser = new Parser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalBeginToCompile(ICompilationUnit[] iCompilationUnitArray, int n) {
        if (!this.useSingleThread && n >= 10) {
            this.parser.readManager = new ReadManager(iCompilationUnitArray, n);
        }
        int n2 = 0;
        while (true) {
            Object var11_9;
            if (n2 >= n) {
                if (this.parser.readManager != null) {
                    this.parser.readManager.shutdown();
                    this.parser.readManager = null;
                }
                this.lookupEnvironment.completeTypeBindings();
                return;
            }
            try {
                if (this.options.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_request, new String[]{String.valueOf(n2 + 1), String.valueOf(n), new String(iCompilationUnitArray[n2].getFileName())}));
                }
                CompilationResult compilationResult = new CompilationResult(iCompilationUnitArray[n2], n2, n, this.options.maxProblemsPerUnit);
                long l = System.currentTimeMillis();
                CompilationUnitDeclaration compilationUnitDeclaration = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnitArray[n2], compilationResult) : this.parser.dietParse(iCompilationUnitArray[n2], compilationResult);
                long l2 = System.currentTimeMillis();
                this.stats.parseTime += l2 - l;
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                this.stats.resolveTime += System.currentTimeMillis() - l2;
                this.addCompilationUnit(iCompilationUnitArray[n2], compilationUnitDeclaration);
                ImportReference importReference = compilationUnitDeclaration.currentPackage;
                if (importReference != null) {
                    compilationResult.recordPackageName(importReference.tokens);
                }
            }
            catch (Throwable throwable) {
                var11_9 = null;
                iCompilationUnitArray[n2] = null;
                throw throwable;
            }
            {
                var11_9 = null;
                iCompilationUnitArray[n2] = null;
                ++n2;
                continue;
            }
            break;
        }
    }

    public void process(CompilationUnitDeclaration compilationUnitDeclaration, int n) {
        this.lookupEnvironment.unitBeingCompleted = compilationUnitDeclaration;
        long l = System.currentTimeMillis();
        this.parser.getMethodBodies(compilationUnitDeclaration);
        long l2 = System.currentTimeMillis();
        this.stats.parseTime += l2 - l;
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.faultInTypes();
        }
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
        }
        compilationUnitDeclaration.resolve();
        long l3 = System.currentTimeMillis();
        this.stats.resolveTime += l3 - l2;
        compilationUnitDeclaration.analyseCode();
        long l4 = System.currentTimeMillis();
        this.stats.analyzeTime += l4 - l3;
        compilationUnitDeclaration.generateCode();
        if (this.options.produceReferenceInfo && compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.storeDependencyInfo();
        }
        compilationUnitDeclaration.finalizeProblems();
        this.stats.generateTime += System.currentTimeMillis() - l4;
        compilationUnitDeclaration.compilationResult.totalUnitsKnown = this.totalUnits;
        this.lookupEnvironment.unitBeingCompleted = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processAnnotations() {
        int n = 0;
        int n2 = 0;
        int n3 = this.annotationProcessorStartIndex;
        int n4 = this.totalUnits;
        ReferenceBinding[] referenceBindingArray = this.referenceBindings;
        if (n4 == 0 && referenceBindingArray == null) {
            return;
        }
        this.referenceBindings = null;
        do {
            ReferenceBinding[] referenceBindingArray2;
            int n5 = n4 - n3;
            CompilationUnitDeclaration[] compilationUnitDeclarationArray = new CompilationUnitDeclaration[n5];
            int n6 = 0;
            int n7 = n3;
            while (n7 < n4) {
                referenceBindingArray2 = this.unitsToProcess[n7];
                if ((referenceBindingArray2.bits & 1) == 0) {
                    compilationUnitDeclarationArray[n6++] = referenceBindingArray2;
                }
                ++n7;
            }
            if (n6 != n5) {
                CompilationUnitDeclaration[] compilationUnitDeclarationArray2 = compilationUnitDeclarationArray;
                compilationUnitDeclarationArray = new CompilationUnitDeclaration[n6];
                System.arraycopy(compilationUnitDeclarationArray2, 0, compilationUnitDeclarationArray, 0, n6);
            }
            this.annotationProcessorManager.processAnnotations(compilationUnitDeclarationArray, referenceBindingArray, false);
            ICompilationUnit[] iCompilationUnitArray = this.annotationProcessorManager.getNewUnits();
            n = iCompilationUnitArray.length;
            referenceBindingArray2 = this.annotationProcessorManager.getNewClassFiles();
            referenceBindingArray = referenceBindingArray2;
            n2 = referenceBindingArray2.length;
            if (n != 0) {
                Object var13_13;
                ICompilationUnit[] iCompilationUnitArray2 = (ICompilationUnit[])iCompilationUnitArray.clone();
                try {
                    try {
                        this.lookupEnvironment.isProcessingAnnotations = true;
                        this.internalBeginToCompile(iCompilationUnitArray, n);
                    }
                    catch (SourceTypeCollisionException sourceTypeCollisionException) {
                        sourceTypeCollisionException.newAnnotationProcessorUnits = iCompilationUnitArray2;
                        throw sourceTypeCollisionException;
                    }
                    var13_13 = null;
                    this.lookupEnvironment.isProcessingAnnotations = false;
                    this.annotationProcessorManager.reset();
                    n3 = n4;
                    n4 = this.totalUnits;
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    this.lookupEnvironment.isProcessingAnnotations = false;
                    this.annotationProcessorManager.reset();
                    throw throwable;
                }
            }
            n3 = n4;
            this.annotationProcessorManager.reset();
        } while (n != 0 || n2 != 0);
        this.annotationProcessorManager.processAnnotations(null, null, true);
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
        if (DebugRequestor != null) {
            DebugRequestor.reset();
        }
        this.problemReporter.reset();
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration compilationUnitDeclaration, ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) {
        try {
            if (compilationUnitDeclaration == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{iCompilationUnit});
                compilationUnitDeclaration = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.lookupEnvironment.unitBeingCompleted = compilationUnitDeclaration;
            this.parser.getMethodBodies(compilationUnitDeclaration);
            if (compilationUnitDeclaration.scope != null) {
                compilationUnitDeclaration.scope.faultInTypes();
                if (compilationUnitDeclaration.scope != null && bl) {
                    compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                compilationUnitDeclaration.resolve();
                if (bl2) {
                    compilationUnitDeclaration.analyseCode();
                }
                if (bl3) {
                    compilationUnitDeclaration.generateCode();
                }
                compilationUnitDeclaration.finalizeProblems();
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
            return compilationUnitDeclaration;
        }
        catch (AbortCompilation abortCompilation) {
            this.handleInternalException(abortCompilation, compilationUnitDeclaration);
            return compilationUnitDeclaration == null ? this.unitsToProcess[0] : compilationUnitDeclaration;
        }
        catch (Error error) {
            this.handleInternalException(error, compilationUnitDeclaration, null);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
            throw runtimeException;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) {
        return this.resolve(null, iCompilationUnit, bl, bl2, bl3);
    }
}

