/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)this.binding.declaringClass.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                flowInfo = this.arguments[n].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n;
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.original().thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if ((referenceBinding.tagBits & 0x834L) == 2068L && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            int n = 0;
            int n2 = syntheticArgumentBindingArray.length;
            while (n < n2) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding != null && localVariableBinding.declaration != null && !flowInfo.isDefinitelyAssigned(localVariableBinding)) {
                    blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this);
                }
                ++n;
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2;
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding.original();
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        codeStream.new_(referenceBinding);
        boolean bl3 = bl2 = (this.implicitConversion & 0x400) != 0;
        if (bl || bl2) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invoke((byte)-73, methodBinding, null);
        } else {
            int n2 = 0;
            int n3 = this.syntheticAccessor.parameters.length - methodBinding.parameters.length;
            while (n2 < n3) {
                codeStream.aconst_null();
                ++n2;
            }
            codeStream.invoke((byte)-73, this.syntheticAccessor, null);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
            switch (this.postConversionType((Scope)blockScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (methodBinding.isPrivate()) {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (blockScope.enclosingSourceType() != referenceBinding) {
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    methodBinding.tagBits |= 0x400L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                }
            }
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.type != null) {
            stringBuffer.append("new ");
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.typeArguments[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        TypeBinding[] typeBindingArray;
        this.constant = Constant.NotAConstant;
        if (this.type == null) {
            this.resolvedType = blockScope.enclosingReceiverType();
        } else {
            this.resolvedType = this.type.resolveType(blockScope, true);
            if (this.type instanceof ParameterizedQualifiedTypeReference) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
                if (referenceBinding == null) {
                    return referenceBinding;
                }
                block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                    if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                    typeBindingArray = (ParameterizedQualifiedTypeReference)this.type;
                    n = typeBindingArray.typeArguments.length - 2;
                    while (n >= 0) {
                        if (typeBindingArray.typeArguments[n] != null) {
                            blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                            break block0;
                        }
                        --n;
                    }
                    break block0;
                }
            }
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            boolean bl = blockScope.compilerOptions().sourceLevel < 0x310000L;
            this.genericTypeArguments = new TypeBinding[n2];
            n = 0;
            while (n < n2) {
                TypeReference typeReference = this.typeArguments[n];
                this.genericTypeArguments[n] = typeReference.resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    bl = true;
                }
                if (bl && typeReference instanceof Wildcard) {
                    blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                ++n;
            }
            if (bl) {
                if (this.arguments != null) {
                    n = 0;
                    int n3 = this.arguments.length;
                    while (n < n3) {
                        this.arguments[n].resolveType(blockScope);
                        ++n;
                    }
                }
                return null;
            }
        }
        boolean bl = false;
        typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            n = 0;
            int n4 = this.arguments.length;
            typeBindingArray = new TypeBinding[n4];
            int n5 = 0;
            while (n5 < n4) {
                Expression expression = this.arguments[n5];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl = true;
                }
                if ((typeBindingArray[n5] = expression.resolveType(blockScope)) == null) {
                    n = 1;
                }
                ++n5;
            }
            if (n != 0) {
                if (this.resolvedType instanceof ReferenceBinding) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n4];
                    int n6 = n4;
                    while (--n6 >= 0) {
                        TypeBinding typeBinding = typeBindingArray2[n6] = typeBindingArray[n6] == null ? TypeBinding.NULL : typeBindingArray[n6];
                    }
                    this.binding = blockScope.findMethod((ReferenceBinding)this.resolvedType, TypeConstants.INIT, typeBindingArray2, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                        }
                        this.binding = methodBinding;
                        MethodBinding methodBinding2 = methodBinding.original();
                        if (methodBinding2.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding2)) {
                            methodBinding2.modifiers |= 0x8000000;
                        }
                    }
                }
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
            return null;
        }
        if (this.type != null && !this.resolvedType.canBeInstantiated()) {
            blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = referenceBinding;
            }
            if (this.type != null && !this.type.resolvedType.isValidBinding()) {
                return null;
            }
            blockScope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInConstructor(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (AllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl, this)) {
            this.bits |= 0x10000;
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        return referenceBinding;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

