/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ClassLiteralAccess
extends Expression {
    public TypeReference type;
    public TypeBinding targetType;
    FieldBinding syntheticField;

    public ClassLiteralAccess(int n, TypeReference typeReference) {
        this.type = typeReference;
        typeReference.bits |= 0x40000000;
        this.sourceStart = typeReference.sourceStart;
        this.sourceEnd = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        SourceTypeBinding sourceTypeBinding = blockScope.outerMostClassScope().enclosingSourceType();
        if (!sourceTypeBinding.isInterface() && !this.targetType.isBaseType() && blockScope.compilerOptions().sourceLevel < 0x310000L) {
            this.syntheticField = sourceTypeBinding.addSyntheticFieldForClassLiteral(this.targetType, blockScope);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateClassLiteralAccessForType(this.type.resolvedType, this.syntheticField);
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.type.print(0, stringBuffer).append(".class");
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        this.constant = Constant.NotAConstant;
        this.targetType = this.type.resolveType(blockScope, true);
        if (this.targetType == null) {
            return null;
        }
        if (this.targetType.isArrayType()) {
            typeBinding2 = (ArrayBinding)this.targetType;
            typeBinding = ((ArrayBinding)typeBinding2).leafComponentType;
            if (typeBinding == TypeBinding.VOID) {
                blockScope.problemReporter().cannotAllocateVoidArray(this);
                return null;
            }
            if (typeBinding.isTypeVariable()) {
                blockScope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)typeBinding, this);
            }
        } else if (this.targetType.isTypeVariable()) {
            blockScope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)this.targetType, this);
        }
        if ((typeBinding2 = blockScope.getJavaLangClass()).isGenericType()) {
            typeBinding = null;
            typeBinding = this.targetType.id == 6 ? blockScope.environment().getResolvedType(JAVA_LANG_VOID, blockScope) : blockScope.boxing(this.targetType);
            this.resolvedType = blockScope.environment().createParameterizedType((ReferenceBinding)typeBinding2, new TypeBinding[]{typeBinding}, null);
        } else {
            this.resolvedType = typeBinding2;
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

