/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashSetOfInt;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            StringLiteral stringLiteral = (StringLiteral)object;
            StringLiteral stringLiteral2 = (StringLiteral)object2;
            return stringLiteral.sourceStart - stringLiteral2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;
    private HashSetOfInt stringLiteralsStart;
    IrritantSet[] suppressWarningIrritants;
    Annotation[] suppressWarningAnnotations;
    long[] suppressWarningScopePositions;
    int suppressWarningsCount;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int n) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = n - 1;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int n = 0;
                int n2 = this.types.length;
                while (n < n2) {
                    this.types[n].analyseCode(this.scope);
                    ++n;
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        int n;
        if (this.types != null) {
            int n2 = 0;
            n = this.types.length;
            while (n2 < n) {
                this.cleanUp(this.types[n2]);
                ++n2;
            }
            n2 = 0;
            n = this.localTypeCount;
            while (n2 < n) {
                LocalTypeBinding localTypeBinding = this.localTypes[n2];
                localTypeBinding.scope = null;
                localTypeBinding.enclosingCase = null;
                ++n2;
            }
        }
        this.compilationResult.recoveryScannerData = null;
        ClassFile[] classFileArray = this.compilationResult.getClassFiles();
        n = 0;
        int n3 = classFileArray.length;
        while (n < n3) {
            ClassFile classFile = classFileArray[n];
            classFile.referenceBinding = null;
            classFile.innerClassesBindings = null;
            classFile.missingTypes = null;
            classFile.visitedTypes = null;
            ++n;
        }
        this.suppressWarningAnnotations = null;
    }

    private void cleanUp(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes != null) {
            int n = 0;
            int n2 = typeDeclaration.memberTypes.length;
            while (n < n2) {
                this.cleanUp(typeDeclaration.memberTypes[n]);
                ++n;
            }
        }
        if (typeDeclaration.binding != null && typeDeclaration.binding.isAnnotationType()) {
            this.compilationResult.hasAnnotations = true;
        }
        if (typeDeclaration.binding != null) {
            typeDeclaration.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            int n = 0;
            int n2 = this.scope.imports.length;
            while (n < n2) {
                ImportBinding importBinding = this.scope.imports[n];
                ImportReference importReference = importBinding.reference;
                if (importReference != null && (importReference.bits & 2) == 0) {
                    this.scope.problemReporter().unusedImport(importReference);
                }
                ++n;
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void createPackageInfoType() {
        TypeDeclaration typeDeclaration = new TypeDeclaration(this.compilationResult);
        typeDeclaration.name = TypeConstants.PACKAGE_INFO_NAME;
        typeDeclaration.modifiers = 512;
        typeDeclaration.javadoc = this.javadoc;
        this.types[0] = typeDeclaration;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n = 0;
        while (n < this.types.length) {
            TypeDeclaration typeDeclaration = this.types[n].declarationOfType(cArray);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            ++n;
        }
        return null;
    }

    public void finalizeProblems() {
        int n;
        int n2;
        int n3;
        CategorizedProblem categorizedProblem;
        if (this.suppressWarningsCount == 0) {
            return;
        }
        int n4 = 0;
        CategorizedProblem[] categorizedProblemArray = this.compilationResult.problems;
        int n5 = this.compilationResult.problemCount;
        IrritantSet[] irritantSetArray = new IrritantSet[this.suppressWarningsCount];
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        boolean bl = false;
        int n6 = 0;
        int n7 = n5;
        while (n6 < n7) {
            categorizedProblem = categorizedProblemArray[n6];
            n3 = categorizedProblem.getID();
            if (categorizedProblem.isError()) {
                if (n3 != 536871547) {
                    bl = true;
                }
            } else {
                int n8 = categorizedProblem.getSourceStart();
                int n9 = categorizedProblem.getSourceEnd();
                int n10 = ProblemReporter.getIrritant(n3);
                n2 = 0;
                n = this.suppressWarningsCount;
                while (n2 < n) {
                    long l = this.suppressWarningScopePositions[n2];
                    int n11 = (int)(l >>> 32);
                    int n12 = (int)l;
                    if (n8 >= n11 && n9 <= n12 && this.suppressWarningIrritants[n2].isSet(n10)) {
                        ++n4;
                        categorizedProblemArray[n6] = null;
                        if (this.compilationResult.problemsMap != null) {
                            this.compilationResult.problemsMap.remove(categorizedProblem);
                        }
                        if (this.compilationResult.firstErrors != null) {
                            this.compilationResult.firstErrors.remove(categorizedProblem);
                        }
                        if (irritantSetArray[n2] == null) {
                            irritantSetArray[n2] = new IrritantSet(n10);
                            break;
                        }
                        irritantSetArray[n2].set(n10);
                        break;
                    }
                    ++n2;
                }
            }
            ++n6;
        }
        if (n4 > 0) {
            n6 = 0;
            n7 = 0;
            while (n6 < n5) {
                categorizedProblem = categorizedProblemArray[n6];
                if (categorizedProblem != null) {
                    if (n6 > n7) {
                        categorizedProblemArray[n7++] = categorizedProblem;
                    } else {
                        ++n7;
                    }
                }
                ++n6;
            }
            this.compilationResult.problemCount -= n4;
        }
        if (!bl && (n6 = compilerOptions.getSeverity(0x22000000)) != -1) {
            n7 = (n6 & 1) == 0 ? 1 : 0;
            int n13 = 0;
            n3 = this.suppressWarningsCount;
            while (n13 < n3) {
                Annotation annotation = this.suppressWarningAnnotations[n13];
                if (annotation != null) {
                    IrritantSet irritantSet = this.suppressWarningIrritants[n13];
                    if (!(n7 != 0 && irritantSet.areAllSet() || irritantSet == irritantSetArray[n13])) {
                        MemberValuePair[] memberValuePairArray = annotation.memberValuePairs();
                        n2 = 0;
                        n = memberValuePairArray.length;
                        block4: while (n2 < n) {
                            MemberValuePair memberValuePair = memberValuePairArray[n2];
                            if (CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) {
                                IrritantSet irritantSet2;
                                int n14;
                                int n15;
                                int n16;
                                int n17;
                                Expression expression = memberValuePair.value;
                                if (expression instanceof ArrayInitializer) {
                                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                                    Expression[] expressionArray = arrayInitializer.expressions;
                                    if (expressionArray == null) break;
                                    n17 = 0;
                                    n16 = expressionArray.length;
                                    while (n17 < n16) {
                                        IrritantSet irritantSet3;
                                        Constant constant = expressionArray[n17].constant;
                                        if (!(constant == Constant.NotAConstant || constant.typeID() != 11 || (irritantSet3 = CompilerOptions.warningTokenToIrritants(constant.stringValue())) == null || irritantSet3.areAllSet() || !compilerOptions.isAnyEnabled(irritantSet3) || irritantSetArray[n13] != null && irritantSetArray[n13].isAnySet(irritantSet3))) {
                                            if (n7 != 0) {
                                                int n18 = expression.sourceStart;
                                                n15 = expression.sourceEnd;
                                                n14 = n13 - 1;
                                                while (n14 >= 0) {
                                                    long l = this.suppressWarningScopePositions[n14];
                                                    int n19 = (int)(l >>> 32);
                                                    int n20 = (int)l;
                                                    if (n18 >= n19 && n15 <= n20 && this.suppressWarningIrritants[n14].areAllSet()) break block4;
                                                    --n14;
                                                }
                                            }
                                            this.scope.problemReporter().unusedWarningToken(expressionArray[n17]);
                                        }
                                        ++n17;
                                    }
                                    break;
                                }
                                Constant constant = expression.constant;
                                if (constant == Constant.NotAConstant || constant.typeID() != 11 || (irritantSet2 = CompilerOptions.warningTokenToIrritants(constant.stringValue())) == null || irritantSet2.areAllSet() || !compilerOptions.isAnyEnabled(irritantSet2) || irritantSetArray[n13] != null && irritantSetArray[n13].isAnySet(irritantSet2)) break;
                                if (n7 != 0) {
                                    n17 = expression.sourceStart;
                                    n16 = expression.sourceEnd;
                                    int n21 = n13 - 1;
                                    while (n21 >= 0) {
                                        long l = this.suppressWarningScopePositions[n21];
                                        n15 = (int)(l >>> 32);
                                        n14 = (int)l;
                                        if (n17 >= n15 && n16 <= n14 && this.suppressWarningIrritants[n21].areAllSet()) break block4;
                                        --n21;
                                    }
                                }
                                this.scope.problemReporter().unusedWarningToken(expression);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                ++n13;
            }
        }
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int n = 0;
                int n2 = this.types.length;
                while (n < n2) {
                    this.types[n].ignoreFurtherInvestigation = true;
                    this.types[n].generateCode(this.scope);
                    ++n;
                }
            }
            return;
        }
        try {
            if (this.types != null) {
                int n = 0;
                int n3 = this.types.length;
                while (n < n3) {
                    this.types[n].generateCode(this.scope);
                    ++n;
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int n;
            char[] cArray = this.compilationResult.getFileName();
            int n2 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n2 == 0 || n2 < CharOperation.lastIndexOf('\\', cArray)) {
                n2 = CharOperation.lastIndexOf('\\', cArray) + 1;
            }
            if ((n = CharOperation.lastIndexOf('.', cArray)) == -1) {
                n = cArray.length;
            }
            return CharOperation.subarray(cArray, n2, n);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(n, stringBuffer).append("package ");
            this.currentPackage.print(0, stringBuffer, false).append(";\n");
        }
        if (this.imports != null) {
            n2 = 0;
            while (n2 < this.imports.length) {
                CompilationUnitDeclaration.printIndent(n, stringBuffer).append("import ");
                ImportReference importReference = this.imports[n2];
                if (importReference.isStatic()) {
                    stringBuffer.append("static ");
                }
                importReference.print(0, stringBuffer).append(";\n");
                ++n2;
            }
        }
        if (this.types != null) {
            n2 = 0;
            while (n2 < this.types.length) {
                this.types[n2].print(n, stringBuffer).append("\n");
                ++n2;
            }
        }
        return stringBuffer;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int n = 0;
        int n2 = this.localTypeCount;
        while (n < n2) {
            LocalTypeBinding localTypeBinding = this.localTypes[n];
            if ((localTypeBinding.scope.referenceType().bits & Integer.MIN_VALUE) != 0) {
                localTypeBinding.updateInnerEmulationDependents();
            }
            ++n;
        }
    }

    public void recordStringLiteral(StringLiteral stringLiteral, boolean bl) {
        int n;
        if (this.stringLiteralsStart != null) {
            if (this.stringLiteralsStart.contains(stringLiteral.sourceStart)) {
                return;
            }
            this.stringLiteralsStart.add(stringLiteral.sourceStart);
        } else if (bl) {
            this.stringLiteralsStart = new HashSetOfInt(this.stringLiteralsPtr + 10);
            n = 0;
            while (n < this.stringLiteralsPtr) {
                this.stringLiteralsStart.add(this.stringLiterals[n].sourceStart);
                ++n;
            }
            if (this.stringLiteralsStart.contains(stringLiteral.sourceStart)) {
                return;
            }
            this.stringLiteralsStart.add(stringLiteral.sourceStart);
        }
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            n = this.stringLiterals.length;
            if (this.stringLiteralsPtr == n) {
                this.stringLiterals = new StringLiteral[n + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = stringLiteral;
    }

    public void recordSuppressWarnings(IrritantSet irritantSet, Annotation annotation, int n, int n2) {
        if (this.suppressWarningIrritants == null) {
            this.suppressWarningIrritants = new IrritantSet[3];
            this.suppressWarningAnnotations = new Annotation[3];
            this.suppressWarningScopePositions = new long[3];
        } else if (this.suppressWarningIrritants.length == this.suppressWarningsCount) {
            this.suppressWarningIrritants = new IrritantSet[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningIrritants, 0, this.suppressWarningIrritants, 0, this.suppressWarningsCount);
            this.suppressWarningAnnotations = new Annotation[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningAnnotations, 0, this.suppressWarningAnnotations, 0, this.suppressWarningsCount);
            this.suppressWarningScopePositions = new long[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningScopePositions, 0, this.suppressWarningScopePositions, 0, this.suppressWarningsCount);
        }
        this.suppressWarningIrritants[this.suppressWarningsCount] = irritantSet;
        this.suppressWarningAnnotations[this.suppressWarningsCount] = annotation;
        this.suppressWarningScopePositions[this.suppressWarningsCount++] = ((long)n << 32) + (long)n2;
    }

    public void record(LocalTypeBinding localTypeBinding) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localTypeBinding;
    }

    public void resolve() {
        int n = 0;
        boolean bl = this.isPackageInfo();
        if (this.types != null && bl) {
            TypeDeclaration typeDeclaration = this.types[0];
            if (typeDeclaration.javadoc == null) {
                typeDeclaration.javadoc = new Javadoc(typeDeclaration.declarationSourceStart, typeDeclaration.declarationSourceStart);
            }
            typeDeclaration.resolve(this.scope);
            if (this.javadoc != null && typeDeclaration.staticInitializerScope != null) {
                this.javadoc.resolve(typeDeclaration.staticInitializerScope);
            }
            n = 1;
        } else if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !bl) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                int n2 = n;
                int n3 = this.types.length;
                while (n2 < n3) {
                    this.types[n2].resolve(this.scope);
                    ++n2;
                }
            }
            if (!this.compilationResult.hasErrors()) {
                this.checkUnusedImports();
            }
            this.reportNLSProblems();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void reportNLSProblems() {
        block25: {
            block27: {
                block26: {
                    if (this.nlsTags == null && this.stringLiterals == null) break block25;
                    var1_1 = this.stringLiteralsPtr;
                    v0 = var2_2 = this.nlsTags == null ? 0 : this.nlsTags.length;
                    if (var1_1 != 0) break block26;
                    if (var2_2 == 0) break block25;
                    var3_3 = 0;
                    while (var3_3 < var2_2) {
                        var4_6 = this.nlsTags[var3_3];
                        if (var4_6 != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(var4_6.start, var4_6.end);
                        }
                        ++var3_3;
                    }
                    break block25;
                }
                if (var2_2 != 0) break block27;
                if (this.stringLiterals.length != var1_1) {
                    this.stringLiterals = new StringLiteral[var1_1];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, var1_1);
                }
                Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
                var3_4 = 0;
                while (var3_4 < var1_1) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[var3_4]);
                    ++var3_4;
                }
                break block25;
            }
            if (this.stringLiterals.length != var1_1) {
                this.stringLiterals = new StringLiteral[var1_1];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, var1_1);
            }
            Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
            var3_5 = 1;
            var4_7 = -1;
            var5_8 = null;
            var6_9 = 0;
            var7_10 = 0;
            block2: while (var7_10 < var1_1) {
                var5_8 = this.stringLiterals[var7_10];
                var8_11 = var5_8.lineNumber;
                if (var4_7 != var8_11) {
                    var3_5 = 1;
                    var4_7 = var8_11;
                } else {
                    ++var3_5;
                }
                if (var6_9 >= var2_2) break;
                while (var6_9 < var2_2) {
                    block24: {
                        var9_13 = this.nlsTags[var6_9];
                        if (var9_13 == null) ** GOTO lbl74
                        var10_14 = var9_13.lineNumber;
                        if (var8_11 < var10_14) {
                            this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                        } else if (var8_11 == var10_14) {
                            if (var9_13.index == var3_5) {
                                this.nlsTags[var6_9] = null;
                                ++var6_9;
                            } else {
                                var11_15 = var6_9 + 1;
                                while (var11_15 < var2_2) {
                                    var12_16 = this.nlsTags[var11_15];
                                    if (var12_16 != null) {
                                        var13_17 = var12_16.lineNumber;
                                        if (var8_11 == var13_17) {
                                            if (var12_16.index == var3_5) {
                                                this.nlsTags[var11_15] = null;
                                                break block24;
                                            }
                                        } else {
                                            this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                                            break block24;
                                        }
                                    }
                                    ++var11_15;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                            }
                        } else {
                            this.scope.problemReporter().unnecessaryNLSTags(var9_13.start, var9_13.end);
lbl74:
                            // 2 sources

                            ++var6_9;
                            continue;
                        }
                    }
                    ++var7_10;
                    continue block2;
                }
                break block2;
            }
            while (var7_10 < var1_1) {
                this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[var7_10]);
                ++var7_10;
            }
            if (var6_9 < var2_2) {
                while (var6_9 < var2_2) {
                    var8_12 = this.nlsTags[var6_9];
                    if (var8_12 != null) {
                        this.scope.problemReporter().unnecessaryNLSTags(var8_12.start, var8_12.end);
                    }
                    ++var6_9;
                }
            }
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, this.scope)) {
                if (this.types != null && this.isPackageInfo()) {
                    Annotation[] annotationArray;
                    TypeDeclaration typeDeclaration = this.types[0];
                    MethodScope methodScope = typeDeclaration.staticInitializerScope;
                    if (this.javadoc != null && methodScope != null) {
                        this.javadoc.traverse(aSTVisitor, methodScope);
                    }
                    if (this.currentPackage != null && methodScope != null && (annotationArray = this.currentPackage.annotations) != null) {
                        int n = annotationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            annotationArray[n2].traverse(aSTVisitor, methodScope);
                            ++n2;
                        }
                    }
                }
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(aSTVisitor, this.scope);
                }
                if (this.imports != null) {
                    int n = this.imports.length;
                    int n3 = 0;
                    while (n3 < n) {
                        this.imports[n3].traverse(aSTVisitor, this.scope);
                        ++n3;
                    }
                }
                if (this.types != null) {
                    int n = this.types.length;
                    int n4 = 0;
                    while (n4 < n) {
                        this.types[n4].traverse(aSTVisitor, this.scope);
                        ++n4;
                    }
                }
            }
            aSTVisitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }
}

