/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class FieldReference
extends Reference
implements InvocationSite {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    public MethodBinding[] syntheticAccessors;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding genericCast;

    public FieldReference(char[] cArray, long l) {
        this.token = cArray;
        this.nameSourcePosition = l;
        this.sourceStart = (int)(l >>> 32);
        this.sourceEnd = (int)(l & 0xFFFFFFFFL);
        this.bits |= 1;
    }

    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl) {
        if (bl) {
            FlowInfo flowInfo2;
            if (this.binding.isBlankFinal() && this.receiver.isThis() && blockScope.needBlankFinalFieldInitializationCheck(this.binding) && !(flowInfo2 = flowContext.getInitsForFinalBlankInitializationCheck(this.binding.declaringClass.original(), flowInfo)).isDefinitelyAssigned(this.binding)) {
                blockScope.problemReporter().uninitializedBlankFinalField(this.binding, this);
            }
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, true);
        }
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, !this.binding.isStatic()).unconditionalInits();
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, false);
        if (this.binding.isFinal()) {
            if (this.binding.isBlankFinal() && !bl && this.receiver.isThis() && !(this.receiver instanceof QualifiedThisReference) && (this.receiver.bits & 0x1FE00000) == 0 && blockScope.allowBlankFinalFieldAssignment(this.binding)) {
                if (flowInfo.isPotentiallyAssigned(this.binding)) {
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField(this.binding, this);
                } else {
                    flowContext.recordSettingFinal(this.binding, this, flowInfo);
                }
                flowInfo.markAsDefinitelyAssigned(this.binding);
            } else {
                blockScope.problemReporter().cannotAssignToFinalField(this.binding, this);
            }
        }
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(blockScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, boolean bl) {
        boolean bl2 = !this.binding.isStatic();
        this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl2);
        if (bl2) {
            this.receiver.checkNPE(blockScope, flowContext, flowInfo);
        }
        if (bl || blockScope.compilerOptions().complianceLevel >= 0x300000L) {
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, true);
        }
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            FieldBinding fieldBinding = this.binding.original();
            TypeBinding typeBinding3 = fieldBinding.type;
            if (typeBinding3.leafComponentType().isTypeVariable()) {
                ReferenceBinding referenceBinding;
                TypeBinding typeBinding4 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                this.genericCast = fieldBinding.type.genericCast(typeBinding4);
                if (this.genericCast instanceof ReferenceBinding && !(referenceBinding = (ReferenceBinding)this.genericCast).canBeSeenBy(scope)) {
                    scope.problemReporter().invalidType(this, new ProblemReferenceBinding(CharOperation.splitOn('.', referenceBinding.shortReadableName()), referenceBinding, 2));
                }
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public void generateAssignment(BlockScope blockScope, CodeStream codeStream, Assignment assignment, boolean bl) {
        int n = codeStream.position;
        FieldBinding fieldBinding = this.binding.original();
        this.receiver.generateCode(blockScope, codeStream, !fieldBinding.isStatic());
        codeStream.recordPositionsFrom(n, this.sourceStart);
        assignment.expression.generateCode(blockScope, codeStream, true);
        this.fieldStore(blockScope, codeStream, fieldBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], this.actualReceiverType, this.receiver.isImplicitThis(), bl);
        if (bl) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        FieldBinding fieldBinding = this.binding.original();
        boolean bl2 = fieldBinding.isStatic();
        boolean bl3 = this.receiver instanceof ThisReference;
        Constant constant = fieldBinding.constant();
        if (constant != Constant.NotAConstant) {
            if (!bl3) {
                this.receiver.generateCode(blockScope, codeStream, !bl2);
                if (!bl2) {
                    codeStream.invokeObjectGetClass();
                    codeStream.pop();
                }
            }
            if (bl) {
                codeStream.generateConstant(constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        if (bl || !bl3 && blockScope.compilerOptions().complianceLevel >= 0x300000L || (this.implicitConversion & 0x400) != 0 || this.genericCast != null) {
            this.receiver.generateCode(blockScope, codeStream, !bl2);
            if ((this.bits & 0x40000) != 0) {
                codeStream.checkcast(this.actualReceiverType);
            }
            n = codeStream.position;
            if (fieldBinding.declaringClass == null) {
                codeStream.arraylength();
                if (bl) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    codeStream.pop();
                }
            } else {
                if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                    TypeBinding typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, fieldBinding, this.actualReceiverType, this.receiver.isImplicitThis());
                    if (bl2) {
                        codeStream.fieldAccess((byte)-78, fieldBinding, typeBinding);
                    } else {
                        codeStream.fieldAccess((byte)-76, fieldBinding, typeBinding);
                    }
                } else {
                    codeStream.invoke((byte)-72, this.syntheticAccessors[0], null);
                }
                if (this.genericCast != null) {
                    codeStream.checkcast(this.genericCast);
                }
                if (bl) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = (this.implicitConversion & 0x400) != 0;
                    if (bl4) {
                        codeStream.generateImplicitConversion(this.implicitConversion);
                    }
                    switch (bl4 ? this.postConversionType((Scope)blockScope).id : fieldBinding.type.id) {
                        case 7: 
                        case 8: {
                            codeStream.pop2();
                            break;
                        }
                        default: {
                            codeStream.pop();
                            break;
                        }
                    }
                }
            }
        } else if (bl3) {
            if (bl2 && this.binding.original().declaringClass != this.actualReceiverType.erasure()) {
                MethodBinding methodBinding;
                MethodBinding methodBinding2 = methodBinding = this.syntheticAccessors == null ? null : this.syntheticAccessors[0];
                if (methodBinding == null) {
                    TypeBinding typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, fieldBinding, this.actualReceiverType, this.receiver.isImplicitThis());
                    codeStream.fieldAccess((byte)-78, fieldBinding, typeBinding);
                } else {
                    codeStream.invoke((byte)-72, methodBinding, null);
                }
                switch (fieldBinding.type.id) {
                    case 7: 
                    case 8: {
                        codeStream.pop2();
                        break;
                    }
                    default: {
                        codeStream.pop();
                        break;
                    }
                }
            }
        } else {
            this.receiver.generateCode(blockScope, codeStream, !bl2);
            if (!bl2) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceEnd);
    }

    public void generateCompoundAssignment(BlockScope blockScope, CodeStream codeStream, Expression expression, int n, int n2, boolean bl) {
        TypeBinding typeBinding;
        FieldBinding fieldBinding = this.binding.original();
        boolean bl2 = fieldBinding.isStatic();
        this.receiver.generateCode(blockScope, codeStream, !bl2);
        if (bl2) {
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, fieldBinding, this.actualReceiverType, this.receiver.isImplicitThis());
                codeStream.fieldAccess((byte)-78, fieldBinding, typeBinding);
            } else {
                codeStream.invoke((byte)-72, this.syntheticAccessors[0], null);
            }
        } else {
            codeStream.dup();
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, fieldBinding, this.actualReceiverType, this.receiver.isImplicitThis());
                codeStream.fieldAccess((byte)-76, fieldBinding, typeBinding);
            } else {
                codeStream.invoke((byte)-72, this.syntheticAccessors[0], null);
            }
        }
        int n3 = (this.implicitConversion & 0xFF) >> 4;
        switch (n3) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(blockScope, null, expression);
                break;
            }
            default: {
                if (this.genericCast != null) {
                    codeStream.checkcast(this.genericCast);
                }
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(blockScope, codeStream, true);
                }
                codeStream.sendOperator(n, n3);
                codeStream.generateImplicitConversion(n2);
            }
        }
        this.fieldStore(blockScope, codeStream, fieldBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], this.actualReceiverType, this.receiver.isImplicitThis(), bl);
    }

    public void generatePostIncrement(BlockScope blockScope, CodeStream codeStream, CompoundAssignment compoundAssignment, boolean bl) {
        TypeBinding typeBinding;
        FieldBinding fieldBinding = this.binding.original();
        boolean bl2 = fieldBinding.isStatic();
        this.receiver.generateCode(blockScope, codeStream, !bl2);
        if (bl2) {
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, fieldBinding, this.actualReceiverType, this.receiver.isImplicitThis());
                codeStream.fieldAccess((byte)-78, fieldBinding, typeBinding);
            } else {
                codeStream.invoke((byte)-72, this.syntheticAccessors[0], null);
            }
        } else {
            codeStream.dup();
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, fieldBinding, this.actualReceiverType, this.receiver.isImplicitThis());
                codeStream.fieldAccess((byte)-76, fieldBinding, typeBinding);
            } else {
                codeStream.invoke((byte)-72, this.syntheticAccessors[0], null);
            }
        }
        if (this.genericCast != null) {
            codeStream.checkcast(this.genericCast);
            typeBinding = this.genericCast;
        } else {
            typeBinding = fieldBinding.type;
        }
        if (bl) {
            if (bl2) {
                switch (typeBinding.id) {
                    case 7: 
                    case 8: {
                        codeStream.dup2();
                        break;
                    }
                    default: {
                        codeStream.dup();
                        break;
                    }
                }
            } else {
                switch (typeBinding.id) {
                    case 7: 
                    case 8: {
                        codeStream.dup2_x1();
                        break;
                    }
                    default: {
                        codeStream.dup_x1();
                    }
                }
            }
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.generateConstant(compoundAssignment.expression.constant, this.implicitConversion);
        codeStream.sendOperator(compoundAssignment.operator, this.implicitConversion & 0xF);
        codeStream.generateImplicitConversion(compoundAssignment.preAssignImplicitConversion);
        this.fieldStore(blockScope, codeStream, fieldBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], this.actualReceiverType, this.receiver.isImplicitThis(), false);
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo, boolean bl) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        FieldBinding fieldBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (blockScope.enclosingSourceType() != fieldBinding.declaringClass && this.binding.constant() == Constant.NotAConstant) {
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[bl ? 0 : 1] = ((SourceTypeBinding)fieldBinding.declaringClass).addSyntheticMethod(fieldBinding, bl, false);
                blockScope.problemReporter().needToEmulateFieldAccess(fieldBinding, this, bl);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[bl ? 0 : 1] = sourceTypeBinding.addSyntheticMethod(fieldBinding, bl, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateFieldAccess(fieldBinding, this, bl);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != sourceTypeBinding.getPackage()) {
                    SourceTypeBinding sourceTypeBinding2 = (SourceTypeBinding)sourceTypeBinding.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    if (this.syntheticAccessors == null) {
                        this.syntheticAccessors = new MethodBinding[2];
                    }
                    this.syntheticAccessors[bl ? 0 : 1] = sourceTypeBinding2.addSyntheticMethod(fieldBinding, bl, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateFieldAccess(fieldBinding, this, bl);
                    return;
                }
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public Constant optimizedBooleanConstant() {
        switch (this.resolvedType.id) {
            case 5: 
            case 33: {
                return this.constant != Constant.NotAConstant ? this.constant : this.binding.constant();
            }
        }
        return Constant.NotAConstant;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        if (this.genericCast != null) {
            typeBinding = this.genericCast;
        }
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.receiver.printExpression(0, stringBuffer).append('.').append(this.token);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding;
        boolean bl;
        FieldBinding fieldBinding;
        boolean bl2 = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            bl2 = true;
        }
        this.actualReceiverType = this.receiver.resolveType(blockScope);
        if (this.actualReceiverType == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        if (bl2 && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (!(fieldBinding = (this.binding = blockScope.getField(this.actualReceiverType, this.token, this))).isValidBinding()) {
            this.constant = Constant.NotAConstant;
            if (this.receiver.resolvedType instanceof ProblemReferenceBinding) {
                return null;
            }
            blockScope.problemReporter().invalidField(this, this.actualReceiverType);
            return null;
        }
        TypeBinding typeBinding2 = this.actualReceiverType;
        this.actualReceiverType = this.actualReceiverType.getErasureCompatibleType(fieldBinding.declaringClass);
        this.receiver.computeConversion(blockScope, this.actualReceiverType, this.actualReceiverType);
        if (this.actualReceiverType != typeBinding2 && this.receiver.postConversionType(blockScope) != this.actualReceiverType) {
            this.bits |= 0x40000;
        }
        if (this.isFieldUseDeprecated(fieldBinding, blockScope, (this.bits & 0x2000) != 0)) {
            blockScope.problemReporter().deprecatedField(fieldBinding, this);
        }
        Constant constant = this.constant = (bl = this.receiver.isImplicitThis()) ? fieldBinding.constant() : Constant.NotAConstant;
        if (fieldBinding.isStatic()) {
            if (!(bl || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
                blockScope.problemReporter().nonStaticAccessToStaticField(this, fieldBinding);
            }
            typeBinding = this.binding.declaringClass;
            if (!bl && typeBinding != this.actualReceiverType && ((ReferenceBinding)typeBinding).canBeSeenBy(blockScope)) {
                blockScope.problemReporter().indirectAccessToStaticField(this, fieldBinding);
            }
            if (((ReferenceBinding)typeBinding).isEnum()) {
                MethodScope methodScope = blockScope.methodScope();
                SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
                if (this.constant == Constant.NotAConstant && !methodScope.isStatic && (sourceTypeBinding == typeBinding || sourceTypeBinding.superclass == typeBinding) && methodScope.isInsideInitializerOrConstructor()) {
                    blockScope.problemReporter().enumStaticFieldUsedDuringInitialization(this.binding, this);
                }
            }
        }
        if ((typeBinding = fieldBinding.type) != null) {
            if ((this.bits & 0x2000) == 0) {
                typeBinding = typeBinding.capture(blockScope, this.sourceEnd);
            }
            this.resolvedType = typeBinding;
            if ((typeBinding.tagBits & 0x80L) != 0L) {
                blockScope.problemReporter().invalidType(this, typeBinding);
                return null;
            }
        }
        return typeBinding;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        this.actualReceiverType = referenceBinding;
    }

    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.receiver.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

