/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public BlockScope scope;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int preCondInitStateIndex = -1;
    int preIncrementsInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForStatement(Statement[] statementArray, Expression expression, Statement[] statementArray2, Statement statement, boolean bl, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.initializations = statementArray;
        this.condition = expression;
        this.increments = statementArray2;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        if (bl) {
            this.bits |= 0x20000000;
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        FlowInfo flowInfo3;
        LoopingFlowContext loopingFlowContext;
        UnconditionalFlowInfo unconditionalFlowInfo;
        int n;
        int n2;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        int n3 = n2 = (flowInfo.reachMode() & 1) != 0 ? 1 : 0;
        if (this.initializations != null) {
            int n4 = 0;
            n = this.initializations.length;
            while (n4 < n) {
                flowInfo = this.initializations[n4].analyseCode(this.scope, flowContext, flowInfo);
                ++n4;
            }
        }
        this.preCondInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        Constant constant = this.condition == null ? null : this.condition.constant;
        n = constant != null && (constant == Constant.NotAConstant || !constant.booleanValue()) ? 0 : 1;
        boolean bl = constant != null && constant != Constant.NotAConstant && !constant.booleanValue();
        constant = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean bl2 = constant == null || constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl3 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue();
        LoopingFlowContext loopingFlowContext2 = null;
        FlowInfo flowInfo4 = flowInfo.nullInfoLessUnconditionalCopy();
        if (this.condition != null && n == 0) {
            loopingFlowContext2 = new LoopingFlowContext(flowContext, flowInfo, this, null, null, this.scope);
            flowInfo4 = this.condition.analyseCode(this.scope, loopingFlowContext2, flowInfo4);
        }
        if (this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            if (loopingFlowContext2 != null) {
                loopingFlowContext2.complainOnDeferredFinalChecks(this.scope, flowInfo4);
            }
            if (n != 0) {
                if (loopingFlowContext2 != null) {
                    loopingFlowContext2.complainOnDeferredNullChecks(blockScope, flowInfo4);
                }
                return FlowInfo.DEAD_END;
            }
            if (bl) {
                this.continueLabel = null;
            }
            unconditionalFlowInfo = flowInfo4.initsWhenTrue().unconditionalCopy();
            loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope);
        } else {
            loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope);
            flowInfo3 = flowInfo4.initsWhenTrue();
            this.condIfTrueInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
            if (bl) {
                unconditionalFlowInfo = FlowInfo.DEAD_END;
            } else {
                unconditionalFlowInfo = flowInfo3.unconditionalCopy();
                if (bl3) {
                    unconditionalFlowInfo.setReachMode(1);
                }
            }
            if (this.action.complainIfUnreachable(unconditionalFlowInfo, this.scope, n2) < 2) {
                unconditionalFlowInfo = this.action.analyseCode(this.scope, loopingFlowContext, unconditionalFlowInfo).unconditionalInits();
            }
            if ((unconditionalFlowInfo.tagBits & loopingFlowContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            } else {
                if (loopingFlowContext2 != null) {
                    loopingFlowContext2.complainOnDeferredFinalChecks(this.scope, flowInfo4);
                }
                unconditionalFlowInfo = unconditionalFlowInfo.mergedWith(loopingFlowContext.initsOnContinue);
                loopingFlowContext.complainOnDeferredFinalChecks(this.scope, unconditionalFlowInfo);
            }
        }
        flowInfo3 = flowInfo.copy();
        LoopingFlowContext loopingFlowContext3 = null;
        if (this.continueLabel != null) {
            if (this.increments != null) {
                loopingFlowContext3 = new LoopingFlowContext(flowContext, flowInfo, this, null, null, this.scope);
                flowInfo2 = unconditionalFlowInfo;
                this.preIncrementsInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
                int n5 = 0;
                int n6 = this.increments.length;
                while (n5 < n6) {
                    flowInfo2 = this.increments[n5].analyseCode(this.scope, loopingFlowContext3, flowInfo2);
                    ++n5;
                }
                unconditionalFlowInfo = ((FlowInfo)flowInfo2).unconditionalInits();
                loopingFlowContext3.complainOnDeferredFinalChecks(this.scope, unconditionalFlowInfo);
            }
            flowInfo3.addPotentialInitializationsFrom(unconditionalFlowInfo).addInitializationsFrom(flowInfo4.initsWhenFalse());
        } else {
            flowInfo3.addInitializationsFrom(flowInfo4.initsWhenFalse());
            if (this.increments != null && n2 == 0) {
                blockScope.problemReporter().fakeReachable(this.increments[0]);
            }
        }
        if (loopingFlowContext2 != null) {
            loopingFlowContext2.complainOnDeferredNullChecks(blockScope, unconditionalFlowInfo);
        }
        loopingFlowContext.complainOnDeferredNullChecks(blockScope, unconditionalFlowInfo);
        if (loopingFlowContext3 != null) {
            loopingFlowContext3.complainOnDeferredNullChecks(blockScope, unconditionalFlowInfo);
        }
        flowInfo2 = FlowInfo.mergedOptimizedBranches((loopingFlowContext.initsOnBreak.tagBits & 1) != 0 ? loopingFlowContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingFlowContext.initsOnBreak), bl2, flowInfo3, bl3, n == 0);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        return flowInfo2;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        int n;
        int n2;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n3 = codeStream.position;
        if (this.initializations != null) {
            int n4 = 0;
            n2 = this.initializations.length;
            while (n4 < n2) {
                this.initializations[n4].generateCode(this.scope, codeStream);
                ++n4;
            }
        }
        Constant constant = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        int n5 = n2 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue() ? 1 : 0;
        if (n2 != 0) {
            this.condition.generateCode(this.scope, codeStream, false);
            if ((this.bits & 0x20000000) != 0) {
                codeStream.exitUserScope(this.scope);
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(n3, this.sourceStart);
            return;
        }
        BranchLabel branchLabel = new BranchLabel(codeStream);
        branchLabel.tagBits |= 2;
        BranchLabel branchLabel2 = new BranchLabel(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel == null) {
            branchLabel2.place();
            if (this.condition != null && this.condition.constant == Constant.NotAConstant) {
                this.condition.generateOptimizedBoolean(this.scope, codeStream, null, this.breakLabel, true);
            }
        } else {
            this.continueLabel.initialize(codeStream);
            if (this.condition != null && this.condition.constant == Constant.NotAConstant && (this.action != null && !this.action.isEmptyBlock() || this.increments != null)) {
                branchLabel2.tagBits |= 2;
                n = codeStream.position;
                codeStream.goto_(branchLabel2);
                codeStream.recordPositionsFrom(n, this.condition.sourceStart);
            }
        }
        if (this.action != null) {
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(blockScope, this.condIfTrueInitStateIndex);
            }
            branchLabel.place();
            this.action.generateCode(this.scope, codeStream);
        } else {
            branchLabel.place();
        }
        if (this.preIncrementsInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preIncrementsInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.preIncrementsInitStateIndex);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            if (this.increments != null) {
                n = 0;
                int n6 = this.increments.length;
                while (n < n6) {
                    this.increments[n].generateCode(this.scope, codeStream);
                    ++n;
                }
            }
            if (this.preCondInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preCondInitStateIndex);
            }
            branchLabel2.place();
            if (this.condition != null && this.condition.constant == Constant.NotAConstant) {
                this.condition.generateOptimizedBoolean(this.scope, codeStream, branchLabel, null, true);
            } else {
                codeStream.goto_(branchLabel);
            }
        } else if (this.preCondInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preCondInitStateIndex);
        }
        if ((this.bits & 0x20000000) != 0) {
            codeStream.exitUserScope(this.scope);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        this.breakLabel.place();
        codeStream.recordPositionsFrom(n3, this.sourceStart);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        int n2;
        ForStatement.printIndent(n, stringBuffer).append("for (");
        if (this.initializations != null) {
            n2 = 0;
            while (n2 < this.initializations.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.initializations[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append("; ");
        if (this.condition != null) {
            this.condition.printExpression(0, stringBuffer);
        }
        stringBuffer.append("; ");
        if (this.increments != null) {
            n2 = 0;
            while (n2 < this.increments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.increments[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append(") ");
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        int n;
        BlockScope blockScope2 = this.scope = (this.bits & 0x20000000) != 0 ? new BlockScope(blockScope) : blockScope;
        if (this.initializations != null) {
            int n2 = 0;
            n = this.initializations.length;
            while (n2 < n) {
                this.initializations[n2].resolve(this.scope);
                ++n2;
            }
        }
        if (this.condition != null) {
            TypeBinding typeBinding = this.condition.resolveTypeExpecting(this.scope, TypeBinding.BOOLEAN);
            this.condition.computeConversion(this.scope, typeBinding, typeBinding);
        }
        if (this.increments != null) {
            int n3 = 0;
            n = this.increments.length;
            while (n3 < n) {
                this.increments[n3].resolve(this.scope);
                ++n3;
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.initializations != null) {
                n2 = this.initializations.length;
                n = 0;
                while (n < n2) {
                    this.initializations[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.condition != null) {
                this.condition.traverse(aSTVisitor, this.scope);
            }
            if (this.increments != null) {
                n2 = this.increments.length;
                n = 0;
                while (n < n2) {
                    this.increments[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.action != null) {
                this.action.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

