/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class ImportReference
extends ASTNode {
    public char[][] tokens;
    public long[] sourcePositions;
    public int declarationEnd;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public Annotation[] annotations;

    public ImportReference(char[][] cArray, long[] lArray, boolean bl, int n) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        if (bl) {
            this.bits |= 0x20000;
        }
        this.sourceEnd = (int)(lArray[lArray.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(lArray[0] >>> 32);
        this.modifiers = n;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public char[][] getImportName() {
        return this.tokens;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer, true);
    }

    public StringBuffer print(int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = 0;
        while (n2 < this.tokens.length) {
            if (n2 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[n2]);
            ++n2;
        }
        if (bl && (this.bits & 0x20000) != 0) {
            stringBuffer.append(".*");
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        aSTVisitor.visit(this, compilationUnitScope);
        aSTVisitor.endVisit(this, compilationUnitScope);
    }
}

