/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class IntLiteral
extends NumberLiteral {
    public int value;
    public static final IntLiteral One = new IntLiteral(new char[]{'1'}, 0, 0, 1);

    public IntLiteral(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public IntLiteral(char[] cArray, int n, int n2, int n3) {
        this(cArray, n, n2);
        this.value = n3;
    }

    public IntLiteral(int n) {
        super(null, 0, 0);
        this.constant = IntConstant.fromValue(n);
        this.value = n;
    }

    public void computeConstant() {
        long l = Integer.MAX_VALUE;
        if (this == One) {
            this.constant = IntConstant.fromValue(1);
            return;
        }
        int n = this.source.length;
        long l2 = 0L;
        if (this.source[0] == '0') {
            int n2;
            int n3;
            int n4;
            l = 0xFFFFFFFFL;
            if (n == 1) {
                this.constant = IntConstant.fromValue(0);
                return;
            }
            if (this.source[1] == 'x' || this.source[1] == 'X') {
                n4 = 4;
                n3 = 2;
                n2 = 16;
            } else {
                n4 = 3;
                n3 = 1;
                n2 = 8;
            }
            while (this.source[n3] == '0') {
                if (++n3 != n) continue;
                this.value = (int)l2;
                this.constant = IntConstant.fromValue(this.value);
                return;
            }
            while (n3 < n) {
                int n5;
                if ((n5 = ScannerHelper.digit(this.source[n3++], n2)) < 0) {
                    return;
                }
                if ((l2 = l2 << n4 | (long)n5) <= l) continue;
                return;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                int n7 = ScannerHelper.digit(this.source[n6], 10);
                if (n7 < 0) {
                    return;
                }
                if ((l2 = 10L * l2 + (long)n7) > l) {
                    return;
                }
                ++n6;
            }
        }
        this.value = (int)l2;
        this.constant = IntConstant.fromValue(this.value);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.INT;
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.source.length == 10 && this.source[0] == '2' && this.source[1] == '1' && this.source[2] == '4' && this.source[3] == '7' && this.source[4] == '4' && this.source[5] == '8' && this.source[6] == '3' && this.source[7] == '6' && this.source[8] == '4' && this.source[9] == '8' && (this.bits & 0x1FE00000) >> 21 == 0;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.source == null) {
            return stringBuffer.append(String.valueOf(this.value));
        }
        return super.printExpression(n, stringBuffer);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

