/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocImplicitTypeReference
extends TypeReference {
    public char[] token;

    public JavadocImplicitTypeReference(char[] cArray, int n) {
        this.token = cArray;
        this.sourceStart = n;
        this.sourceEnd = n;
    }

    public TypeReference copyDims(int n) {
        return null;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        this.constant = Constant.NotAConstant;
        this.resolvedType = scope.enclosingReceiverType();
        return this.resolvedType;
    }

    public char[] getLastToken() {
        return this.token;
    }

    public char[][] getTypeName() {
        if (this.token != null) {
            char[][] cArrayArray = new char[][]{this.token};
            return cArrayArray;
        }
        return null;
    }

    public boolean isThis() {
        return true;
    }

    protected TypeBinding internalResolveType(Scope scope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.resolvedType = this.getTypeBinding(scope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        boolean bl = !typeBinding.isValidBinding();
        if (bl) {
            this.reportInvalidType(scope);
            switch (typeBinding.problemId()) {
                case 1: 
                case 2: {
                    typeBinding = typeBinding.closestMatch();
                    if (typeBinding != null) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, scope)) {
            this.reportDeprecatedType(typeBinding, scope);
        }
        if (typeBinding.isGenericType() || typeBinding.isParameterizedType()) {
            typeBinding = scope.environment().convertToRawType(typeBinding, true);
        }
        if (bl) {
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().javadocInvalidType(this, this.resolvedType, scope.getDeclarationModifiers());
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().javadocDeprecatedType(typeBinding, this, scope.getDeclarationModifiers());
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return new StringBuffer();
    }
}

