/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocQualifiedTypeReference
extends QualifiedTypeReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public PackageBinding packageBinding;

    public JavadocQualifiedTypeReference(char[][] cArray, long[] lArray, int n, int n2) {
        super(cArray, lArray);
        this.tagSourceStart = n;
        this.tagSourceEnd = n2;
        this.bits |= 0x8000;
    }

    private TypeBinding internalResolveType(Scope scope, boolean bl) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : this.resolvedType.closestMatch();
        }
        this.resolvedType = this.getTypeBinding(scope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        if (!typeBinding.isValidBinding()) {
            Binding binding = scope.getTypeOrPackage(this.tokens);
            if (binding instanceof PackageBinding) {
                this.packageBinding = (PackageBinding)binding;
            } else {
                this.reportInvalidType(scope);
            }
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, scope)) {
            this.reportDeprecatedType(typeBinding, scope);
        }
        if (typeBinding.isGenericType() || typeBinding.isParameterizedType()) {
            this.resolvedType = scope.environment().convertToRawType(typeBinding, true);
        }
        return this.resolvedType;
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().javadocDeprecatedType(typeBinding, this, scope.getDeclarationModifiers());
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().javadocInvalidType(this, this.resolvedType, scope.getDeclarationModifiers());
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, bl);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, false);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

