/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.declarationEnd = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        int n = this.initialization.nullStatus(flowInfo);
        this.bits = !(flowInfo = this.initialization.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).isDefinitelyAssigned(this.binding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
        flowInfo.markAsDefinitelyAssigned(this.binding);
        if ((this.binding.type.tagBits & 2L) == 0L) {
            switch (n) {
                case 1: {
                    flowInfo.markAsDefinitelyNull(this.binding);
                    break;
                }
                case -1: {
                    flowInfo.markAsDefinitelyNonNull(this.binding);
                    break;
                }
                default: {
                    flowInfo.markAsDefinitelyUnknown(this.binding);
                }
            }
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.binding.resolvedPosition != -1) {
            codeStream.addVisibleLocalVariable(this.binding);
        }
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.initialization != null) {
            if (this.binding.resolvedPosition < 0) {
                if (this.initialization.constant == Constant.NotAConstant) {
                    this.initialization.generateCode(blockScope, codeStream, false);
                }
            } else {
                this.initialization.generateCode(blockScope, codeStream, true);
                if (this.binding.type.isArrayType() && (this.initialization.resolvedType == TypeBinding.NULL || this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == TypeBinding.NULL)) {
                    codeStream.checkcast(this.binding.type);
                }
                codeStream.store(this.binding, false);
                if ((this.bits & 8) != 0) {
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public int getKind() {
        return 4;
    }

    public void resolve(BlockScope blockScope) {
        Binding binding;
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.checkModifiers();
        if (typeBinding != null) {
            if (typeBinding == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        if ((binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false)) != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineLocal(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
            this.modifiers |= 0x4000000;
        }
        this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, false);
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(Constant.NotAConstant);
        if (typeBinding == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(blockScope);
            }
            return;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding typeBinding2 = this.initialization.resolveTypeExpecting(blockScope, typeBinding);
                if (typeBinding2 != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)typeBinding2;
                    this.initialization.computeConversion(blockScope, typeBinding, typeBinding2);
                }
            } else {
                this.initialization.setExpectedType(typeBinding);
                TypeBinding typeBinding3 = this.initialization.resolveType(blockScope);
                if (typeBinding3 != null) {
                    if (typeBinding != typeBinding3) {
                        blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding3);
                    }
                    if (this.initialization.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding) || typeBinding3.isCompatibleWith(typeBinding)) {
                        this.initialization.computeConversion(blockScope, typeBinding, typeBinding3);
                        if (typeBinding3.needsUncheckedConversion(typeBinding)) {
                            blockScope.problemReporter().unsafeTypeConversion(this.initialization, typeBinding3, typeBinding);
                        }
                        if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                            CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.initialization);
                        }
                    } else if (this.isBoxingCompatible(typeBinding3, typeBinding, this.initialization, blockScope)) {
                        this.initialization.computeConversion(blockScope, typeBinding, typeBinding3);
                        if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                            CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.initialization);
                        }
                    } else if ((typeBinding.tagBits & 0x80L) == 0L) {
                        blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding, this.initialization, null);
                    }
                }
            }
            if (this.binding == Expression.getDirectBinding(this.initialization)) {
                blockScope.problemReporter().assignmentHasNoEffect(this, this.name);
            }
            this.binding.setConstant(this.binding.isFinal() ? this.initialization.constant.castTo((typeBinding.id << 4) + this.initialization.constant.typeID()) : Constant.NotAConstant);
        }
        LocalDeclaration.resolveAnnotations(blockScope, this.annotations, this.binding);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            this.type.traverse(aSTVisitor, blockScope);
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

