/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MemberValuePair
extends ASTNode {
    public char[] name;
    public Expression value;
    public MethodBinding binding;
    public ElementValuePair compilerElementPair = null;

    public MemberValuePair(char[] cArray, int n, int n2, Expression expression) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.value = expression;
        if (expression instanceof ArrayInitializer) {
            expression.bits |= 1;
        }
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.name).append(" = ");
        this.value.print(0, stringBuffer);
        return stringBuffer;
    }

    public void resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        Object object;
        if (this.value == null) {
            this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
            return;
        }
        if (typeBinding == null) {
            if (this.value instanceof ArrayInitializer) {
                this.value.resolveTypeExpecting(blockScope, null);
            } else {
                this.value.resolveType(blockScope);
            }
            this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
            return;
        }
        this.value.setExpectedType(typeBinding);
        if (this.value instanceof ArrayInitializer) {
            object = (ArrayInitializer)this.value;
            typeBinding2 = ((ArrayInitializer)object).resolveTypeExpecting(blockScope, this.binding.returnType);
        } else if (this.value instanceof ArrayAllocationExpression) {
            blockScope.problemReporter().annotationValueMustBeArrayInitializer(this.binding.declaringClass, this.name, this.value);
            this.value.resolveType(blockScope);
            typeBinding2 = null;
        } else {
            typeBinding2 = this.value.resolveType(blockScope);
        }
        this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
        if (typeBinding2 == null) {
            return;
        }
        object = typeBinding.leafComponentType();
        if (!this.value.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) && !typeBinding2.isCompatibleWith(typeBinding)) {
            if (!typeBinding.isArrayType() || typeBinding.dimensions() != 1 || !this.value.isConstantValueOfTypeAssignableToType(typeBinding2, (TypeBinding)object) && !typeBinding2.isCompatibleWith((TypeBinding)object)) {
                if (((TypeBinding)object).isAnnotationType() && !typeBinding2.isAnnotationType()) {
                    blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, (TypeBinding)object);
                } else {
                    blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.value, null);
                }
                return;
            }
        } else {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding.leafComponentType(), typeBinding2.leafComponentType());
            this.value.computeConversion(blockScope, typeBinding, typeBinding2);
        }
        switch (((TypeBinding)object).erasure().id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n = 0;
                    int n2 = expressionArray.length;
                    while (n < n2) {
                        Expression expression = expressionArray[n];
                        if (expression.resolvedType != null && expression.constant == Constant.NotAConstant) {
                            blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expressionArray[n], false);
                        }
                        ++n;
                    }
                    break;
                }
                if (this.value.constant != Constant.NotAConstant) break;
                if (typeBinding2.isArrayType()) {
                    blockScope.problemReporter().annotationValueMustBeArrayInitializer(this.binding.declaringClass, this.name, this.value);
                    break;
                }
                blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value, false);
                break;
            }
            case 16: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n = 0;
                    int n3 = expressionArray.length;
                    while (n < n3) {
                        Expression expression = expressionArray[n];
                        if (!(expression instanceof ClassLiteralAccess)) {
                            blockScope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, expression);
                        }
                        ++n;
                    }
                    break;
                }
                if (this.value instanceof ClassLiteralAccess) break;
                blockScope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, this.value);
                break;
            }
            default: {
                if (((TypeBinding)object).isEnum()) {
                    if (this.value instanceof NullLiteral) {
                        blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value, true);
                        break;
                    }
                    if (this.value instanceof ArrayInitializer) {
                        ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                        Expression[] expressionArray = arrayInitializer.expressions;
                        if (expressionArray == null) break;
                        int n = 0;
                        int n4 = expressionArray.length;
                        while (n < n4) {
                            Expression expression = expressionArray[n];
                            if (expression instanceof NullLiteral) {
                                blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expression, true);
                            } else if (expression instanceof NameReference) {
                                NameReference nameReference = (NameReference)expression;
                                Binding binding = nameReference.binding;
                                if (binding.kind() == 1) {
                                    FieldBinding fieldBinding = (FieldBinding)binding;
                                    if (!fieldBinding.declaringClass.isEnum()) {
                                        blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expression, true);
                                    }
                                }
                            }
                            ++n;
                        }
                        break;
                    }
                    if (this.value instanceof NameReference) {
                        NameReference nameReference = (NameReference)this.value;
                        Binding binding = nameReference.binding;
                        if (binding.kind() != 1) break;
                        FieldBinding fieldBinding = (FieldBinding)binding;
                        if (fieldBinding.declaringClass.isEnum()) break;
                        if (!fieldBinding.type.isArrayType()) {
                            blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value, true);
                            break;
                        }
                        blockScope.problemReporter().annotationValueMustBeArrayInitializer(this.binding.declaringClass, this.name, this.value);
                        break;
                    }
                    blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value, true);
                    break;
                }
                if (!((TypeBinding)object).isAnnotationType()) break;
                if (!typeBinding2.leafComponentType().isAnnotationType()) {
                    blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, (TypeBinding)object);
                    break;
                }
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n = 0;
                    int n5 = expressionArray.length;
                    while (n < n5) {
                        Expression expression = expressionArray[n];
                        if (expression instanceof NullLiteral || !(expression instanceof Annotation)) {
                            blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, expression, (TypeBinding)object);
                        }
                        ++n;
                    }
                    break;
                }
                if (this.value instanceof Annotation) break;
                blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, (TypeBinding)object);
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.value != null) {
            this.value.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

