/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, long l) {
        super(cArray, n, l);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
    }

    public TypeReference copyDims(int n) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, n, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[][] getParameterizedTypeName() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n = 0;
        int n2 = this.typeArguments.length;
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n].getParameterizedTypeName(), '.'));
            ++n;
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n3 = this.dimensions;
        if (n3 > 0) {
            char[] cArray2 = new char[n3 * 2];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 * 2;
                cArray2[n5] = 91;
                cArray2[n5 + 1] = 93;
                ++n4;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding typeBinding, boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        TypeBinding typeBinding2;
        Object object;
        TypeBinding typeBinding3;
        ReferenceBinding referenceBinding;
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding4 = this.resolvedType.closestMatch();
                    return typeBinding4;
                }
            }
            return null;
        }
        boolean bl2 = false;
        this.bits |= 0x40000;
        if (typeBinding == null) {
            this.resolvedType = scope.getType(this.token);
            if (this.resolvedType.isValidBinding()) {
                referenceBinding = (ReferenceBinding)this.resolvedType;
            } else {
                bl2 = true;
                this.reportInvalidType(scope);
                switch (this.resolvedType.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        typeBinding3 = this.resolvedType.closestMatch();
                        if (typeBinding3 instanceof ReferenceBinding) {
                            referenceBinding = (ReferenceBinding)typeBinding3;
                            break;
                        }
                    }
                    default: {
                        boolean bl3 = scope.kind == 3;
                        int n = this.typeArguments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TypeReference typeReference = this.typeArguments[n2];
                            if (bl3) {
                                typeReference.resolveType((ClassScope)scope);
                            } else {
                                typeReference.resolveType((BlockScope)scope, bl);
                            }
                            ++n2;
                        }
                        return null;
                    }
                }
            }
            typeBinding = referenceBinding.enclosingType();
            if (typeBinding != null) {
                typeBinding = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(typeBinding, false) : scope.environment().convertToParameterizedType((ReferenceBinding)typeBinding);
                referenceBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding);
            }
        } else {
            referenceBinding = scope.getMemberType(this.token, (ReferenceBinding)typeBinding);
            this.resolvedType = referenceBinding;
            if (!this.resolvedType.isValidBinding()) {
                bl2 = true;
                scope.problemReporter().invalidEnclosingType(this, referenceBinding, (ReferenceBinding)typeBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(referenceBinding, scope)) {
                scope.problemReporter().deprecatedType(referenceBinding, this);
            }
            if ((typeBinding3 = referenceBinding.enclosingType()) != null && typeBinding3.erasure() != typeBinding.erasure()) {
                typeBinding = typeBinding3;
            }
        }
        boolean bl4 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl4) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        int n = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        boolean bl5 = false;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
        int n3 = 0;
        while (n3 < n) {
            object = this.typeArguments[n3];
            TypeBinding typeBinding5 = typeBinding2 = bl4 ? ((TypeReference)object).resolveTypeArgument((ClassScope)scope, referenceBinding2, n3) : ((TypeReference)object).resolveTypeArgument((BlockScope)scope, referenceBinding2, n3);
            if (typeBinding2 == null) {
                bl5 = true;
            } else {
                typeBindingArray[n3] = typeBinding2;
            }
            ++n3;
        }
        if (bl5) {
            return null;
        }
        if (bl4) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                return null;
            }
        }
        if ((typeVariableBindingArray = referenceBinding2.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
            boolean bl6;
            boolean bl7 = bl6 = scope.compilerOptions().sourceLevel >= 0x310000L;
            if ((referenceBinding2.tagBits & 0x80L) == 0L && bl6) {
                this.resolvedType = referenceBinding;
                scope.problemReporter().nonGenericTypeCannotBeParameterized(0, this, referenceBinding, typeBindingArray);
                return null;
            }
            if (!bl6) {
                typeBinding2 = referenceBinding;
                if (this.dimensions > 0) {
                    if (this.dimensions > 255) {
                        scope.problemReporter().tooManyDimensions(this);
                    }
                    typeBinding2 = scope.createArrayType(typeBinding2, this.dimensions);
                }
                if (bl2) {
                    return typeBinding2;
                }
                this.resolvedType = typeBinding2;
                return this.resolvedType;
            }
        } else {
            if (n != typeVariableBindingArray.length) {
                scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray);
                return null;
            }
            if (!referenceBinding.isStatic() && (object = referenceBinding.enclosingType()) != null && ((TypeBinding)object).isRawType()) {
                scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)object), typeBindingArray);
                return null;
            }
        }
        ParameterizedTypeBinding parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)typeBinding);
        if (bl) {
            parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
        } else {
            scope.deferBoundCheck(this);
        }
        if (this.isTypeUseDeprecated(parameterizedTypeBinding, scope)) {
            this.reportDeprecatedType(parameterizedTypeBinding, scope);
        }
        typeBinding2 = parameterizedTypeBinding;
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            typeBinding2 = scope.createArrayType(typeBinding2, this.dimensions);
        }
        if (bl2) {
            return typeBinding2;
        }
        this.resolvedType = typeBinding2;
        return this.resolvedType;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n2 = this.typeArguments.length - 1;
        int n3 = 0;
        while (n3 < n2) {
            this.typeArguments[n3].print(0, stringBuffer);
            stringBuffer.append(", ");
            ++n3;
        }
        this.typeArguments[n2].print(0, stringBuffer);
        stringBuffer.append(">");
        if ((this.bits & 0x4000) != 0) {
            n3 = 0;
            while (n3 < this.dimensions - 1) {
                stringBuffer.append("[]");
                ++n3;
            }
            stringBuffer.append("...");
        } else {
            n3 = 0;
            while (n3 < this.dimensions) {
                stringBuffer.append("[]");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, null, bl);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, null, false);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = 0;
            int n2 = this.typeArguments.length;
            while (n < n2) {
                this.typeArguments[n].traverse(aSTVisitor, blockScope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = 0;
            int n2 = this.typeArguments.length;
            while (n < n2) {
                this.typeArguments[n].traverse(aSTVisitor, classScope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

