/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class GCCMain
extends Main {
    private HashSet commandLineCompilationUnits = new HashSet();
    private boolean syntaxOnly;
    private String zipDestination;
    private ZipOutputStream zipStream;
    private String zipDependencyDestination;
    private ZipOutputStream zipDependencyStream;

    public GCCMain(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        super(printWriter, printWriter2, bl);
        this.logger.setEmacs();
    }

    public GCCMain(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        super(printWriter, printWriter2, bl, map);
        this.logger.setEmacs();
    }

    private void fail(Exception exception) {
        exception.printStackTrace();
        this.logger.logException(exception);
        System.exit(1);
    }

    public CompilationUnit[] getCompilationUnits() {
        CompilationUnit[] compilationUnitArray = super.getCompilationUnits();
        int n = 0;
        while (n < compilationUnitArray.length) {
            this.commandLineCompilationUnits.add(compilationUnitArray[n]);
            ++n;
        }
        return compilationUnitArray;
    }

    private String combine(char[] cArray, char[] cArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        stringBuffer.append(cArray2);
        return stringBuffer.toString();
    }

    private ZipOutputStream getZipOutput() throws IOException {
        if (this.zipDestination != null && this.zipStream == null) {
            OutputStream outputStream = "-".equals(this.zipDestination) ? System.out : new FileOutputStream(this.zipDestination);
            this.zipStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
            this.zipStream.setMethod(0);
            ZipEntry zipEntry = new ZipEntry(".dummy");
            byte[] byArray = new byte[]{};
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            zipEntry.setSize(byArray.length);
            zipEntry.setCrc(cRC32.getValue());
            this.zipStream.putNextEntry(zipEntry);
            this.zipStream.write(byArray);
            this.zipStream.closeEntry();
        }
        return this.zipStream;
    }

    private ZipOutputStream getDependencyOutput() throws IOException {
        if (this.zipDependencyDestination != null && this.zipDependencyStream == null) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zipDependencyDestination);
            this.zipDependencyStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            this.zipDependencyStream.setMethod(0);
            ZipEntry zipEntry = new ZipEntry(".dummy");
            byte[] byArray = new byte[]{};
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            zipEntry.setSize(byArray.length);
            zipEntry.setCrc(cRC32.getValue());
            this.zipDependencyStream.putNextEntry(zipEntry);
            this.zipDependencyStream.write(byArray);
            this.zipDependencyStream.closeEntry();
        }
        return this.zipDependencyStream;
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (this.syntaxOnly) {
            return;
        }
        if (this.zipDestination == null) {
            super.outputClassFiles(compilationResult);
            return;
        }
        if (compilationResult == null || compilationResult.hasErrors()) {
            return;
        }
        boolean bl = this.commandLineCompilationUnits.contains(compilationResult.getCompilationUnit());
        if (this.zipDependencyDestination == null && !bl) {
            return;
        }
        try {
            ZipOutputStream zipOutputStream = bl ? this.getZipOutput() : this.getDependencyOutput();
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            int n = 0;
            while (n < classFileArray.length) {
                ClassFile classFile = classFileArray[n];
                String string = this.combine(classFile.fileName(), SuffixConstants.SUFFIX_class);
                if (this.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string}));
                }
                ZipEntry zipEntry = new ZipEntry(string);
                byte[] byArray = classFile.getBytes();
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                zipEntry.setSize(byArray.length);
                zipEntry.setCrc(cRC32.getValue());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray);
                zipOutputStream.closeEntry();
                ++n;
            }
        }
        catch (IOException iOException) {
            this.fail(iOException);
        }
    }

    private String getArgument(String string) {
        int n = string.indexOf(61);
        return string.substring(n + 1);
    }

    private void addPath(ArrayList arrayList, String string) {
        String string2 = null;
        AccessRule[] accessRuleArray = new AccessRule[0];
        AccessRuleSet accessRuleSet = new AccessRuleSet(accessRuleArray, 0, string);
        FileSystem.Classpath classpath = FileSystem.getClasspath(string, string2, accessRuleSet);
        if (classpath != null) {
            arrayList.add(classpath);
        }
    }

    private void parsePath(ArrayList arrayList, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            this.addPath(arrayList, stringTokenizer.nextToken());
        }
    }

    protected void handleWarningToken(String string, boolean bl) {
        if ("deprecated".equals(string)) {
            string = "deprecation";
        } else if (!("static-access".equals(string) || "dep-ann".equals(string) || "over-ann".equals(string))) {
            if ("extraneous-semicolon".equals(string)) {
                string = "semicolon";
            } else {
                StringBuffer stringBuffer = new StringBuffer(string.length());
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                boolean bl2 = true;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (bl2) {
                        stringBuffer.append(string2);
                        bl2 = false;
                        continue;
                    }
                    stringBuffer.append(Character.toUpperCase(string2.charAt(0)));
                    stringBuffer.append(string2.substring(1));
                }
                string = stringBuffer.toString();
            }
        }
        super.handleWarningToken(string, bl);
    }

    private void turnWarningsToErrors() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Map.Entry entry = (Map.Entry)objectArray[n];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "error");
            }
            ++n;
        }
    }

    private void setDebugLevel(int n) {
        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", n > 1 ? "generate" : "do not generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", n > 0 ? "generate" : "do not generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
    }

    private void readFileList(String string, ArrayList arrayList) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.endsWith(".java")) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.fail(iOException);
        }
    }

    private void readAllFileListFiles(ArrayList arrayList, ArrayList arrayList2) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.readFileList((String)iterator.next(), arrayList2);
        }
    }

    private void handleWall(boolean bl) {
        this.handleWarningToken("constructor-name", bl);
        this.handleWarningToken("pkg-default-method", bl);
        this.handleWarningToken("masked-catch-block", bl);
        this.handleWarningToken("all-deprecation", bl);
        this.handleWarningToken("unused-local", bl);
        this.handleWarningToken("unused-label", bl);
        this.handleWarningToken("static-receiver", bl);
        this.handleWarningToken("indirect-static", bl);
        this.handleWarningToken("no-effect-assign", bl);
        this.handleWarningToken("char-concat", bl);
        this.handleWarningToken("useless-type-check", bl);
        this.handleWarningToken("final-bound", bl);
        this.handleWarningToken("assert-identifier", bl);
        this.handleWarningToken("enum-identifier", bl);
        this.handleWarningToken("finally", bl);
        this.handleWarningToken("varargs-cast", bl);
        this.handleWarningToken("unused", bl);
        this.handleWarningToken("forbidden", bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            System.exit(1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            String string3 = stringArray[n];
            if (string3.startsWith("-fencoding=")) {
                string2 = this.getArgument(string3);
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", string2));
                }
                this.options.put("org.eclipse.jdt.core.encoding", string2);
            } else if (string3.startsWith("-foutput-class-dir=")) {
                string2 = this.getArgument(string3);
                if (this.destinationPath != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("-d");
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", stringBuffer.toString()));
                }
                this.setDestinationPath(string2);
            } else if (string3.startsWith("-fbootclasspath=")) {
                string = this.getArgument(string3);
            } else if (string3.equals("-fzip-target")) {
                if (++n >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("gcc.zipArg"));
                }
                this.zipDestination = stringArray[n];
            } else if (string3.equals("-fzip-dependency")) {
                if (++n >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("gcc.zipDepArg"));
                }
                this.zipDependencyDestination = stringArray[n];
            } else if (string3.startsWith("-g")) {
                if (string3.equals("-g0")) {
                    this.setDebugLevel(0);
                } else if (string3.equals("-g2") || string3.equals("-g3") || string3.equals("-g")) {
                    this.setDebugLevel(2);
                } else {
                    this.setDebugLevel(1);
                }
            } else if (string3.equals("-Werror")) {
                bl3 = true;
            } else if (string3.equals("-Wno-error")) {
                bl3 = false;
            } else if (string3.equals("-Wall")) {
                this.handleWall(true);
            } else if (string3.equals("-Wno-all")) {
                this.handleWall(false);
            } else if (string3.startsWith("-Wno-")) {
                this.handleWarningToken(string3.substring(5), false);
            } else if (string3.startsWith("-W")) {
                this.handleWarningToken(string3.substring(2), true);
            } else if (string3.equals("-w")) {
                bl2 = true;
            } else if (!string3.startsWith("-O")) {
                if (string3.equals("-v")) {
                    this.verbose = true;
                } else if (string3.equals("-fsyntax-only")) {
                    this.syntaxOnly = true;
                } else if (string3.startsWith("-fsource=")) {
                    if ((string3 = this.getArgument(string3)).equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (string3.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (string3.equals("1.5") || string3.equals("5") || string3.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else {
                        if (!string3.equals("1.6") && !string3.equals("6") && !string3.equals("6.0")) throw new IllegalArgumentException(this.bind("configure.source", string3));
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    }
                } else if (string3.startsWith("-ftarget=")) {
                    if ((string3 = this.getArgument(string3)).equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (string3.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (string3.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (string3.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (string3.equals("1.5") || string3.equals("5") || string3.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (string3.equals("1.6") || string3.equals("6") || string3.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else {
                        if (!string3.equals("jsr14")) throw new IllegalArgumentException(this.bind("configure.targetJDK", string3));
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    }
                } else if (string3.equals("-ffilelist-file")) {
                    bl = true;
                } else if (string3.endsWith(".java")) {
                    arrayList.add(string3);
                } else if (string3.charAt(0) != '-') {
                    arrayList2.add(string3);
                }
            }
            ++n;
        }
        if (bl) {
            this.readAllFileListFiles(arrayList2, arrayList);
        }
        this.filenames = arrayList.toArray(new String[0]);
        this.encodings = new String[this.filenames.length];
        this.destinationPaths = new String[this.filenames.length];
        n = 0;
        while (n < this.filenames.length) {
            this.destinationPaths[n] = this.destinationPath;
            ++n;
        }
        ArrayList arrayList3 = new ArrayList();
        if (string == null) {
            throw new IllegalArgumentException(this.bind("gcc.noClasspath"));
        }
        this.parsePath(arrayList3, string);
        try {
            this.getZipOutput();
            this.getDependencyOutput();
        }
        catch (IOException iOException) {
            this.fail(iOException);
        }
        if (bl2) {
            this.disableWarnings();
        }
        if (bl3) {
            this.turnWarningsToErrors();
        }
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logCommandLineArguments(stringArray);
        this.logger.logOptions(this.options);
        this.logger.logClasspath(this.checkedClasspaths);
        this.maxRepetition = 1;
    }

    public boolean compile(String[] stringArray) {
        boolean bl = super.compile(stringArray);
        try {
            if (this.zipStream != null) {
                this.zipStream.finish();
                this.zipStream.close();
            }
            if (this.zipDependencyStream != null) {
                this.zipDependencyStream.finish();
                this.zipDependencyStream.close();
            }
        }
        catch (IOException iOException) {
            this.fail(iOException);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        boolean bl = new GCCMain(new PrintWriter(System.out), new PrintWriter(System.err), false).compile(stringArray);
        System.exit(bl ? 0 : 1);
    }
}

