/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerStats;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    boolean enableJavadocOn;
    boolean warnJavadocOn;
    boolean warnAllJavadocOn;
    public Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public CompilationProgress progress;
    public String destinationPath;
    public String[] destinationPaths;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public String[] classNames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    public long lineCount0;
    public String log;
    public Logger logger;
    public int maxProblems;
    public Map options;
    protected PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int currentRepetition;
    public int maxRepetition;
    public boolean showProgress = false;
    public long startTime;
    public ArrayList pendingErrors;
    public boolean systemExitWhenFinished = true;
    public static final int TIMING_DISABLED = 0;
    public static final int TIMING_ENABLED = 1;
    public static final int TIMING_DETAILED = 2;
    public int timing = 0;
    public CompilerStats[] compilerStats;
    public boolean verbose = false;
    private String[] expandedCommandLine;
    private PrintWriter err;
    ArrayList extraProblems;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";
    static /* synthetic */ Class class$0;

    public static boolean compile(String string) {
        return new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2, CompilationProgress compilationProgress) {
        return new Main(printWriter, printWriter2, false, null, compilationProgress).compile(stringArray);
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return Util.isPotentialZipArchive(string);
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isDirectory()) {
                fileArray2[n2] = file.listFiles(filenameFilter);
            }
            ++n2;
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true, null, null).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = Util.EMPTY_STRING;
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = String.valueOf(stringArray[n2]) + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = Util.EMPTY_STRING;
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = String.valueOf(stringArray[n3]) + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = String.valueOf(stringArray[n4]) + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this(printWriter, printWriter2, bl, map, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map, CompilationProgress compilationProgress) {
        this.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.relocalize();
    }

    public void addExtraProblems(CategorizedProblem categorizedProblem) {
        if (this.extraProblems == null) {
            this.extraProblems = new ArrayList();
        }
        this.extraProblems.add(categorizedProblem);
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                char c = string4.charAt(0);
                String string5 = string4.substring(1);
                if (string5.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0);
                            break;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000118);
                            break;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133);
                            break;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133, true);
                            break;
                        }
                        default: {
                            bl3 = false;
                            break;
                        }
                    }
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                accessRuleSet = new AccessRuleSet((AccessRule[])object, 0, string);
            } else {
                if (string.length() != 0) {
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
                }
                return;
            }
        }
        if (NONE.equals(string3)) {
            string3 = NONE;
        }
        if (bl2 && string3 != null && Util.isPotentialZipArchive(string)) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3);
        if (object != null) {
            arrayList.add(object);
        } else if (string.length() != 0) {
            this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
        }
    }

    void addPendingErrors(String string) {
        if (this.pendingErrors == null) {
            this.pendingErrors = new ArrayList();
        }
        this.pendingErrors.add(string);
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    private boolean checkVMVersion(long l) {
        int n;
        String string = System.getProperty("java.class.version");
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (n) {
            case 45: {
                return 2949123L >= l;
            }
            case 46: {
                return 0x2E0000L >= l;
            }
            case 47: {
                return 0x2F0000L >= l;
            }
            case 48: {
                return 0x300000L >= l;
            }
            case 49: {
                return 0x310000L >= l;
            }
            case 50: {
                return 0x320000L >= l;
            }
            case 51: {
                return 0x330000L >= l;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(String[] stringArray) {
        try {
            try {
                this.configure(stringArray);
                if (this.progress != null) {
                    this.progress.begin(this.filenames == null ? 0 : this.filenames.length * this.maxRepetition);
                }
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    this.currentRepetition = 0;
                    while (true) {
                        if (this.currentRepetition >= this.maxRepetition) {
                            if (this.compilerStats != null) {
                                this.logger.logAverage();
                            }
                            if (!this.showProgress) break;
                            this.logger.printNewLine();
                            break;
                        }
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.exportedClassFilesCounter = 0;
                        if (this.maxRepetition > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(this.currentRepetition, this.maxRepetition);
                        }
                        this.performCompilation();
                        ++this.currentRepetition;
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                block19: {
                    this.logger.logException(illegalArgumentException);
                    if (this.systemExitWhenFinished) {
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                    break block19;
                    catch (RuntimeException runtimeException) {
                        this.logger.logException(runtimeException);
                        if (!this.systemExitWhenFinished) break block19;
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                }
                Object var3_4 = null;
                this.logger.flush();
                this.logger.close();
                if (this.progress == null) return false;
                this.progress.done();
                return false;
            }
            Object var3_6 = null;
            this.logger.flush();
            this.logger.close();
            if (this.progress != null) {
                this.progress.done();
            }
            if (this.globalErrorsCount != 0 || this.progress != null && this.progress.isCanceled()) return false;
            return true;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.logger.flush();
            this.logger.close();
            if (this.progress == null) throw throwable;
            this.progress.done();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void configure(String[] var1_1) {
        if (var1_1 == null || var1_1.length == 0) {
            this.printUsage();
            return;
        }
        var2_2 = new ArrayList<E>(4);
        var3_3 = null;
        var4_4 = new ArrayList<E>(4);
        var5_5 = new ArrayList<E>(4);
        var6_6 = null;
        var7_7 = null;
        var8_8 = -1;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = var1_1.length;
        var12_12 = 0;
        this.maxRepetition = 0;
        var13_13 = false;
        var14_14 = null;
        var15_15 = false;
        var16_16 = false;
        var17_17 = false;
        var18_18 = false;
        var19_19 = false;
        var20_20 = null;
        var21_21 = null;
        var22_22 = null;
        var23_23 = Util.EMPTY_STRING;
        var24_24 = false;
        var25_25 = 0;
        while (var25_25 < var11_11) {
            if (var1_1[var25_25].startsWith("@")) {
                var24_24 = true;
                break;
            }
            ++var25_25;
        }
        var25_26 = null;
        if (var24_24) {
            var25_26 = new String[var11_11];
            var8_8 = 0;
            var26_27 = 0;
            while (var26_27 < var11_11) {
                var27_40 = null;
                var28_50 = var1_1[var26_27].trim();
                if (var28_50.startsWith("@")) {
                    try {
                        var29_54 = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(var28_50.substring(1)), null))));
                        var30_59 = new StringBuffer();
                        while ((var31_62 = var29_54.readLine()) != null) {
                            if ((var31_62 = var31_62.trim()).startsWith("#")) continue;
                            var30_59.append((String)var31_62).append(" ");
                        }
                        var27_40 = Main.tokenize(var30_59.toString());
                    }
                    catch (IOException v0) {
                        throw new IllegalArgumentException(this.bind("configure.invalidexpansionargumentname", var28_50));
                    }
                }
                if (var27_40 != null) {
                    var29_55 = var25_26.length;
                    var30_60 = var27_40.length;
                    v1 = var25_26;
                    var25_26 = new String[var29_55 + var30_60 - 1];
                    System.arraycopy(v1, 0, var25_26, 0, var8_8);
                    System.arraycopy(var27_40, 0, var25_26, var8_8, var30_60);
                    var8_8 += var30_60;
                } else {
                    var25_26[var8_8++] = var28_50;
                }
                ++var26_27;
            }
            var8_8 = -1;
        } else {
            var25_26 = var1_1;
            var26_27 = 0;
            while (var26_27 < var11_11) {
                var25_26[var26_27] = var25_26[var26_27].trim();
                ++var26_27;
            }
        }
        var11_11 = var25_26.length;
        this.expandedCommandLine = var25_26;
        block42: while (++var8_8 < var11_11) {
            if (var20_20 != null) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedCustomEncoding", var23_23, var20_20));
            }
            var23_23 = var25_26[var8_8];
            switch (var12_12) {
                case 0: {
                    if (var23_23.startsWith("[")) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", var23_23));
                    }
                    if (var23_23.endsWith("]")) {
                        var26_28 = var23_23.indexOf(91) + 1;
                        if (var26_28 <= 1) {
                            throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", var23_23));
                        }
                        var27_42 = var23_23.length() - 1;
                        if (var26_28 >= 1) {
                            if (var26_28 < var27_42) {
                                var20_20 = var23_23.substring(var26_28, var27_42);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var20_20);
                                }
                                catch (UnsupportedEncodingException v2) {
                                    throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", var20_20));
                                }
                            }
                            var23_23 = var23_23.substring(0, var26_28 - 1);
                        }
                    }
                    if (var23_23.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[var11_11 - var8_8];
                            this.encodings = new String[var11_11 - var8_8];
                            this.destinationPaths = new String[var11_11 - var8_8];
                        } else if (var9_9 == this.filenames.length) {
                            var26_29 = this.filenames.length;
                            this.filenames = new String[var26_29 + var11_11 - var8_8];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, var26_29);
                            this.encodings = new String[var26_29 + var11_11 - var8_8];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, var26_29);
                            this.destinationPaths = new String[var26_29 + var11_11 - var8_8];
                            System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, var26_29);
                        }
                        this.filenames[var9_9] = var23_23;
                        this.encodings[var9_9++] = var20_20;
                        var20_20 = null;
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-log")) {
                        if (this.log != null) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateLog", var23_23));
                        }
                        var12_12 = 5;
                        break;
                    }
                    if (var23_23.equals("-repeat")) {
                        if (this.maxRepetition > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateRepeat", var23_23));
                        }
                        var12_12 = 6;
                        break;
                    }
                    if (var23_23.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateMaxProblems", var23_23));
                        }
                        var12_12 = 11;
                        break;
                    }
                    if (var23_23.equals("-source")) {
                        var12_12 = 7;
                        break;
                    }
                    if (var23_23.equals("-encoding")) {
                        var12_12 = 8;
                        break;
                    }
                    if (var23_23.equals("-1.3")) {
                        if (var18_18) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var23_23));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-1.4")) {
                        if (var18_18) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var23_23));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-1.5") || var23_23.equals("-5") || var23_23.equals("-5.0")) {
                        if (var18_18) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var23_23));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-1.6") || var23_23.equals("-6") || var23_23.equals("-6.0")) {
                        if (var18_18) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var23_23));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-1.7") || var23_23.equals("-7") || var23_23.equals("-7.0")) {
                        if (var18_18) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var23_23));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-d")) {
                        if (this.destinationPath != null) {
                            var26_30 = new StringBuffer();
                            var26_30.append(var23_23);
                            if (var8_8 + 1 < var11_11) {
                                var26_30.append(' ');
                                var26_30.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", var26_30.toString()));
                        }
                        var12_12 = 3;
                        break;
                    }
                    if (var23_23.equals("-classpath") || var23_23.equals("-cp")) {
                        var12_12 = 1;
                        break;
                    }
                    if (var23_23.equals("-bootclasspath")) {
                        if (var2_2.size() > 0) {
                            var26_31 = new StringBuffer();
                            var26_31.append(var23_23);
                            if (var8_8 + 1 < var11_11) {
                                var26_31.append(' ');
                                var26_31.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateBootClasspath", var26_31.toString()));
                        }
                        var12_12 = 9;
                        break;
                    }
                    if (var23_23.equals("-sourcepath")) {
                        if (var3_3 != null) {
                            var26_32 = new StringBuffer();
                            var26_32.append(var23_23);
                            if (var8_8 + 1 < var11_11) {
                                var26_32.append(' ');
                                var26_32.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateSourcepath", var26_32.toString()));
                        }
                        var12_12 = 13;
                        break;
                    }
                    if (var23_23.equals("-extdirs")) {
                        if (var6_6 != null) {
                            var26_33 = new StringBuffer();
                            var26_33.append(var23_23);
                            if (var8_8 + 1 < var11_11) {
                                var26_33.append(' ');
                                var26_33.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateExtDirs", var26_33.toString()));
                        }
                        var12_12 = 12;
                        break;
                    }
                    if (var23_23.equals("-endorseddirs")) {
                        if (var7_7 != null) {
                            var26_34 = new StringBuffer();
                            var26_34.append(var23_23);
                            if (var8_8 + 1 < var11_11) {
                                var26_34.append(' ');
                                var26_34.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateEndorsedDirs", var26_34.toString()));
                        }
                        var12_12 = 15;
                        break;
                    }
                    if (var23_23.equals("-progress")) {
                        var12_12 = 0;
                        this.showProgress = true;
                        break;
                    }
                    if (var23_23.equals("-proceedOnError")) {
                        var12_12 = 0;
                        this.proceedOnError = true;
                        break;
                    }
                    if (var23_23.equals("-time")) {
                        var12_12 = 0;
                        this.timing = 1;
                        break;
                    }
                    if (var23_23.equals("-time:detail")) {
                        var12_12 = 0;
                        this.timing = 3;
                        break;
                    }
                    if (var23_23.equals("-version") || var23_23.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (var23_23.equals("-showversion")) {
                        var15_15 = true;
                        var12_12 = 0;
                        break;
                    }
                    if ("-deprecation".equals(var23_23)) {
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-help") || var23_23.equals("-?")) {
                        var13_13 = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-help:warn") || var23_23.equals("-?:warn")) {
                        var13_13 = true;
                        var14_14 = "misc.usage.warn";
                        break;
                    }
                    if (var23_23.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-verbose")) {
                        this.verbose = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-inlineJSR")) {
                        var12_12 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        break;
                    }
                    if (var23_23.startsWith("-g")) {
                        var12_12 = 0;
                        var26_35 = var23_23;
                        var27_43 = var23_23.length();
                        if (var27_43 == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            break;
                        }
                        if (var27_43 > 3) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                            if (var27_43 == 7 && var26_35.equals("-g:none")) continue block42;
                            var28_51 = new StringTokenizer(var26_35.substring(3, var26_35.length()), ",");
                            while (var28_51.hasMoreTokens()) {
                                var29_56 = var28_51.nextToken();
                                if (var29_56.equals("vars")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                    continue;
                                }
                                if (var29_56.equals("lines")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                    continue;
                                }
                                if (var29_56.equals("source")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                                    continue;
                                }
                                throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", var26_35));
                            }
                            continue block42;
                        }
                        throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", var26_35));
                    }
                    if (var23_23.startsWith("-nowarn")) {
                        this.disableWarnings();
                        var12_12 = 0;
                        break;
                    }
                    if (!var23_23.startsWith("-warn")) ** GOTO lbl398
                    var12_12 = 0;
                    var26_36 = var23_23;
                    var27_44 = var23_23.length();
                    if (var27_44 == 10 && var26_36.equals("-warn:none")) {
                        this.disableWarnings();
                        break;
                    }
                    if (var27_44 <= 6) {
                        throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", var26_36));
                    }
                    switch (var26_36.charAt(6)) {
                        case '+': {
                            var28_52 = 7;
                            var29_57 = true;
                            var30_61 = true;
                            break;
                        }
                        case '-': {
                            var28_52 = 7;
                            var29_57 = false;
                            var30_61 = true;
                            break;
                        }
                        default: {
                            this.disableWarnings();
                            var28_52 = 6;
                            var29_57 = true;
                            var30_61 = false;
                        }
                    }
                    var31_62 = new StringTokenizer(var26_36.substring(var28_52, var26_36.length()), ",");
                    var32_63 = 0;
                    if (var17_17) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                    }
                    block44: while (var31_62.hasMoreTokens()) {
                        var33_64 = var31_62.nextToken();
                        ++var32_63;
                        switch (var33_64.charAt(0)) {
                            case '+': {
                                if (!var30_61) ** GOTO lbl384
                                var29_57 = true;
                                var33_64 = var33_64.substring(1);
                                ** GOTO lbl393
lbl384:
                                // 1 sources

                                var32_63 = 0;
                                break block44;
                            }
                            case '-': {
                                if (var30_61) {
                                    var29_57 = false;
                                    var33_64 = var33_64.substring(1);
                                } else {
                                    var32_63 = 0;
                                    break block44;
                                }
                            }
lbl393:
                            // 3 sources

                            default: {
                                this.handleWarningToken(var33_64, var29_57);
                            }
                        }
                    }
                    if (var32_63 != 0) continue block42;
                    throw new IllegalArgumentException(this.bind("configure.invalidWarningOption", var23_23));
lbl398:
                    // 1 sources

                    if (var23_23.equals("-target")) {
                        var12_12 = 4;
                        break;
                    }
                    if (var23_23.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-enableJavadoc")) {
                        var12_12 = 0;
                        this.enableJavadocOn = true;
                        break;
                    }
                    if (var23_23.equals("-Xemacs")) {
                        var12_12 = 0;
                        this.logger.setEmacs();
                        break;
                    }
                    if (var23_23.startsWith("-A")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-processorpath")) {
                        var12_12 = 17;
                        break;
                    }
                    if (var23_23.equals("-processor")) {
                        var12_12 = 18;
                        break;
                    }
                    if (var23_23.equals("-proc:only")) {
                        this.options.put("org.eclipse.jdt.core.compiler.generateClassFiles", "disabled");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-proc:none")) {
                        var19_19 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "disabled");
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-s")) {
                        var12_12 = 19;
                        break;
                    }
                    if (var23_23.equals("-XprintProcessorInfo") || var23_23.equals("-XprintRounds")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.startsWith("-X")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.startsWith("-J")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-O")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var23_23.equals("-classNames")) {
                        var12_12 = 20;
                        break;
                    }
                    ** GOTO lbl630
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateTarget", var23_23));
                    }
                    this.didSpecifyTarget = true;
                    if (var23_23.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (var23_23.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (var23_23.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (var23_23.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (var23_23.equals("1.5") || var23_23.equals("5") || var23_23.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (var23_23.equals("1.6") || var23_23.equals("6") || var23_23.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (var23_23.equals("1.7") || var23_23.equals("7") || var23_23.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    } else if (var23_23.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else if (var23_23.equals("cldc1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "cldc1.1");
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                    } else {
                        throw new IllegalArgumentException(this.bind("configure.targetJDK", var23_23));
                    }
                    var12_12 = 0;
                    break;
                }
                case 5: {
                    this.log = var23_23;
                    var12_12 = 0;
                    break;
                }
                case 6: {
                    try {
                        this.maxRepetition = Integer.parseInt(var23_23);
                        if (this.maxRepetition <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.repetition", var23_23));
                        }
                    }
                    catch (NumberFormatException v3) {
                        throw new IllegalArgumentException(this.bind("configure.repetition", var23_23));
                    }
                    var12_12 = 0;
                    break;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(var23_23);
                        if (this.maxProblems <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.maxProblems", var23_23));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", var23_23);
                    }
                    catch (NumberFormatException v4) {
                        throw new IllegalArgumentException(this.bind("configure.maxProblems", var23_23));
                    }
                    var12_12 = 0;
                    break;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateSource", var23_23));
                    }
                    this.didSpecifySource = true;
                    if (var23_23.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (var23_23.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (var23_23.equals("1.5") || var23_23.equals("5") || var23_23.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (var23_23.equals("1.6") || var23_23.equals("6") || var23_23.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else if (var23_23.equals("1.7") || var23_23.equals("7") || var23_23.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    } else {
                        throw new IllegalArgumentException(this.bind("configure.source", var23_23));
                    }
                    var12_12 = 0;
                    break;
                }
                case 8: {
                    if (var16_16) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateDefaultEncoding", var23_23));
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var23_23);
                    }
                    catch (UnsupportedEncodingException v5) {
                        throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", var23_23));
                    }
                    this.options.put("org.eclipse.jdt.core.encoding", var23_23);
                    var16_16 = true;
                    var12_12 = 0;
                    break;
                }
                case 3: {
                    this.setDestinationPath(var23_23.equals("none") != false ? "none" : var23_23);
                    var12_12 = 0;
                    break;
                }
                case 1: {
                    var12_12 = 0;
                    var8_8 += this.processPaths(var25_26, var8_8, var23_23, var5_5);
                    break;
                }
                case 9: {
                    var12_12 = 0;
                    var8_8 += this.processPaths(var25_26, var8_8, var23_23, var2_2);
                    break;
                }
                case 13: {
                    var12_12 = 0;
                    var26_37 = new String[1];
                    var8_8 += this.processPaths(var25_26, var8_8, var23_23, var26_37);
                    var3_3 = var26_37[0];
                    break;
                }
                case 12: {
                    if (var23_23.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-extdir"));
                    }
                    var27_45 = new StringTokenizer(var23_23, File.pathSeparator, false);
                    var6_6 = new ArrayList<String>(4);
                    while (var27_45.hasMoreTokens()) {
                        var6_6.add(var27_45.nextToken());
                    }
                    var12_12 = 0;
                    break;
                }
                case 15: {
                    if (var23_23.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-endorseddirs"));
                    }
                    var27_46 = new StringTokenizer(var23_23, File.pathSeparator, false);
                    var7_7 = new ArrayList<String>(4);
                    while (var27_46.hasMoreTokens()) {
                        var7_7.add(var27_46.nextToken());
                    }
                    var12_12 = 0;
                    break;
                }
                case 16: {
                    if (!var23_23.endsWith("]")) ** GOTO lbl608
                    var21_21 = var23_23.substring(0, var23_23.length() - 1);
                    ** GOTO lbl630
lbl608:
                    // 1 sources

                    throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", "[-d " + var23_23));
                }
                case 17: {
                    var12_12 = 0;
                    break;
                }
                case 18: {
                    var12_12 = 0;
                    break;
                }
                case 19: {
                    var12_12 = 0;
                    break;
                }
                case 20: {
                    var27_47 = new StringTokenizer(var23_23, ",");
                    if (this.classNames == null) {
                        this.classNames = new String[4];
                    }
                    while (var27_47.hasMoreTokens()) {
                        if (this.classNames.length == var10_10) {
                            this.classNames = new String[var10_10 * 2];
                            System.arraycopy(this.classNames, 0, this.classNames, 0, var10_10);
                        }
                        this.classNames[var10_10++] = var27_47.nextToken();
                    }
                    var12_12 = 0;
                    break;
                }
lbl630:
                // 3 sources

                default: {
                    if (var21_21 == null) {
                        if (File.separatorChar != '/') {
                            var23_23 = var23_23.replace('/', File.separatorChar);
                        }
                        if (var23_23.endsWith("[-d")) {
                            var22_22 = var23_23.substring(0, var23_23.length() - 3);
                            var12_12 = 16;
                            break;
                        }
                        var22_22 = var23_23;
                    }
                    if (!(var26_38 = new File(var22_22)).isDirectory()) {
                        throw new IllegalArgumentException(this.bind("configure.unrecognizedOption", var22_22));
                    }
                    var27_48 = FileFinder.find(var26_38, ".JAVA");
                    if ("none".equals(var21_21)) {
                        var21_21 = "none";
                    }
                    if (this.filenames != null) {
                        var28_53 = var27_48.length;
                        this.filenames = new String[var28_53 + var9_9];
                        System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
                        this.encodings = new String[var28_53 + var9_9];
                        System.arraycopy(this.encodings, 0, this.encodings, 0, var9_9);
                        this.destinationPaths = new String[var28_53 + var9_9];
                        System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, var9_9);
                        System.arraycopy(var27_48, 0, this.filenames, var9_9, var28_53);
                        var29_58 = 0;
                        while (var29_58 < var28_53) {
                            this.encodings[var9_9 + var29_58] = var20_20;
                            this.destinationPaths[var9_9 + var29_58] = var21_21;
                            ++var29_58;
                        }
                        var9_9 += var28_53;
                        var20_20 = null;
                        var21_21 = null;
                        var22_22 = null;
                    } else {
                        this.filenames = var27_48;
                        var9_9 = this.filenames.length;
                        this.encodings = new String[var9_9];
                        this.destinationPaths = new String[var9_9];
                        var28_53 = 0;
                        while (var28_53 < var9_9) {
                            this.encodings[var28_53] = var20_20;
                            this.destinationPaths[var28_53] = var21_21;
                            ++var28_53;
                        }
                        var20_20 = null;
                        var21_21 = null;
                        var22_22 = null;
                    }
                    var12_12 = 0;
                }
            }
        }
        if (this.enableJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        } else if (this.warnJavadocOn || this.warnAllJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        }
        if (this.warnJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        }
        if (this.warnAllJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
        }
        if (var13_13 || var9_9 == 0 && var10_10 == 0) {
            if (var14_14 == null) {
                this.printUsage();
            } else {
                this.printUsage(var14_14);
            }
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(var15_15);
        this.validateOptions(var18_18);
        if (!var19_19 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) >= 0x320000L) {
            this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        }
        this.logger.logCommandLineArguments(var25_26);
        this.logger.logOptions(this.options);
        if (this.maxRepetition == 0) {
            this.maxRepetition = 1;
        }
        if (this.maxRepetition >= 3 && (this.timing & 1) != 0) {
            this.compilerStats = new CompilerStats[this.maxRepetition];
        }
        if (var9_9 != 0) {
            this.filenames = new String[var9_9];
            System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
        }
        if (var10_10 != 0) {
            this.classNames = new String[var10_10];
            System.arraycopy(this.classNames, 0, this.classNames, 0, var10_10);
        }
        this.setPaths(var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var20_20);
        if (this.pendingErrors != null) {
            var26_39 = this.pendingErrors.iterator();
            while (var26_39.hasNext()) {
                var27_49 = (String)var26_39.next();
                this.logger.logPendingError(var27_49);
            }
            this.pendingErrors = null;
        }
    }

    protected void disableWarnings() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Map.Entry entry = (Map.Entry)objectArray[n];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++n;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int n = compilationResult.lineSeparatorPositions.length;
                    this.lineDelta += n;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if (Util.EMPTY_STRING.equals(string)) {
            string = null;
        }
        int n2 = 0;
        while (n2 < n) {
            char[] cArray = this.filenames[n2].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new IllegalArgumentException(this.bind("unit.more", this.filenames[n2]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[n2]);
            if (!file.exists()) {
                throw new IllegalArgumentException(this.bind("unit.missing", this.filenames[n2]));
            }
            String string2 = this.encodings[n2];
            if (string2 == null) {
                string2 = string;
            }
            compilationUnitArray[n2] = new CompilationUnit(null, this.filenames[n2], string2, this.destinationPaths[n2]);
            ++n2;
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String string = System.getProperty("java.home");
            if (string != null) {
                this.javaHomeCache = new File(string);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected ArrayList handleBootclasspath(ArrayList arrayList, String string) {
        block10: {
            block11: {
                block9: {
                    int n;
                    int n2 = n = arrayList == null ? 0 : arrayList.size();
                    if (n == 0) break block9;
                    String[] stringArray = new String[n];
                    arrayList.toArray(stringArray);
                    arrayList.clear();
                    int n3 = 0;
                    while (n3 < n) {
                        this.processPathEntries(4, arrayList, stringArray[n3], string, false, true);
                        ++n3;
                    }
                    break block10;
                }
                arrayList = new ArrayList<FileSystem.Classpath>(4);
                String string2 = System.getProperty("java.version");
                if (string2 != null && string2.equalsIgnoreCase("1.1.8")) {
                    this.logger.logWrongJDK();
                    this.proceed = false;
                    return null;
                }
                String string3 = System.getProperty("sun.boot.class.path");
                if (!(string3 != null && string3.length() != 0 || (string3 = System.getProperty("vm.boot.class.path")) != null && string3.length() != 0)) {
                    string3 = System.getProperty("org.apache.harmony.boot.class.path");
                }
                if (string3 == null || string3.length() == 0) break block11;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    FileSystem.Classpath classpath = FileSystem.getClasspath(string4, string, null);
                    if (classpath == null) continue;
                    arrayList.add(classpath);
                }
                break block10;
            }
            File file = this.getJavaHome();
            if (file == null) break block10;
            File[] fileArray = null;
            fileArray = System.getProperty("os.name").startsWith("Mac") ? new File[]{new File(file, "../Classes")} : new File[]{new File(file, "lib")};
            File[][] fileArray2 = Main.getLibrariesFiles(fileArray);
            if (fileArray2 != null) {
                int n = 0;
                int n4 = fileArray2.length;
                while (n < n4) {
                    File[] fileArray3 = fileArray2[n];
                    if (fileArray3 != null) {
                        int n5 = 0;
                        int n6 = fileArray3.length;
                        while (n5 < n6) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray3[n5].getAbsolutePath(), null, false, null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n5;
                        }
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleClasspath(ArrayList arrayList, String string) {
        FileSystem.Classpath classpath;
        Object object;
        Object object2;
        int n;
        int n2 = n = arrayList == null ? 0 : arrayList.size();
        if (n != 0) {
            object2 = new String[n];
            arrayList.toArray((T[])object2);
            arrayList.clear();
            int n3 = 0;
            while (n3 < n) {
                this.processPathEntries(4, arrayList, (String)object2[n3], string, false, true);
                ++n3;
            }
        } else {
            arrayList = new ArrayList<FileSystem.Classpath>(4);
            object2 = System.getProperty("java.class.path");
            if (object2 == null || ((String)object2).length() == 0) {
                this.addPendingErrors(this.bind("configure.noClasspath"));
                FileSystem.Classpath classpath2 = FileSystem.getClasspath(System.getProperty("user.dir"), string, null);
                if (classpath2 != null) {
                    arrayList.add(classpath2);
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    classpath = FileSystem.getClasspath((String)object, string, null);
                    if (classpath != null) {
                        arrayList.add(classpath);
                        continue;
                    }
                    if (((String)object).length() == 0) continue;
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", (String)object));
                }
            }
        }
        object2 = new ArrayList();
        HashMap<String, FileSystem.Classpath> hashMap = new HashMap<String, FileSystem.Classpath>();
        object = new FileSystem.ClasspathSectionProblemReporter(){

            public void invalidClasspathSection(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.invalidClasspathSection", string));
            }

            public void multipleClasspathSections(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.multipleClasspathSections", string));
            }
        };
        while (!arrayList.isEmpty()) {
            classpath = (FileSystem.Classpath)arrayList.remove(0);
            String string2 = classpath.getPath();
            if (hashMap.get(string2) != null) continue;
            hashMap.put(string2, classpath);
            ((ArrayList)object2).add(classpath);
            List list = classpath.fetchLinkedJars((FileSystem.ClasspathSectionProblemReporter)object);
            if (list == null) continue;
            arrayList.addAll(0, list);
        }
        return object2;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.endorsed.dirs");
            if (object == null) {
                if (file != null) {
                    arrayList.add(String.valueOf(file.getAbsolutePath()) + "/lib/endorsed");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            int n = 0;
            while (n < ((File[])object).length) {
                object[n] = new File((String)arrayList.get(n));
                ++n;
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n2 = 0;
                int n3 = fileArray.length;
                while (n2 < n3) {
                    File[] fileArray2 = fileArray[n2];
                    if (fileArray2 != null) {
                        int n4 = 0;
                        int n5 = fileArray2.length;
                        while (n4 < n5) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[n4].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n4;
                        }
                    } else if (object[n2].isFile()) {
                        this.addPendingErrors(this.bind("configure.incorrectEndorsedDirsEntry", object[n2].getAbsolutePath()));
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.ext.dirs");
            if (object == null) {
                arrayList.add(String.valueOf(file.getAbsolutePath()) + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            int n = 0;
            while (n < ((File[])object).length) {
                object[n] = new File((String)arrayList.get(n));
                ++n;
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n2 = 0;
                int n3 = fileArray.length;
                while (n2 < n3) {
                    File[] fileArray2 = fileArray[n2];
                    if (fileArray2 != null) {
                        int n4 = 0;
                        int n5 = fileArray2.length;
                        while (n4 < n5) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[n4].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n4;
                        }
                    } else if (object[n2].isFile()) {
                        this.addPendingErrors(this.bind("configure.incorrectExtDirsEntry", object[n2].getAbsolutePath()));
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected void handleWarningToken(String string, boolean bl) {
        if (string.length() == 0) {
            return;
        }
        switch (string.charAt(0)) {
            case 'a': {
                if (string.equals("allDeprecation")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allJavadoc")) {
                    this.warnAllJavadocOn = this.warnJavadocOn = bl;
                    return;
                }
                if (string.equals("assertIdentifier")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("allDeadCode")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCode", bl ? "warning" : "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", bl ? "enabled" : "disabled");
                return;
            }
            case 'b': {
                if (!string.equals("boxing")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", bl ? "warning" : "ignore");
                return;
            }
            case 'c': {
                if (string.equals("constructorName")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("conditionAssign")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("compareIdentical")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.comparingIdentical", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("charConcat")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", bl ? "warning" : "ignore");
                return;
            }
            case 'd': {
                if (string.equals("deprecation")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
                    return;
                }
                if (string.equals("dep-ann")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("discouraged")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.discouragedReference", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("deadCode")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCode", bl ? "warning" : "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "disabled");
                return;
            }
            case 'e': {
                if (string.equals("enumSwitch") || string.equals("incomplete-switch")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("emptyBlock")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("enumIdentifier")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", bl ? "warning" : "ignore");
                return;
            }
            case 'f': {
                if (string.equals("fieldHiding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("finalBound")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("finally")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("forbidden")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("fallthrough")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", bl ? "warning" : "ignore");
                return;
            }
            case 'h': {
                if (string.equals("hiding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("hashCode")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", bl ? "warning" : "ignore");
                return;
            }
            case 'i': {
                if (string.equals("indirectStatic")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("intfAnnotation")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("intfRedundant")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", bl ? "warning" : "ignore");
                return;
            }
            case 'j': {
                if (!string.equals("javadoc")) break;
                this.warnJavadocOn = bl;
                return;
            }
            case 'l': {
                if (!string.equals("localHiding")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
                return;
            }
            case 'm': {
                if (!string.equals("maskedCatchBlock") && !string.equals("maskedCatchBlocks")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
                return;
            }
            case 'n': {
                if (string.equals("nls")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("noEffectAssign")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("noImplicitStringConversion")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("null")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("nullDereference")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", bl ? "warning" : "ignore");
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "ignore");
                }
                return;
            }
            case 'o': {
                if (string.equals("over-sync")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", bl ? "error" : "ignore");
                    return;
                }
                if (!string.equals("over-ann")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", bl ? "warning" : "ignore");
                return;
            }
            case 'p': {
                if (string.equals("pkgDefaultMethod") || string.equals("packageDefaultMethod")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("paramAssign")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", bl ? "warning" : "ignore");
                return;
            }
            case 'r': {
                if (string.equals("raw")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("redundantSuperinterface")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", bl ? "warning" : "ignore");
                return;
            }
            case 's': {
                if (string.equals("specialParamHiding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("staticReceiver")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("syncOverride")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", bl ? "error" : "ignore");
                    return;
                }
                if (string.equals("semicolon")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("serial")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("suppress")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("static-access")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("super")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", bl ? "warning" : "ignore");
                return;
            }
            case 't': {
                if (string.startsWith("tasks")) {
                    String string2 = Util.EMPTY_STRING;
                    int n = string.indexOf(40);
                    int n2 = string.indexOf(41);
                    if (n >= 0 && n2 >= 0 && n < n2) {
                        string2 = string.substring(n + 1, n2).trim();
                        string2 = string2.replace('|', ',');
                    }
                    if (string2.length() == 0) {
                        throw new IllegalArgumentException(this.bind("configure.invalidTaskTag", string));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl ? string2 : Util.EMPTY_STRING);
                    return;
                }
                if (!string.equals("typeHiding")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
                return;
            }
            case 'u': {
                if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unusedImport") || string.equals("unusedImports")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unusedPrivate")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unusedLabel")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("uselessTypeCheck")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unchecked") || string.equals("unsafe")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unnecessaryElse")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unusedThrown")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", bl ? "warning" : "ignore");
                    return;
                }
                if (string.equals("unused")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", bl ? "warning" : "ignore");
                    return;
                }
                if (!string.equals("unusedTypeArgs")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", bl ? "warning" : "ignore");
                return;
            }
            case 'v': {
                if (!string.equals("varargsCast")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", bl ? "warning" : "ignore");
                return;
            }
            case 'w': {
                if (!string.equals("warningToken")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", bl ? "warning" : "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", bl ? "warning" : "ignore");
                return;
            }
        }
        this.addPendingErrors(this.bind("configure.invalidWarning", string));
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map, CompilationProgress compilationProgress) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.proceed = true;
        this.out = printWriter;
        this.err = printWriter2;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        this.progress = compilationProgress;
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.options.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
        this.classNames = null;
    }

    protected void initializeAnnotationProcessorManager() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jdt.internal.compiler.apt.dispatch.BatchAnnotationProcessorManager");
            AbstractAnnotationProcessorManager abstractAnnotationProcessorManager = (AbstractAnnotationProcessorManager)clazz.newInstance();
            abstractAnnotationProcessorManager.configure(this, this.expandedCommandLine);
            abstractAnnotationProcessorManager.setErr(this.err);
            abstractAnnotationProcessorManager.setOut(this.out);
            this.batchCompiler.annotationProcessorManager = abstractAnnotationProcessorManager;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AbortCompilation();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbortCompilation();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            this.logger.logIncorrectVMVersionForAnnotationProcessing();
        }
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            String string = null;
            boolean bl = false;
            CompilationUnit compilationUnit = (CompilationUnit)compilationResult.compilationUnit;
            if (compilationUnit.destinationPath == null) {
                if (this.destinationPath == null) {
                    string = this.extractDestinationPathFromSourceFile(compilationResult);
                } else if (this.destinationPath != NONE) {
                    string = this.destinationPath;
                    bl = true;
                }
            } else if (compilationUnit.destinationPath != NONE) {
                string = compilationUnit.destinationPath;
                bl = true;
            }
            if (string != null) {
                int n = 0;
                int n2 = classFileArray.length;
                while (n < n2) {
                    ClassFile classFile = classFileArray[n];
                    char[] cArray = classFile.fileName();
                    int n3 = cArray.length;
                    char[] cArray2 = new char[n3 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n3, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string2 = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                        }
                        Util.writeToDisk(bl, string, string2, classFile);
                        this.logger.logClassFile(bl, string, string2);
                        ++this.exportedClassFilesCounter;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(string, string2, iOException);
                    }
                    ++n;
                }
                this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCompilation() {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performMethodsFullRecovery = false;
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler(fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out, this.progress);
        this.batchCompiler.remainingIterations = this.maxRepetition - this.currentRepetition;
        String string = System.getProperty("jdt.compiler.useSingleThread");
        boolean bl = this.batchCompiler.useSingleThread = string != null && string.equals("true");
        if (this.compilerOptions.complianceLevel >= 0x320000L && this.compilerOptions.processAnnotations) {
            if (this.checkVMVersion(0x320000L)) {
                this.initializeAnnotationProcessorManager();
                if (this.classNames != null) {
                    this.batchCompiler.setBinaryTypes(this.processClassNames(this.batchCompiler.lookupEnvironment));
                }
            } else {
                this.logger.logIncorrectVMVersionForAnnotationProcessing();
            }
        }
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.logger.endLoggingSources();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.logger.endLoggingSources();
            if (this.extraProblems != null) {
                this.logger.loggingExtraProblems(this);
                this.extraProblems = null;
            }
            if (this.compilerStats != null) {
                this.compilerStats[this.currentRepetition] = this.batchCompiler.stats;
            }
            this.logger.printStats();
            fileSystem.cleanup();
            return;
        }
    }

    public void printUsage() {
        this.printUsage("misc.usage");
    }

    private void printUsage(String string) {
        this.logger.logUsage(this.bind(string, new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
        this.logger.flush();
    }

    private ReferenceBinding[] processClassNames(LookupEnvironment lookupEnvironment) {
        int n = this.classNames.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = this.classNames[n2];
            Object object2 = null;
            if (string.indexOf(46) != -1) {
                object = string.toCharArray();
                object2 = CharOperation.splitOn('.', (char[])object);
            } else {
                object2 = new char[][]{string.toCharArray()};
            }
            object = lookupEnvironment.getType((char[][])object2);
            if (object != null && ((Binding)object).isValidBinding()) {
                if (((ReferenceBinding)object).isBinaryBinding()) {
                    referenceBindingArray[n2] = object;
                }
            } else {
                throw new IllegalArgumentException(this.bind("configure.invalidClassName", string));
            }
            ++n2;
        }
        return referenceBindingArray;
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(File.pathSeparator) + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = "";
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        int n6 = n5;
                        while (n6 < n3) {
                            string3 = String.valueOf(string3) + (String)arrayList3.get(n6);
                            ++n6;
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
            default: {
                if (string.length() == 0) break;
                this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
            }
        }
    }

    private int processPaths(String[] stringArray, int n, String string, ArrayList arrayList) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n5) {
            switch (string.charAt(n4)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            if (n3 > 1) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[++n2];
                int n6 = 0;
                int n7 = string2.length();
                while (n6 < n7) {
                    switch (string2.charAt(n6)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                            }
                            ++n3;
                            break;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    arrayList.add(stringBuffer.toString());
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        arrayList.add(string);
        return n2 - n;
    }

    private int processPaths(String[] stringArray, int n, String string, String[] stringArray2) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n5) {
            switch (string.charAt(n4)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (++n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[n2];
                int n6 = 0;
                int n7 = string2.length();
                while (n6 < n7) {
                    switch (string2.charAt(n6)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                            }
                            ++n3;
                            break;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    stringArray2[0] = stringBuffer.toString();
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        stringArray2[0] = string;
        return n2 - n;
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    private void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundleFactory.getBundle(locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) {
        arrayList = this.handleBootclasspath(arrayList, string2);
        arrayList3 = this.handleClasspath(arrayList3, string2);
        if (string != null) {
            this.processPathEntries(4, arrayList2, string, string2, true, false);
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(arrayList5);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        arrayList3 = FileSystem.ClasspathNormalizer.normalize(arrayList3);
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
    }

    protected void validateOptions(boolean bl) {
        Object v;
        Object v2;
        if (bl) {
            v2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(v2)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                        }
                    } else if ("1.4".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    }
                }
            } else if ("1.5".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                }
            } else if ("1.6".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if (("1.5".equals(v) || "1.6".equals(v)) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                }
            } else if ("1.7".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) || "1.6".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                }
            }
        } else if (this.didSpecifySource) {
            v2 = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            } else if ("1.7".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                }
            }
        }
        v2 = this.options.get("org.eclipse.jdt.core.compiler.source");
        v = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (v2.equals("1.7") && CompilerOptions.versionToJdkLevel(v) < 0x330000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.7"));
        }
        if (v2.equals("1.6") && CompilerOptions.versionToJdkLevel(v) < 0x320000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (v2.equals("1.5") && CompilerOptions.versionToJdkLevel(v) < 0x310000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (v2.equals("1.4") && CompilerOptions.versionToJdkLevel(v) < 0x300000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            Object v3 = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(v3)) {
                if (CompilerOptions.versionToJdkLevel(v2) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForGenericSource", (String)v3, (String)v2));
                }
            } else if ("cldc1.1".equals(v3)) {
                if (this.didSpecifySource && CompilerOptions.versionToJdkLevel(v2) >= 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleSourceForCldcTarget", (String)v3, (String)v2));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForCldcTarget", (String)v3, (String)v2));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x330000L && CompilerOptions.versionToJdkLevel(v3) < 0x330000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.7"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x320000L && CompilerOptions.versionToJdkLevel(v3) < 0x320000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x310000L && CompilerOptions.versionToJdkLevel(v3) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x300000L && CompilerOptions.versionToJdkLevel(v3) < 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(v) < CompilerOptions.versionToJdkLevel(v3)) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)v3));
                }
            }
        }
    }

    public static class Logger {
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String EXCEPTION = "exception";
        private static final String EXTRA_PROBLEM_TAG = "extra_problem";
        private static final String EXTRA_PROBLEMS = "extra_problems";
        private static final HashtableOfInt FIELD_TABLE = new HashtableOfInt();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String OUTPUT = "output";
        private static final String PACKAGE = "package";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_CATEGORY_ID = "categoryID";
        private static final String ID = "id";
        private static final String PROBLEM_ID = "problemID";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_OPTION_KEY = "optionKey";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.003 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_003.dtd\">";

        static {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> clazz2 = clazz;
                Field[] fieldArray = clazz2.getFields();
                int n = 0;
                int n2 = fieldArray.length;
                while (n < n2) {
                    Field field = fieldArray[n];
                    if (field.getType().equals(Integer.TYPE)) {
                        Integer n3 = (Integer)field.get(null);
                        int n4 = n3 & 0xFFFFFF;
                        if (n4 == 0) {
                            n4 = Integer.MAX_VALUE;
                        }
                        FIELD_TABLE.put(n4, field.getName());
                    }
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingExtraProblems() {
            this.endTag(EXTRA_PROBLEMS);
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).endTag(string, true, true);
            }
        }

        private String errorReportSource(CategorizedProblem categorizedProblem, char[] cArray, int n) {
            char c;
            int n2;
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {}
            }
            int n5 = n2 = cArray == null ? 0 : cArray.length;
            if (n3 > n4 || n3 < 0 && n4 < 0 || n2 == 0) {
                return Messages.problem_noSourceInformation;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 2) == 0) {
                stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(categorizedProblem.getSourceLineNumber())));
                stringBuffer.append(Util.LINE_SEPARATOR);
            }
            stringBuffer.append('\t');
            int n6 = n3 >= n2 ? n2 - 1 : n3;
            while (n6 > 0) {
                c = cArray[n6 - 1];
                if (c == '\n' || c == '\r') break;
                --n6;
            }
            int n7 = n4 >= n2 ? n2 - 1 : n4;
            while (n7 + 1 < n2) {
                c = cArray[n7 + 1];
                if (c == '\r' || c == '\n') break;
                ++n7;
            }
            while ((c = cArray[n6]) == ' ' || c == '\t') {
                ++n6;
            }
            stringBuffer.append(cArray, n6, n7 - n6 + 1);
            stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
            int n8 = n6;
            while (n8 < n3) {
                stringBuffer.append(cArray[n8] == '\t' ? (char)'\t' : ' ');
                ++n8;
            }
            n8 = n3;
            while (n8 <= (n4 >= n2 ? n2 - 1 : n4)) {
                stringBuffer.append('^');
                ++n8;
            }
            return stringBuffer.toString();
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            char c;
            int n;
            int n2 = categorizedProblem.getSourceStart();
            int n3 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {}
            }
            int n4 = n = cArray == null ? 0 : cArray.length;
            if (n2 > n3 || n2 < 0 && n3 < 0 || n <= 0 || n3 > n) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
                return;
            }
            int n5 = n2 >= n ? n - 1 : n2;
            while (n5 > 0) {
                c = cArray[n5 - 1];
                if (c == '\n' || c == '\r') break;
                --n5;
            }
            int n6 = n3 >= n ? n - 1 : n3;
            while (n6 + 1 < n) {
                c = cArray[n6 + 1];
                if (c == '\r' || c == '\n') break;
                ++n6;
            }
            while ((c = cArray[n5]) == ' ' || c == '\t') {
                ++n5;
            }
            while ((c = cArray[n6]) == ' ' || c == '\t') {
                --n6;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n5, n6 - n5 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n2 - n5));
            this.parameters.put(SOURCE_END, Integer.toString(n3 - n5));
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            int n2 = n & 0xFFFFFF;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            return (String)FIELD_TABLE.get(n2);
        }

        private String getProblemOptionKey(int n) {
            int n2 = ProblemReporter.getIrritant(n);
            return CompilerOptions.optionKeyFromIrritant(n2);
        }

        public void logAverage() {
            Arrays.sort(this.main.compilerStats);
            long l = this.main.compilerStats[0].lineCount;
            int n = this.main.maxRepetition;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            int n2 = 1;
            int n3 = n - 1;
            while (n2 < n3) {
                CompilerStats compilerStats = this.main.compilerStats[n2];
                l2 += compilerStats.elapsedTime();
                l3 += compilerStats.parseTime;
                l4 += compilerStats.resolveTime;
                l5 += compilerStats.analyzeTime;
                l6 += compilerStats.generateTime;
                ++n2;
            }
            long l7 = l2 / (long)(n - 2);
            long l8 = l3 / (long)(n - 2);
            long l9 = l4 / (long)(n - 2);
            long l10 = l5 / (long)(n - 2);
            long l11 = l6 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l7), String.valueOf((double)((int)((double)l * 10000.0 / (double)l7)) / 10.0)}));
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(l8), String.valueOf((double)((int)((double)l8 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l9), String.valueOf((double)((int)((double)l9 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l10), String.valueOf((double)((int)((double)l10 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l11), String.valueOf((double)((int)((double)l11 * 1000.0 / (double)l7)) / 10.0)}));
            }
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2 : String.valueOf(string) + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2.substring(n + 1, n2) : String.valueOf(string) + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    String string = classpathArray[n2].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isPotentialZipArchive(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 != null) {
                        this.parameters.put("id", string2);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++n2;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    this.parameters.put("value", stringArray[n2]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n2;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        private void logExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            String string;
            char[] cArray = categorizedProblem.getOriginatingFileName();
            String string2 = string = cArray == null ? this.main.bind("requestor.noFileNameSpecified") : new String(cArray);
            if ((this.tagBits & 2) != 0) {
                String string3 = String.valueOf(string) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string3);
                String string4 = this.errorReportSource(categorizedProblem, null, this.tagBits);
                this.printlnErr(string4);
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(string)) : this.main.bind("requestor.warning", Integer.toString(n2), new String(string)));
                String string5 = this.errorReportSource(categorizedProblem, null, 0);
                this.printlnErr(string5);
                this.printlnErr(categorizedProblem.getMessage());
                this.printlnErr("----------");
            }
        }

        public void loggingExtraProblems(Main main) {
            ArrayList arrayList = main.extraProblems;
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n) {
                    categorizedProblem = (CategorizedProblem)arrayList.get(n6);
                    if (categorizedProblem != null) {
                        ++main.globalProblemsCount;
                        this.logExtraProblem(categorizedProblem, n3, main.globalProblemsCount);
                        ++n3;
                        if (categorizedProblem.isError()) {
                            ++n2;
                            ++n4;
                            ++main.globalErrorsCount;
                        } else if (categorizedProblem.isWarning()) {
                            ++main.globalWarningsCount;
                            ++n5;
                        }
                    }
                    ++n6;
                }
                if ((this.tagBits & 1) != 0 && n4 + n5 != 0) {
                    this.startLoggingExtraProblems(n);
                    n6 = 0;
                    while (n6 < n) {
                        categorizedProblem = (CategorizedProblem)arrayList.get(n6);
                        if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                            this.logXmlExtraProblem(categorizedProblem, n3, main.globalProblemsCount);
                        }
                        ++n6;
                    }
                    this.endLoggingExtraProblems();
                }
            }
        }

        public void logIncorrectVMVersionForAnnotationProcessing() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectVMVersionforAPT"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectVMVersionforAPT"));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Integer(n));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.entrySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray, new Comparator(this){
                    final /* synthetic */ Logger this$1;
                    {
                        this.this$1 = logger;
                    }

                    public int compare(Object object, Object object2) {
                        Map.Entry entry = (Map.Entry)object;
                        Map.Entry entry2 = (Map.Entry)object2;
                        return ((String)entry.getKey()).compareTo((String)entry2.getKey());
                    }
                });
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Map.Entry entry = (Map.Entry)objectArray[n];
                    String string = (String)entry.getKey();
                    this.parameters.put(KEY, string);
                    this.parameters.put("value", entry.getValue());
                    this.printTag(OPTION, this.parameters, true, true);
                    ++n;
                }
                this.endTag(OPTIONS);
            }
        }

        public void logPendingError(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(string);
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = String.valueOf(new String(categorizedProblem.getOriginatingFileName())) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = this.errorReportSource(categorizedProblem, cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = this.errorReportSource(categorizedProblem, cArray, 0);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n) {
                    categorizedProblem = categorizedProblemArray[n7];
                    if (categorizedProblem != null) {
                        ++main.globalProblemsCount;
                        this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                        ++n3;
                        if (categorizedProblem.isError()) {
                            ++n2;
                            ++n4;
                            ++main.globalErrorsCount;
                        } else if (categorizedProblem.getID() == 536871362) {
                            ++main.globalTasksCount;
                            ++n6;
                        } else {
                            ++main.globalWarningsCount;
                            ++n5;
                        }
                    }
                    ++n7;
                }
                if ((this.tagBits & 1) != 0) {
                    if (n4 + n5 != 0) {
                        this.startLoggingProblems(n4, n5);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                                this.logXmlProblem(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingProblems();
                    }
                    if (n6 != 0) {
                        this.startLoggingTasks(n6);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() == 536871362) {
                                this.logXmlTask(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingTasks();
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", new Integer(n));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
                this.parameters.put("tasks", new Integer(n4));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 2) != 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(CompilerStats compilerStats) {
            long l = compilerStats.elapsedTime();
            long l2 = compilerStats.lineCount;
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Long(l));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", new Long(l2));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", new String[]{String.valueOf(l)}));
            }
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(compilerStats.parseTime), String.valueOf((double)((int)((double)compilerStats.parseTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.resolveTime), String.valueOf((double)((int)((double)compilerStats.resolveTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.analyzeTime), String.valueOf((double)((int)((double)compilerStats.analyzeTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.generateTime), String.valueOf((double)((int)((double)compilerStats.generateTime * 1000.0 / (double)l)) / 10.0)}));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            boolean bl = categorizedProblem.isError();
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n3));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n4));
            this.printTag(EXTRA_PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, null);
            this.endTag(EXTRA_PROBLEM_TAG);
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            int n3 = categorizedProblem.getID();
            this.parameters.put("id", this.getFieldName(n3));
            this.parameters.put(PROBLEM_ID, new Integer(n3));
            boolean bl = categorizedProblem.isError();
            int n4 = bl ? 1 : 0;
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n2));
            String string = this.getProblemOptionKey(n3);
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            int n5 = ProblemReporter.getProblemCategory(n4, n3);
            this.parameters.put(PROBLEM_CATEGORY_ID, new Integer(n5));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            String[] stringArray = categorizedProblem.getArguments();
            int n6 = stringArray.length;
            if (n6 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                int n7 = 0;
                while (n7 < n6) {
                    this.parameters.put("value", stringArray[n7]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n7;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(categorizedProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(categorizedProblem.getSourceEnd()));
            String string = this.getProblemOptionKey(categorizedProblem.getID());
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl;
            boolean bl2 = bl = (this.main.timing & 1) != 0;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                CompilerStats compilerStats = this.main.batchCompiler.stats;
                compilerStats.startTime = this.main.startTime;
                compilerStats.endTime = System.currentTimeMillis();
                this.logTiming(compilerStats);
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            }
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
            try {
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    if (string.substring(n).toLowerCase().equals(".xml")) {
                        this.log = new GenericXMLWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), "UTF-8"), Util.LINE_SEPARATOR, true);
                        this.tagBits |= 1;
                        this.log.println("<!-- " + dateFormat.format(date) + " -->");
                        this.log.println(XML_DTD_DECLARATION);
                        this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                        this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                        this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                        this.printTag(COMPILER, this.parameters, true, false);
                    } else {
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                    }
                } else {
                    this.log = new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLog", string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLogInvalidEncoding", string));
            }
        }

        private void startLoggingExtraProblems(int n) {
            this.parameters.put("problems", new Integer(n));
            this.printTag(EXTRA_PROBLEMS, this.parameters, true, false);
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", new Integer(n + n2));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n2));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                if (iCompilationUnit != null) {
                    char[][] cArray;
                    char[] cArray2 = iCompilationUnit.getFileName();
                    File file = new File(new String(cArray2));
                    if (cArray2 != null) {
                        this.parameters.put(PATH, file.getAbsolutePath());
                    }
                    if ((cArray = compilationResult.packageName) != null) {
                        this.parameters.put(PACKAGE, new String(CharOperation.concatWith(cArray, File.separatorChar)));
                    }
                    CompilationUnit compilationUnit = (CompilationUnit)iCompilationUnit;
                    String string = compilationUnit.destinationPath;
                    if (string == null) {
                        string = this.main.destinationPath;
                    }
                    if (string != null && string != Main.NONE) {
                        if (File.separatorChar == '/') {
                            this.parameters.put(OUTPUT, string);
                        } else {
                            this.parameters.put(OUTPUT, string.replace('/', File.separatorChar));
                        }
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", new Integer(n));
                this.printTag("tasks", this.parameters, true, false);
            }
        }
    }

    public static class ResourceBundleFactory {
        private static HashMap Cache = new HashMap();

        public static synchronized ResourceBundle getBundle(Locale locale) {
            ResourceBundle resourceBundle = (ResourceBundle)Cache.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(Main.bundleName, locale);
                Cache.put(locale, resourceBundle);
            }
            return resourceBundle;
        }
    }
}

