/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;

    public FinallyFlowContext(FlowContext flowContext, ASTNode aSTNode) {
        super(flowContext, aSTNode);
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n = 0;
        while (n < this.assignCount) {
            object = this.finalVariables[n];
            if (object != null) {
                boolean bl = false;
                if (object instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)object)) {
                        bl = true;
                        blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)object, this.finalAssignments[n]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)object)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)object, this.finalAssignments[n]);
                }
                if (bl) {
                    FlowContext flowContext = this.parent;
                    while (flowContext != null) {
                        flowContext.removeFinalAssignmentIfAny(this.finalAssignments[n]);
                        flowContext = flowContext.parent;
                    }
                }
            }
            ++n;
        }
        if (this.deferNullDiagnostic) {
            n = 0;
            while (n < this.nullCount) {
                this.parent.recordUsingNullReference(blockScope, this.nullLocals[n], this.nullReferences[n], this.nullCheckTypes[n], flowInfo);
                ++n;
            }
        } else {
            n = 0;
            while (n < this.nullCount) {
                object = this.nullReferences[n];
                LocalVariableBinding localVariableBinding = this.nullLocals[n];
                block0 : switch (this.nullCheckTypes[n]) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if (this.nullCheckTypes[n] == 512) {
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, (ASTNode)object);
                                break;
                            }
                            blockScope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, (ASTNode)object);
                            break;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) break;
                        switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                            case 256: {
                                blockScope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, (ASTNode)object);
                                break block0;
                            }
                            case 512: {
                                blockScope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, (ASTNode)object);
                                break block0;
                            }
                            case 768: {
                                blockScope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, (ASTNode)object);
                                break block0;
                            }
                            case 1024: {
                                blockScope.problemReporter().localVariableNullInstanceof(localVariableBinding, (ASTNode)object);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)object);
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                        blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)object);
                    }
                }
                ++n;
            }
        }
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Finally flow context");
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        block32: {
            block34: {
                block33: {
                    if ((flowInfo.tagBits & 1) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) break block32;
                    if (!this.deferNullDiagnostic) break block33;
                    switch (n) {
                        case 256: 
                        case 257: 
                        case 512: 
                        case 513: 
                        case 769: 
                        case 1025: {
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                if (n == 512) {
                                    scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                                } else {
                                    scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                                }
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                switch (n & 0xFFFFFF00) {
                                    case 256: {
                                        scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                        return;
                                    }
                                    case 512: {
                                        scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                        return;
                                    }
                                    case 768: {
                                        scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                        return;
                                    }
                                    case 1024: {
                                        scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                        return;
                                    }
                                }
                                break;
                            }
                            break block34;
                        }
                        case 3: {
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            break block34;
                        }
                    }
                    break block34;
                }
                switch (n) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if (n == 512) {
                                scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                            } else {
                                scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                            }
                            return;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) break;
                        switch (n & 0xFFFFFF00) {
                            case 256: {
                                scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                return;
                            }
                            case 512: {
                                scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                return;
                            }
                            case 768: {
                                scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                return;
                            }
                            case 1024: {
                                scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                return;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                            return;
                        }
                        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        if (!flowInfo.isDefinitelyNonNull(localVariableBinding)) break;
                        return;
                    }
                }
            }
            this.recordNullReference(localVariableBinding, expression, n);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int n = 0;
        while (n < this.assignCount) {
            if (this.finalAssignments[n] == reference) {
                this.finalAssignments[n] = null;
                this.finalVariables[n] = null;
                return;
            }
            ++n;
        }
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            int n2 = this.nullCount * 2;
            this.nullLocals = new LocalVariableBinding[n2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[n2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[n2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = n;
    }
}

