/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public final class ArrayBinding
extends TypeBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, TypeBinding.INT, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;

    public ArrayBinding(TypeBinding typeBinding, int n, LookupEnvironment lookupEnvironment) {
        this.tagBits |= 1L;
        this.leafComponentType = typeBinding;
        this.dimensions = n;
        this.environment = lookupEnvironment;
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        } else {
            this.tagBits |= typeBinding.tagBits & 0x60000880L;
        }
    }

    public TypeBinding closestMatch() {
        if (this.isValidBinding()) {
            return this;
        }
        TypeBinding typeBinding = this.leafComponentType.closestMatch();
        if (typeBinding == null) {
            return null;
        }
        return this.environment.createArrayType(this.leafComponentType.closestMatch(), this.dimensions);
    }

    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            list = this.leafComponentType.collectMissingTypes(list);
        }
        return list;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        if ((this.tagBits & 0x20000000L) == 0L) {
            return;
        }
        if (typeBinding == TypeBinding.NULL) {
            return;
        }
        switch (typeBinding.kind()) {
            case 68: {
                int n2 = typeBinding.dimensions();
                if (n2 == this.dimensions) {
                    this.leafComponentType.collectSubstitutes(scope, typeBinding.leafComponentType(), inferenceContext, n);
                    break;
                }
                if (n2 <= this.dimensions) break;
                ArrayBinding arrayBinding = this.environment.createArrayType(typeBinding.leafComponentType(), n2 - this.dimensions);
                this.leafComponentType.collectSubstitutes(scope, arrayBinding, inferenceContext, n);
                break;
            }
        }
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = new char[this.dimensions];
        int n = this.dimensions - 1;
        while (n >= 0) {
            cArray[n] = 91;
            --n;
        }
        return CharOperation.concat(cArray, this.leafComponentType.computeUniqueKey(bl));
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] cArray = new char[this.dimensions];
        int n = this.dimensions - 1;
        while (n >= 0) {
            cArray[n] = 91;
            --n;
        }
        this.constantPoolName = CharOperation.concat(cArray, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(this.dimensions * 2);
        int n = this.dimensions;
        while (--n >= 0) {
            stringBuffer.append("[]");
        }
        return String.valueOf(this.leafComponentType.debugName()) + stringBuffer.toString();
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1);
    }

    public TypeBinding erasure() {
        TypeBinding typeBinding = this.leafComponentType.erasure();
        if (this.leafComponentType != typeBinding) {
            return this.environment.createArrayType(typeBinding, this.dimensions);
        }
        return this;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] cArray = new char[this.dimensions];
            int n = this.dimensions - 1;
            while (n >= 0) {
                cArray[n] = 91;
                --n;
            }
            this.genericTypeSignature = CharOperation.concat(cArray, this.leafComponentType.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    public boolean isCompatibleWith(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isCompatibleWith(arrayBinding.leafComponentType);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 4100: {
                if (typeBinding.isCapture()) {
                    CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = captureBinding.lowerBound;
                    if (typeBinding2 != null) {
                        if (!typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2);
                    }
                }
                return false;
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public int kind() {
        return 68;
    }

    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    public int problemId() {
        return this.leafComponentType.problemId();
    }

    public char[] qualifiedSourceName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), cArray);
    }

    public char[] readableName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), cArray);
    }

    public char[] shortReadableName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), cArray);
    }

    public char[] sourceName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), cArray);
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.leafComponentType == unresolvedReferenceBinding) {
            this.leafComponentType = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            this.tagBits |= this.leafComponentType.tagBits & 0x60000080L;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }
}

