/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public HashtableOfObject typeOrPackageCache;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private SimpleNameVector rootReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;
    private int captureID = 1;

    public CompilationUnitScope(CompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super(4, null);
        this.environment = lookupEnvironment;
        this.referenceContext = compilationUnitDeclaration;
        compilationUnitDeclaration.scope = this;
        char[][] cArray = this.currentPackageName = compilationUnitDeclaration.currentPackage == null ? CharOperation.NO_CHAR_CHAR : compilationUnitDeclaration.currentPackage.tokens;
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.rootReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.rootReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypes = null;
        }
    }

    void buildFieldsAndMethods() {
        int n = 0;
        int n2 = this.topLevelTypes.length;
        while (n < n2) {
            this.topLevelTypes[n].scope.buildFieldsAndMethods();
            ++n;
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        Object object;
        this.topLevelTypes = new SourceTypeBinding[0];
        boolean bl = false;
        if (this.referenceContext.compilationResult.compilationUnit != null && (object = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, object)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = ((char[][])object).length == 0 ? CharOperation.NO_CHAR_CHAR : object;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.fPackage == null) {
                this.problemReporter().mustSpecifyPackage(this.referenceContext);
                return;
            }
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                if (this.referenceContext.currentPackage != null) {
                    this.problemReporter().packageCollidesWithType(this.referenceContext);
                }
                return;
            }
            if (this.referenceContext.isPackageInfo()) {
                if (this.referenceContext.types == null || this.referenceContext.types.length == 0) {
                    this.referenceContext.types = new TypeDeclaration[1];
                    this.referenceContext.createPackageInfoType();
                    bl = true;
                }
                if (this.referenceContext.currentPackage != null) {
                    this.referenceContext.types[0].annotations = this.referenceContext.currentPackage.annotations;
                }
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        int n = (object = (Object)this.referenceContext.types) == null ? 0 : ((char[][])object).length;
        this.topLevelTypes = new SourceTypeBinding[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char[] cArray = object[n3];
            if (this.environment.isProcessingAnnotations && this.environment.isMissingType(cArray.name)) {
                throw new SourceTypeCollisionException();
            }
            ReferenceBinding referenceBinding = this.fPackage.getType0(cArray.name);
            this.recordSimpleReference(cArray.name);
            if (referenceBinding != null && referenceBinding.isValidBinding() && !(referenceBinding instanceof UnresolvedReferenceBinding)) {
                if (this.environment.isProcessingAnnotations) {
                    throw new SourceTypeCollisionException();
                }
                this.problemReporter().duplicateTypes(this.referenceContext, (TypeDeclaration)cArray);
            } else {
                Object object2;
                if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(cArray.name) != null) {
                    this.problemReporter().typeCollidesWithPackage(this.referenceContext, (TypeDeclaration)cArray);
                }
                if ((cArray.modifiers & 1) != 0 && (object2 = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals((char[])object2, cArray.name)) {
                    this.problemReporter().publicClassMustMatchFileName(this.referenceContext, (TypeDeclaration)cArray);
                }
                object2 = new ClassScope(this, (TypeDeclaration)cArray);
                SourceTypeBinding sourceTypeBinding = ((ClassScope)object2).buildType(null, this.fPackage, accessRestriction);
                if (bl && n3 == 0) {
                    sourceTypeBinding.modifiers |= 0x1000;
                }
                if (sourceTypeBinding != null) {
                    this.topLevelTypes[n2++] = sourceTypeBinding;
                }
            }
            ++n3;
        }
        if (n2 != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[n2];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, n2);
        }
    }

    void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int n = this.referenceContext.imports.length;
        int n2 = n + 1;
        int n3 = 0;
        while (n3 < n) {
            ImportReference importReference = this.referenceContext.imports[n3];
            if ((importReference.bits & 0x20000) != 0 && CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) && !importReference.isStatic()) {
                --n2;
                break;
            }
            ++n3;
        }
        ImportBinding[] importBindingArray = new ImportBinding[n2];
        importBindingArray[0] = this.getDefaultImports()[0];
        int n4 = 1;
        int n5 = 0;
        while (n5 < n) {
            block10: {
                ImportReference importReference = this.referenceContext.imports[n5];
                char[][] cArray = importReference.tokens;
                int n6 = 0;
                while (n6 < n4) {
                    ImportBinding importBinding = importBindingArray[n6];
                    if (importBinding.onDemand != ((importReference.bits & 0x20000) != 0) || importBinding.isStatic() != importReference.isStatic() || !CharOperation.equals(cArray, importBindingArray[n6].compoundName)) {
                        ++n6;
                        continue;
                    }
                    break block10;
                }
                if ((importReference.bits & 0x20000) != 0) {
                    Binding binding;
                    if (!(CharOperation.equals(cArray, this.currentPackageName) || !(binding = this.findImport(cArray, cArray.length)).isValidBinding() || importReference.isStatic() && binding instanceof PackageBinding)) {
                        importBindingArray[n4++] = new ImportBinding(cArray, true, binding, importReference);
                    }
                } else {
                    importBindingArray[n4++] = new ImportBinding(cArray, false, null, importReference);
                }
            }
            ++n5;
        }
        if (importBindingArray.length > n4) {
            ImportBinding[] importBindingArray2 = importBindingArray;
            importBindingArray = new ImportBinding[n4];
            System.arraycopy(importBindingArray2, 0, importBindingArray, 0, n4);
        }
        this.imports = importBindingArray;
    }

    void checkParameterizedTypes() {
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            return;
        }
        int n = 0;
        int n2 = this.topLevelTypes.length;
        while (n < n2) {
            ClassScope classScope = this.topLevelTypes[n].scope;
            classScope.checkParameterizedTypeBounds();
            classScope.checkParameterizedSuperTypeCollisions();
            ++n;
        }
    }

    public char[] computeConstantPoolName(LocalTypeBinding localTypeBinding) {
        char[] cArray;
        boolean bl;
        if (localTypeBinding.constantPoolName() != null) {
            return localTypeBinding.constantPoolName();
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding sourceTypeBinding = localTypeBinding.scope.outerMostClassScope().enclosingSourceType();
        int n = 0;
        boolean bl2 = bl = this.compilerOptions().complianceLevel >= 0x310000L;
        while (true) {
            cArray = localTypeBinding.isMemberType() ? (n == 0 ? CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), localTypeBinding.sourceName, '$') : CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), '$', String.valueOf(n).toCharArray(), '$', localTypeBinding.sourceName)) : (localTypeBinding.isAnonymousType() ? (bl ? CharOperation.concat(localTypeBinding.enclosingType.constantPoolName(), String.valueOf(n + 1).toCharArray(), '$') : CharOperation.concat(sourceTypeBinding.constantPoolName(), String.valueOf(n + 1).toCharArray(), '$')) : (bl ? CharOperation.concat(CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), String.valueOf(n + 1).toCharArray(), '$'), localTypeBinding.sourceName) : CharOperation.concat(sourceTypeBinding.constantPoolName(), '$', String.valueOf(n + 1).toCharArray(), '$', localTypeBinding.sourceName)));
            if (this.constantPoolNameUsage.get(cArray) == null) break;
            ++n;
        }
        this.constantPoolNameUsage.put(cArray, localTypeBinding);
        return cArray;
    }

    void connectTypeHierarchy() {
        int n = 0;
        int n2 = this.topLevelTypes.length;
        while (n < n2) {
            this.topLevelTypes[n].scope.connectTypeHierarchy();
            ++n;
        }
    }

    void faultInImports() {
        Object object;
        int n;
        if (this.typeOrPackageCache != null) {
            return;
        }
        if (this.referenceContext.imports == null) {
            this.typeOrPackageCache = new HashtableOfObject(1);
            return;
        }
        int n2 = this.referenceContext.imports.length;
        HashtableOfType hashtableOfType = null;
        int n3 = 0;
        while (n3 < n2) {
            if ((this.referenceContext.imports[n3].bits & 0x20000) == 0) {
                hashtableOfType = new HashtableOfType(this.topLevelTypes.length + n2);
                n = 0;
                int n4 = this.topLevelTypes.length;
                while (n < n4) {
                    hashtableOfType.put(this.topLevelTypes[n].sourceName, this.topLevelTypes[n]);
                    ++n;
                }
                break;
            }
            ++n3;
        }
        n3 = n2 + 1;
        n = 0;
        while (n < n2) {
            ImportReference importReference = this.referenceContext.imports[n];
            if ((importReference.bits & 0x20000) != 0 && CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) && !importReference.isStatic()) {
                --n3;
                break;
            }
            ++n;
        }
        ImportBinding[] importBindingArray = new ImportBinding[n3];
        importBindingArray[0] = this.getDefaultImports()[0];
        int n5 = 1;
        int n6 = 0;
        while (n6 < n2) {
            block27: {
                Binding binding;
                Binding binding2;
                ImportReference importReference;
                block33: {
                    Binding binding3;
                    block31: {
                        Binding binding4;
                        block32: {
                            ReferenceBinding referenceBinding;
                            block30: {
                                block29: {
                                    block28: {
                                        importReference = this.referenceContext.imports[n6];
                                        object = importReference.tokens;
                                        int n7 = 0;
                                        while (n7 < n5) {
                                            binding2 = importBindingArray[n7];
                                            if (((ImportBinding)binding2).onDemand == ((importReference.bits & 0x20000) != 0) && ((ImportBinding)binding2).isStatic() == importReference.isStatic() && CharOperation.equals(object, ((ImportBinding)binding2).compoundName)) {
                                                this.problemReporter().unusedImport(importReference);
                                                break block27;
                                            }
                                            ++n7;
                                        }
                                        if ((importReference.bits & 0x20000) == 0) break block28;
                                        if (CharOperation.equals(object, this.currentPackageName)) {
                                            this.problemReporter().unusedImport(importReference);
                                        } else {
                                            Binding binding5 = this.findImport((char[][])object, ((char[][])object).length);
                                            if (!binding5.isValidBinding()) {
                                                this.problemReporter().importProblem(importReference, binding5);
                                            } else if (importReference.isStatic() && binding5 instanceof PackageBinding) {
                                                this.problemReporter().cannotImportPackage(importReference);
                                            } else {
                                                importBindingArray[n5++] = new ImportBinding((char[][])object, true, binding5, importReference);
                                            }
                                        }
                                        break block27;
                                    }
                                    binding = this.findSingleImport((char[][])object, 13, importReference.isStatic());
                                    if (binding.isValidBinding() || binding.problemId() == 3) break block29;
                                    this.problemReporter().importProblem(importReference, binding);
                                    break block27;
                                }
                                if (!(binding instanceof PackageBinding)) break block30;
                                this.problemReporter().cannotImportPackage(importReference);
                                break block27;
                            }
                            binding2 = null;
                            if (binding instanceof MethodBinding && !(binding2 = (ReferenceBinding)this.getType((char[][])object, ((char[][])object).length)).isValidBinding()) {
                                binding2 = null;
                            }
                            if (!(binding instanceof ReferenceBinding) && binding2 == null) break block31;
                            binding4 = binding2 == null ? (ReferenceBinding)binding : binding2;
                            Binding binding6 = binding3 = binding4.problemId() == 3 ? ((ProblemReferenceBinding)binding4).closestMatch : binding4;
                            if (importReference.isTypeUseDeprecated((TypeBinding)binding3, this)) {
                                this.problemReporter().deprecatedType((TypeBinding)binding3, importReference);
                            }
                            if ((referenceBinding = hashtableOfType.get(object[((char[][])object).length - 1])) == null) break block32;
                            if (referenceBinding != binding4) {
                                int n8 = 0;
                                int n9 = this.topLevelTypes.length;
                                while (n8 < n9) {
                                    if (CharOperation.equals(this.topLevelTypes[n8].sourceName, referenceBinding.sourceName)) {
                                        this.problemReporter().conflictingImport(importReference);
                                        break block27;
                                    }
                                    ++n8;
                                }
                                this.problemReporter().duplicateImport(importReference);
                            }
                            break block27;
                        }
                        hashtableOfType.put(object[((char[][])object).length - 1], (ReferenceBinding)binding4);
                        break block33;
                    }
                    if (binding instanceof FieldBinding) {
                        int n10 = 0;
                        while (n10 < n5) {
                            binding3 = importBindingArray[n10];
                            if (((ImportBinding)binding3).isStatic() && ((ImportBinding)binding3).resolvedImport instanceof FieldBinding && binding != ((ImportBinding)binding3).resolvedImport && CharOperation.equals(object[((char[][])object).length - 1], ((ImportBinding)binding3).compoundName[((ImportBinding)binding3).compoundName.length - 1])) {
                                this.problemReporter().duplicateImport(importReference);
                                break block27;
                            }
                            ++n10;
                        }
                    }
                }
                importBindingArray[n5++] = binding2 == null ? new ImportBinding((char[][])object, false, binding, importReference) : new ImportConflictBinding((char[][])object, binding, (ReferenceBinding)binding2, importReference);
            }
            ++n6;
        }
        if (importBindingArray.length > n5) {
            ImportBinding[] importBindingArray2 = importBindingArray;
            importBindingArray = new ImportBinding[n5];
            System.arraycopy(importBindingArray2, 0, importBindingArray, 0, n5);
        }
        this.imports = importBindingArray;
        n6 = this.imports.length;
        this.typeOrPackageCache = new HashtableOfObject(n6);
        int n11 = 0;
        while (n11 < n6) {
            object = this.imports[n11];
            if (!object.onDemand && object.resolvedImport instanceof ReferenceBinding || object instanceof ImportConflictBinding) {
                this.typeOrPackageCache.put(object.compoundName[object.compoundName.length - 1], object);
            }
            ++n11;
        }
    }

    public void faultInTypes() {
        this.faultInImports();
        int n = 0;
        int n2 = this.topLevelTypes.length;
        while (n < n2) {
            this.topLevelTypes[n].faultInTypesForFieldsAndMethods();
            ++n;
        }
    }

    public Binding findImport(char[][] cArray, boolean bl, boolean bl2) {
        if (bl2) {
            return this.findImport(cArray, cArray.length);
        }
        return this.findSingleImport(cArray, 13, bl);
    }

    private Binding findImport(char[][] cArray, int n) {
        Binding binding;
        int n2;
        Binding binding2;
        block12: {
            this.recordQualifiedReference(cArray);
            binding2 = this.environment.getTopLevelPackage(cArray[0]);
            n2 = 1;
            if (binding2 != null) {
                binding = binding2;
                while (n2 < n) {
                    if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null || !binding2.isValidBinding()) {
                        binding2 = null;
                    } else if (binding2 instanceof PackageBinding) {
                        binding = (PackageBinding)binding2;
                        continue;
                    }
                    break block12;
                }
                return binding;
            }
        }
        if (binding2 == null) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            binding = this.findType(cArray[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (binding == null || !binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            n2 = 1;
        } else {
            binding = (ReferenceBinding)binding2;
        }
        while (n2 < n) {
            char[] cArray2;
            if (!((ReferenceBinding)(binding = (ReferenceBinding)this.environment.convertToRawType((TypeBinding)binding, false))).canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
            }
            if ((binding = ((ReferenceBinding)binding).getMemberType(cArray2 = cArray[n2++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
        }
        if (!((ReferenceBinding)binding).canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 2);
        }
        return binding;
    }

    private Binding findSingleImport(char[][] cArray, int n, boolean bl) {
        if (cArray.length == 1) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(cArray, null, 1);
            }
            ReferenceBinding referenceBinding = this.findType(cArray[0], this.environment.defaultPackage, this.fPackage);
            if (referenceBinding == null) {
                return new ProblemReferenceBinding(cArray, null, 1);
            }
            return referenceBinding;
        }
        if (bl) {
            return this.findSingleStaticImport(cArray, n);
        }
        return this.findImport(cArray, cArray.length);
    }

    private Binding findSingleStaticImport(char[][] cArray, int n) {
        MethodBinding methodBinding;
        FieldBinding fieldBinding;
        Binding binding = this.findImport(cArray, cArray.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] cArray2 = cArray[cArray.length - 1];
        if (binding instanceof PackageBinding) {
            Binding binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray2);
            if (binding2 != null && binding2 instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding2, 14);
            }
            return binding;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        FieldBinding fieldBinding2 = fieldBinding = (n & 1) != 0 ? this.findField(referenceBinding, cArray2, null, true) : null;
        if (fieldBinding != null) {
            if (fieldBinding.problemId() == 3 && ((ProblemFieldBinding)fieldBinding).closestMatch.isStatic()) {
                return fieldBinding;
            }
            if (fieldBinding.isValidBinding() && fieldBinding.isStatic() && fieldBinding.canBeSeenBy(referenceBinding, null, this)) {
                return fieldBinding;
            }
        }
        MethodBinding methodBinding2 = methodBinding = (n & 8) != 0 ? this.findStaticMethod(referenceBinding, cArray2) : null;
        if (methodBinding != null) {
            return methodBinding;
        }
        if ((referenceBinding = this.findMemberType(cArray2, referenceBinding)) == null || !referenceBinding.isStatic()) {
            if (fieldBinding != null && !fieldBinding.isValidBinding() && fieldBinding.problemId() != 1) {
                return fieldBinding;
            }
            return new ProblemReferenceBinding(cArray, referenceBinding, 1);
        }
        if (referenceBinding.isValidBinding() && !referenceBinding.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 2);
        }
        if (referenceBinding.problemId() == 2) {
            return new ProblemReferenceBinding(cArray, ((ProblemReferenceBinding)referenceBinding).closestMatch, 2);
        }
        return referenceBinding;
    }

    private MethodBinding findStaticMethod(ReferenceBinding referenceBinding, char[] cArray) {
        if (!referenceBinding.canBeSeenBy(this)) {
            return null;
        }
        do {
            referenceBinding.initializeForStaticImports();
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
            if (methodBindingArray == Binding.NO_METHODS) continue;
            int n = methodBindingArray.length;
            while (--n >= 0) {
                MethodBinding methodBinding = methodBindingArray[n];
                if (!methodBinding.isStatic() || !methodBinding.canBeSeenBy(this.fPackage)) continue;
                return methodBinding;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return null;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding binding = this.environment.getTopLevelPackage(TypeConstants.JAVA);
        if (binding != null) {
            binding = binding.getTypeOrPackage(TypeConstants.JAVA_LANG[1]);
        }
        if (binding == null || !binding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceContext, this.environment.missingClassFileLocation);
            MissingTypeBinding missingTypeBinding = this.environment.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            binding = missingTypeBinding.fPackage;
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(TypeConstants.JAVA_LANG, true, binding, null)};
        return this.environment.defaultImports;
    }

    public final Binding getImport(char[][] cArray, boolean bl, boolean bl2) {
        if (bl) {
            return this.findImport(cArray, cArray.length);
        }
        return this.findSingleImport(cArray, 13, bl2);
    }

    public int nextCaptureID() {
        return this.captureID++;
    }

    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] object) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int n = ((char[][])object).length;
        if (n > 1) {
            this.recordRootReference(object[0]);
            while (!this.qualifiedReferences.contains((char[][])object)) {
                this.qualifiedReferences.add((char[][])object);
                if (n == 2) {
                    this.recordSimpleReference(object[0]);
                    this.recordSimpleReference(object[1]);
                    return;
                }
                this.recordSimpleReference(object[--n]);
                char[][] cArray = object;
                char[][] cArrayArray = new char[n][];
                object = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, n);
            }
        } else if (n == 1) {
            this.recordRootReference(object[0]);
            this.recordSimpleReference(object[0]);
        }
    }

    void recordReference(char[][] cArray, char[] cArray2) {
        this.recordQualifiedReference(cArray);
        if (cArray.length == 0) {
            this.recordRootReference(cArray2);
        }
        this.recordSimpleReference(cArray2);
    }

    void recordReference(ReferenceBinding referenceBinding, char[] cArray) {
        ReferenceBinding referenceBinding2 = this.typeToRecord(referenceBinding);
        if (referenceBinding2 != null) {
            this.recordReference(referenceBinding2.compoundName, cArray);
        }
    }

    void recordRootReference(char[] cArray) {
        if (this.rootReferences == null) {
            return;
        }
        if (!this.rootReferences.contains(cArray)) {
            this.rootReferences.add(cArray);
        }
    }

    void recordSimpleReference(char[] cArray) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(cArray)) {
            this.simpleNameReferences.add(cArray);
        }
    }

    void recordSuperTypeReference(TypeBinding typeBinding) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding referenceBinding = this.typeToRecord(typeBinding);
        if (referenceBinding != null && !this.referencedSuperTypes.containsIdentical(referenceBinding)) {
            this.referencedSuperTypes.add(referenceBinding);
        }
    }

    public void recordTypeConversion(TypeBinding typeBinding, TypeBinding typeBinding2) {
        this.recordSuperTypeReference(typeBinding2);
    }

    void recordTypeReference(TypeBinding typeBinding) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding referenceBinding = this.typeToRecord(typeBinding);
        if (referenceBinding != null && !this.referencedTypes.containsIdentical(referenceBinding)) {
            this.referencedTypes.add(referenceBinding);
        }
    }

    void recordTypeReferences(TypeBinding[] typeBindingArray) {
        if (this.referencedTypes == null) {
            return;
        }
        if (typeBindingArray == null || typeBindingArray.length == 0) {
            return;
        }
        int n = 0;
        int n2 = typeBindingArray.length;
        while (n < n2) {
            ReferenceBinding referenceBinding = this.typeToRecord(typeBindingArray[n]);
            if (referenceBinding != null && !this.referencedTypes.containsIdentical(referenceBinding)) {
                this.referencedTypes.add(referenceBinding);
            }
            ++n;
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding, int n) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, n, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (importBinding.resolvedImport.problemId() == 3) {
                    return importBinding.resolvedImport;
                }
                if (this.imports != null) {
                    ImportBinding[] importBindingArray = new ImportBinding[this.imports.length - 1];
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = this.imports.length;
                    while (n2 < n4) {
                        if (this.imports[n2] != importBinding) {
                            importBindingArray[n3++] = this.imports[n2];
                        }
                        ++n2;
                    }
                    this.imports = importBindingArray;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int n;
        ReferenceBinding referenceBinding;
        int n2 = 0;
        while (n2 < this.referencedSuperTypes.size) {
            ReferenceBinding[] referenceBindingArray;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.referencedSuperTypes.elementAt(n2);
            if (!this.referencedTypes.containsIdentical(referenceBinding2)) {
                this.referencedTypes.add(referenceBinding2);
            }
            if (!referenceBinding2.isLocalType() && (referenceBinding = referenceBinding2.enclosingType()) != null) {
                this.recordSuperTypeReference(referenceBinding);
            }
            if ((referenceBinding = referenceBinding2.superclass()) != null) {
                this.recordSuperTypeReference(referenceBinding);
            }
            if ((referenceBindingArray = referenceBinding2.superInterfaces()) != null) {
                n = 0;
                int n3 = referenceBindingArray.length;
                while (n < n3) {
                    this.recordSuperTypeReference(referenceBindingArray[n]);
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        int n4 = this.referencedTypes.size;
        while (n2 < n4) {
            referenceBinding = (ReferenceBinding)this.referencedTypes.elementAt(n2);
            if (!referenceBinding.isLocalType()) {
                this.recordQualifiedReference(referenceBinding.isMemberType() ? CharOperation.splitOn('.', referenceBinding.readableName()) : referenceBinding.compoundName);
            }
            ++n2;
        }
        n2 = this.qualifiedReferences.size;
        char[][][] cArrayArray = new char[n2][][];
        int n5 = 0;
        while (n5 < n2) {
            cArrayArray[n5] = this.qualifiedReferences.elementAt(n5);
            ++n5;
        }
        this.referenceContext.compilationResult.qualifiedReferences = cArrayArray;
        n2 = this.simpleNameReferences.size;
        char[][] cArrayArray2 = new char[n2][];
        int n6 = 0;
        while (n6 < n2) {
            cArrayArray2[n6] = this.simpleNameReferences.elementAt(n6);
            ++n6;
        }
        this.referenceContext.compilationResult.simpleNameReferences = cArrayArray2;
        n2 = this.rootReferences.size;
        char[][] cArrayArray3 = new char[n2][];
        n = 0;
        while (n < n2) {
            cArrayArray3[n] = this.rootReferences.elementAt(n);
            ++n;
        }
        this.referenceContext.compilationResult.rootReferences = cArrayArray3;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding typeBinding) {
        if (typeBinding.isArrayType()) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 4100: 
            case 8196: {
                return null;
            }
            case 260: 
            case 1028: {
                typeBinding = typeBinding.erasure();
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (referenceBinding.isLocalType()) {
            return null;
        }
        return referenceBinding;
    }

    public void verifyMethods(MethodVerifier methodVerifier) {
        int n = 0;
        int n2 = this.topLevelTypes.length;
        while (n < n2) {
            this.topLevelTypes[n].verifyMethods(methodVerifier);
            ++n;
        }
    }
}

