/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public class MethodVerifier {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    LookupEnvironment environment;
    private boolean allowCompatibleReturnTypes;

    MethodVerifier(LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.allowCompatibleReturnTypes = lookupEnvironment.globalOptions.complianceLevel >= 0x310000L && lookupEnvironment.globalOptions.sourceLevel < 0x310000L;
    }

    boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.isParameterSubsignature(methodBinding, methodBinding2) && this.areReturnTypesCompatible(methodBinding, methodBinding2);
    }

    boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n = typeBindingArray.length;
        if (n != typeBindingArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.areTypesEqual(typeBindingArray[n2], typeBindingArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType == methodBinding2.returnType) {
            return true;
        }
        if (this.areTypesEqual(methodBinding.returnType, methodBinding2.returnType)) {
            return true;
        }
        if (this.allowCompatibleReturnTypes && methodBinding.declaringClass instanceof BinaryTypeBinding && methodBinding2.declaringClass instanceof BinaryTypeBinding) {
            return this.areReturnTypesCompatible0(methodBinding, methodBinding2);
        }
        return false;
    }

    boolean areReturnTypesCompatible0(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType.isBaseType()) {
            return false;
        }
        if (!methodBinding.declaringClass.isInterface() && methodBinding.declaringClass.id == 1) {
            return methodBinding2.returnType.isCompatibleWith(methodBinding.returnType);
        }
        return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType);
    }

    boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)typeBinding).resolvedType == typeBinding2;
        }
        if (typeBinding2 instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)typeBinding2).resolvedType == typeBinding;
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && this.type.superclass().isAbstract()) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || methodBinding.declaringClass == methodBinding2.declaringClass;
    }

    void checkAbstractMethod(MethodBinding methodBinding) {
        if (this.mustImplementAbstractMethod(methodBinding.declaringClass)) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding);
                methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            }
        }
    }

    void checkAgainstInheritedMethods(MethodBinding methodBinding, MethodBinding[] methodBindingArray, int n, MethodBinding[] methodBindingArray2) {
        if (this.type.isAnnotationType()) {
            this.problemReporter().annotationCannotOverrideMethod(methodBinding, methodBindingArray[n - 1]);
            return;
        }
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        int[] nArray = n > 1 ? this.findOverriddenInheritedMethods(methodBindingArray, n) : null;
        int n2 = n;
        block0: while (--n2 >= 0) {
            MethodBinding methodBinding2 = methodBindingArray[n2];
            if (nArray == null || nArray[n2] == 0) {
                if (methodBinding.isStatic() != methodBinding2.isStatic()) {
                    this.problemReporter(methodBinding).staticAndInstanceConflict(methodBinding, methodBinding2);
                    continue;
                }
                if (methodBinding2.isAbstract()) {
                    methodBinding.modifiers = methodBinding2.declaringClass.isInterface() ? (methodBinding.modifiers |= 0x20000000) : (methodBinding.modifiers |= 0x30000000);
                } else if (methodBinding2.isPublic() || !this.type.isInterface()) {
                    methodBinding.modifiers |= 0x10000000;
                }
                if (!this.areReturnTypesCompatible(methodBinding, methodBinding2) && (methodBinding.returnType.tagBits & 0x80L) == 0L && this.reportIncompatibleReturnTypeError(methodBinding, methodBinding2)) continue;
                if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                    this.checkExceptions(methodBinding, methodBinding2);
                }
                if (methodBinding2.isFinal()) {
                    this.problemReporter(methodBinding).finalMethodCannotBeOverridden(methodBinding, methodBinding2);
                }
                if (!this.isAsVisible(methodBinding, methodBinding2)) {
                    this.problemReporter(methodBinding).visibilityConflict(methodBinding, methodBinding2);
                }
                if (methodBinding2.isSynchronized() && !methodBinding.isSynchronized()) {
                    this.problemReporter(methodBinding).missingSynchronizedOnInheritedMethod(methodBinding, methodBinding2);
                }
                if (compilerOptions.reportDeprecationWhenOverridingDeprecatedMethod && methodBinding2.isViewedAsDeprecated() && (!methodBinding.isViewedAsDeprecated() || compilerOptions.reportDeprecationInsideDeprecatedCode)) {
                    ReferenceBinding referenceBinding = methodBinding2.declaringClass;
                    if (referenceBinding.isInterface()) {
                        int n3 = n;
                        while (--n3 >= 0) {
                            if (n2 != n3 && methodBindingArray[n3].declaringClass.implementsInterface(referenceBinding, false)) continue block0;
                        }
                    }
                    this.problemReporter(methodBinding).overridesDeprecatedMethod(methodBinding, methodBinding2);
                }
            }
            this.checkForBridgeMethod(methodBinding, methodBinding2, methodBindingArray2);
        }
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        int n;
        if (methodBinding.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, methodBinding, methodBindingArray);
        }
        if (!methodBinding.isPublic()) {
            n = 0;
            int n2 = methodBindingArray.length;
            if (methodBinding.isProtected()) {
                while (n < n2) {
                    if (!methodBindingArray[n].isPublic()) {
                        ++n;
                        continue;
                    }
                    break;
                }
            } else if (methodBinding.isDefault()) {
                while (n < n2) {
                    if (methodBindingArray[n].isDefault()) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            if (n < n2) {
                this.problemReporter().inheritedMethodReducesVisibility(this.type, methodBinding, methodBindingArray);
            }
        }
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n = methodBindingArray.length;
            while (--n >= 0) {
                this.checkExceptions(methodBinding, methodBindingArray[n]);
            }
        }
        if (methodBinding.isOrEnclosedByPrivateType()) {
            methodBinding.original().modifiers |= 0x8000000;
        }
    }

    void checkExceptions(MethodBinding methodBinding, MethodBinding methodBinding2) {
        ReferenceBinding[] referenceBindingArray = this.resolvedExceptionTypesFor(methodBinding);
        ReferenceBinding[] referenceBindingArray2 = this.resolvedExceptionTypesFor(methodBinding2);
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = referenceBindingArray[n];
            int n2 = referenceBindingArray2.length;
            while (--n2 > -1 && !this.isSameClassOrSubclassOf(referenceBinding, referenceBindingArray2[n2])) {
            }
            if (n2 != -1 || referenceBinding.isUncheckedException(false) || (referenceBinding.tagBits & 0x80L) != 0L) continue;
            this.problemReporter(methodBinding).incompatibleExceptionInThrowsClause(this.type, methodBinding, methodBinding2, referenceBinding);
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
    }

    void checkForMissingHashCodeMethod() {
        MethodBinding methodBinding;
        MethodBinding[] methodBindingArray = this.type.getMethods(TypeConstants.EQUALS);
        boolean bl = false;
        int n = methodBindingArray.length;
        while (!bl && --n >= 0) {
            boolean bl2 = bl = methodBindingArray[n].parameters.length == 1 && methodBindingArray[n].parameters[0].id == 1;
        }
        if (bl && (methodBinding = this.type.getExactMethod(TypeConstants.HASHCODE, Binding.NO_PARAMETERS, null)) != null && methodBinding.declaringClass.id == 1) {
            this.problemReporter().shouldImplementHashcode(this.type);
        }
    }

    void checkForRedundantSuperinterfaces(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2;
        if (referenceBindingArray == Binding.NO_SUPERINTERFACES) {
            return;
        }
        SimpleSet simpleSet = new SimpleSet(referenceBindingArray.length);
        int n3 = 0;
        int n4 = referenceBindingArray.length;
        while (n3 < n4) {
            simpleSet.add(referenceBindingArray[n3]);
            ++n3;
        }
        ReferenceBinding[] referenceBindingArray2 = null;
        SimpleSet simpleSet2 = new SimpleSet(5);
        Object object = referenceBinding;
        while (object != null && ((Binding)object).isValidBinding()) {
            referenceBindingArray2 = ((ReferenceBinding)object).superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                n2 = 0;
                int n5 = referenceBindingArray2.length;
                while (n2 < n5) {
                    ReferenceBinding referenceBinding2 = referenceBindingArray2[n2];
                    if (!simpleSet2.includes(referenceBinding2) && referenceBinding2.isValidBinding()) {
                        if (simpleSet.includes(referenceBinding2)) {
                            TypeReference[] typeReferenceArray = this.type.scope.referenceContext.superInterfaces;
                            n = 0;
                            int n6 = typeReferenceArray.length;
                            while (n < n6) {
                                if (typeReferenceArray[n].resolvedType == referenceBinding2) {
                                    this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray[n], referenceBinding2, (ReferenceBinding)object);
                                    break;
                                }
                                ++n;
                            }
                        } else {
                            simpleSet2.add(referenceBinding2);
                        }
                    }
                    ++n2;
                }
            }
            object = ((ReferenceBinding)object).superclass();
        }
        n2 = simpleSet2.elementSize;
        if (n2 == 0) {
            return;
        }
        Object[] objectArray = new ReferenceBinding[n2];
        simpleSet2.asArray(objectArray);
        int n7 = 0;
        while (n7 < n2) {
            object = objectArray[n7];
            referenceBindingArray2 = ((ReferenceBinding)object).superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                int n8 = referenceBindingArray2.length;
                if (n2 + n8 >= objectArray.length) {
                    Object[] objectArray2 = objectArray;
                    objectArray = new ReferenceBinding[n2 + n8 + 5];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                }
                n = 0;
                while (n < n8) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    if (!simpleSet2.includes(referenceBinding3) && referenceBinding3.isValidBinding()) {
                        if (simpleSet.includes(referenceBinding3)) {
                            TypeReference[] typeReferenceArray = this.type.scope.referenceContext.superInterfaces;
                            int n9 = 0;
                            int n10 = typeReferenceArray.length;
                            while (n9 < n10) {
                                if (typeReferenceArray[n9].resolvedType == referenceBinding3) {
                                    this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray[n9], referenceBinding3, (ReferenceBinding)object);
                                    break;
                                }
                                ++n9;
                            }
                        } else {
                            simpleSet2.add(referenceBinding3);
                            objectArray[n2++] = referenceBinding3;
                        }
                    }
                    ++n;
                }
            }
            ++n7;
        }
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = methodBinding = this.type.isInterface() || methodBindingArray[0].isAbstract() ? null : methodBindingArray[0];
        if (methodBinding == null) {
            boolean bl;
            MethodBinding methodBinding3 = n == 1 ? methodBindingArray[0] : this.findBestInheritedAbstractMethod(methodBindingArray, n);
            boolean bl2 = bl = methodBinding3 == null;
            if (bl) {
                methodBinding3 = methodBindingArray[0];
            }
            if (this.mustImplementAbstractMethod(methodBinding3.declaringClass)) {
                TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                MethodBinding methodBinding4 = methodBindingArray[0];
                if (methodBinding4 == methodBinding3 || methodBinding4.declaringClass.isInterface()) {
                    if (typeDeclaration != null) {
                        MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding3);
                        methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3);
                    }
                } else if (typeDeclaration != null) {
                    MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding3);
                    methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3, methodBinding4);
                } else {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3, methodBinding4);
                }
            } else if (bl) {
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n);
            }
            return;
        }
        if (n < 2) {
            return;
        }
        int n2 = n;
        while (--n2 > 0 && this.checkInheritedReturnTypes(methodBinding, methodBindingArray[n2])) {
        }
        if (n2 > 0) {
            MethodBinding methodBinding5 = this.findBestInheritedAbstractMethod(methodBindingArray, n);
            if (methodBinding5 == null) {
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding5, methodBinding);
            }
            return;
        }
        MethodBinding[] methodBindingArray2 = new MethodBinding[n - 1];
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (methodBindingArray[n3].isAbstract()) {
                methodBindingArray2[n2++] = methodBindingArray[n3];
            }
            ++n3;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < methodBindingArray2.length) {
            MethodBinding[] methodBindingArray3 = methodBindingArray2;
            methodBindingArray2 = new MethodBinding[n2];
            System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, n2);
        }
        this.checkConcreteInheritedMethod(methodBinding, methodBindingArray2);
    }

    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        return !(this.type.isInterface() || !methodBinding.declaringClass.isClass() && this.type.implementsInterface(methodBinding.declaringClass, false) || !methodBinding2.declaringClass.isClass() && this.type.implementsInterface(methodBinding2.declaringClass, false));
    }

    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            int n2;
            MethodBinding methodBinding;
            int n3;
            int n4;
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.currentMethods.get(cArray[n])) == null && bl2) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            if (methodBindingArray2.length == 1 && methodBindingArray == null) {
                if (!bl || !methodBindingArray2[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray2[0]);
                continue;
            }
            int n5 = -1;
            MethodBinding[] methodBindingArray3 = new MethodBinding[methodBindingArray2.length];
            if (methodBindingArray != null) {
                n4 = 0;
                n3 = methodBindingArray.length;
                while (n4 < n3) {
                    methodBinding = methodBindingArray[n4];
                    n2 = 0;
                    int n6 = methodBindingArray2.length;
                    while (n2 < n6) {
                        MethodBinding methodBinding2 = this.computeSubstituteMethod(methodBindingArray2[n2], methodBinding);
                        if (methodBinding2 != null && this.isParameterSubsignature(methodBinding, methodBinding2)) {
                            methodBindingArray3[++n5] = methodBinding2;
                            methodBindingArray2[n2] = null;
                        }
                        ++n2;
                    }
                    if (n5 >= 0) {
                        this.checkAgainstInheritedMethods(methodBinding, methodBindingArray3, n5 + 1, methodBindingArray2);
                        while (n5 >= 0) {
                            methodBindingArray3[n5--] = null;
                        }
                    }
                    ++n4;
                }
            }
            n4 = 0;
            n3 = methodBindingArray2.length;
            while (n4 < n3) {
                methodBinding = methodBindingArray2[n4];
                if (methodBinding != null) {
                    methodBindingArray3[++n5] = methodBinding;
                    n2 = n4 + 1;
                    while (n2 < n3) {
                        MethodBinding methodBinding3 = methodBindingArray2[n2];
                        if (!this.canSkipInheritedMethods(methodBinding, methodBinding3) && (methodBinding3 = this.computeSubstituteMethod(methodBinding3, methodBinding)) != null && this.isParameterSubsignature(methodBinding, methodBinding3)) {
                            methodBindingArray3[++n5] = methodBinding3;
                            methodBindingArray2[n2] = null;
                        }
                        ++n2;
                    }
                    if (n5 != -1) {
                        if (n5 > 0) {
                            this.checkInheritedMethods(methodBindingArray3, n5 + 1);
                        } else if (bl && methodBindingArray3[0].isAbstract()) {
                            this.checkAbstractMethod(methodBindingArray3[0]);
                        }
                        while (n5 >= 0) {
                            methodBindingArray3[n5--] = null;
                        }
                    }
                }
                ++n4;
            }
        }
    }

    void checkPackagePrivateAbstractMethod(MethodBinding methodBinding) {
        PackageBinding packageBinding = methodBinding.declaringClass.fPackage;
        if (packageBinding == this.type.fPackage) {
            return;
        }
        ReferenceBinding referenceBinding = this.type.superclass();
        char[] cArray = methodBinding.selector;
        do {
            if (!referenceBinding.isValidBinding()) {
                return;
            }
            if (!referenceBinding.isAbstract()) {
                return;
            }
            if (packageBinding != referenceBinding.fPackage) continue;
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
            int n = methodBindingArray.length;
            while (--n >= 0) {
                MethodBinding methodBinding2 = methodBindingArray[n];
                if (methodBinding2.isPrivate() || methodBinding2.isConstructor() || methodBinding2.isDefaultAbstract() || !this.areMethodsCompatible(methodBinding2, methodBinding)) continue;
                return;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != methodBinding.declaringClass);
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, methodBinding);
    }

    void computeInheritedMethods() {
        ReferenceBinding referenceBinding = this.type.isInterface() ? this.type.scope.getJavaLangObject() : this.type.superclass();
        this.computeInheritedMethods(referenceBinding, this.type.superInterfaces());
        this.checkForRedundantSuperinterfaces(referenceBinding, this.type.superInterfaces());
    }

    void computeInheritedMethods(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2;
        MethodBinding[] methodBindingArray;
        Object object;
        int n3;
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        ReferenceBinding referenceBinding2 = referenceBinding;
        HashtableOfObject hashtableOfObject = new HashtableOfObject(3);
        boolean bl = true;
        while (referenceBinding2 != null && referenceBinding2.isValidBinding()) {
            if (bl) {
                if (referenceBinding2.isAbstract()) {
                    referenceBindingArray3 = referenceBinding2.superInterfaces();
                    if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                        if (referenceBindingArray2 == null) {
                            referenceBindingArray2 = referenceBindingArray3;
                            n4 = referenceBindingArray2.length;
                        } else {
                            int n5 = referenceBindingArray3.length;
                            if (n4 + n5 >= referenceBindingArray2.length) {
                                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                                referenceBindingArray2 = new ReferenceBinding[n4 + n5 + 5];
                                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
                            }
                            n3 = 0;
                            while (n3 < n5) {
                                block39: {
                                    object = referenceBindingArray3[n3];
                                    int n6 = 0;
                                    while (n6 < n4) {
                                        if (object != referenceBindingArray2[n6]) {
                                            ++n6;
                                            continue;
                                        }
                                        break block39;
                                    }
                                    referenceBindingArray2[n4++] = object;
                                }
                                ++n3;
                            }
                        }
                    }
                } else {
                    bl = false;
                }
            }
            methodBindingArray = referenceBinding2.unResolvedMethods();
            n3 = methodBindingArray.length;
            block3: while (--n3 >= 0) {
                MethodBinding[] methodBindingArray2;
                int n7;
                object = methodBindingArray[n3];
                if (((MethodBinding)object).isPrivate() || ((MethodBinding)object).isConstructor() || ((MethodBinding)object).isDefaultAbstract()) continue;
                MethodBinding[] methodBindingArray3 = (MethodBinding[])this.inheritedMethods.get(((MethodBinding)object).selector);
                if (methodBindingArray3 != null) {
                    n7 = 0;
                    n2 = methodBindingArray3.length;
                    while (n7 < n2) {
                        MethodBinding methodBinding = methodBindingArray3[n7];
                        if (methodBinding.declaringClass != ((MethodBinding)object).declaringClass && this.areMethodsCompatible(methodBinding, (MethodBinding)object)) {
                            if (!((MethodBinding)object).isDefault()) continue block3;
                            if (((MethodBinding)object).isAbstract()) {
                                this.checkPackagePrivateAbstractMethod((MethodBinding)object);
                                continue block3;
                            }
                            if (methodBinding.declaringClass.fPackage == ((MethodBinding)object).declaringClass.fPackage || this.type.fPackage != ((MethodBinding)object).declaringClass.fPackage || this.areReturnTypesCompatible((MethodBinding)object, methodBinding)) continue block3;
                        }
                        ++n7;
                    }
                }
                if (!((MethodBinding)object).isDefault() || ((MethodBinding)object).declaringClass.fPackage == this.type.fPackage) {
                    if (methodBindingArray3 == null) {
                        methodBindingArray3 = new MethodBinding[]{object};
                    } else {
                        n7 = methodBindingArray3.length;
                        MethodBinding[] methodBindingArray4 = methodBindingArray3;
                        methodBindingArray3 = new MethodBinding[n7 + 1];
                        System.arraycopy(methodBindingArray4, 0, methodBindingArray3, 0, n7);
                        methodBindingArray3[n7] = object;
                    }
                    this.inheritedMethods.put(((MethodBinding)object).selector, methodBindingArray3);
                    continue;
                }
                MethodBinding[] methodBindingArray5 = (MethodBinding[])hashtableOfObject.get(((MethodBinding)object).selector);
                if (methodBindingArray5 != null) {
                    n2 = 0;
                    int n8 = methodBindingArray5.length;
                    while (n2 < n8) {
                        if (this.areMethodsCompatible(methodBindingArray5[n2], (MethodBinding)object)) continue block3;
                        ++n2;
                    }
                }
                if (methodBindingArray5 == null) {
                    methodBindingArray5 = new MethodBinding[]{object};
                } else {
                    n2 = methodBindingArray5.length;
                    MethodBinding[] methodBindingArray6 = methodBindingArray5;
                    methodBindingArray5 = new MethodBinding[n2 + 1];
                    System.arraycopy(methodBindingArray6, 0, methodBindingArray5, 0, n2);
                    methodBindingArray5[n2] = object;
                }
                hashtableOfObject.put(((MethodBinding)object).selector, methodBindingArray5);
                if (((MethodBinding)object).isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, (MethodBinding)object);
                }
                if ((methodBindingArray2 = (MethodBinding[])this.currentMethods.get(((MethodBinding)object).selector)) == null || ((MethodBinding)object).isStatic()) continue;
                int n9 = 0;
                n = methodBindingArray2.length;
                while (n9 < n) {
                    if (!methodBindingArray2[n9].isStatic() && this.areMethodsCompatible(methodBindingArray2[n9], (MethodBinding)object)) {
                        this.problemReporter().overridesPackageDefaultMethod(methodBindingArray2[n9], (MethodBinding)object);
                        continue block3;
                    }
                    ++n9;
                }
            }
            referenceBinding2 = referenceBinding2.superclass();
        }
        if (n4 == 0) {
            return;
        }
        methodBindingArray = this.findSuperinterfaceCollisions(referenceBinding, referenceBindingArray);
        n3 = 0;
        while (n3 < n4) {
            referenceBinding2 = referenceBindingArray2[n3];
            if (referenceBinding2.isValidBinding() && (methodBindingArray == null || !methodBindingArray.includes(referenceBinding2))) {
                referenceBindingArray3 = referenceBinding2.superInterfaces();
                if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                    int n10 = referenceBindingArray3.length;
                    if (n4 + n10 >= referenceBindingArray2.length) {
                        ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n4 + n10 + 5];
                        System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
                    }
                    int n11 = 0;
                    while (n11 < n10) {
                        block40: {
                            ReferenceBinding referenceBinding3 = referenceBindingArray3[n11];
                            n2 = 0;
                            while (n2 < n4) {
                                if (referenceBinding3 != referenceBindingArray2[n2]) {
                                    ++n2;
                                    continue;
                                }
                                break block40;
                            }
                            referenceBindingArray2[n4++] = referenceBinding3;
                        }
                        ++n11;
                    }
                }
                object = referenceBinding2.unResolvedMethods();
                int n12 = ((MethodBinding[])object).length;
                block10: while (--n12 >= 0) {
                    Object object2 = object[n12];
                    MethodBinding[] methodBindingArray7 = (MethodBinding[])this.inheritedMethods.get(((MethodBinding)object2).selector);
                    if (methodBindingArray7 == null) {
                        methodBindingArray7 = new MethodBinding[]{object2};
                    } else {
                        int n13 = methodBindingArray7.length;
                        n = 0;
                        while (n < n13) {
                            if (this.isInterfaceMethodImplemented((MethodBinding)object2, methodBindingArray7[n], referenceBinding2)) continue block10;
                            ++n;
                        }
                        MethodBinding[] methodBindingArray8 = methodBindingArray7;
                        methodBindingArray7 = new MethodBinding[n13 + 1];
                        System.arraycopy(methodBindingArray8, 0, methodBindingArray7, 0, n13);
                        methodBindingArray7[n13] = object2;
                    }
                    this.inheritedMethods.put(((MethodBinding)object2).selector, methodBindingArray7);
                }
            }
            ++n3;
        }
    }

    void computeMethods() {
        MethodBinding[] methodBindingArray = this.type.methods();
        int n = methodBindingArray.length;
        this.currentMethods = new HashtableOfObject(n == 0 ? 1 : n);
        int n2 = n;
        while (--n2 >= 0) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (methodBinding.isConstructor() || methodBinding.isDefaultAbstract()) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(methodBinding.selector);
            if (methodBindingArray2 == null) {
                methodBindingArray2 = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray3 = methodBindingArray2;
                methodBindingArray2 = new MethodBinding[methodBindingArray2.length + 1];
                System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, methodBindingArray2.length - 1);
            }
            methodBindingArray2[methodBindingArray2.length - 1] = methodBinding;
            this.currentMethods.put(methodBinding.selector, methodBindingArray2);
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        return methodBinding;
    }

    boolean couldMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding == methodBinding2 || methodBinding.isStatic() || methodBinding2.isStatic()) {
            return false;
        }
        if (methodBinding2.isPrivate()) {
            return false;
        }
        if (methodBinding2.isDefault() && methodBinding.declaringClass.getPackage() != methodBinding2.declaringClass.getPackage()) {
            return false;
        }
        if (!methodBinding.isPublic()) {
            if (methodBinding2.isPublic()) {
                return false;
            }
            if (methodBinding2.isProtected() && !methodBinding.isProtected()) {
                return false;
            }
        }
        return true;
    }

    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!this.couldMethodOverride(methodBinding, methodBinding2)) {
            return false;
        }
        methodBinding2 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass);
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        return this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        return null;
    }

    MethodBinding findBestInheritedAbstractMethod(MethodBinding[] methodBindingArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            block5: {
                MethodBinding methodBinding = methodBindingArray[n2];
                if (methodBinding.isAbstract()) {
                    int n3 = 0;
                    while (n3 < n) {
                        if (n2 != n3 && !this.checkInheritedReturnTypes(methodBinding, methodBindingArray[n3])) {
                            if (this.type.isInterface() && methodBindingArray[n3].declaringClass.id == 1) {
                                return methodBinding;
                            }
                            break block5;
                        }
                        ++n3;
                    }
                    return methodBinding;
                }
            }
            ++n2;
        }
        return null;
    }

    int[] findOverriddenInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        int[] nArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding = methodBindingArray[n2].declaringClass;
        if (!referenceBinding.isInterface()) {
            ReferenceBinding referenceBinding2 = methodBindingArray[++n2].declaringClass;
            while (referenceBinding == referenceBinding2) {
                if (++n2 == n) {
                    return null;
                }
                referenceBinding2 = methodBindingArray[n2].declaringClass;
            }
            if (!referenceBinding2.isInterface()) {
                if (referenceBinding.fPackage != referenceBinding2.fPackage && methodBindingArray[n2].isDefault()) {
                    return null;
                }
                nArray = new int[n];
                do {
                    nArray[n2] = -1;
                    if (++n2 != n) continue;
                    return nArray;
                } while (!(referenceBinding2 = methodBindingArray[n2].declaringClass).isInterface());
            }
        }
        while (n2 < n) {
            if (nArray == null || nArray[n2] != -1) {
                referenceBinding = methodBindingArray[n2].declaringClass;
                int n3 = n2 + 1;
                while (n3 < n) {
                    ReferenceBinding referenceBinding3;
                    if ((nArray == null || nArray[n3] != -1) && referenceBinding != (referenceBinding3 = methodBindingArray[n3].declaringClass)) {
                        if (referenceBinding.implementsInterface(referenceBinding3, true)) {
                            if (nArray == null) {
                                nArray = new int[n];
                            }
                            nArray[n3] = -1;
                        } else if (referenceBinding3.implementsInterface(referenceBinding, true)) {
                            if (nArray == null) {
                                nArray = new int[n];
                            }
                            nArray[n2] = -1;
                            break;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return nArray;
    }

    boolean isAsVisible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.modifiers == methodBinding.modifiers) {
            return true;
        }
        if (methodBinding.isPublic()) {
            return true;
        }
        if (methodBinding2.isPublic()) {
            return false;
        }
        if (methodBinding.isProtected()) {
            return true;
        }
        if (methodBinding2.isProtected()) {
            return false;
        }
        return !methodBinding.isPrivate();
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        return this.areParametersEqual(methodBinding2, methodBinding) && methodBinding2.declaringClass.implementsInterface(referenceBinding, true);
    }

    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return CharOperation.equals(methodBinding.selector, methodBinding2.selector) && this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.areParametersEqual(methodBinding, methodBinding2);
    }

    boolean isSameClassOrSubclassOf(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        do {
            if (referenceBinding != referenceBinding2) continue;
            return true;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean mustImplementAbstractMethod(ReferenceBinding var1_1) {
        block4: {
            block3: {
                if (!this.mustImplementAbstractMethods()) {
                    return false;
                }
                var2_2 = this.type.superclass();
                if (!var1_1.isClass()) break block3;
                while (var2_2.isAbstract() && var2_2 != var1_1) {
                    var2_2 = var2_2.superclass();
                }
                break block4;
            }
            if (!this.type.implementsInterface(var1_1, false) || var2_2.implementsInterface(var1_1, true)) ** GOTO lbl13
            return true;
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2.superclass();
lbl13:
                // 2 sources

                ** while (var2_2.isAbstract() && !var2_2.implementsInterface((ReferenceBinding)var1_1, (boolean)false))
            }
        }
        return var2_2.isAbstract();
    }

    boolean mustImplementAbstractMethods() {
        return !this.type.isInterface() && !this.type.isAbstract();
    }

    ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    ProblemReporter problemReporter(MethodBinding methodBinding) {
        ProblemReporter problemReporter = this.problemReporter();
        if (methodBinding.declaringClass == this.type && methodBinding.sourceMethod() != null) {
            problemReporter.referenceContext = methodBinding.sourceMethod();
        }
        return problemReporter;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        this.problemReporter(methodBinding).incompatibleReturnType(methodBinding, methodBinding2);
        return true;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding methodBinding) {
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return referenceBindingArray;
        }
        if (!(methodBinding.declaringClass instanceof BinaryTypeBinding)) {
            return Binding.NO_EXCEPTIONS;
        }
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            referenceBindingArray[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBindingArray[n], this.environment, true);
        }
        return referenceBindingArray;
    }

    void verify() {
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
        if (this.type.isClass()) {
            this.checkForMissingHashCodeMethod();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void verify(SourceTypeBinding sourceTypeBinding) {
        if (this.type != null) {
            this.environment.newMethodVerifier().verify(sourceTypeBinding);
            return;
        }
        try {
            this.type = sourceTypeBinding;
            this.verify();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.type = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.type = null;
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("MethodVerifier for type: ");
        stringBuffer.append(this.type.readableName());
        stringBuffer.append('\n');
        stringBuffer.append("\t-inherited methods: ");
        stringBuffer.append(this.inheritedMethods);
        return stringBuffer.toString();
    }
}

