/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        methodBinding = methodBinding.original();
        methodBinding2 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass);
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        if (typeBinding != methodBinding2.declaringClass) {
            MethodBinding[] methodBindingArray = ((ReferenceBinding)typeBinding).getMethods(methodBinding2.selector);
            int n = 0;
            int n2 = methodBindingArray.length;
            while (n < n2) {
                if (methodBindingArray[n].original() == methodBinding2) {
                    return this.isParameterSubsignature(methodBinding, methodBindingArray[n]);
                }
                ++n;
            }
        }
        return this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n = typeBindingArray.length;
        if (n != typeBindingArray2.length) {
            return false;
        }
        if (methodBinding.declaringClass.isInterface()) {
            int n2 = 0;
            while (n2 < n) {
                if (!this.areTypesEqual(typeBindingArray[n2], typeBindingArray2[n2])) {
                    return false;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if (!this.areTypesEqual(typeBindingArray[n3], typeBindingArray2[n3])) {
                    if (typeBindingArray[n3].leafComponentType().isRawType() && typeBindingArray[n3].dimensions() == typeBindingArray2[n3].dimensions() && typeBindingArray[n3].leafComponentType().isEquivalentTo(typeBindingArray2[n3].leafComponentType())) {
                        if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                            return false;
                        }
                        int n4 = 0;
                        while (n4 < n3) {
                            if (typeBindingArray[n4].leafComponentType().isParameterizedTypeWithActualArguments()) {
                                return false;
                            }
                            ++n4;
                        }
                        break;
                    }
                    return false;
                }
                ++n3;
            }
            ++n3;
            while (n3 < n) {
                if (!this.areTypesEqual(typeBindingArray[n3], typeBindingArray2[n3])) {
                    if (!typeBindingArray[n3].leafComponentType().isRawType() || typeBindingArray[n3].dimensions() != typeBindingArray2[n3].dimensions() || !typeBindingArray[n3].leafComponentType().isEquivalentTo(typeBindingArray2[n3].leafComponentType())) {
                        return false;
                    }
                } else if (typeBindingArray[n3].leafComponentType().isParameterizedTypeWithActualArguments()) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType == methodBinding2.returnType) {
            return true;
        }
        return this.areReturnTypesCompatible0(methodBinding, methodBinding2);
    }

    boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding.isParameterizedType() && typeBinding2.isParameterizedType()) {
            return typeBinding.isEquivalentTo(typeBinding2) && typeBinding2.isEquivalentTo(typeBinding);
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || methodBinding.declaringClass == methodBinding2.declaringClass && !methodBinding.declaringClass.isParameterizedType();
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        super.checkConcreteInheritedMethod(methodBinding, methodBindingArray);
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding2 = methodBindingArray[n];
            if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
                this.problemReporter().varargsConflict(methodBinding, methodBinding2, this.type);
            }
            MethodBinding methodBinding3 = methodBinding2.original();
            if (methodBinding3.returnType != methodBinding.returnType && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
                this.problemReporter().unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
            }
            if (methodBinding3.declaringClass.isInterface() && (methodBinding.declaringClass == this.type.superclass && this.type.superclass.isParameterizedType() || this.type.superclass.erasure().findSuperTypeOriginatingFrom(methodBinding3.declaringClass) == null)) {
                this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original());
            }
            ++n;
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
        if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
            this.problemReporter(methodBinding).varargsConflict(methodBinding, methodBinding2, this.type);
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        if (methodBinding3.returnType != methodBinding.returnType && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
        }
        if (this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original()) != null) {
            int n = 0;
            int n2 = methodBindingArray == null ? 0 : methodBindingArray.length;
            while (n < n2) {
                if (methodBindingArray[n] != null && this.detectInheritedNameClash(methodBinding3, methodBindingArray[n].original())) {
                    return;
                }
                ++n;
            }
        }
    }

    void checkForNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.declaringClass.isInterface() || methodBinding2.isStatic()) {
            return;
        }
        if (!this.detectNameClash(methodBinding, methodBinding2)) {
            int n;
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            int n2 = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            if (n2 != typeBindingArray2.length) {
                return;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (!(typeBindingArray[n3] == typeBindingArray2[n3] || typeBindingArray[n3].isBaseType() == typeBindingArray2[n3].isBaseType() && typeBindingArray2[n3].isCompatibleWith(typeBindingArray[n3]))) {
                    return;
                }
                ++n3;
            }
            ReferenceBinding[] referenceBindingArray = null;
            int n4 = 0;
            ReferenceBinding referenceBinding = methodBinding2.declaringClass;
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                n4 = referenceBindingArray2.length;
                referenceBindingArray = referenceBindingArray2;
            }
            referenceBinding = referenceBinding.superclass();
            while (referenceBinding != null && referenceBinding.isValidBinding()) {
                Binding binding;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                int n5 = 0;
                n = methodBindingArray.length;
                while (n5 < n) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n5], methodBinding);
                    if (binding != null && !this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)binding) && this.detectNameClash(methodBinding, (MethodBinding)binding)) {
                        return;
                    }
                    ++n5;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                    if (referenceBindingArray == null) {
                        referenceBindingArray = referenceBindingArray2;
                        n4 = referenceBindingArray.length;
                    } else {
                        n5 = referenceBindingArray2.length;
                        if (n4 + n5 >= referenceBindingArray.length) {
                            ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n4 + n5 + 5];
                            System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n4);
                        }
                        n = 0;
                        while (n < n5) {
                            block25: {
                                binding = referenceBindingArray2[n];
                                int n6 = 0;
                                while (n6 < n4) {
                                    if (binding != referenceBindingArray[n6]) {
                                        ++n6;
                                        continue;
                                    }
                                    break block25;
                                }
                                referenceBindingArray[n4++] = binding;
                            }
                            ++n;
                        }
                    }
                }
                referenceBinding = referenceBinding.superclass();
            }
            int n7 = 0;
            while (n7 < n4) {
                referenceBinding = referenceBindingArray[n7];
                if (referenceBinding.isValidBinding()) {
                    MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                    n = 0;
                    int n8 = methodBindingArray.length;
                    while (n < n8) {
                        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBindingArray[n], methodBinding);
                        if (methodBinding3 != null && !this.isSubstituteParameterSubsignature(methodBinding, methodBinding3) && this.detectNameClash(methodBinding, methodBinding3)) {
                            return;
                        }
                        ++n;
                    }
                    referenceBindingArray2 = referenceBinding.superInterfaces();
                    if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                        n = referenceBindingArray2.length;
                        if (n4 + n >= referenceBindingArray.length) {
                            ReferenceBinding[] referenceBindingArray4 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n4 + n + 5];
                            System.arraycopy(referenceBindingArray4, 0, referenceBindingArray, 0, n4);
                        }
                        n8 = 0;
                        while (n8 < n) {
                            block26: {
                                ReferenceBinding referenceBinding2 = referenceBindingArray2[n8];
                                int n9 = 0;
                                while (n9 < n4) {
                                    if (referenceBinding2 != referenceBindingArray[n9]) {
                                        ++n9;
                                        continue;
                                    }
                                    break block26;
                                }
                                referenceBindingArray[n4++] = referenceBinding2;
                            }
                            ++n8;
                        }
                    }
                }
                ++n7;
            }
        }
    }

    void checkInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.declaringClass.erasure() == methodBinding2.declaringClass.erasure()) {
            boolean bl;
            boolean bl2 = bl = methodBinding.hasSubstitutedParameters() && methodBinding2.hasSubstitutedParameters() ? methodBinding.areParametersEqual(methodBinding2) : methodBinding.areParameterErasuresEqual(methodBinding2);
            if (bl) {
                this.problemReporter().duplicateInheritedMethods(this.type, methodBinding, methodBinding2);
                return;
            }
        }
        if (methodBinding.declaringClass.isInterface() || methodBinding.isStatic()) {
            return;
        }
        this.detectInheritedNameClash(methodBinding.original(), methodBinding2.original());
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        int n2 = n;
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = n - 1;
        while (n3 < n4) {
            if (nArray[n3] != -1) {
                MethodBinding methodBinding;
                MethodBinding methodBinding2 = methodBindingArray[n3];
                MethodBinding[] methodBindingArray2 = null;
                int n5 = n3 + 1;
                while (n5 <= n4) {
                    methodBinding = methodBindingArray[n5];
                    if (methodBinding2.declaringClass == methodBinding.declaringClass && this.areMethodsCompatible(methodBinding2, methodBinding)) {
                        nArray[n5] = -1;
                        if (methodBindingArray2 == null) {
                            methodBindingArray2 = new MethodBinding[n];
                        }
                        methodBindingArray2[n5] = methodBinding;
                    }
                    ++n5;
                }
                if (methodBindingArray2 != null) {
                    n5 = methodBinding2.isAbstract() ? 0 : 1;
                    methodBinding = methodBinding2;
                    int n6 = 0;
                    int n7 = methodBindingArray2.length;
                    while (n6 < n7) {
                        if (methodBindingArray2[n6] != null && !methodBindingArray2[n6].isAbstract()) {
                            methodBinding = methodBindingArray2[n6];
                            ++n5;
                        }
                        ++n6;
                    }
                    if (n5 != 1) {
                        n6 = 0;
                        n7 = methodBindingArray2.length;
                        while (n6 < n7) {
                            if (methodBindingArray2[n6] != null) {
                                this.problemReporter().duplicateInheritedMethods(this.type, methodBinding2, methodBindingArray2[n6]);
                                --n2;
                                if (methodBinding == methodBindingArray2[n6]) {
                                    methodBindingArray[n3] = null;
                                } else {
                                    methodBindingArray[n6] = null;
                                }
                            }
                            ++n6;
                        }
                    }
                }
            }
            ++n3;
        }
        if (n2 < n) {
            if (n2 == 1) {
                return;
            }
            MethodBinding[] methodBindingArray3 = new MethodBinding[n2];
            n4 = n;
            while (--n4 >= 0) {
                if (methodBindingArray[n4] == null) continue;
                methodBindingArray3[--n2] = methodBindingArray[n4];
            }
            methodBindingArray = methodBindingArray3;
            n = methodBindingArray3.length;
        }
        super.checkInheritedMethods(methodBindingArray, n);
    }

    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        if (!(this.type.isInterface() || !methodBinding.declaringClass.isClass() && this.type.implementsInterface(methodBinding.declaringClass, false) || !methodBinding2.declaringClass.isClass() && this.type.implementsInterface(methodBinding2.declaringClass, false))) {
            return true;
        }
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            if (!methodBinding.declaringClass.implementsInterface(methodBinding2.declaringClass, false)) {
                this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            }
            return true;
        }
        return false;
    }

    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            MethodBinding methodBinding;
            int n2;
            Object object;
            MethodBinding methodBinding2;
            int n3;
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.currentMethods.get(cArray[n])) == null && bl2) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            if (methodBindingArray2.length == 1 && methodBindingArray == null) {
                if (!bl || !methodBindingArray2[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray2[0]);
                continue;
            }
            int n4 = -1;
            int n5 = methodBindingArray2.length;
            MethodBinding[] methodBindingArray3 = new MethodBinding[methodBindingArray2.length];
            MethodBinding[] methodBindingArray4 = new MethodBinding[methodBindingArray2.length];
            if (methodBindingArray != null) {
                int n6 = 0;
                n3 = methodBindingArray.length;
                while (n6 < n3) {
                    methodBinding2 = methodBindingArray[n6];
                    object = null;
                    n2 = 0;
                    while (n2 < n5) {
                        methodBinding = this.computeSubstituteMethod(methodBindingArray2[n2], methodBinding2);
                        if (methodBinding != null) {
                            if (methodBindingArray4[n2] == null && this.isSubstituteParameterSubsignature(methodBinding2, methodBinding)) {
                                methodBindingArray3[++n4] = methodBinding;
                                methodBindingArray4[n2] = methodBinding2;
                            } else {
                                this.checkForNameClash(methodBinding2, methodBinding);
                                if (n5 > 1) {
                                    if (object == null) {
                                        object = new MethodBinding[n5];
                                    }
                                    object[n2] = methodBinding;
                                }
                            }
                        }
                        ++n2;
                    }
                    if (n4 >= 0) {
                        this.checkAgainstInheritedMethods(methodBinding2, methodBindingArray3, n4 + 1, (MethodBinding[])object);
                        while (n4 >= 0) {
                            methodBindingArray3[n4--] = null;
                        }
                    }
                    ++n6;
                }
            }
            boolean[] blArray = new boolean[n5];
            n3 = 0;
            while (n3 < n5) {
                if (!blArray[n3]) {
                    methodBinding2 = methodBindingArray2[n3];
                    object = methodBindingArray4[n3];
                    if (object == null) {
                        methodBindingArray3[++n4] = methodBinding2;
                    }
                    n2 = n3 + 1;
                    while (n2 < n5) {
                        methodBinding = methodBindingArray2[n2];
                        if (!(object == methodBindingArray4[n2] && object != null || this.canSkipInheritedMethods(methodBinding2, methodBinding) || (methodBinding = this.computeSubstituteMethod(methodBinding, methodBinding2)) == null)) {
                            if (methodBinding2.declaringClass != methodBinding.declaringClass && this.isSubstituteParameterSubsignature(methodBinding2, methodBinding)) {
                                if (n4 == -1) {
                                    methodBindingArray3[++n4] = methodBinding2;
                                }
                                if (methodBindingArray4[n2] == null) {
                                    methodBindingArray3[++n4] = methodBinding;
                                }
                                blArray[n2] = true;
                            } else if (object == null && methodBindingArray4[n2] == null) {
                                this.checkInheritedMethods(methodBinding2, methodBinding);
                            }
                        }
                        ++n2;
                    }
                    if (n4 != -1) {
                        if (n4 > 0) {
                            this.checkInheritedMethods(methodBindingArray3, n4 + 1);
                        } else if (bl && methodBindingArray3[0].isAbstract()) {
                            this.checkAbstractMethod(methodBindingArray3[0]);
                        }
                        while (n4 >= 0) {
                            methodBindingArray3[n4--] = null;
                        }
                    }
                }
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void checkTypeVariableMethods(TypeParameter var1_1) {
        var2_2 = this.inheritedMethods.keyTable;
        var3_3 = var2_2.length;
        block0: while (--var3_3 >= 0) {
            if (var2_2[var3_3] == null || (var4_4 = (MethodBinding[])this.inheritedMethods.valueTable[var3_3]).length == 1) continue;
            var5_5 = -1;
            var6_6 = new MethodBinding[var4_4.length];
            var7_7 = 0;
            var8_8 = var4_4.length;
            ** GOTO lbl33
            {
                var6_6[var5_5--] = null;
                do {
                    if (var5_5 >= 0) continue block1;
                    var9_9 = var4_4[var7_7];
                    if (var9_9 != null) {
                        var6_6[++var5_5] = var9_9;
                        var10_10 = var7_7 + 1;
                        while (var10_10 < var8_8) {
                            var11_12 = var4_4[var10_10];
                            if (!this.canSkipInheritedMethods(var9_9, var11_12) && (var11_12 = this.computeSubstituteMethod(var11_12, var9_9)) != null && this.isSubstituteParameterSubsignature(var9_9, var11_12)) {
                                var6_6[++var5_5] = var11_12;
                                var4_4[var10_10] = null;
                            }
                            ++var10_10;
                        }
                    }
                    if (var5_5 > 0) {
                        var10_11 = var6_6[0];
                        var11_13 = var5_5 + 1;
                        while (--var11_13 > 0 && this.areReturnTypesCompatible(var10_11, var6_6[var11_13])) {
                        }
                        if (var11_13 > 0) {
                            this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(var1_1, var6_6, var5_5 + 1);
                            continue block0;
                        }
                    }
                    ++var7_7;
lbl33:
                    // 2 sources

                } while (var7_7 < var8_8);
            }
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeVariableBinding[] typeVariableBindingArray;
        int n;
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        if (methodBinding2.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding2.declaringClass).resolveTypesFor(methodBinding2);
        }
        if (methodBinding.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
        }
        if ((n = (typeVariableBindingArray = methodBinding.typeVariables).length) == 0) {
            return methodBinding;
        }
        TypeVariableBinding[] typeVariableBindingArray2 = methodBinding2.typeVariables;
        int n2 = typeVariableBindingArray2.length;
        if (n2 == 0) {
            return methodBinding.asRawMethod(this.environment);
        }
        if (n2 != n) {
            return methodBinding;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        System.arraycopy(typeVariableBindingArray2, 0, typeBindingArray, 0, n2);
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = this.environment.createParameterizedGenericMethod(methodBinding, typeBindingArray);
        int n3 = 0;
        while (n3 < n) {
            block19: {
                TypeBinding typeBinding;
                TypeVariableBinding typeVariableBinding;
                block16: {
                    TypeVariableBinding typeVariableBinding2;
                    block18: {
                        block17: {
                            typeVariableBinding = typeVariableBindingArray[n3];
                            typeBinding = typeBindingArray[n3];
                            if (!(typeBinding instanceof TypeVariableBinding)) break block16;
                            typeVariableBinding2 = (TypeVariableBinding)typeBinding;
                            if (typeVariableBinding2.firstBound != typeVariableBinding.firstBound) break block17;
                            if (typeVariableBinding2.firstBound != null) break block18;
                            break block19;
                        }
                        if (typeVariableBinding2.firstBound != null && typeVariableBinding.firstBound != null && typeVariableBinding2.firstBound.isClass() != typeVariableBinding.firstBound.isClass()) {
                            return methodBinding;
                        }
                    }
                    if (Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superclass) != typeVariableBinding2.superclass) {
                        return methodBinding;
                    }
                    int n4 = typeVariableBinding.superInterfaces.length;
                    ReferenceBinding[] referenceBindingArray = typeVariableBinding2.superInterfaces;
                    if (n4 != referenceBindingArray.length) {
                        return methodBinding;
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        block15: {
                            TypeBinding typeBinding2 = Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superInterfaces[n5]);
                            int n6 = 0;
                            while (n6 < n4) {
                                if (typeBinding2 != referenceBindingArray[n6]) {
                                    ++n6;
                                    continue;
                                }
                                break block15;
                            }
                            return methodBinding;
                        }
                        ++n5;
                    }
                    break block19;
                }
                if (typeVariableBinding.boundCheck(parameterizedGenericMethodBinding, typeBinding) != 0) {
                    return methodBinding;
                }
            }
            ++n3;
        }
        return parameterizedGenericMethodBinding;
    }

    boolean detectInheritedNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        if (this.environment.globalOptions.sourceLevel < 0x330000L && methodBinding.returnType.erasure() != methodBinding2.returnType.erasure()) {
            return false;
        }
        if (methodBinding.declaringClass.erasure() != methodBinding2.declaringClass.erasure() && methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass) != null) {
            return false;
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, methodBinding, methodBinding2);
        return true;
    }

    boolean detectNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = methodBinding2.original();
        if (!methodBinding.areParameterErasuresEqual(methodBinding3)) {
            return false;
        }
        if (this.environment.globalOptions.sourceLevel < 0x330000L && methodBinding.returnType.erasure() != methodBinding3.returnType.erasure()) {
            return false;
        }
        this.problemReporter(methodBinding).methodNameClash(methodBinding, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding3);
        return true;
    }

    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.couldMethodOverride(methodBinding, methodBinding2) && this.areMethodsCompatible(methodBinding, methodBinding2);
    }

    boolean doTypeVariablesClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES && !(methodBinding2 instanceof ParameterizedGenericMethodBinding);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        ReferenceBinding referenceBinding2;
        int n2;
        int n3;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        boolean bl = this.type.isHierarchyInconsistent();
        ReferenceBinding referenceBinding3 = referenceBinding;
        while (referenceBinding3 != null && referenceBinding3.isValidBinding()) {
            bl |= referenceBinding3.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding3.superInterfaces();
            if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                if (referenceBindingArray2 == null) {
                    referenceBindingArray2 = referenceBindingArray3;
                    n4 = referenceBindingArray2.length;
                } else {
                    n3 = referenceBindingArray3.length;
                    if (n4 + n3 >= referenceBindingArray2.length) {
                        ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n4 + n3 + 5];
                        System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
                    }
                    n2 = 0;
                    while (n2 < n3) {
                        block22: {
                            referenceBinding2 = referenceBindingArray3[n2];
                            int n5 = 0;
                            while (n5 < n4) {
                                if (referenceBinding2 != referenceBindingArray2[n5]) {
                                    ++n5;
                                    continue;
                                }
                                break block22;
                            }
                            referenceBindingArray2[n4++] = referenceBinding2;
                        }
                        ++n2;
                    }
                }
            }
            referenceBinding3 = referenceBinding3.superclass();
        }
        n3 = 0;
        while (n3 < n4) {
            referenceBinding3 = referenceBindingArray2[n3];
            if (referenceBinding3.isValidBinding()) {
                bl |= referenceBinding3.isHierarchyInconsistent();
                referenceBindingArray3 = referenceBinding3.superInterfaces();
                if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                    n2 = referenceBindingArray3.length;
                    if (n4 + n2 >= referenceBindingArray2.length) {
                        ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n4 + n2 + 5];
                        System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
                    }
                    int n6 = 0;
                    while (n6 < n2) {
                        block23: {
                            ReferenceBinding referenceBinding4 = referenceBindingArray3[n6];
                            n = 0;
                            while (n < n4) {
                                if (referenceBinding4 != referenceBindingArray2[n]) {
                                    ++n;
                                    continue;
                                }
                                break block23;
                            }
                            referenceBindingArray2[n4++] = referenceBinding4;
                        }
                        ++n6;
                    }
                }
            }
            ++n3;
        }
        if (!bl) {
            return null;
        }
        SimpleSet simpleSet = null;
        n2 = 0;
        while (n2 < n4) {
            referenceBinding2 = referenceBindingArray2[n2];
            if (referenceBinding2.isValidBinding()) {
                TypeBinding typeBinding = referenceBinding2.erasure();
                n = n2 + 1;
                while (n < n4) {
                    ReferenceBinding referenceBinding5 = referenceBindingArray2[n];
                    if (referenceBinding5.isValidBinding() && referenceBinding5.erasure() == typeBinding) {
                        if (simpleSet == null) {
                            simpleSet = new SimpleSet(n4);
                        }
                        simpleSet.add(referenceBindingArray2[n2]);
                        simpleSet.add(referenceBindingArray2[n]);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        return simpleSet;
    }

    boolean hasGenericParameter(MethodBinding methodBinding) {
        if (methodBinding.genericSignature() == null) {
            return false;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = 0;
        int n2 = typeBindingArray.length;
        while (n < n2) {
            int n3;
            TypeBinding typeBinding = typeBindingArray[n].leafComponentType();
            if (typeBinding instanceof ReferenceBinding && ((n3 = ((ReferenceBinding)typeBinding).modifiers) & 0x40000000) != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isAcceptableReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.declaringClass.isRawType()) {
            return true;
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding3.returnType.leafComponentType();
        if (typeBinding.isParameterizedTypeWithActualArguments()) {
            return !methodBinding.returnType.leafComponentType().isRawType();
        }
        TypeBinding typeBinding2 = methodBinding.returnType.leafComponentType();
        switch (typeBinding2.kind()) {
            case 4100: {
                if (typeBinding2 != methodBinding2.returnType.leafComponentType()) break;
                return true;
            }
        }
        return !typeBinding.isTypeVariable() || ((TypeVariableBinding)typeBinding).declaringElement != methodBinding3;
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        if (methodBinding.original() != methodBinding && methodBinding2.declaringClass.isInterface()) {
            return false;
        }
        return (methodBinding = this.computeSubstituteMethod(methodBinding, methodBinding2)) != null && methodBinding.returnType == methodBinding2.returnType && this.doesMethodOverride(methodBinding2, methodBinding);
    }

    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding.declaringClass.isParameterizedType()) {
            methodBinding = methodBinding.original();
        }
        methodBinding2 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass);
        if (typeBinding instanceof ReferenceBinding && typeBinding != methodBinding2.declaringClass) {
            MethodBinding[] methodBindingArray = ((ReferenceBinding)typeBinding).getMethods(methodBinding2.selector);
            int n = 0;
            int n2 = methodBindingArray.length;
            while (n < n2) {
                if (methodBindingArray[n].original() == methodBinding2.original()) {
                    return this.isParameterSubsignature(methodBinding, methodBindingArray[n]);
                }
                ++n;
            }
        }
        return this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBinding2, methodBinding);
        return methodBinding3 != null && this.isSubstituteParameterSubsignature(methodBinding, methodBinding3);
    }

    boolean isSubstituteParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!this.areParametersEqual(methodBinding, methodBinding2)) {
            if (methodBinding2.hasSubstitutedParameters() && methodBinding.areParameterErasuresEqual(methodBinding2)) {
                return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && !this.hasGenericParameter(methodBinding);
            }
            if (methodBinding.declaringClass.isRawType() && methodBinding2.declaringClass.isRawType() && methodBinding.hasSubstitutedParameters() && methodBinding2.hasSubstitutedParameters()) {
                return this.areMethodsCompatible(methodBinding, methodBinding2);
            }
            return false;
        }
        if (methodBinding2 instanceof ParameterizedGenericMethodBinding) {
            if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                return !((ParameterizedGenericMethodBinding)methodBinding2).isRaw;
            }
            return !this.hasGenericParameter(methodBinding);
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES;
    }

    boolean isUnsafeReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType == methodBinding2.returnType.erasure()) {
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            int n = 0;
            int n2 = typeBindingArray.length;
            while (n < n2) {
                if (!this.areTypesEqual(typeBindingArray[n], typeBindingArray2[n])) {
                    return true;
                }
                ++n;
            }
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding2.original().typeVariables != Binding.NO_TYPE_VARIABLES && methodBinding.returnType.erasure().findSuperTypeOriginatingFrom(methodBinding2.returnType.erasure()) != null;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(methodBinding, methodBinding2);
    }

    void verify() {
        if (this.type.isAnnotationType()) {
            this.type.detectAnnotationCycle();
        }
        super.verify();
        int n = this.type.typeVariables.length;
        while (--n >= 0) {
            TypeVariableBinding typeVariableBinding = this.type.typeVariables[n];
            if (typeVariableBinding.superInterfaces == Binding.NO_SUPERINTERFACES || typeVariableBinding.superInterfaces.length == 1 && typeVariableBinding.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding referenceBinding = typeVariableBinding.superclass();
            if (referenceBinding.kind() == 4100) {
                referenceBinding = (ReferenceBinding)referenceBinding.erasure();
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[referenceBindingArray.length];
            int n2 = referenceBindingArray.length;
            while (--n2 >= 0) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n2] = referenceBindingArray[n2].kind() == 4100 ? (ReferenceBinding)referenceBindingArray[n2].erasure() : referenceBindingArray[n2];
            }
            this.computeInheritedMethods(referenceBinding, referenceBindingArray2);
            this.checkTypeVariableMethods(this.type.scope.referenceContext.typeParameters[n]);
        }
    }
}

