/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;

public class PackageBinding
extends Binding
implements TypeConstants {
    public long tagBits = 0L;
    public char[][] compoundName;
    PackageBinding parent;
    public LookupEnvironment environment;
    HashtableOfType knownTypes;
    HashtableOfPackage knownPackages;

    protected PackageBinding() {
    }

    public PackageBinding(char[] cArray, LookupEnvironment lookupEnvironment) {
        this(new char[][]{cArray}, null, lookupEnvironment);
    }

    public PackageBinding(char[][] cArray, PackageBinding packageBinding, LookupEnvironment lookupEnvironment) {
        this.compoundName = cArray;
        this.parent = packageBinding;
        this.environment = lookupEnvironment;
        this.knownTypes = null;
        this.knownPackages = new HashtableOfPackage(3);
    }

    public PackageBinding(LookupEnvironment lookupEnvironment) {
        this(CharOperation.NO_CHAR_CHAR, null, lookupEnvironment);
    }

    private void addNotFoundPackage(char[] cArray) {
        this.knownPackages.put(cArray, LookupEnvironment.TheNotFoundPackage);
    }

    private void addNotFoundType(char[] cArray) {
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(cArray, LookupEnvironment.TheNotFoundType);
    }

    void addPackage(PackageBinding packageBinding) {
        if ((packageBinding.tagBits & 0x80L) == 0L) {
            this.clearMissingTagBit();
        }
        this.knownPackages.put(packageBinding.compoundName[packageBinding.compoundName.length - 1], packageBinding);
    }

    void addType(ReferenceBinding referenceBinding) {
        if ((referenceBinding.tagBits & 0x80L) == 0L) {
            this.clearMissingTagBit();
        }
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(referenceBinding.compoundName[referenceBinding.compoundName.length - 1], referenceBinding);
    }

    void clearMissingTagBit() {
        PackageBinding packageBinding = this;
        do {
            packageBinding.tagBits &= 0xFFFFFFFFFFFFFF7FL;
        } while ((packageBinding = packageBinding.parent) != null);
    }

    public char[] computeUniqueKey(boolean bl) {
        return CharOperation.concatWith(this.compoundName, '/');
    }

    private PackageBinding findPackage(char[] cArray) {
        if (!this.environment.isPackage(this.compoundName, cArray)) {
            return null;
        }
        char[][] cArray2 = CharOperation.arrayConcat(this.compoundName, cArray);
        PackageBinding packageBinding = new PackageBinding(cArray2, this, this.environment);
        this.addPackage(packageBinding);
        return packageBinding;
    }

    PackageBinding getPackage(char[] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray);
        if (packageBinding != null) {
            if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        packageBinding = this.findPackage(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        this.addNotFoundPackage(cArray);
        return null;
    }

    PackageBinding getPackage0(char[] cArray) {
        return this.knownPackages.get(cArray);
    }

    ReferenceBinding getType(char[] cArray) {
        ReferenceBinding referenceBinding = this.getType0(cArray);
        if (referenceBinding == null && (referenceBinding = this.environment.askForType(this, cArray)) == null) {
            this.addNotFoundType(cArray);
            return null;
        }
        if (referenceBinding == LookupEnvironment.TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false)).isNestedType()) {
            return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 4);
        }
        return referenceBinding;
    }

    ReferenceBinding getType0(char[] cArray) {
        if (this.knownTypes == null) {
            return null;
        }
        return this.knownTypes.get(cArray);
    }

    public Binding getTypeOrPackage(char[] cArray) {
        PackageBinding packageBinding;
        ReferenceBinding referenceBinding = this.getType0(cArray);
        if (referenceBinding != null && referenceBinding != LookupEnvironment.TheNotFoundType) {
            if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false)).isNestedType()) {
                return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 4);
            }
            if ((referenceBinding.tagBits & 0x80L) == 0L) {
                return referenceBinding;
            }
        }
        if ((packageBinding = this.getPackage0(cArray)) != null && packageBinding != LookupEnvironment.TheNotFoundPackage) {
            return packageBinding;
        }
        if (referenceBinding == null) {
            referenceBinding = this.environment.askForType(this, cArray);
            if (referenceBinding != null) {
                if (referenceBinding.isNestedType()) {
                    return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 4);
                }
                return referenceBinding;
            }
            this.addNotFoundType(cArray);
        }
        if (packageBinding == null) {
            packageBinding = this.findPackage(cArray);
            if (packageBinding != null) {
                return packageBinding;
            }
            if (referenceBinding != null && referenceBinding != LookupEnvironment.TheNotFoundType) {
                return referenceBinding;
            }
            this.addNotFoundPackage(cArray);
        }
        return null;
    }

    public final boolean isViewedAsDeprecated() {
        if ((this.tagBits & 0x400000000L) == 0L) {
            ReferenceBinding referenceBinding;
            this.tagBits |= 0x400000000L;
            if (this.compoundName != CharOperation.NO_CHAR_CHAR && (referenceBinding = this.getType(TypeConstants.PACKAGE_INFO_NAME)) != null) {
                referenceBinding.initializeDeprecatedAnnotationTagBits();
                this.tagBits |= referenceBinding.tagBits & 0x7FFF800000000L;
            }
        }
        return (this.tagBits & 0x400000000000L) != 0L;
    }

    public final int kind() {
        return 16;
    }

    public int problemId() {
        if ((this.tagBits & 0x80L) != 0L) {
            return 1;
        }
        return 0;
    }

    public char[] readableName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public String toString() {
        String string = this.compoundName == CharOperation.NO_CHAR_CHAR ? "The Default Package" : "package " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
        if ((this.tagBits & 0x80L) != 0L) {
            string = String.valueOf(string) + "[MISSING]";
        }
        return string;
    }
}

