/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedMethodBinding
extends MethodBinding {
    protected MethodBinding originalMethod;

    public ParameterizedMethodBinding(final ParameterizedTypeBinding parameterizedTypeBinding, MethodBinding methodBinding) {
        block19: {
            int n;
            super(methodBinding.modifiers, methodBinding.selector, methodBinding.returnType, methodBinding.parameters, methodBinding.thrownExceptions, parameterizedTypeBinding);
            this.originalMethod = methodBinding;
            this.tagBits = methodBinding.tagBits;
            final TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
            Substitution substitution = null;
            final int n2 = typeVariableBindingArray.length;
            final boolean bl = methodBinding.isStatic();
            if (n2 == 0) {
                this.typeVariables = Binding.NO_TYPE_VARIABLES;
                if (!bl) {
                    substitution = parameterizedTypeBinding;
                }
            } else {
                TypeVariableBinding typeVariableBinding;
                final TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n2];
                n = 0;
                while (n < n2) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    typeVariableBindingArray2[n] = new TypeVariableBinding(typeVariableBinding.sourceName, this, typeVariableBinding.rank, parameterizedTypeBinding.environment);
                    ++n;
                }
                this.typeVariables = typeVariableBindingArray2;
                substitution = new Substitution(){

                    public LookupEnvironment environment() {
                        return parameterizedTypeBinding.environment;
                    }

                    public boolean isRawSubstitution() {
                        return !bl && parameterizedTypeBinding.isRawSubstitution();
                    }

                    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                        if (typeVariableBinding.rank < n2 && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
                            return typeVariableBindingArray2[typeVariableBinding.rank];
                        }
                        if (!bl) {
                            return parameterizedTypeBinding.substitute(typeVariableBinding);
                        }
                        return typeVariableBinding;
                    }
                };
                n = 0;
                while (n < n2) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[n];
                    TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superclass);
                    ReferenceBinding[] referenceBindingArray = Scope.substitute(substitution, typeVariableBinding.superInterfaces);
                    if (typeVariableBinding.firstBound != null) {
                        typeVariableBinding2.firstBound = typeVariableBinding.firstBound == typeVariableBinding.superclass ? typeBinding : referenceBindingArray[0];
                    }
                    switch (typeBinding.kind()) {
                        case 68: {
                            typeVariableBinding2.superclass = parameterizedTypeBinding.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                            typeVariableBinding2.superInterfaces = referenceBindingArray;
                            break;
                        }
                        default: {
                            if (typeBinding.isInterface()) {
                                typeVariableBinding2.superclass = parameterizedTypeBinding.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                                int n3 = referenceBindingArray.length;
                                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                                referenceBindingArray = new ReferenceBinding[n3 + 1];
                                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 1, n3);
                                referenceBindingArray[0] = (ReferenceBinding)typeBinding;
                                typeVariableBinding2.superInterfaces = referenceBindingArray;
                                break;
                            }
                            typeVariableBinding2.superclass = (ReferenceBinding)typeBinding;
                            typeVariableBinding2.superInterfaces = referenceBindingArray;
                        }
                    }
                    ++n;
                }
            }
            if (substitution != null) {
                this.returnType = Scope.substitute(substitution, this.returnType);
                this.parameters = Scope.substitute(substitution, this.parameters);
                this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
                if (this.thrownExceptions == null) {
                    this.thrownExceptions = Binding.NO_EXCEPTIONS;
                }
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    int n4 = 0;
                    n = this.parameters.length;
                    while (n4 < n) {
                        if ((this.parameters[n4].tagBits & 0x80L) != 0L) {
                            this.tagBits |= 0x80L;
                            break block19;
                        }
                        ++n4;
                    }
                    n4 = 0;
                    n = this.thrownExceptions.length;
                    while (n4 < n) {
                        if ((this.thrownExceptions[n4].tagBits & 0x80L) != 0L) {
                            this.tagBits |= 0x80L;
                            break;
                        }
                        ++n4;
                    }
                }
            }
        }
    }

    public ParameterizedMethodBinding(ReferenceBinding referenceBinding, MethodBinding methodBinding, char[][] cArray, final LookupEnvironment lookupEnvironment) {
        block18: {
            int n;
            super(methodBinding.modifiers, methodBinding.selector, methodBinding.returnType, methodBinding.parameters, methodBinding.thrownExceptions, referenceBinding);
            this.originalMethod = methodBinding;
            this.tagBits = methodBinding.tagBits;
            final TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
            Substitution substitution = null;
            final int n2 = typeVariableBindingArray.length;
            if (n2 == 0) {
                this.typeVariables = Binding.NO_TYPE_VARIABLES;
            } else {
                TypeVariableBinding typeVariableBinding;
                final TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n2];
                n = 0;
                while (n < n2) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    typeVariableBindingArray2[n] = new TypeVariableBinding(cArray == null ? typeVariableBinding.sourceName : cArray[n], this, typeVariableBinding.rank, lookupEnvironment);
                    ++n;
                }
                this.typeVariables = typeVariableBindingArray2;
                substitution = new Substitution(){

                    public LookupEnvironment environment() {
                        return lookupEnvironment;
                    }

                    public boolean isRawSubstitution() {
                        return false;
                    }

                    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                        if (typeVariableBinding.rank < n2 && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
                            return typeVariableBindingArray2[typeVariableBinding.rank];
                        }
                        return typeVariableBinding;
                    }
                };
                n = 0;
                while (n < n2) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[n];
                    TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superclass);
                    ReferenceBinding[] referenceBindingArray = Scope.substitute(substitution, typeVariableBinding.superInterfaces);
                    if (typeVariableBinding.firstBound != null) {
                        typeVariableBinding2.firstBound = typeVariableBinding.firstBound == typeVariableBinding.superclass ? typeBinding : referenceBindingArray[0];
                    }
                    switch (typeBinding.kind()) {
                        case 68: {
                            typeVariableBinding2.superclass = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                            typeVariableBinding2.superInterfaces = referenceBindingArray;
                            break;
                        }
                        default: {
                            if (typeBinding.isInterface()) {
                                typeVariableBinding2.superclass = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                                int n3 = referenceBindingArray.length;
                                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                                referenceBindingArray = new ReferenceBinding[n3 + 1];
                                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 1, n3);
                                referenceBindingArray[0] = (ReferenceBinding)typeBinding;
                                typeVariableBinding2.superInterfaces = referenceBindingArray;
                                break;
                            }
                            typeVariableBinding2.superclass = (ReferenceBinding)typeBinding;
                            typeVariableBinding2.superInterfaces = referenceBindingArray;
                        }
                    }
                    ++n;
                }
            }
            if (substitution != null) {
                this.returnType = Scope.substitute(substitution, this.returnType);
                this.parameters = Scope.substitute(substitution, this.parameters);
                this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
                if (this.thrownExceptions == null) {
                    this.thrownExceptions = Binding.NO_EXCEPTIONS;
                }
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    int n4 = 0;
                    n = this.parameters.length;
                    while (n4 < n) {
                        if ((this.parameters[n4].tagBits & 0x80L) != 0L) {
                            this.tagBits |= 0x80L;
                            break block18;
                        }
                        ++n4;
                    }
                    n4 = 0;
                    n = this.thrownExceptions.length;
                    while (n4 < n) {
                        if ((this.thrownExceptions[n4].tagBits & 0x80L) != 0L) {
                            this.tagBits |= 0x80L;
                            break;
                        }
                        ++n4;
                    }
                }
            }
        }
    }

    public ParameterizedMethodBinding() {
    }

    public static ParameterizedMethodBinding instantiateGetClass(TypeBinding typeBinding, MethodBinding methodBinding, Scope scope) {
        ParameterizedMethodBinding parameterizedMethodBinding = new ParameterizedMethodBinding();
        parameterizedMethodBinding.modifiers = methodBinding.modifiers;
        parameterizedMethodBinding.selector = methodBinding.selector;
        parameterizedMethodBinding.declaringClass = methodBinding.declaringClass;
        parameterizedMethodBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
        parameterizedMethodBinding.originalMethod = methodBinding;
        parameterizedMethodBinding.parameters = methodBinding.parameters;
        parameterizedMethodBinding.thrownExceptions = methodBinding.thrownExceptions;
        parameterizedMethodBinding.tagBits = methodBinding.tagBits;
        ReferenceBinding referenceBinding = scope.getJavaLangClass();
        LookupEnvironment lookupEnvironment = scope.environment();
        TypeBinding typeBinding2 = lookupEnvironment.convertToRawType(typeBinding.erasure(), false);
        parameterizedMethodBinding.returnType = lookupEnvironment.createParameterizedType(referenceBinding, new TypeBinding[]{lookupEnvironment.createWildcard(referenceBinding, 0, typeBinding2, null, 1)}, null);
        if ((parameterizedMethodBinding.returnType.tagBits & 0x80L) != 0L) {
            parameterizedMethodBinding.tagBits |= 0x80L;
        }
        return parameterizedMethodBinding;
    }

    public boolean hasSubstitutedParameters() {
        return this.parameters != this.originalMethod.parameters;
    }

    public boolean hasSubstitutedReturnType() {
        return this.returnType != this.originalMethod.returnType;
    }

    public MethodBinding original() {
        return this.originalMethod.original();
    }
}

