/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public abstract class ReferenceBinding
extends TypeBinding {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;
    private SimpleLookupTable compatibleCache;
    public static final ReferenceBinding LUB_GENERIC = new ReferenceBinding(){};
    private static final Comparator FIELD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            char[] cArray = ((FieldBinding)object).name;
            char[] cArray2 = ((FieldBinding)object2).name;
            return ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
        }
    };
    private static final Comparator METHOD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            MethodBinding methodBinding = (MethodBinding)object;
            MethodBinding methodBinding2 = (MethodBinding)object2;
            char[] cArray = methodBinding.selector;
            char[] cArray2 = methodBinding2.selector;
            int n = ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
            return n == 0 ? methodBinding.parameters.length - methodBinding2.parameters.length : n;
        }
    };

    public static FieldBinding binarySearch(char[] cArray, FieldBinding[] fieldBindingArray) {
        if (fieldBindingArray == null) {
            return null;
        }
        int n = fieldBindingArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = fieldBindingArray[n5].name;
            int n6 = ReferenceBinding.compare(cArray, fieldBindingArray[n5].name, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            return fieldBindingArray[n5];
        }
        return null;
    }

    public static long binarySearch(char[] cArray, MethodBinding[] methodBindingArray) {
        if (methodBindingArray == null) {
            return -1L;
        }
        int n = methodBindingArray.length;
        if (n == 0) {
            return -1L;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = methodBindingArray[n5].selector;
            int n6 = ReferenceBinding.compare(cArray, methodBindingArray[n5].selector, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            int n7 = n5;
            int n8 = n5;
            while (n7 > n2 && CharOperation.equals(methodBindingArray[n7 - 1].selector, cArray)) {
                --n7;
            }
            while (n8 < n3 && CharOperation.equals(methodBindingArray[n8 + 1].selector, cArray)) {
                ++n8;
            }
            return (long)n7 + ((long)n8 << 32);
        }
        return -1L;
    }

    static int compare(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = cArray[n4];
            if (c2 == (c = cArray2[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static void sortFields(FieldBinding[] fieldBindingArray, int n, int n2) {
        Arrays.sort(fieldBindingArray, n, n2, FIELD_COMPARATOR);
    }

    public static void sortMethods(MethodBinding[] methodBindingArray, int n, int n2) {
        Arrays.sort(methodBindingArray, n, n2, METHOD_COMPARATOR);
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.fPackage;
    }

    public final boolean canBeSeenBy(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        if (this.isPublic()) {
            return true;
        }
        if (referenceBinding2 == this && referenceBinding2 == referenceBinding) {
            return true;
        }
        if (this.isProtected()) {
            if (referenceBinding2 == this) {
                return true;
            }
            if (referenceBinding2.fPackage == this.fPackage) {
                return true;
            }
            TypeBinding typeBinding = referenceBinding2.erasure();
            TypeBinding typeBinding2 = this.enclosingType().erasure();
            if (typeBinding2 == referenceBinding2) {
                return true;
            }
            if (typeBinding2 == null) {
                return false;
            }
            do {
                if (typeBinding.findSuperTypeOriginatingFrom(typeBinding2) == null) continue;
                return true;
            } while ((typeBinding = typeBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding3;
            if (!(referenceBinding == this || referenceBinding == this.enclosingType() || referenceBinding.isTypeVariable() && (((TypeVariableBinding)(referenceBinding3 = (TypeVariableBinding)referenceBinding)).isErasureBoundTo(this.erasure()) || ((TypeVariableBinding)referenceBinding3).isErasureBoundTo(this.enclosingType().erasure())))) {
                return false;
            }
            if (referenceBinding2 != this) {
                referenceBinding3 = referenceBinding2;
                ReferenceBinding referenceBinding4 = referenceBinding3.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding3 = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                ReferenceBinding referenceBinding5 = (ReferenceBinding)this.erasure();
                referenceBinding4 = referenceBinding5.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding5 = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                if (referenceBinding3 != referenceBinding5) {
                    return false;
                }
            }
            return true;
        }
        if (referenceBinding2.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding referenceBinding6 = referenceBinding;
        TypeBinding typeBinding = (this.enclosingType() == null ? this : this.enclosingType()).original();
        do {
            if (typeBinding == referenceBinding6.original()) {
                return true;
            }
            PackageBinding packageBinding = referenceBinding6.fPackage;
            if (packageBinding == null || packageBinding == this.fPackage) continue;
            return false;
        } while ((referenceBinding6 = referenceBinding6.superclass()) != null);
        return false;
    }

    public final boolean canBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.fPackage) {
                return true;
            }
            TypeBinding typeBinding = this.enclosingType();
            if (typeBinding == null) {
                return false;
            }
            typeBinding = typeBinding.erasure();
            TypeBinding typeBinding2 = sourceTypeBinding.erasure();
            do {
                if (typeBinding == sourceTypeBinding) {
                    return true;
                }
                if (typeBinding2.findSuperTypeOriginatingFrom(typeBinding) == null) continue;
                return true;
            } while ((typeBinding2 = typeBinding2.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.erasure();
            referenceBinding2 = referenceBinding3.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            return referenceBinding == referenceBinding3;
        }
        return sourceTypeBinding.fPackage == this.fPackage;
    }

    public char[] computeGenericTypeSignature(TypeVariableBinding[] typeVariableBindingArray) {
        char[] cArray;
        boolean bl;
        boolean bl2 = bl = this.isMemberType() && (this.enclosingType().modifiers & 0x40000000) != 0;
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES && !bl) {
            return this.signature();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (bl) {
            cArray = this.enclosingType().genericTypeSignature();
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('.');
            stringBuffer.append(this.sourceName);
        } else {
            cArray = this.signature();
            stringBuffer.append(cArray, 0, cArray.length - 1);
        }
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                stringBuffer.append(typeVariableBindingArray[n].genericTypeSignature());
                ++n;
            }
            stringBuffer.append(">;");
        }
        int n = stringBuffer.length();
        char[] cArray2 = new char[n];
        stringBuffer.getChars(0, n, cArray2, 0);
        return cArray2;
    }

    public void computeId() {
        block0 : switch (this.compoundName.length) {
            case 3: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                char[] cArray = this.compoundName[1];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray2 = this.compoundName[2];
                if (cArray2.length == 0) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    switch (cArray[0]) {
                        case 'i': {
                            if (CharOperation.equals(cArray, TypeConstants.IO)) {
                                switch (cArray2[0]) {
                                    case 'E': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_EXTERNALIZABLE[2])) {
                                            this.id = 56;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_IOEXCEPTION[2])) {
                                            this.id = 58;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_OBJECTSTREAMEXCEPTION[2])) {
                                            this.id = 57;
                                        }
                                        return;
                                    }
                                    case 'P': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_PRINTSTREAM[2])) {
                                            this.id = 53;
                                        }
                                        return;
                                    }
                                    case 'S': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_SERIALIZABLE[2])) {
                                            this.id = 37;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                        case 'u': {
                            if (CharOperation.equals(cArray, TypeConstants.UTIL)) {
                                switch (cArray2[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_COLLECTION[2])) {
                                            this.id = 59;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_ITERATOR[2])) {
                                            this.id = 39;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                    }
                    return;
                }
                switch (cArray2[0]) {
                    case 'A': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ASSERTIONERROR[2])) {
                            this.id = 35;
                        }
                        return;
                    }
                    case 'B': {
                        switch (cArray2.length) {
                            case 4: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_BYTE[2])) {
                                    this.id = 26;
                                }
                                return;
                            }
                            case 7: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_BOOLEAN[2])) {
                                    this.id = 33;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'C': {
                        switch (cArray2.length) {
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLASS[2])) {
                                    this.id = 16;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CHARACTER[2])) {
                                    this.id = 28;
                                } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLONEABLE[2])) {
                                    this.id = 36;
                                }
                                return;
                            }
                            case 22: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLASSNOTFOUNDEXCEPTION[2])) {
                                    this.id = 23;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'D': {
                        switch (cArray2.length) {
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_DOUBLE[2])) {
                                    this.id = 32;
                                }
                                return;
                            }
                            case 10: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                                    this.id = 44;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'E': {
                        switch (cArray2.length) {
                            case 4: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ENUM[2])) {
                                    this.id = 41;
                                }
                                return;
                            }
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ERROR[2])) {
                                    this.id = 19;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_EXCEPTION[2])) {
                                    this.id = 25;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_FLOAT[2])) {
                            this.id = 31;
                        }
                        return;
                    }
                    case 'I': {
                        switch (cArray2.length) {
                            case 7: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_INTEGER[2])) {
                                    this.id = 29;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ITERABLE[2])) {
                                    this.id = 38;
                                }
                                return;
                            }
                            case 24: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION[2])) {
                                    this.id = 42;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'L': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_LONG[2])) {
                            this.id = 30;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_NOCLASSDEFERROR[2])) {
                            this.id = 22;
                        }
                        return;
                    }
                    case 'O': {
                        switch (cArray2.length) {
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_OBJECT[2])) {
                                    this.id = 1;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_OVERRIDE[2])) {
                                    this.id = 47;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'R': {
                        if (!CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2])) break block0;
                        this.id = 24;
                        break block0;
                    }
                    case 'S': {
                        switch (cArray2.length) {
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SHORT[2])) {
                                    this.id = 27;
                                }
                                return;
                            }
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRING[2])) {
                                    this.id = 11;
                                } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SYSTEM[2])) {
                                    this.id = 18;
                                }
                                return;
                            }
                            case 12: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRINGBUFFER[2])) {
                                    this.id = 17;
                                }
                                return;
                            }
                            case 13: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRINGBUILDER[2])) {
                                    this.id = 40;
                                }
                                return;
                            }
                            case 16: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SUPPRESSWARNINGS[2])) {
                                    this.id = 49;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_THROWABLE[2])) {
                            this.id = 21;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    return;
                }
                char[] cArray = this.compoundName[2];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray3 = this.compoundName[3];
                if (cArray3.length == 0) {
                    return;
                }
                switch (cArray[0]) {
                    case 'a': {
                        if (CharOperation.equals(cArray, TypeConstants.ANNOTATION)) {
                            switch (cArray3[0]) {
                                case 'A': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                                        this.id = 43;
                                    }
                                    return;
                                }
                                case 'D': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                                        this.id = 45;
                                    }
                                    return;
                                }
                                case 'E': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                                        this.id = 52;
                                    }
                                    return;
                                }
                                case 'I': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED[3])) {
                                        this.id = 46;
                                    }
                                    return;
                                }
                                case 'R': {
                                    switch (cArray3.length) {
                                        case 9: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION[3])) {
                                                this.id = 48;
                                            }
                                            return;
                                        }
                                        case 15: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                                                this.id = 51;
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                case 'T': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_TARGET[3])) {
                                        this.id = 50;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'r': {
                        if (CharOperation.equals(cArray, TypeConstants.REFLECT)) {
                            switch (cArray3[0]) {
                                case 'C': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR[2])) {
                                        this.id = 20;
                                    }
                                    return;
                                }
                                case 'F': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_FIELD[2])) {
                                        this.id = 54;
                                    }
                                    return;
                                }
                                case 'M': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_METHOD[2])) {
                                        this.id = 55;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                }
            }
        }
    }

    public char[] computeUniqueKey(boolean bl) {
        if (!bl) {
            return this.signature();
        }
        return this.genericTypeSignature();
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    public String debugName() {
        return this.compoundName != null ? new String(this.readableName()) : "UNNAMED TYPE";
    }

    public final int depth() {
        int n = 0;
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.enclosingType()) != null) {
            ++n;
        }
        return n;
    }

    public boolean detectAnnotationCycle() {
        if ((this.tagBits & 0x100000000L) != 0L) {
            return false;
        }
        if ((this.tagBits & 0x80000000L) != 0L) {
            return true;
        }
        this.tagBits |= 0x80000000L;
        MethodBinding[] methodBindingArray = this.methods();
        boolean bl = false;
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodDeclaration methodDeclaration;
            TypeBinding typeBinding = methodBindingArray[n].returnType.leafComponentType();
            if (this == typeBinding) {
                if (this instanceof SourceTypeBinding) {
                    methodDeclaration = (MethodDeclaration)methodBindingArray[n].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, this, methodDeclaration != null ? methodDeclaration.returnType : null);
                }
            } else if (typeBinding.isAnnotationType() && ((ReferenceBinding)typeBinding).detectAnnotationCycle()) {
                if (this instanceof SourceTypeBinding) {
                    methodDeclaration = (MethodDeclaration)methodBindingArray[n].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, typeBinding, methodDeclaration != null ? methodDeclaration.returnType : null);
                }
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        this.tagBits |= 0x100000000L;
        return false;
    }

    public final ReferenceBinding enclosingTypeAt(int n) {
        ReferenceBinding referenceBinding = this;
        while (n-- > 0 && referenceBinding != null) {
            referenceBinding = referenceBinding.enclosingType();
        }
        return referenceBinding;
    }

    public int enumConstantCount() {
        int n = 0;
        FieldBinding[] fieldBindingArray = this.fields();
        int n2 = 0;
        int n3 = fieldBindingArray.length;
        while (n2 < n3) {
            if ((fieldBindingArray[n2].modifiers & 0x4000) != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return Binding.NO_FIELDS;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public int getEnclosingInstancesSlotSize() {
        if (this.isStatic()) {
            return 0;
        }
        return this.enclosingType() == null ? 0 : 1;
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        ReferenceBinding[] referenceBindingArray = this.memberTypes();
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(referenceBindingArray[n].sourceName, cArray)) continue;
            return referenceBindingArray[n];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        return Binding.NO_METHODS;
    }

    public MethodBinding[] getMethods(char[] cArray, int n) {
        return this.getMethods(cArray);
    }

    public int getOuterLocalVariablesSlotSize() {
        return 0;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        int n = typeVariableBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(typeVariableBindingArray[n].sourceName, cArray)) continue;
            return typeVariableBindingArray[n];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding referenceBinding) {
        int n;
        TypeBinding typeBinding;
        if (this == referenceBinding) {
            return false;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            if ((typeBinding = referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2)) != null && typeBinding.isProvablyDistinct(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray2 = referenceBinding2.superInterfaces();
            if (referenceBindingArray2 == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            n = 0;
            while (n < n3) {
                block16: {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    int n4 = 0;
                    while (n4 < n2) {
                        if (referenceBinding3 != referenceBindingArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block16;
                    }
                    referenceBindingArray[n2++] = referenceBinding3;
                }
                ++n;
            }
        } while ((referenceBinding2 = referenceBinding2.superclass()) != null);
        int n5 = 0;
        while (n5 < n2) {
            referenceBinding2 = referenceBindingArray[n5];
            if (referenceBinding2 == referenceBinding) {
                return false;
            }
            typeBinding = referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2);
            if (typeBinding != null && typeBinding.isProvablyDistinct(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 != null && referenceBindingArray4 != Binding.NO_SUPERINTERFACES) {
                n = referenceBindingArray4.length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                }
                int n6 = 0;
                while (n6 < n) {
                    block17: {
                        ReferenceBinding referenceBinding4 = referenceBindingArray4[n6];
                        int n7 = 0;
                        while (n7 < n2) {
                            if (referenceBinding4 != referenceBindingArray[n7]) {
                                ++n7;
                                continue;
                            }
                            break block17;
                        }
                        referenceBindingArray[n2++] = referenceBinding4;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return false;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean implementsInterface(ReferenceBinding referenceBinding, boolean bl) {
        int n;
        if (this == referenceBinding) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            ReferenceBinding[] referenceBindingArray2;
            if ((referenceBindingArray2 = referenceBinding2.superInterfaces()) == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            n = 0;
            while (n < n3) {
                block14: {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    int n4 = 0;
                    while (n4 < n2) {
                        if (referenceBinding3 != referenceBindingArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block14;
                    }
                    referenceBindingArray[n2++] = referenceBinding3;
                }
                ++n;
            }
        } while (bl && (referenceBinding2 = referenceBinding2.superclass()) != null);
        int n5 = 0;
        while (n5 < n2) {
            referenceBinding2 = referenceBindingArray[n5];
            if (referenceBinding2.isEquivalentTo(referenceBinding)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 != null && referenceBindingArray4 != Binding.NO_SUPERINTERFACES) {
                n = referenceBindingArray4.length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                }
                int n6 = 0;
                while (n6 < n) {
                    block15: {
                        ReferenceBinding referenceBinding4 = referenceBindingArray4[n6];
                        int n7 = 0;
                        while (n7 < n2) {
                            if (referenceBinding4 != referenceBindingArray[n7]) {
                                ++n7;
                                continue;
                            }
                            break block15;
                        }
                        referenceBindingArray[n2++] = referenceBinding4;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding methodBinding) {
        char[] cArray = methodBinding.selector;
        ReferenceBinding referenceBinding = this;
        while (referenceBinding != null) {
            MethodBinding[] methodBindingArray = referenceBinding.methods();
            long l = ReferenceBinding.binarySearch(cArray, methodBindingArray);
            if (l >= 0L) {
                int n = (int)l;
                int n2 = (int)(l >> 32);
                int n3 = n;
                while (n3 <= n2) {
                    if (methodBindingArray[n3].areParametersEqual(methodBinding)) {
                        return true;
                    }
                    ++n3;
                }
            }
            referenceBinding = referenceBinding.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    public boolean isCompatibleWith(TypeBinding typeBinding) {
        if (typeBinding == this) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.compatibleCache == null) {
            this.compatibleCache = new SimpleLookupTable(3);
            Object var2_2 = null;
        } else {
            Object object = this.compatibleCache.get(typeBinding);
            if (object != null) {
                return object == Boolean.TRUE;
            }
        }
        this.compatibleCache.put(typeBinding, Boolean.FALSE);
        if (this.isCompatibleWith0(typeBinding)) {
            this.compatibleCache.put(typeBinding, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private boolean isCompatibleWith0(TypeBinding typeBinding) {
        if (typeBinding == this) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return false;
            }
            case 4100: {
                ReferenceBinding referenceBinding;
                if (typeBinding.isCapture()) {
                    referenceBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = ((CaptureBinding)referenceBinding).lowerBound;
                    if (typeBinding2 != null) {
                        if (typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2);
                    }
                }
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: {
                switch (this.kind()) {
                    case 260: 
                    case 1028: 
                    case 2052: {
                        if (this.erasure() != typeBinding.erasure()) break;
                        return false;
                    }
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                if (referenceBinding.isInterface()) {
                    return this.implementsInterface(referenceBinding, true);
                }
                if (this.isInterface()) {
                    return false;
                }
                return referenceBinding.isSuperclassOf(this);
            }
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isHierarchyConnected() {
        return true;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if (this.isLocalType()) {
            return true;
        }
        ReferenceBinding referenceBinding = this;
        while (referenceBinding != null) {
            if ((referenceBinding.modifiers & 2) != 0) {
                return true;
            }
            referenceBinding = referenceBinding.enclosingType();
        }
        return false;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            if (!referenceBinding.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowable() {
        ReferenceBinding referenceBinding = this;
        do {
            switch (referenceBinding.id) {
                case 19: 
                case 21: 
                case 24: 
                case 25: {
                    return true;
                }
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public boolean isUncheckedException(boolean bl) {
        switch (this.id) {
            case 19: 
            case 24: {
                return true;
            }
            case 21: 
            case 25: {
                return bl;
            }
        }
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            switch (referenceBinding.id) {
                case 19: 
                case 24: {
                    return true;
                }
                case 21: 
                case 25: {
                    return false;
                }
            }
        }
        return false;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0 || this.getPackage().isViewedAsDeprecated();
    }

    public ReferenceBinding[] memberTypes() {
        return Binding.NO_MEMBER_TYPES;
    }

    public MethodBinding[] methods() {
        return Binding.NO_METHODS;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding referenceBinding;
        ReferenceBinding referenceBinding2 = this;
        do {
            referenceBinding = referenceBinding2;
        } while ((referenceBinding2 = referenceBinding2.enclosingType()) != null);
        return referenceBinding;
    }

    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    public char[] readableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].readableName());
                ++n;
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
        return simpleLookupTable == null ? null : (AnnotationHolder)simpleLookupTable.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder annotationHolder = this.retrieveAnnotationHolder(binding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getAnnotations();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.storeAnnotations(this, annotationBindingArray);
    }

    public char[] shortReadableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName;
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].shortReadableName());
                ++n;
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder annotationHolder) {
        if (annotationHolder == null) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
            if (simpleLookupTable != null) {
                simpleLookupTable.removeKey(binding);
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true);
            if (simpleLookupTable != null) {
                simpleLookupTable.put(binding, annotationHolder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotationBindingArray) {
        AnnotationHolder annotationHolder = null;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
            if (simpleLookupTable != null) {
                annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            }
            if (annotationHolder == null) {
                return;
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true);
            if (simpleLookupTable == null) {
                return;
            }
            annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            if (annotationHolder == null) {
                annotationHolder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, annotationHolder.setAnnotations(annotationBindingArray));
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        return null;
    }

    public ReferenceBinding superclass() {
        return null;
    }

    public ReferenceBinding[] superInterfaces() {
        return Binding.NO_SUPERINTERFACES;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding == null) {
            return null;
        }
        return new ReferenceBinding[]{referenceBinding};
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return null;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }
}

