/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.jettyrunner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.jettyrunner.Connectors;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class ManifoldCFJettyRunner {
    public static final String _rcsid = "@(#)$Id: ManifoldCFJettyRunner.java 989983 2010-08-27 00:10:12Z kwright $";
    public static final String agentShutdownSignal = "_AGENTRUN_";
    public static final String connectorsConfigurationFile = "org.apache.manifoldcf.connectorsconfigurationfile";
    public static final String databaseSuperuserName = "org.apache.manifoldcf.dbsuperusername";
    public static final String databaseSuperuserPassword = "org.apache.manifoldcf.dbsuperuserpassword";
    public static final String NODE_OUTPUTCONNECTOR = "outputconnector";
    public static final String NODE_AUTHORITYCONNECTOR = "authorityconnector";
    public static final String NODE_REPOSITORYCONNECTOR = "repositoryconnector";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CLASS = "class";
    protected Server server;

    public ManifoldCFJettyRunner(int port, String crawlerWarPath, String authorityServiceWarPath, String apiWarPath) {
        this.server = new Server(port);
        this.server.setStopAtShutdown(true);
        WebAppContext lcfCrawlerUI = new WebAppContext(crawlerWarPath, "/mcf-crawler-ui");
        lcfCrawlerUI.setParentLoaderPriority(true);
        this.server.addHandler((Handler)lcfCrawlerUI);
        WebAppContext lcfAuthorityService = new WebAppContext(authorityServiceWarPath, "/mcf-authority-service");
        lcfAuthorityService.setParentLoaderPriority(true);
        this.server.addHandler((Handler)lcfAuthorityService);
        WebAppContext lcfApi = new WebAppContext(apiWarPath, "/mcf-api-service");
        lcfApi.setParentLoaderPriority(true);
        this.server.addHandler((Handler)lcfApi);
    }

    public void start() throws ManifoldCFException {
        if (!this.server.isRunning()) {
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new ManifoldCFException("Couldn't start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() throws ManifoldCFException {
        if (this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new ManifoldCFException("Couldn't stop: " + e.getMessage(), (Throwable)e);
            }
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    public int getLocalPort() throws ManifoldCFException {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new ManifoldCFException("Jetty Server has no Connectors");
        }
        return conns[0].getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 4 && args.length != 1 && args.length != 0) {
            System.err.println("Usage: ManifoldCFJettyRunner [<port> [<crawler-war-path> <authority-service-war-path> <api-war-path>]]");
            System.exit(1);
        }
        int jettyPort = 8345;
        if (args.length > 0) {
            try {
                jettyPort = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        String crawlerWarPath = "war/mcf-crawler-ui.war";
        String authorityserviceWarPath = "war/mcf-authority-service.war";
        String apiWarPath = "war/mcf-api-service.war";
        if (args.length == 4) {
            crawlerWarPath = args[1];
            authorityserviceWarPath = args[2];
            apiWarPath = args[3];
        }
        System.setProperty("org.apache.manifoldcf.configfile", "./properties.xml");
        try {
            String[] connectionNames;
            String[] connectionNames2;
            String superuserPassword;
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            ILockManager lockManager = LockManagerFactory.make((IThreadContext)tc);
            lockManager.clearGlobalFlag(agentShutdownSignal);
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            String superuserName = ManifoldCF.getProperty((String)databaseSuperuserName);
            if (superuserName == null) {
                superuserName = "";
            }
            if ((superuserPassword = ManifoldCF.getProperty((String)databaseSuperuserPassword)) == null) {
                superuserPassword = "";
            }
            ManifoldCF.createSystemDatabase((IThreadContext)tc, (String)superuserName, (String)superuserPassword);
            ManifoldCF.installTables((IThreadContext)tc);
            IAgentManager agentMgr = AgentManagerFactory.make((IThreadContext)tc);
            agentMgr.registerAgent("org.apache.manifoldcf.crawler.system.CrawlerAgent");
            Connectors c = null;
            File connectorConfigFile = ManifoldCF.getFileProperty((String)connectorsConfigurationFile);
            if (connectorConfigFile != null) {
                try {
                    FileInputStream is = new FileInputStream(connectorConfigFile);
                    try {
                        c = new Connectors(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ManifoldCFException("Couldn't find connector configuration file: " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ManifoldCFException("Error reading connector configuration file: " + e.getMessage(), (Throwable)e);
                }
            }
            IOutputConnectorManager mgr = OutputConnectorManagerFactory.make((IThreadContext)tc);
            IOutputConnectionManager connManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
            IResultSet classNames = mgr.getConnectors();
            int i = 0;
            while (i < classNames.getRowCount()) {
                IResultRow row = classNames.getRow(i++);
                String className = (String)row.getValue("classname");
                database.beginTransaction();
                try {
                    connectionNames2 = connManager.findConnectionsForConnector(className);
                    AgentManagerFactory.noteOutputConnectorDeregistration((IThreadContext)tc, (String[])connectionNames2);
                    mgr.unregisterConnector(className);
                }
                catch (ManifoldCFException e) {
                    database.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    database.signalRollback();
                    throw e;
                }
                finally {
                    database.endTransaction();
                }
            }
            System.err.println("Successfully unregistered all output connectors");
            mgr = AuthorityConnectorManagerFactory.make((IThreadContext)tc);
            IResultSet classNames2 = mgr.getConnectors();
            int i2 = 0;
            while (i2 < classNames2.getRowCount()) {
                IResultRow row = classNames2.getRow(i2++);
                mgr.unregisterConnector((String)row.getValue("classname"));
            }
            System.err.println("Successfully unregistered all authority connectors");
            mgr = ConnectorManagerFactory.make((IThreadContext)tc);
            IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
            IRepositoryConnectionManager connManager2 = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
            IResultSet classNames3 = mgr.getConnectors();
            int i3 = 0;
            while (i3 < classNames3.getRowCount()) {
                IResultRow row = classNames3.getRow(i3++);
                String className = (String)row.getValue("classname");
                database.beginTransaction();
                try {
                    connectionNames = connManager2.findConnectionsForConnector(className);
                    jobManager.noteConnectorDeregistration(connectionNames);
                    mgr.unregisterConnector(className);
                }
                catch (ManifoldCFException e) {
                    database.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    database.signalRollback();
                    throw e;
                }
                finally {
                    database.endTransaction();
                }
            }
            System.err.println("Successfully unregistered all repository connectors");
            if (c != null) {
                int i4 = 0;
                while (i4 < c.getChildCount()) {
                    IOutputConnectorManager mgr2;
                    String className;
                    String name;
                    ConfigurationNode cn;
                    if ((cn = c.findChild(i4++)).getType().equals(NODE_OUTPUTCONNECTOR)) {
                        name = cn.getAttributeValue(ATTRIBUTE_NAME);
                        className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                        mgr2 = OutputConnectorManagerFactory.make((IThreadContext)tc);
                        IOutputConnectionManager connManager3 = OutputConnectionManagerFactory.make((IThreadContext)tc);
                        database.beginTransaction();
                        try {
                            mgr2.registerConnector(name, className);
                            connectionNames2 = connManager3.findConnectionsForConnector(className);
                            AgentManagerFactory.noteOutputConnectorRegistration((IThreadContext)tc, (String[])connectionNames2);
                        }
                        catch (ManifoldCFException e) {
                            database.signalRollback();
                            throw e;
                        }
                        catch (Error e) {
                            database.signalRollback();
                            throw e;
                        }
                        finally {
                            database.endTransaction();
                        }
                        System.err.println("Successfully registered output connector '" + className + "'");
                        continue;
                    }
                    if (cn.getType().equals(NODE_AUTHORITYCONNECTOR)) {
                        name = cn.getAttributeValue(ATTRIBUTE_NAME);
                        className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                        mgr2 = AuthorityConnectorManagerFactory.make((IThreadContext)tc);
                        mgr2.registerConnector(name, className);
                        System.err.println("Successfully registered authority connector '" + className + "'");
                        continue;
                    }
                    if (cn.getType().equals(NODE_REPOSITORYCONNECTOR)) {
                        name = cn.getAttributeValue(ATTRIBUTE_NAME);
                        className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                        mgr2 = ConnectorManagerFactory.make((IThreadContext)tc);
                        IJobManager jobManager2 = JobManagerFactory.make((IThreadContext)tc);
                        IRepositoryConnectionManager connManager4 = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
                        database.beginTransaction();
                        try {
                            mgr2.registerConnector(name, className);
                            connectionNames = connManager4.findConnectionsForConnector(className);
                            jobManager2.noteConnectorRegistration(connectionNames);
                        }
                        catch (ManifoldCFException e) {
                            database.signalRollback();
                            throw e;
                        }
                        catch (Error e) {
                            database.signalRollback();
                            throw e;
                        }
                        finally {
                            database.endTransaction();
                        }
                        System.err.println("Successfully registered repository connector '" + className + "'");
                        continue;
                    }
                    throw new ManifoldCFException("Unrecognized connectors node type '" + cn.getType() + "'");
                }
            }
            System.err.println("Starting jetty...");
            ManifoldCFJettyRunner jetty = new ManifoldCFJettyRunner(jettyPort, crawlerWarPath, authorityserviceWarPath, apiWarPath);
            jetty.start();
            System.err.println("Jetty started.");
            System.err.println("Starting crawler...");
            while (!lockManager.checkGlobalFlag(agentShutdownSignal)) {
                ManifoldCF.startAgents((IThreadContext)tc);
                try {
                    ManifoldCF.sleep((long)5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            System.err.println("Shutting down crawler...");
        }
        catch (ManifoldCFException e) {
            if (Logging.root != null) {
                Logging.root.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

