/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class BaseFetchException
extends Exception {
    private String _url = "";
    private Exception _exception;

    protected BaseFetchException() {
        this._exception = new Exception();
    }

    protected BaseFetchException(String url) {
        this._exception = new Exception();
        this._url = url;
    }

    protected BaseFetchException(String url, String msg) {
        super(msg);
        this._exception = new Exception(msg);
        this._url = url;
    }

    protected BaseFetchException(String url, Exception e) {
        super(e);
        this._exception = new Exception(e);
        this._url = url;
    }

    protected BaseFetchException(String url, String msg, Exception e) {
        super(msg, e);
        this._exception = new Exception(msg, e);
        this._url = url;
    }

    public String getUrl() {
        return this._url;
    }

    protected int compareToBase(BaseFetchException e) {
        return this._url.compareTo(e._url);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseFetchException other = (BaseFetchException)obj;
        if (this._exception == null ? other._exception != null : !this._exception.equals(other._exception)) {
            return false;
        }
        return !(this._url == null ? other._url != null : !this._url.equals(other._url));
    }

    @Override
    public Throwable getCause() {
        return this._exception.getCause();
    }

    @Override
    public String getLocalizedMessage() {
        return this._exception.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        return this._exception.getMessage();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this._exception.getStackTrace();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._exception == null ? 0 : this._exception.hashCode());
        result = 31 * result + (this._url == null ? 0 : this._url.hashCode());
        return result;
    }

    @Override
    public Throwable initCause(Throwable cause) {
        return this._exception.initCause(cause);
    }

    @Override
    public void printStackTrace() {
        this._exception.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this._exception.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this._exception.printStackTrace(s);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        this._exception.setStackTrace(stackTrace);
    }

    @Override
    public String toString() {
        return this._url + ": " + this._exception.toString();
    }

    protected void readBaseFields(DataInput input) throws IOException {
        int serializedLen = input.readInt();
        byte[] serialized = new byte[serializedLen];
        input.readFully(serialized);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serialized));
        try {
            this._exception = (Exception)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this._url = input.readUTF();
    }

    protected void writeBaseFields(DataOutput output) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this._exception);
        byte[] serialized = bos.toByteArray();
        output.writeInt(serialized.length);
        output.write(bos.toByteArray());
        output.writeUTF(this._url);
    }
}

