/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher;

import crawlercommons.fetcher.BaseFetchException;
import crawlercommons.fetcher.FetchedResult;
import crawlercommons.fetcher.Payload;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tika.mime.MediaType;

public abstract class BaseFetcher
implements Serializable {
    public static final int DEFAULT_MAX_CONTENT_SIZE = 65536;
    protected Map<String, Integer> _maxContentSizes = new HashMap<String, Integer>();
    protected int _defaultMaxContentSize = 65536;
    protected Set<String> _validMimeTypes = new HashSet<String>();

    public void setDefaultMaxContentSize(int defaultMaxContentSize) {
        this._defaultMaxContentSize = defaultMaxContentSize;
    }

    public int getDefaultMaxContentSize() {
        return this._defaultMaxContentSize;
    }

    public void setMaxContentSize(String mimeType, int maxContentSize) {
        this._maxContentSizes.put(mimeType, maxContentSize);
    }

    public int getMaxContentSize(String mimeType) {
        Integer result = this._maxContentSizes.get(mimeType);
        if (result == null) {
            result = this.getDefaultMaxContentSize();
        }
        return result;
    }

    public Set<String> getValidMimeTypes() {
        return this._validMimeTypes;
    }

    public void setValidMimeTypes(Set<String> validMimeTypes) {
        this._validMimeTypes = new HashSet<String>(validMimeTypes);
    }

    public void addValidMimeTypes(Set<String> validMimeTypes) {
        this._validMimeTypes.addAll(validMimeTypes);
    }

    public void addValidMimeType(String validMimeType) {
        this._validMimeTypes.add(validMimeType);
    }

    public FetchedResult get(String url) throws BaseFetchException {
        return this.get(url, null);
    }

    protected static String getMimeTypeFromContentType(String contentType) {
        String result = "";
        MediaType mt = MediaType.parse((String)contentType);
        if (mt != null) {
            result = mt.getType() + "/" + mt.getSubtype();
        }
        return result;
    }

    public abstract FetchedResult get(String var1, Payload var2) throws BaseFetchException;

    public abstract void abort();
}

