/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodingUtils.class);
    private static final int EXPECTED_GZIP_COMPRESSION_RATIO = 5;
    private static final int EXPECTED_DEFLATE_COMPRESSION_RATIO = 5;
    private static final int BUF_SIZE = 4096;

    public static byte[] processGzipEncoded(byte[] compressed) throws IOException {
        return EncodingUtils.processGzipEncoded(compressed, Integer.MAX_VALUE).getExpanded();
    }

    public static ExpandedResult processGzipEncoded(byte[] compressed, int sizeLimit) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * compressed.length);
        GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(compressed));
        boolean isTruncated = false;
        byte[] buf = new byte[4096];
        int written = 0;
        try {
            int size;
            while ((size = inStream.read(buf)) > 0) {
                if (written + size > sizeLimit) {
                    isTruncated = true;
                    outStream.write(buf, 0, sizeLimit - written);
                    break;
                }
                outStream.write(buf, 0, size);
                written += size;
            }
        }
        catch (Exception e) {
            LOGGER.trace("Exception unzipping content", (Throwable)e);
        }
        EncodingUtils.safeClose(outStream);
        return new ExpandedResult(outStream.toByteArray(), isTruncated);
    }

    public static byte[] processDeflateEncoded(byte[] content) throws IOException {
        return EncodingUtils.processDeflateEncoded(content, Integer.MAX_VALUE);
    }

    public static byte[] processDeflateEncoded(byte[] compressed, int sizeLimit) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * compressed.length);
        Inflater inflater = new Inflater(true);
        InflaterInputStream inStream = new InflaterInputStream(new ByteArrayInputStream(compressed), inflater);
        byte[] buf = new byte[4096];
        int written = 0;
        try {
            int size;
            while ((size = inStream.read(buf)) > 0) {
                if (written + size > sizeLimit) {
                    outStream.write(buf, 0, sizeLimit - written);
                    break;
                }
                outStream.write(buf, 0, size);
                written += size;
            }
        }
        catch (Exception e) {
            LOGGER.trace("Exception inflating content", (Throwable)e);
        }
        EncodingUtils.safeClose(outStream);
        return outStream.toByteArray();
    }

    private static void safeClose(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException e) {
            LOGGER.warn("IOException closing input stream", (Throwable)e);
        }
    }

    public static class ExpandedResult {
        private byte[] _expanded;
        private boolean _isTruncated;

        public ExpandedResult(byte[] expanded, boolean isTruncated) {
            this._expanded = expanded;
            this._isTruncated = isTruncated;
        }

        public byte[] getExpanded() {
            return this._expanded;
        }

        public void setExpanded(byte[] expanded) {
            this._expanded = expanded;
        }

        public boolean isTruncated() {
            return this._isTruncated;
        }

        public void setTruncated(boolean isTruncated) {
            this._isTruncated = isTruncated;
        }
    }
}

