/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher;

import crawlercommons.fetcher.Payload;
import java.security.InvalidParameterException;
import org.apache.tika.metadata.Metadata;

public class FetchedResult {
    private final String _baseUrl;
    private final String _fetchedUrl;
    private final long _fetchTime;
    private final byte[] _content;
    private final String _contentType;
    private final int _responseRate;
    private final Metadata _headers;
    private final String _newBaseUrl;
    private final int _numRedirects;
    private final String _hostAddress;
    private final int _statusCode;
    private final String _reasonPhrase;
    private Payload _payload;

    public FetchedResult(String baseUrl, String redirectedUrl, long fetchTime, Metadata headers, byte[] content, String contentType, int responseRate, Payload payload, String newBaseUrl, int numRedirects, String hostAddress, int statusCode, String reasonPhrase) {
        this._payload = payload;
        if (baseUrl == null) {
            throw new InvalidParameterException("baseUrl cannot be null");
        }
        if (redirectedUrl == null) {
            throw new InvalidParameterException("redirectedUrl cannot be null");
        }
        if (headers == null) {
            throw new InvalidParameterException("headers cannot be null");
        }
        if (content == null) {
            throw new InvalidParameterException("content cannot be null");
        }
        if (contentType == null) {
            throw new InvalidParameterException("contentType cannot be null");
        }
        if (hostAddress == null) {
            throw new InvalidParameterException("hostAddress cannot be null");
        }
        this._baseUrl = baseUrl;
        this._fetchedUrl = redirectedUrl;
        this._fetchTime = fetchTime;
        this._content = content;
        this._contentType = contentType;
        this._responseRate = responseRate;
        this._headers = headers;
        this._newBaseUrl = newBaseUrl;
        this._numRedirects = numRedirects;
        this._hostAddress = hostAddress;
        this._statusCode = statusCode;
        this._reasonPhrase = reasonPhrase;
    }

    public Payload getPayload() {
        return this._payload;
    }

    public void setPayload(Payload payload) {
        this._payload = payload;
    }

    public String getBaseUrl() {
        return this._baseUrl;
    }

    public String getFetchedUrl() {
        return this._fetchedUrl;
    }

    public long getFetchTime() {
        return this._fetchTime;
    }

    public byte[] getContent() {
        return this._content;
    }

    public int getContentLength() {
        return this._content.length;
    }

    public String getContentType() {
        return this._contentType;
    }

    public int getResponseRate() {
        return this._responseRate;
    }

    public Metadata getHeaders() {
        return this._headers;
    }

    public String getNewBaseUrl() {
        return this._newBaseUrl;
    }

    public int getNumRedirects() {
        return this._numRedirects;
    }

    public String getHostAddress() {
        return this._hostAddress;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getReasonPhrase() {
        return this._reasonPhrase;
    }
}

