/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher.file;

import crawlercommons.fetcher.BadProtocolFetchException;
import crawlercommons.fetcher.BaseFetchException;
import crawlercommons.fetcher.BaseFetcher;
import crawlercommons.fetcher.FetchedResult;
import crawlercommons.fetcher.HttpFetchException;
import crawlercommons.fetcher.IOFetchException;
import crawlercommons.fetcher.Payload;
import crawlercommons.fetcher.UrlFetchException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;

public class SimpleFileFetcher
extends BaseFetcher {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchedResult get(String url, Payload payload) throws BaseFetchException {
        FetchedResult fetchedResult;
        String path = null;
        try {
            URL realUrl = new URL(url);
            if (!realUrl.getProtocol().equals("file")) {
                throw new BadProtocolFetchException(url);
            }
            path = realUrl.getPath();
            if (path.length() == 0) {
                path = "/";
            }
        }
        catch (MalformedURLException e) {
            throw new UrlFetchException(url, e.getMessage());
        }
        File f = new File(path);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            long startTime = System.currentTimeMillis();
            byte[] content = IOUtils.toByteArray((InputStream)fis);
            long stopTime = System.currentTimeMillis();
            long totalReadTime = Math.max(1L, stopTime - startTime);
            long responseRate = (long)content.length * 1000L / totalReadTime;
            String contentType = "application/octet-stream";
            fetchedResult = new FetchedResult(url, url, System.currentTimeMillis(), new Metadata(), content, contentType, (int)responseRate, payload, url, 0, "localhost", 200, null);
        }
        catch (FileNotFoundException e) {
            try {
                throw new HttpFetchException(url, "Error fetching " + url, 404, new Metadata());
                catch (IOException e2) {
                    throw new IOFetchException(url, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return fetchedResult;
    }

    @Override
    public void abort() {
    }
}

