/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher.http;

import crawlercommons.fetcher.AbortedFetchException;
import crawlercommons.fetcher.AbortedFetchReason;
import crawlercommons.fetcher.BadProtocolFetchException;
import crawlercommons.fetcher.BaseFetchException;
import crawlercommons.fetcher.EncodingUtils;
import crawlercommons.fetcher.FetchedResult;
import crawlercommons.fetcher.HttpFetchException;
import crawlercommons.fetcher.IOFetchException;
import crawlercommons.fetcher.Payload;
import crawlercommons.fetcher.RedirectFetchException;
import crawlercommons.fetcher.UrlFetchException;
import crawlercommons.fetcher.http.BaseHttpFetcher;
import crawlercommons.fetcher.http.UserAgent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.AbstractVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.params.CookieSpecParamBean;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpFetcher
extends BaseHttpFetcher {
    private static Logger LOGGER = LoggerFactory.getLogger(SimpleHttpFetcher.class);
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final int DEFAULT_MAX_THREADS = 1;
    private static final long CONNECTION_POOL_TIMEOUT = 100000L;
    private static final int BUFFER_SIZE = 8192;
    private static final int DEFAULT_MAX_RETRY_COUNT = 10;
    private static final int DEFAULT_BYTEARRAY_SIZE = 32768;
    private static final String DEFAULT_ACCEPT = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    private static final String DEFAULT_ACCEPT_CHARSET = "utf-8,ISO-8859-1;q=0.7,*;q=0.7";
    private static final String DEFAULT_ACCEPT_ENCODING = "x-gzip, gzip";
    private static final String PERM_REDIRECT_CONTEXT_KEY = "perm-redirect";
    private static final String REDIRECT_COUNT_CONTEXT_KEY = "redirect-count";
    private static final String HOST_ADDRESS = "host-address";
    private static final String[] SSL_CONTEXT_NAMES = new String[]{"TLS", "Default", "SSL"};
    private static final String[] TEXT_MIME_TYPES = new String[]{"text/html", "application/x-asp", "application/xhtml+xml", "application/vnd.wap.xhtml+xml"};
    private HttpVersion _httpVersion = HttpVersion.HTTP_1_1;
    private int _socketTimeout = 30000;
    private int _connectionTimeout = 30000;
    private int _maxRetryCount = 10;
    private transient DefaultHttpClient _httpClient = null;

    public SimpleHttpFetcher(UserAgent userAgent) {
        this(1, userAgent);
    }

    public SimpleHttpFetcher(int maxThreads, UserAgent userAgent) {
        super(maxThreads, userAgent);
    }

    public HttpVersion getHttpVersion() {
        return this._httpVersion;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        if (this._httpClient != null) {
            throw new IllegalStateException("Can't change HTTP version after HttpClient has been initialized");
        }
        this._httpVersion = httpVersion;
    }

    public int getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setSocketTimeout(int socketTimeoutInMs) {
        if (this._httpClient != null) {
            throw new IllegalStateException("Can't change socket timeout after HttpClient has been initialized");
        }
        this._socketTimeout = socketTimeoutInMs;
    }

    public int getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeoutInMs) {
        if (this._httpClient != null) {
            throw new IllegalStateException("Can't change connection timeout after HttpClient has been initialized");
        }
        this._connectionTimeout = connectionTimeoutInMs;
    }

    public int getMaxRetryCount() {
        return this._maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this._maxRetryCount = maxRetryCount;
    }

    @Override
    public FetchedResult get(String url, Payload payload) throws BaseFetchException {
        try {
            URL realUrl = new URL(url);
            String protocol = realUrl.getProtocol();
            if (!protocol.equals("http") && !protocol.equals("https")) {
                throw new BadProtocolFetchException(url);
            }
        }
        catch (MalformedURLException e) {
            throw new UrlFetchException(url, e.getMessage());
        }
        return this.request((HttpRequestBase)new HttpGet(), url, payload);
    }

    private FetchedResult request(HttpRequestBase request, String url, Payload payload) throws BaseFetchException {
        this.init();
        try {
            return this.doRequest(request, url, payload);
        }
        catch (HttpFetchException e) {
            if (LOGGER.isTraceEnabled() && e.getHttpStatus() != 404) {
                LOGGER.trace(String.format("Exception fetching %s (%s)", url, e.getMessage()));
            }
            throw e;
        }
        catch (AbortedFetchException e) {
            if (e.getAbortReason() != AbortedFetchReason.INVALID_MIMETYPE) {
                LOGGER.debug(String.format("Exception fetching %s (%s)", url, e.getMessage()));
            }
            throw e;
        }
        catch (BaseFetchException e) {
            LOGGER.debug(String.format("Exception fetching %s (%s)", url, e.getMessage()));
            throw e;
        }
    }

    public FetchedResult fetch(String url) throws BaseFetchException {
        return this.fetch((HttpRequestBase)new HttpGet(), url, new Payload());
    }

    public FetchedResult fetch(HttpRequestBase request, String url, Payload payload) throws BaseFetchException {
        this.init();
        try {
            return this.doRequest(request, url, payload);
        }
        catch (BaseFetchException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Exception fetching %s", url), (Throwable)e);
            }
            throw e;
        }
    }

    private FetchedResult doRequest(HttpRequestBase request, String url, Payload payload) throws BaseFetchException {
        int maxContentSize;
        HttpResponse response;
        long readStartTime;
        LOGGER.trace("Fetching " + url);
        Metadata headerMap = new Metadata();
        String redirectedUrl = null;
        String newBaseUrl = null;
        int numRedirects = 0;
        boolean needAbort = true;
        String contentType = "";
        String mimeType = "";
        String hostAddress = null;
        int statusCode = 500;
        String reasonPhrase = null;
        BasicHttpContext localContext = new BasicHttpContext();
        BasicCookieStore cookieStore = new BasicCookieStore();
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        StringBuilder fetchTrace = null;
        if (LOGGER.isTraceEnabled()) {
            fetchTrace = new StringBuilder("Fetched url: " + url);
        }
        try {
            Integer redirects;
            Header[] headers;
            request.setURI(new URI(url));
            readStartTime = System.currentTimeMillis();
            response = this._httpClient.execute((HttpUriRequest)request, (HttpContext)localContext);
            for (Header header : headers = response.getAllHeaders()) {
                headerMap.add(header.getName(), header.getValue());
            }
            statusCode = response.getStatusLine().getStatusCode();
            reasonPhrase = response.getStatusLine().getReasonPhrase();
            if (LOGGER.isTraceEnabled()) {
                fetchTrace.append("; status code: " + statusCode);
                if (headerMap.get("Content-Length") != null) {
                    fetchTrace.append("; Content-Length: " + headerMap.get("Content-Length"));
                }
                if (headerMap.get("Location") != null) {
                    fetchTrace.append("; Location: " + headerMap.get("Location"));
                }
            }
            if (statusCode < 200 || statusCode >= 300) {
                throw new HttpFetchException(url, "Error fetching " + url + " due to \"" + reasonPhrase + "\"", statusCode, headerMap);
            }
            redirectedUrl = this.extractRedirectedUrl(url, (HttpContext)localContext);
            URI permRedirectUri = (URI)localContext.getAttribute(PERM_REDIRECT_CONTEXT_KEY);
            if (permRedirectUri != null) {
                newBaseUrl = permRedirectUri.toURL().toExternalForm();
            }
            if ((redirects = (Integer)localContext.getAttribute(REDIRECT_COUNT_CONTEXT_KEY)) != null) {
                numRedirects = redirects;
            }
            if ((hostAddress = (String)localContext.getAttribute(HOST_ADDRESS)) == null) {
                throw new UrlFetchException(url, "Host address not saved in context");
            }
            Header cth = response.getFirstHeader("Content-Type");
            if (cth != null) {
                contentType = cth.getValue();
            }
            mimeType = SimpleHttpFetcher.getMimeTypeFromContentType(contentType);
            Set<String> mimeTypes = this.getValidMimeTypes();
            if (mimeTypes != null && mimeTypes.size() > 0 && !mimeTypes.contains(mimeType)) {
                throw new AbortedFetchException(url, "Invalid mime-type: " + mimeType, AbortedFetchReason.INVALID_MIMETYPE);
            }
            needAbort = false;
        }
        catch (ClientProtocolException e) {
            needAbort = false;
            if (e.getCause() instanceof MyRedirectException) {
                MyRedirectException mre = (MyRedirectException)((Object)e.getCause());
                String redirectUrl = url;
                try {
                    redirectUrl = mre.getUri().toURL().toExternalForm();
                }
                catch (MalformedURLException e2) {
                    LOGGER.warn("Invalid URI saved during redirect handling: " + mre.getUri());
                }
                throw new RedirectFetchException(url, redirectUrl, mre.getReason());
            }
            if (e.getCause() instanceof RedirectException) {
                throw new RedirectFetchException(url, this.extractRedirectedUrl(url, (HttpContext)localContext), RedirectFetchException.RedirectExceptionReason.TOO_MANY_REDIRECTS);
            }
            throw new IOFetchException(url, (IOException)((Object)e));
        }
        catch (IOException e) {
            needAbort = false;
            if (e instanceof ConnectionPoolTimeoutException) {
                ThreadSafeClientConnManager cm = (ThreadSafeClientConnManager)this._httpClient.getConnectionManager();
                int numConnections = cm.getConnectionsInPool();
                cm.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
                LOGGER.error(String.format("Got ConnectionPoolTimeoutException: %d connections before, %d after idle close", numConnections, cm.getConnectionsInPool()));
            }
            throw new IOFetchException(url, e);
        }
        catch (URISyntaxException e) {
            throw new UrlFetchException(url, e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new UrlFetchException(url, e.getMessage());
        }
        catch (BaseFetchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOFetchException(url, new IOException(e));
        }
        finally {
            SimpleHttpFetcher.safeAbort(needAbort, request);
        }
        int targetLength = maxContentSize = this.getMaxContentSize(mimeType);
        boolean truncated = false;
        String contentLengthStr = headerMap.get("Content-Length");
        if (contentLengthStr != null) {
            try {
                int contentLength = Integer.parseInt(contentLengthStr);
                if (contentLength > targetLength) {
                    truncated = true;
                } else {
                    targetLength = contentLength;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid content length in header: " + contentLengthStr);
            }
        }
        byte[] content = new byte[]{};
        long readRate = 0L;
        HttpEntity entity = response.getEntity();
        needAbort = true;
        if (entity != null) {
            InputStream in = null;
            try {
                in = entity.getContent();
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                int totalRead = 0;
                ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
                int readRequests = 0;
                int minResponseRate = this.getMinResponseRate();
                while (totalRead < targetLength && (bytesRead = in.read(buffer, 0, Math.min(buffer.length, targetLength - totalRead))) != -1) {
                    out.write(buffer, 0, bytesRead);
                    long totalReadTime = Math.max(1L, System.currentTimeMillis() - readStartTime);
                    readRate = (long)(totalRead += bytesRead) * 1000L / totalReadTime;
                    if (++readRequests > 1 && totalRead < targetLength && readRate < (long)minResponseRate) {
                        throw new AbortedFetchException(url, "Slow response rate of " + readRate + " bytes/sec", AbortedFetchReason.SLOW_RESPONSE_RATE);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new AbortedFetchException(url, AbortedFetchReason.INTERRUPTED);
                }
                content = out.toByteArray();
                needAbort = truncated || in.available() > 0;
            }
            catch (IOException e) {
                throw new IOFetchException(url, e);
            }
            finally {
                SimpleHttpFetcher.safeAbort(needAbort, request);
                SimpleHttpFetcher.safeClose(in);
            }
        }
        if (truncated && !this.isTextMimeType(mimeType)) {
            throw new AbortedFetchException(url, "Truncated image", AbortedFetchReason.CONTENT_SIZE);
        }
        String contentEncoding = headerMap.get("Content-Encoding");
        if (contentEncoding != null) {
            if (LOGGER.isTraceEnabled()) {
                fetchTrace.append("; Content-Encoding: " + contentEncoding);
            }
            try {
                if ("gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding)) {
                    if (truncated) {
                        throw new AbortedFetchException(url, "Truncated compressed data", AbortedFetchReason.CONTENT_SIZE);
                    }
                    EncodingUtils.ExpandedResult expandedResult = EncodingUtils.processGzipEncoded(content, maxContentSize);
                    truncated = expandedResult.isTruncated();
                    if (truncated && !this.isTextMimeType(mimeType)) {
                        throw new AbortedFetchException(url, "Truncated decompressed image", AbortedFetchReason.CONTENT_SIZE);
                    }
                    content = expandedResult.getExpanded();
                    if (LOGGER.isTraceEnabled()) {
                        fetchTrace.append("; unzipped to " + content.length + " bytes");
                    }
                }
            }
            catch (IOException e) {
                throw new IOFetchException(url, e);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(fetchTrace.toString());
        }
        return new FetchedResult(url, redirectedUrl, System.currentTimeMillis(), headerMap, content, contentType, (int)readRate, payload, newBaseUrl, numRedirects, hostAddress, statusCode, reasonPhrase);
    }

    private boolean isTextMimeType(String mimeType) {
        for (String textContentType : TEXT_MIME_TYPES) {
            if (!textContentType.equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    private String extractRedirectedUrl(String url, HttpContext localContext) {
        HttpHost host = (HttpHost)localContext.getAttribute("http.target_host");
        HttpUriRequest finalRequest = (HttpUriRequest)localContext.getAttribute("http.request");
        try {
            URL hostUrl = new URI(host.toURI()).toURL();
            return new URL(hostUrl, finalRequest.getURI().toString()).toExternalForm();
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Invalid host/uri specified in final fetch: " + host + finalRequest.getURI());
            return url;
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Invalid host/uri specified in final fetch: " + host + finalRequest.getURI());
            return url;
        }
    }

    private static void safeClose(Closeable o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void safeAbort(boolean needAbort, HttpRequestBase request) {
        if (needAbort && request != null) {
            try {
                request.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private synchronized void init() {
        if (this._httpClient == null) {
            BasicHttpParams params = new BasicHttpParams();
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)this._maxThreads);
            ConnManagerParams.setTimeout((HttpParams)params, (long)100000L);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this._socketTimeout);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this._connectionTimeout);
            HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
            ConnPerRouteBean connPerRoute = new ConnPerRouteBean(this.getMaxConnectionsPerHost());
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRoute);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)this._httpVersion);
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)this._userAgent.getUserAgentString());
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            HttpProtocolParams.setHttpElementCharset((HttpParams)params, (String)"UTF-8");
            HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)true);
            CookieSpecParamBean cookieParams = new CookieSpecParamBean((HttpParams)params);
            cookieParams.setSingleHeader(true);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            SSLSocketFactory sf = null;
            for (String contextName : SSL_CONTEXT_NAMES) {
                try {
                    SSLContext sslContext = SSLContext.getInstance(contextName);
                    sslContext.init(null, new TrustManager[]{new DummyX509TrustManager(null)}, null);
                    sf = new SSLSocketFactory(sslContext);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.debug("SSLContext algorithm not available: " + contextName);
                }
                catch (Exception e) {
                    LOGGER.debug("SSLContext can't be initialized: " + contextName, (Throwable)e);
                }
            }
            if (sf != null) {
                sf.setHostnameVerifier((X509HostnameVerifier)new DummyX509HostnameVerifier());
                schemeRegistry.register(new Scheme("https", sf, 443));
            } else {
                LOGGER.warn("No valid SSLContext found for https");
            }
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
            this._httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
            this._httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new MyRequestRetryHandler(this._maxRetryCount));
            this._httpClient.setRedirectHandler((RedirectHandler)new MyRedirectHandler(this.getRedirectMode()));
            this._httpClient.addRequestInterceptor((HttpRequestInterceptor)new MyRequestInterceptor());
            params = this._httpClient.getParams();
            HttpClientParams.setAuthenticating((HttpParams)params, (boolean)false);
            HttpClientParams.setCookiePolicy((HttpParams)params, (String)"best-match");
            ClientParamBean clientParams = new ClientParamBean((HttpParams)params);
            if (this.getMaxRedirects() == 0) {
                clientParams.setHandleRedirects(false);
            } else {
                clientParams.setHandleRedirects(true);
                clientParams.setMaxRedirects(this.getMaxRedirects());
            }
            HashSet<BasicHeader> defaultHeaders = new HashSet<BasicHeader>();
            defaultHeaders.add(new BasicHeader("Accept-Language", this.getAcceptLanguage()));
            defaultHeaders.add(new BasicHeader("Accept-Charset", DEFAULT_ACCEPT_CHARSET));
            defaultHeaders.add(new BasicHeader("Accept-Encoding", DEFAULT_ACCEPT_ENCODING));
            defaultHeaders.add(new BasicHeader("Accept", DEFAULT_ACCEPT));
            clientParams.setDefaultHeaders(defaultHeaders);
        }
    }

    @Override
    public void abort() {
    }

    private static class DummyX509TrustManager
    implements X509TrustManager {
        private X509TrustManager standardTrustManager = null;

        public DummyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
            String algo = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algo);
            factory.init(keystore);
            TrustManager[] trustmanagers = factory.getTrustManagers();
            if (trustmanagers.length == 0) {
                throw new NoSuchAlgorithmException(algo + " trust manager not supported");
            }
            this.standardTrustManager = (X509TrustManager)trustmanagers[0];
        }

        public boolean isClientTrusted(X509Certificate[] certificates) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] certificates) {
            return true;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.standardTrustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }

    private static class DummyX509HostnameVerifier
    extends AbstractVerifier {
        private DummyX509HostnameVerifier() {
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            try {
                this.verify(host, cns, subjectAlts, false);
            }
            catch (SSLException e) {
                LOGGER.warn("Invalid SSL certificate for " + host + ": " + e.getMessage());
            }
        }

        public final String toString() {
            return "DUMMY_VERIFIER";
        }
    }

    private static class MyRequestInterceptor
    implements HttpRequestInterceptor {
        private MyRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            HttpInetConnection connection = (HttpInetConnection)context.getAttribute("http.connection");
            context.setAttribute(SimpleHttpFetcher.HOST_ADDRESS, (Object)connection.getRemoteAddress().getHostAddress());
        }
    }

    private static class MyRedirectHandler
    extends DefaultRedirectHandler {
        private BaseHttpFetcher.RedirectMode _redirectMode;

        public MyRedirectHandler(BaseHttpFetcher.RedirectMode redirectMode) {
            this._redirectMode = redirectMode;
        }

        public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
            boolean isPermRedirect;
            Integer count;
            URI result = super.getLocationURI(response, context);
            if (result.getScheme().equalsIgnoreCase("http") && result.getPort() == 80) {
                try {
                    result = new URI(result.getScheme(), result.getUserInfo(), result.getHost(), -1, result.getPath(), result.getQuery(), result.getFragment());
                }
                catch (URISyntaxException e) {
                    LOGGER.warn("Unexpected exception removing port from URI", (Throwable)e);
                }
            }
            if ((count = (Integer)context.getAttribute(SimpleHttpFetcher.REDIRECT_COUNT_CONTEXT_KEY)) == null) {
                count = new Integer(0);
            }
            context.setAttribute(SimpleHttpFetcher.REDIRECT_COUNT_CONTEXT_KEY, (Object)(count + 1));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 301) {
                context.setAttribute(SimpleHttpFetcher.PERM_REDIRECT_CONTEXT_KEY, (Object)result);
            }
            boolean bl = isPermRedirect = statusCode == 301;
            if (this._redirectMode == BaseHttpFetcher.RedirectMode.FOLLOW_NONE || this._redirectMode == BaseHttpFetcher.RedirectMode.FOLLOW_TEMP && isPermRedirect) {
                RedirectFetchException.RedirectExceptionReason reason = isPermRedirect ? RedirectFetchException.RedirectExceptionReason.PERM_REDIRECT_DISALLOWED : RedirectFetchException.RedirectExceptionReason.TEMP_REDIRECT_DISALLOWED;
                throw new MyRedirectException("RedirectMode disallowed redirect: " + (Object)((Object)this._redirectMode), result, reason);
            }
            return result;
        }
    }

    private static class MyRedirectException
    extends RedirectException {
        private URI _uri;
        private RedirectFetchException.RedirectExceptionReason _reason;

        public MyRedirectException(String message, URI uri, RedirectFetchException.RedirectExceptionReason reason) {
            super(message);
            this._uri = uri;
            this._reason = reason;
        }

        public URI getUri() {
            return this._uri;
        }

        public RedirectFetchException.RedirectExceptionReason getReason() {
            return this._reason;
        }
    }

    private static class MyRequestRetryHandler
    implements HttpRequestRetryHandler {
        private int _maxRetryCount;

        public MyRequestRetryHandler(int maxRetryCount) {
            this._maxRetryCount = maxRetryCount;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Decide about retry #" + executionCount + " for exception " + exception.getMessage());
            }
            if (executionCount >= this._maxRetryCount) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            boolean idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        }
    }
}

