/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.fetcher.http;

import java.io.Serializable;

public class UserAgent
implements Serializable {
    public static final String DEFAULT_BROWSER_VERSION = "Mozilla/5.0";
    private final String _agentName;
    private final String _emailAddress;
    private final String _webAddress;
    private final String _browserVersion;
    private final String _crawlerVersion;

    public UserAgent(String agentName, String emailAddress, String webAddress) {
        this(agentName, emailAddress, webAddress, DEFAULT_BROWSER_VERSION);
    }

    public UserAgent(String agentName, String emailAddress, String webAddress, String browserVersion) {
        this(agentName, emailAddress, webAddress, browserVersion, null);
    }

    public UserAgent(String agentName, String emailAddress, String webAddress, String browserVersion, String crawlerVersion) {
        this._agentName = agentName;
        this._emailAddress = emailAddress;
        this._webAddress = webAddress;
        this._browserVersion = browserVersion;
        this._crawlerVersion = crawlerVersion == null ? "" : "/" + crawlerVersion;
    }

    public String getAgentName() {
        return this._agentName;
    }

    public String getUserAgentString() {
        return String.format("%s (compatible; %s%s; +%s; %s)", this._browserVersion, this.getAgentName(), this._crawlerVersion, this._webAddress, this._emailAddress);
    }
}

