/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.robots;

import crawlercommons.fetcher.FetchedResult;
import crawlercommons.fetcher.HttpFetchException;
import crawlercommons.fetcher.IOFetchException;
import crawlercommons.fetcher.RedirectFetchException;
import crawlercommons.fetcher.http.BaseHttpFetcher;
import crawlercommons.fetcher.http.SimpleHttpFetcher;
import crawlercommons.fetcher.http.UserAgent;
import crawlercommons.robots.BaseRobotRules;
import crawlercommons.robots.BaseRobotsParser;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RobotUtils.class);
    private static final int MAX_ROBOTS_SIZE = 131072;
    private static final int MAX_CONNECTIONS_PER_HOST = 20;
    private static final int ROBOTS_CONNECTION_TIMEOUT = 10000;
    private static final int ROBOTS_SOCKET_TIMEOUT = 10000;
    private static final int ROBOTS_RETRY_COUNT = 2;
    private static final long MAX_FETCH_TIME = 40000L;

    public static BaseHttpFetcher createFetcher(BaseHttpFetcher fetcher) {
        return RobotUtils.createFetcher(fetcher.getUserAgent(), fetcher.getMaxThreads());
    }

    public static BaseHttpFetcher createFetcher(UserAgent userAgent, int maxThreads) {
        SimpleHttpFetcher fetcher = new SimpleHttpFetcher(maxThreads, userAgent);
        fetcher.setDefaultMaxContentSize(131072);
        fetcher.setMaxConnectionsPerHost(20);
        fetcher.setMaxRetryCount(2);
        fetcher.setConnectionTimeout(10000);
        fetcher.setSocketTimeout(10000);
        return fetcher;
    }

    public static long getMaxFetchTime() {
        return 40000L;
    }

    public static BaseRobotRules getRobotRules(BaseHttpFetcher fetcher, BaseRobotsParser parser, URL robotsUrl) {
        try {
            boolean isPlainText;
            String urlToFetch = robotsUrl.toExternalForm();
            FetchedResult result = fetcher.get(urlToFetch);
            String contentType = result.getContentType();
            boolean bl = isPlainText = contentType != null && contentType.startsWith("text/plain");
            if (result.getNumRedirects() > 0 && !isPlainText) {
                return parser.failedFetch(410);
            }
            return parser.parseContent(urlToFetch, result.getContent(), result.getContentType(), fetcher.getUserAgent().getAgentName());
        }
        catch (HttpFetchException e) {
            return parser.failedFetch(e.getHttpStatus());
        }
        catch (IOFetchException e) {
            return parser.failedFetch(500);
        }
        catch (RedirectFetchException e) {
            return parser.failedFetch(410);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception fetching robots.txt: " + robotsUrl, (Throwable)e);
            return parser.failedFetch(500);
        }
    }
}

