/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.robots;

import crawlercommons.robots.BaseRobotRules;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class SimpleRobotRules
extends BaseRobotRules {
    private ArrayList<RobotRule> _rules;
    private RobotRulesMode _mode;

    public SimpleRobotRules() {
        this(RobotRulesMode.ALLOW_SOME);
    }

    public SimpleRobotRules(RobotRulesMode mode) {
        this._mode = mode;
        this._rules = new ArrayList();
    }

    public void clearRules() {
        this._rules.clear();
    }

    public void addRule(String prefix, boolean allow) {
        if (!allow && prefix.length() == 0) {
            allow = true;
        }
        this._rules.add(new RobotRule(prefix, allow));
    }

    @Override
    public boolean isAllowed(String url) {
        if (this._mode == RobotRulesMode.ALLOW_NONE) {
            return false;
        }
        if (this._mode == RobotRulesMode.ALLOW_ALL) {
            return true;
        }
        String path = this.getPath(url);
        if (path.equals("/robots.txt")) {
            return true;
        }
        for (RobotRule rule : this._rules) {
            if (!path.startsWith(rule._prefix)) continue;
            return rule._allow;
        }
        return true;
    }

    private String getPath(String url) {
        try {
            String path = new URL(url).getPath();
            if (path == null || path.equals("")) {
                return "/";
            }
            return URLDecoder.decode(path, "UTF-8").toLowerCase();
        }
        catch (Exception e) {
            return "/";
        }
    }

    @Override
    public boolean isAllowAll() {
        return this._mode == RobotRulesMode.ALLOW_ALL;
    }

    @Override
    public boolean isAllowNone() {
        return this._mode == RobotRulesMode.ALLOW_NONE;
    }

    protected class RobotRule {
        String _prefix;
        Pattern _pattern;
        boolean _allow;

        public RobotRule(String prefix, boolean allow) {
            this._prefix = prefix;
            this._pattern = null;
            this._allow = allow;
        }

        public RobotRule(Pattern pattern, boolean allow) {
            this._prefix = null;
            this._pattern = pattern;
            this._allow = allow;
        }
    }

    public static enum RobotRulesMode {
        ALLOW_ALL,
        ALLOW_NONE,
        ALLOW_SOME;

    }
}

