/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.SiteMap;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractSiteMap {
    private Date lastModified = null;
    private SitemapType type;
    private boolean processed;
    protected URL url;
    private static final ThreadLocal<DateFormat[]> dateFormats = new ThreadLocal<DateFormat[]>(){

        @Override
        protected DateFormat[] initialValue() {
            return new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm+hh:00"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm-hh:00"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+hh:00"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss-hh:00"), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz")};
        }
    };

    public static DateFormat getFullDateFormat() {
        return dateFormats.get()[1];
    }

    public boolean isIndex() {
        return this.type == SitemapType.INDEX;
    }

    public URL getUrl() {
        return this.url;
    }

    void setType(SitemapType type) {
        this.type = type;
    }

    public SitemapType getType() {
        return this.type;
    }

    void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = SiteMap.convertToDate(lastModified);
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static Date convertToDate(String date) {
        if (date != null) {
            for (DateFormat df : dateFormats.get()) {
                try {
                    return df.parse(date);
                }
                catch (ParseException e) {
                }
            }
        }
        return null;
    }

    public static enum SitemapType {
        INDEX,
        XML,
        ATOM,
        RSS,
        TEXT;

    }
}

