/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.SiteMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class SiteMapURL {
    public static double defaultPriority = 0.5;
    private URL url;
    private Date lastModified;
    private ChangeFrequency changeFreq;
    private double priority = defaultPriority;
    private boolean valid;

    public SiteMapURL(String url, boolean valid) {
        this.setUrl(url);
        this.setValid(valid);
    }

    public SiteMapURL(URL url, boolean valid) {
        this.setUrl(url);
        this.setValid(valid);
    }

    public SiteMapURL(String url, String lastModified, String changeFreq, String priority, boolean valid) {
        this.setUrl(url);
        this.setLastModified(lastModified);
        this.setChangeFrequency(changeFreq);
        this.setPriority(priority);
        this.setValid(valid);
    }

    public SiteMapURL(URL url, Date lastModified, ChangeFrequency changeFreq, double priority, boolean valid) {
        this.setUrl(url);
        this.setLastModified(lastModified);
        this.setChangeFrequency(changeFreq);
        this.setPriority(priority);
        this.setValid(valid);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUrl(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            System.out.println("Bad url: [" + url + "]");
            this.url = null;
        }
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = SiteMap.convertToDate(lastModified);
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        this.priority = priority < 0.0 || priority > 1.0 ? defaultPriority : priority;
    }

    public void setPriority(String priority) {
        if (priority != null && priority.length() > 0) {
            try {
                this.setPriority(Double.parseDouble(priority));
            }
            catch (NumberFormatException e) {
                this.setPriority(defaultPriority);
            }
        } else {
            this.setPriority(defaultPriority);
        }
    }

    public ChangeFrequency getChangeFrequency() {
        return this.changeFreq;
    }

    public void setChangeFrequency(ChangeFrequency changeFreq) {
        this.changeFreq = changeFreq;
    }

    public void setChangeFrequency(String changeFreq) {
        if (changeFreq != null) {
            this.changeFreq = (changeFreq = changeFreq.toUpperCase()).contains("ALWAYS") ? ChangeFrequency.ALWAYS : (changeFreq.contains("HOURLY") ? ChangeFrequency.HOURLY : (changeFreq.contains("DAILY") ? ChangeFrequency.DAILY : (changeFreq.contains("WEEKLY") ? ChangeFrequency.WEEKLY : (changeFreq.contains("MONTHLY") ? ChangeFrequency.MONTHLY : (changeFreq.contains("YEARLY") ? ChangeFrequency.YEARLY : (changeFreq.contains("NEVER") ? ChangeFrequency.NEVER : null))))));
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("url=\"").append(this.url).append("\",");
        sb.append("lastMod=").append(this.lastModified == null ? "null" : SiteMap.getFullDateFormat().format(this.lastModified));
        sb.append(",changeFreq=").append((Object)this.changeFreq);
        sb.append(",priority=").append(this.priority);
        return sb.toString();
    }

    public static enum ChangeFrequency {
        ALWAYS,
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY,
        NEVER;

    }
}

